@echo off
REM  Installation script for TextPad.
REM  Must be run from the source diskette or directory.
REM  The first argument must be 16 or 32, specifying the edition.
REM  Optionally takes the installation directory as its 2nd arg.

:chekenv
set FILLER=123456789012345678901234567890
if %FILLER% == 123456789012345678901234567890 goto getedition
@echo Increase environment space before continuing
goto end

:getedition
set FILLER=
REM  Determine which edition to install.
if "%1" == "16" goto install16
if "%1" == "32" goto install32

@echo Usage: INSTALL 16 [drive:directory]
@echo    or: INSTALL 32 [drive:directory]
goto end

:install16
set EDITION=16
set SYSDIR=SYSTEM
goto windir

:install32
set EDITION=32
set SYSDIR=SYSTEM32

:windir

REM See if we can determine the Windows installation directory.
if not "%WINDIR%" == "" goto instdir
if exist c:\windows\win.ini goto win16
@echo Cannot determine Windows installation directory.
@echo Set environment variable WINDIR and start again.
goto end

:win16
set WINDIR=C:\WINDOWS
set SYSDIR=SYSTEM

:instdir
@echo Installing the %EDITION%-bit edition of TextPad
if "%2" == "" goto default
set destdir=%2
goto makedir

:default
set destdir=C:\TEXTPAD

:makedir
mkdir %destdir%

REM --- Copy files to the installation directory.
@echo in the directory: %destdir% ...
@echo readme.txt...
copy readme.txt %destdir%
if not exist %destdir%\readme.txt goto copyerr
@echo license.txt...
copy license.txt %destdir%
if not exist %destdir%\license.txt goto copyerr
@echo register.txt...
copy register.txt %destdir%
if not exist %destdir%\register.txt goto copyerr
@echo txtpad%EDITION%.exe...
copy txtpad%EDITION%.exe %destdir%
if not exist %destdir%\txtpad%EDITION%.exe goto copyerr
@echo textpad.hlp...
copy textpad.hlp %destdir%
if not exist %destdir%\textpad.hlp goto copyerr
@echo txtpad%EDITION%.reg...
copy txtpad%EDITION%.reg %destdir%
if not exist %destdir%\txtpad%EDITION%.reg goto copyerr
@echo ddeopn%EDITION%.exe...
copy ddeopn%EDITION%.exe %destdir%
if not exist %destdir%\ddeopn%EDITION%.exe goto copyerr

if not exist textpad.lic goto dependents
@echo textpad.lic...
copy textpad.lic %destdir%
if not exist %destdir%\textpad.lic goto copyerr

:dependents
if %EDITION% == 32 goto files32

REM  Files for the 16-bit edition only:
@echo Copying txtpad.pif to %WINDIR%
copy txtpad.pif %WINDIR%
if not exist %WINDIR%\txtpad.pif goto copyerr

if exist %WINDIR%\system\ctl3dv2.dll goto done
@echo Copying ctl3dv2.dll to %WINDIR%\SYSTEM
copy ctl3dv2.dll %WINDIR%\SYSTEM\ctl3dv2.dll
if not exist %WINDIR%\SYSTEM\ctl3dv2.dll goto copyerr
goto done

:files32
REM  Files for the 32-bit edition only:
@echo ut16.dll...
copy ut16.dll %destdir%
if not exist %destdir%\ut16.dll goto copyerr
@echo ut32.dll...
copy ut32.dll %destdir%
if not exist %destdir%\ut32.dll goto copyerr

if exist %WINDIR%\%SYSDIR%\ctl3d32.dll goto done
@echo Copying ctl3d32.dll to %WINDIR%\%SYSDIR%
copy ctl3d32.dll %WINDIR%\%SYSDIR%\ctl3d32.dll
if not exist %WINDIR%\%SYSDIR%\ctl3d32.dll goto copyerr

:done
@echo ---------------------------------------------------------
@echo TextPad has been successfully installed in %destdir%
@echo Please read the file README.TXT before starting use.
@echo Use Program Manager to add %destdir%\TXTPAD%EDITION%.EXE
@echo to a program group.
@echo ---------------------------------------------------------
goto end

:copyerr
@echo File copy error, abandoning installation.
@echo Correct the problem and reinstall TextPad.

:end
set WINDIR=
set SYSDIR=
set EDITION=
