/********************************************************
 * TapeWait  -- Waits until only specified number of users are still
 *              on the system or until the <Esc> or <A> key is pressed.
 *
 * Parameters	fileserver:	File Server to poll
 *		maxusers:	Maximum number of users to ignore
 *
 * Returns	0:	Wrong Syntax
 *		1:	<Esc> key pressed by user to proceed or automaic exit
 *		2:	<A> key pressed to abort
 ********************************************************/

#define		TIMEDELAY	10	/* Time delay in seconds */

#include	<conio.h>
#include	<graph.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>
#include	<nit.h>
#include	<niterror.h>

int	Pause(double);
void	AtSay(short,short,char *),
	ClearScreen(void),
	ClearWindow(void),
	DefineTextWindow(short,short,short,short),
	ExitProgram(int),
	HelpScreen(void),
	SendBroadcast(void);
WORD	DisplayUserList(void),
	GetFileServerConnectionID(char *);

WORD	defaultConnectionID,
	maxConnectionsSupported;

void	main(int argc, char *argv[])
{
	char		stringBuffer[81];
	int		errorCode,exitCondition,keyStroke,maxNumberUsers;
	WORD		fileServerNumber,numberUsers;

	FILE_SERV_INFO	serverInfo;

	/* Set variable defaults */
	exitCondition=maxNumberUsers=0;

	/* Get the current connection number */
	defaultConnectionID=GetPreferredConnectionID();

	/* If the number of parameters is 0 or help is asked, display help */
	argc--;
	if (!argc)
		HelpScreen();
	if ((argv[1][1]=='?') || (argv[1][1]=='h') || (argv[1][1]=='H'))
		HelpScreen();

	/* Switch to the file server specified in argument 1 */
	fileServerNumber=GetFileServerConnectionID(argv[1]);
	if (!fileServerNumber)
		HelpScreen();
	SetPreferredConnectionID(fileServerNumber);
	/* Disable broadcasts */
	DisableBroadcasts();

	/* Get the maximum number of connections on the server */
	errorCode=GetServerInformation(sizeof(serverInfo),&serverInfo);
	if (errorCode)
		ExitProgram(errorCode);
	maxConnectionsSupported=serverInfo.maxConnectionsSupported;

	/* Get the maximum number of users, if not set, default to 1 */
	if (argc > 1)
		maxNumberUsers=atoi(argv[2]);
	if (!maxNumberUsers)
		maxNumberUsers=1;

	/* Draw the screen for displaying the users */
	ClearScreen();
	sprintf(stringBuffer,"TapeWait -- Waiting until only %d users left  (time delay %d seconds)",maxNumberUsers,(int)TIMEDELAY);
	AtSay(1,1,stringBuffer);
	AtSay(24,7,"Press <Esc> to Continue, <A> to Abort or <T> to re-send the Message");
	AtSay(2,1,"Connection  User ID             Full Name");
	AtSay(3,1,"----------  ------------------  ----------------------------------------");
	DefineTextWindow(4,1,22,78);	

	/* Send the message to all users to logout */
	SendBroadcast();

	while (!exitCondition)
	{
		/* Display the user list */
		numberUsers=DisplayUserList();

		/* Check is number of users remaining is less that or equal to specified */
		if (numberUsers <= (WORD)maxNumberUsers)
		{
			exitCondition=1;
			break;
		}

		/* Check for a keypress, if one, process */
		if (Pause((double)TIMEDELAY))
		{
			keyStroke=getch();
			switch (keyStroke)
			{
				case	27:	exitCondition=1;	/* <Esc> */
						break;
				case	'A':
				case	'a':	exitCondition=2;	/* <A> */
						break;
				case	'T':	SendBroadcast();		/* <T> */
						break;
			}
		}
	}
	ExitProgram(exitCondition);
}

void	AtSay(short row,short column,char *text)
{
	_settextposition(row,column);
	_outtext(text);
}

void	ClearScreen(void)
{
	_clearscreen(_GCLEARSCREEN);
}

void	ClearWindow(void)
{
	_clearscreen(_GWINDOW);
}

void	DefineTextWindow(short row1,short column1,short row2,short column2)
{
	_settextwindow(row1,column1,row2,column2);
}

void	ExitProgram(int errorLevel)
{
	EnableBroadcasts();
	SetPreferredConnectionID(defaultConnectionID);
	exit(errorLevel);
}

WORD	GetFileServerConnectionID(char *fileServer)
{
	WORD	i;
	char	fileServerName[48];

	for (i=1; i <= 8; i++)
		if (IsConnectionIDInUse(i))
		{
			GetFileServerName(i,fileServerName);
			if (strcmpi(fileServer,fileServerName)==0)
				return(i);
		}
	return(0);
}

void	HelpScreen(void)
{
	printf("TapeWait  --  Waits until only a specified number of users\n");
	printf("              are logged on or until the <Esc> or <A> key is\n");
	printf("              pressed.\n");
	printf("Syntax: TapeWait <fileserver> <users remaining>\n");
	printf("Return: 1 = Proceed with backup\n");
	printf("        2 = Abort backup\n");
	printf("        0 = Syntax error\n\n");
	ExitProgram(0);
}

int	Pause(double timeDelay)
{
	time_t	startTime,endTime;
	int	keyPress;

	time(&startTime);
	do
	{
		time(&endTime);
		keyPress=kbhit();
	} while ((difftime(endTime,startTime) < timeDelay) && !keyPress);
	return(keyPress);
}

void	SendBroadcast(void)
{
	BYTE	resultList[255];
	WORD	connectionList[255];
	WORD	connectionCount;

	for (connectionCount=0; connectionCount<maxConnectionsSupported; connectionCount++)
		connectionList[connectionCount]=connectionCount;

	SendBroadcastMessage("Please LOG OUT, Backing up files.",connectionList,resultList,maxConnectionsSupported);
}

WORD	DisplayUserList(void)
{
	BYTE	moreSegments,propertyFlags;
	char	objectName[48],loginTime[8],propertyValue[128],stringBuffer[81];
	int	loopCounter,objectType,errorCode;
	long	objectID;
	WORD	connectionNumber,usersLoggedOn;

	loopCounter=0;
	usersLoggedOn=0;
	connectionNumber=1;

	ClearWindow();
	/* Display the user list in the defined window */
	while ((loopCounter < 19) && (connectionNumber <= maxConnectionsSupported))
	{
		errorCode=GetConnectionInformation(connectionNumber,objectName,
			&objectType,&objectID,loginTime);
		if ((!errorCode) && (objectName[0] != '\0') && (objectType==OT_USER))
		{
			errorCode=ReadPropertyValue(objectName,objectType,"IDENTIFICATION",1,
				propertyValue,&moreSegments,&propertyFlags);

			if (!errorCode)
				sprintf(stringBuffer,"    %3d     %-18s  %-40s",connectionNumber,objectName,propertyValue);
			else
				sprintf(stringBuffer,"    %3d     %-18s",connectionNumber,objectName);

			loopCounter++;
			usersLoggedOn++;
			AtSay((short)loopCounter,1,stringBuffer);
		}
		connectionNumber++;
	}
	return(usersLoggedOn);
}
