/*
        TW2.H -- Tradewars 2 C header file.

        Selected portions of the TW2.H file.

*/

typedef unsigned char Uchar;
typedef unsigned int  Uint;
typedef unsigned long Ulong;

// 'killed by' definitions..
#define CABAL   -1
#define DELETED -2
#define UNKNOWN -3
#define MINE    -4
#define ACTIVE  -5
#define PIRATES -6

/* struct _PLYROPTS

    -- boolean switches in player records -- used in struct _PLAYER

*/
    struct _PLYROPTS
    {
        unsigned    Kloak:    1;             // cloaking device
        unsigned    Graphics: 2;             // graphics (None, Color,
                                             // C/G w/o msc, C/G w/ music)
        unsigned    RTOnNow:  1;             // REAL TIME: using TW now
        unsigned    Banished: 1;             // Restricted from plane 0
        unsigned    MailWaiting: 1;          // has mail waiting
    };

// union _WASCABAL_ used in _TWMAIN (formerly..  prior to ver 11)

union _WASCABAL_
    {
        char FreeForUse[23];
        struct _OLDCABAL
            {
                unsigned    regen;           // cabal regeneration
                unsigned    hq;              // cabal HQ location
                unsigned    Secndry;         // secondary force location
                unsigned    loc1;            // location around base #1
                unsigned    loc2;            // location around base #2
                unsigned    loc3;            // location around base #3
                unsigned    loc4;            // location around base #4
                unsigned    loc5;            // location around base #5
                unsigned    loc6;            // location around base #6
                unsigned    type2;           // number of cabal group 2 ftrs
                unsigned    type3;           // number of cabal group 3 ftrs
                char        strength;        // cabal strength level 1 - 10
            } OldCabal;
    };

// union _WASOPTIONS_  formerly used in _TWMAIN - NOT USED!

union _WASOPTIONS_
    {
        int Unused;
        struct _OLDOPTIONS
            {
                unsigned    aliases:  1;     // aliases on/off
                unsigned    network:  1;     // network on/off
                unsigned    news:     1;     // galactic news on/off
                unsigned    debug:    1;     // debug on/off
                unsigned    bbs_type: 4;     // bbs interface type
                unsigned    GMon:     1;     // using GMon??
                unsigned    externm:  1;     // external maintenance
                unsigned    local_password: 1; // ask for local password?
                unsigned    sales:    1;     // sales allowed??
                unsigned    surr:     1;     // surrender allowed?
                unsigned    show_dead: 1;    // show dead in rankings?
                unsigned    MoreThan1K: 1;   // More than 1K sectors?
                unsigned    Restricted: 1;   // restricted access for studs
            } Option;
    };

/* struct _TWMAIN

    -- file structure of main TW data file

*/
struct _TWMAIN
    {
        char        EditorPassword[13];      // password used to enter TWEDT
        unsigned    StartingYear;            // starting year of game
        unsigned    TurnsPerDay;             // turns per day allowed
        unsigned    StartingFighters;        // starting fghter amount
        unsigned    StartingCredits;         // starting credit amount
        unsigned    StartingHolds;           // starting hold amount
        unsigned    DaysInactive;            // max days of inactivity
        unsigned    LastMaintenance;         // last day of maintenance
        unsigned    NewsDays;                // days to save newspaper
        unsigned    NewsDeleted;             // last day paper deleted
        float       BankInterest;            // todays bank interest
        unsigned    MaxHolds;                // maximum holds allowed in TW
        unsigned    MaxOre;                  // max planet prod of ore
        unsigned    MaxOrg;                  // max planet prod of org
        unsigned    MaxEqp;                  // max planet prod of eqp
        unsigned    FighterPrice;            // todays fighter price
        union       _WASOPTIONS_ Old;        //
        unsigned    CabalBounty;             // todays cabal bounty
        union       _WASCABAL_ Was;          //
        unsigned    AutoLogOff;              // time in minutes before tmout
        unsigned    MaxTime;                 // max time in minutes no montr
        char        BBSInfoFile[65];         // file to get BBS info from
        char        RankFileName[65];        // file for player rankings
        char        BBSSysopName[32];        // BBS SysOp name       (n-a-u)
        char        BBSName[41];             // BBS name (not always used)
        char        PortNumber;              // port num (not always used)
        unsigned    ModemLockSpeed;          // speed of locked port (n-a-u)
        int         BBSMode;                 // running in bbs mode? y/n (n-u)
        char        ReservedPortionA[67];    // Reserved for use by TW2
        int         TW2Version;              // version number of tw
        char        MaxNodes;                // number of nodes (for chat)
        int         PlanetRecords;           // records in planet file
        int         PlayerRecords;           // records in user file
        int         TeamRecords;             // records in team file
        char        Language[4];             // language file extension
        Uchar       BBSType;                 // BBS type
        unsigned long TWOptions;             // home of options
        long        BanishValue;             // if restrict studs, this Value
        char        TWDirectory[65];         // directory TW data files are in
        int         MaxPlayers;              // maximum player total
        int         InputBuffer;             // input comm buffer
        int         OutputBuffer;            // output comm buffer
        char        NetDirectory[65];        // area for TW2NET.DAT/TW2NET.INC
        char        MsgDirectory[65];        // TW msg base directory
        Uchar       NetNode;                 // TW network node number
        int         Net;                     // Regular network #
        int         Node;                    // Regular node #
        int         NodesInNet;              // Nodes in the network
        char        PackerName[13];          // Network packer filename
        char        PackerOptions[10];       // Packer command options
        char        ChatFileDirectory[65];   // Drive/Directory for chat file
        char        ReservedPortionB[30];    // Reserved for use by TW2
        char        Unused[300];             // not currently in use..
    };

/*  struct _PLAYER

    -- structure for each record of TWPLAYER.DAT

*/
struct _PLAYER
    {
        char        RealName[31];            // players real (BBS) name
        char        Alias[31];               // players alias name (if any)
        char        Password[9];             // local password
        struct      _PLYROPTS Options;       // use: Player.Options.etc
        unsigned    LastOn;                  // last day on
        int         DestroyedBy;             // player killed by
        unsigned    TurnsLeft;               // turns left on last day
        unsigned    SectorIn;                // current sector in
        unsigned    LastSectorIn;            // last sector in
        Ulong       BankCredits;             // banked credits
        Ulong       Credits;                 // trading credits
        unsigned    Fighters;                // fighters w/ ship
        unsigned    Mines;                   // mines w/ ship
        unsigned    Kloak;                   // cloak days left (if any)
        unsigned    Probes;                  // probes w/ ship
        unsigned    Holds;                   // holds w/ ship
        unsigned    Ore;                     // ore in holds
        unsigned    Org;                     // organics in holds
        unsigned    Eqp;                     // equipment in holds
        unsigned    TeamIn;                  // team in (if any)
        unsigned    DayQuitTeam;             // day player quit team
        unsigned    TimeUsed;                // time used today
        int         RTAttackBy;              // REAL TIME: attacked by
        unsigned    UnusedInt;               // pointer to next lower player
        long        UnusedLong;              // value of player
        unsigned    SuperSearch;             // super sector finder onboard
        unsigned    RTMessage;               // REAL TIME: radio msg
        unsigned    LastMsgRead;             // Last message number read
        char        JustPlainUnused[36];     // not currently in use..
    };

/*  struct _SECTOR

    -- structure for each record of TWSECTOR.DAT

*/
struct _SECTOR
    {
        unsigned    DefenseForce;            // sector defense force ftr #
        int         DFOwner;                 // owner of those fighters
        unsigned    Port;                    // port in sector (if any)
        unsigned    Planet;                  // planet in sector (if any)
        unsigned    Mine;                    // mine in sector (if any)
        char        InUnion;                 // is sector in union??
        unsigned    DefenseOptions;          // Defense Force options
        unsigned    OptionWork;              // Work Integer For above
        unsigned    MineOptions;             // Mine Programming Options
        unsigned    MOWork;                  // Mine Option Work
        char        Unused[31];              // not currently in use..
    };

/*  struct _PORT

    -- structure for each record of TWPORT.DAT

*/
struct _PORT
    {
        char        Name[30];                // name of port
        char        Class;                   // class of port 0, 1, 2, 3
        unsigned    RecalcDay;               // last day materials recalc'd
        unsigned    RecalcMin;               // last min materials recalc'd
        int         OreUnits;                // units of ore
        int         OrgUnits;                // units of organics
        int         EqpUnits;                // units of equipment
        unsigned    OreProd;                 // productivity of ore per day
        unsigned    OrgProd;                 // productivity of org per day
        unsigned    EqpProd;                 // productivity of eqp per day
        int         OreCost;                 // cost of ore %/thsnd units
        int         OrgCost;                 // cost of org %/thsnd units
        int         EqpCost;                 // cost of eqp %/thsnd units
        unsigned    OreFract;                // 1/10000's units of ore
        unsigned    OrgFract;                // 1/10000's units of organics
        unsigned    EqpFract;                // 1/10000's units of eqp
        char        Unused[20];              // not currently in use..
    };

/*  struct _PLANET

    -- structure for each record of the TWPLANET.DAT file

*/
struct _PLANET
    {
        char        Name[30];                // name of planet
        unsigned    Owner;                   // owner of planet
        unsigned    RecalcDay;               // last day materials recalc'd
        unsigned    RecalcMin;               // last min materials recalc'd
        unsigned    OreUnits;                // amount of ore
        unsigned    OrgUnits;                // amount of organics
        unsigned    EqpUnits;                // amount of equipment
        unsigned    OreProd;                 // productivity of ore
        unsigned    OrgProd;                 // productivity of organics
        unsigned    EqpProd;                 // productivity of equipment
        unsigned    OreFract;                // 1/10000's units of ore
        unsigned    OrgFract;                // 1/10000's units of org
        unsigned    EqpFract;                // 1/10000's units of eqp
        char        Factory;                 // factory  yes/no
        unsigned    Workers;                 // number of workers
        unsigned    Pay;                     // pay for each worker per day
        long        Cash;                    // factory cash available
        unsigned    FactoryOre;              // factory ore supply
        unsigned    FactoryOrg;              // factory organics supply
        unsigned    FactoryEqp;              // factory equipment supply
        unsigned    FactoryFighters;         // fighter supply
        unsigned    DefenseForce;            // Planetary Defense force
        int         DefenseOwner;            // Defense force owner
        unsigned    DefenseOptions;          // DF Options
        unsigned    OptionWork;              // Option work area
        char        Unused[22];              // not currently in use..
    };

struct twcabal    // used in struct _CABAL_
    {
        unsigned    Location;                // location of this group
        unsigned    Goal;                    // goal of this cabal group
        unsigned    Fighters;                // fighters in this group
    };

/*  struct _CABAL_

    -- file structure for each record of TWCABAL.DAT

*/
struct _CABAL_
    {
        unsigned    Regeneration;            // cabal regeneration
        unsigned    Hq;                      // cabal HQ location
        unsigned    Secondary;               // secondary force location
        unsigned    Location1;               // location around base #1
        unsigned    Location2;               // location around base #2
        unsigned    Location3;               // location around base #3
        unsigned    Location4;               // location around base #4
        unsigned    Location5;               // location around base #5
        unsigned    Location6;               // location around base #6
        unsigned    GroupType2;              // number of cabal group 2 ftrs
        unsigned    GroupType3;              // number of cabal group 3 ftrs
        char        Strength;                // cabal strength level 1 - 10
        struct      twcabal Group[50];       // Array of all 50 group locs
    };

/*  struct _PLYRMSG

    -- file structure for each record of TWPMESS.DAT

*/
struct _PLYRMSG
    {
        unsigned    To;                      // player msg is to and total #
        unsigned    Active;                  // is msg active?
        int         From;                    // player who killed above ftrs
        unsigned    Destroyed;               // fighters destroyed by above
    };

/*  struct _TEAM

    -- file structure for each record of TWTEAM.DAT

*/
struct _TEAM
    {
        char        Name[30];                // name of team
        char        Password[9];             // password to join team
        unsigned    Players;                 // number of players on team
        unsigned    Captain;                 // active/team captain
    };

// General TW2 options  used in _TWMAIN.TWOptions

#define ALIASES         0x00000001           // Aliases
#define NETWORK         0x00000002           // Networking
#define NEWS            0x00000004           // News/MsgstoSysop
#define DEBUG           0x00000008           // Debug mode
#define GMON            0x00000010           // GMon
#define EXTERNM         0x00000020           // External Maintenance
#define LOCALPW         0x00000040           // Password entry
#define SALES           0x00000080           // Sales of products
#define SURRENDER       0x00000100           // Surrendering?
#define SHOWDEAD        0x00000200           // Show dead in rankings?
#define RESERVED1       0x00000400
#define RESTRICTED      0x00000800           // restrict good players from plane 0
#define ALLOWKLOAK      0x00001000           // Allow kloaking?
#define KEEPSAVINGS     0x00002000           // keep savings when killed?
#define RESERVED2       0x00004000
#define ISNETWORKED     0x00008000           // in TW network mode?
#define ISNETHOST       0x00010000           // TW network host?
#define NOUNIONATTACKS  0x00020000           // no attacks allowed in Union
#define MUZAKOK         0x00040000           // Local muzak okay??
#define GGGRAPHICSOK    0x00080000           // Local Graphics Okay?
#define COMMITDATA      0x00100000           // commit data to disk?

// defense force options - used in Sector & Planet Defense force options
#define TEAMDF      0x0001                   // team defense force
#define ATTACKALL   0x0002                   // Defense force attacks anyone
#define ATTACKNONE  0x0004                   // attacks no one
#define ATTACKTEAM  0x0008                   // attack certain team
#define ATTACKPLYR  0x0010                   // attack certain player
