program EDITRM;
{$S-}
uses
  Drivers, Views, Dialogs, App, Objects, StdDlg, Editors, Validate, Menus;

var
  ResFile: PResourceFile;

function MakeMainMenu: PMenuBar;
var
  Menu: PMenuBar;
  R: TRect;
begin
  R.Assign(0, 0, 80, 1);
  Menu := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile', hcNoContext, NewMenu(
      NewItem('~N~ew', '', kbNoKey, cmNew, hcNew,
      NewItem('~O~pen...', 'F3', kbF3, cmOpen, hcOpen,
      NewItem('~S~ave', 'F2', kbF2, cmSave, hcSave,
      NewItem('S~a~ve as...', '', kbNoKey, cmSaveAs, hcSaveAs,
      NewItem('Save a~l~l', '', kbNoKey, cmSaveAll, hcSaveAll,
      NewLine(
      NewItem('~C~hange dir...', '', kbNoKey, cmChangeDir, hcChangeDir,
      NewItem('~D~OS shell', '', kbNoKey, cmDosShell, hcDosShell,
      NewItem('E~x~it', 'Alt+X', kbAltX, cmQuit, hcExit,
      nil)))))))))),
    NewSubMenu('~E~dit', hcNoContext, NewMenu(
      NewItem('~U~ndo', 'Alt+BkSp', kbAltBack, 23, hcUndo,
      NewItem('~R~edo', 'Ctrl+BkSp', kbCtrlBack, cmRedo, hcRedo,
      NewLine(
      NewItem('Cu~t~', 'Shift+Del', kbShiftDel, 20, hcCut,
      NewItem('~C~opy', 'Ctrl+Ins', kbCtrlIns, 21, hcCopy,
      NewItem('~P~aste', 'Shift+Ins', kbShiftIns, 22, hcPaste,
      NewItem('C~l~ear', 'Ctrl+Del', kbCtrlDel, cmClear, hcClear,
      nil)))))))),
    NewSubMenu('~W~indow', hcNoContext, NewMenu(
      NewItem('~T~ile', '', kbNoKey, cmTile, hcTile,
      NewItem('C~a~scade', '', kbNoKey, cmCascade, hcCascade,
      NewItem('Cl~o~se all', '', kbNoKey, cmCloseAll, hcCloseAll,
      NewLine(
      NewItem('~S~ize/Move', 'Ctrl+F5', kbCtrlF5, cmResize, hcResize,
      NewItem('~Z~oom', 'F5', kbF5, cmZoom, hcZoom,
      NewItem('~N~ext', 'F6', kbF6, cmNext, hcNext,
      NewItem('~P~revious', 'Shift+F6', kbShiftF6, cmPrev, hcPrev,
      NewItem('~C~lose', 'Alt+F3', kbAltF3, cmClose, hcClose,
      nil)))))))))),
    NewSubMenu('~H~elp', hcNoContext, NewMenu(
      NewItem('~C~ontents', 'F1', kbF1, cmHelp, 65328,
      NewItem('~I~ndex', 'Shift+F1', kbShiftF1, 900, 65329,
      NewItem('~P~revious topic', 'Alt+F1', kbAltF1, 901, 65330,
      NewItem('~U~sing help', '', kbNoKey, 902, 65331,
      NewLine(
      NewItem('~A~bout', '', kbNoKey, 903, 65332,
      nil))))))),
    nil)))))
  ));
  MakeMainMenu := Menu;
end;

function MakeOpenFileDlg: PDialog;
var
  Control, Crnt: PView;
  R: TRect;
  SB1, SB2: PScrollBar;
  Dlg: PDialog;
  Strs: PStringCollection;
  V: PValidator;
begin
  R.Assign(10, 1, 70, 22);
  Dlg := New(PDialog, Init(R, 'Open a file'));
  with Dlg^ do begin
    Options := ofSelectable or ofTopSelect or ofBuffered or ofCenterX or ofCenterY or ofVersion20;
    R.Assign(3, 3, 55, 4);
    Crnt := New(PInputLine, Init(R, 79));
    Insert(Crnt);
    R.Assign(3, 2, 13, 3);
    Insert(New(PLabel, Init(R, 'File ~n~ame', Crnt)));
    R.Assign(55, 3, 58, 4);
    Insert(New(PHistory, Init(R, PInputLine(Crnt), 1)));
    R.Assign(27, 6, 28, 16);
    SB1 := New(PScrollBar, Init(R));
    Insert(SB1);
    R.Assign(3, 6, 27, 16);
    Control := New(PSortedListBox, Init(R, 1, SB1));
    Insert(Control);
    R.Assign(3, 5, 15, 6);
    Insert(New(PLabel, Init(R, '~D~irectories', Control)));
    R.Assign(56, 6, 57, 16);
    SB1 := New(PScrollBar, Init(R));
    Insert(SB1);
    R.Assign(32, 6, 56, 16);
    Control := New(PSortedListBox, Init(R, 1, SB1));
    Insert(Control);
    R.Assign(32, 5, 38, 6);
    Insert(New(PLabel, Init(R, '~F~iles', Control)));
    R.Assign(28, 18, 38, 20);
    Control := New(PButton, Init(R, 'O~K~', cmOk, bfDefault));
    Insert(Control);
    R.Assign(40, 18, 50, 20);
    Control := New(PButton, Init(R, 'Cancel', cmCancel, bfNormal));
    Insert(Control);
    Crnt^.Select;
  end;
  MakeOpenFileDlg := PDialog(Dlg);
end;

function MakeStatusLine: PStatusLine;
var
  Stat: PStatusLine;
  R: TRect;
begin
  R.Assign(0, 24, 80, 25);
  Stat := New(PStatusLine, Init(R,
    NewStatusDef(hcDragging, hcDragging,
      NewStatusKey('~~ Move', kbNoKey, 0,
      NewStatusKey('~Shift+~ Resize', kbNoKey, 0,
      NewStatusKey('~~ Done', kbNoKey, 0,
      NewStatusKey('~Esc~ Cancel', kbNoKey, 0,
      nil)))),
    NewStatusDef(hcNoContext, 65535,
      NewStatusKey('~Alt+X~ Quit', kbAltX, cmQuit,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('', kbCtrlF5, cmResize,
      NewStatusKey('', kbF5, cmZoom,
      NewStatusKey('', kbAltF3, cmClose,
      NewStatusKey('', kbF6, cmNext,
      NewStatusKey('', kbShiftF6, cmPrev,
      NewStatusKey('', kbF1, cmHelp,
      nil)))))))),
    nil))
  ));
  MakeStatusLine := Stat;
end;

function MakeStrings: PStrListMaker;
var
  Str: PStrListMaker;
begin
  Str := New(PStrListMaker, Init(155, 3));
  with Str^ do begin
    Put($0000, 'Turbo Vision Resource WorkShop Demo.');
    Put($0001, '');
    Put($0002, 'This is a string whose key is 2.');
    Put($03E8, 'This command redoes the previous operation.');
    Put($FF01, 'This command opens a new editor window.');
  end;
  MakeStrings := Str;
end;

begin
  RegisterViews;
  RegisterDialogs;
  RegisterApp;
  RegisterObjects;
  RegisterStdDlg;
  RegisterEditors;
  RegisterValidate;
  RegisterMenus;
  RegisterType(RStrListMaker);
  ResFile := New(PResourceFile, Init(New(PBufStream, Init('TVRWDMO.RES', stCreate, 4096))));
  with ResFile^ do begin
    Put(MakeMainMenu, 'MainMenu');
    Put(MakeOpenFileDlg, 'OpenFileDlg');
    Put(MakeStatusLine, 'StatusLine');
    Put(MakeStrings, 'Strings');
  end;
  Dispose(ResFile, Done);
end.
