/*****************************************************************
 * Testzip version 1.11                                          *
 * Test zip file integrity, Nuke Bad Zips                        *
 * Also prints a list of what it deleted in badfiles.txt         *
 *                                                               *
 * Programmer: Madman, with suggestions from Pantera             *
 * Date: 12/6/96     Version 1.0                                 *
 *                                                               *
 * Modified by: Jeff Hamilton, hjeffrey@wam.umd.edu              *
 * Date: 12/8/96     Version 1.01                                *
 * Date: 12/12/96    Version 1.02                                *
 * Date: 12/13/96    Version 1.03                                *
 * Date: 12/15/96    Version 1.04                                *
 * Date: 1/5/97      Version 1.1                                 *
 *                                                               *
 * See the readme.txt included with this source code for more    *
 * information, and instructions for compiling and using this    *
 * program.                                                      *
 *                                                               *
 * Disclaimer:   DISCLAIM THIS!!!!                               *
 * This program and source code are distributed as is.  There is *
 * NO guarantee that it will work on all systems.  Please test   *
 * it out before using.  The programmers take no responsibilty   *
 * for lost or damaged files, or any other problems that use of  *
 * this software might cause.  USE AT YOUR OWN RISK!!!           *
 *                                                               *
 * Bug Reports:                                                  *
 * If you find a bug, please e-mail a description of your        *
 * operating system, what the bug does, and how to reproduce it  *
 * to hjeffrey@wam.umd.edu  I will make every effort to find and *
 * correct the bug.                                              *
 *****************************************************************/

/*  Change these setting to match your system. */

/* OS/2 System */
#define OS2
/* Unix System */
/*
#define UNIX
*/

/*  Use default configuration if config file is not found.  Set to FALSE  */
/*  to cause testzip to exit if config is not found.                      */

#define CONFIG_DEFAULTS TRUE

/*  If testzip can't open the logfile, it will exit.  Set this to true to */
/*  cause it to continue, but disable all logging.                        */

#define READONLY_LOG FALSE

/*  It is not recommended that you modify any of these values, however,   */
/*  if you know what you are doing, you can customize these to meet your  */
/*  and your system's needs.                                              */

#define MAX_LINE_LEN 125
#define MAX_EXTENSION 5
#define MAX_ARCHIVER_NAME 20
#define MAX_TEST_COMMAND 50
#define MAX_ARCHIVERS 10
#define MAX_DIR_LEN 100
#define MAX_CONFIG_NAME 15
#define MAX_LOG_NAME 25

/*  Operating System specific settings.  DO NOT change 'STATUS1'.  If you */
/*  do, testzip will not be able to properly test files.                  */

#if defined(OS2)
   #define STATUS1 255
   #define CONFIG_NAME "testzip.cfg"
#elif defined(UNIX)
   #define STATUS1 256
   #define CONFIG_PATH "/usr/local/lib"
   #define CONFIG_NAME ".testzipcfg"
#else
   #error No Operating system specified -- Edit testzip.h
#endif


/**************************************************************************/
/*  DO NOT Modify anything below this line.  Doing so will cause testzip  */
/*  to work improperly, and possibly not work at all.                     */
/**************************************************************************/

#define TRUE 1
#define FALSE 0

/*  Testzip Version Number  */

#define TZ_VERSION "1.11"

/*  Type definitions of Boolean type, and configuration structs.      */

typedef short int Bool;

typedef struct {
   char name[MAX_ARCHIVER_NAME+1];
   char extension[MAX_EXTENSION+1];
   char option;
   char command[MAX_TEST_COMMAND+1];
} archiver;

typedef struct {
   Bool do_delete;
   char dir[MAX_DIR_LEN+1];
   char logname[MAX_LOG_NAME+1];
   short int loglevel;
   Bool overwrite;
   Bool append;
   archiver archive[MAX_ARCHIVERS];
   short int default_num;
   short int num_archivers;
   Bool do_all;
} config;

/*  Function Prototypes  */

void do_archive_test();
void open_log();
void check_status(const int status, char tmpcommand[]);
void read_options(int *argc, char *argv[]);
void strtoupper(char *string);
void check_dir(char *string);
void load_config_defaults();
void print_config();
void read_config();
