@echo off

echo ======================================
echo T.BAT
echo TSR Build Utility
echo Version 1.6
echo Copywrite (C) 1987-1995, Geoff Friesen
echo All rights reserved.
echo ======================================

if %1.==. goto syntax

set filename=%1
set tsrargs=
shift

:next
if %1.==. goto compile
set tsrargs=%tsrargs% %1
shift
goto next

:compile
echo TSR arguments = %tsrargs%
bcc -mt -S -I%ti% %filename%.c
if errorlevel 1 goto badexit

filter %filename%
if errorlevel 1 goto badexit

tsr %tsrargs% %filename%
if errorlevel 1 goto badexit

tasm %filename%
if errorlevel 1 goto badexit

tlink /t %filename%
if errorlevel 1 goto badexit

echo TSR build successful.
goto exit

:badexit
echo TSR build unsuccessful.
goto exit

:syntax
echo "-------------------------------------------------------------------"
echo "t.bat - TSR Build Utility                                          "
echo "                                                                   "
echo "Command-line format:                                               "
echo "                                                                   "
echo "t tsrspec options                                                  "
echo "                                                                   "
echo "options = map | [hotkey] [include] [setup_cleanup] [stack] [xparse]"
echo "                                                                   "
echo "map = ("/"|"-") "m"                                                "
echo "hotkey = ("/"|"-") "h" x                                           "
echo "include = ("/"|"-") "i"                                            "
echo "setup_cleanup = ("/"|"-") "sc"                                     "
echo "stack = ("/"|"-") "s" y                                            "
echo "xparse = ("/"|"-") "x"                                             "
echo "                                                                   "
echo "x is either "A"-"Z" or "0"-"9" (default is T)                      "
echo "y is a byte value from 256 to 8192 (default is 256)                "
echo "tsrspec defines the .TSR file to be TSRed                          "
echo "                                                                   "
echo "You may specify a search path for include files by setting environ-"
echo "ment variable TI to this path.  By default, BCC can locate standard"
echo "include files (DOS.H, STDLIB.H, etc.) but will need help in finding"
echo "others.  This is where TI comes in.  Suppose C:\BORLANDC\TSR is the"
echo "location of TSR specific include files.  The following SET can help"
echo "BCC find these files.                                              "
echo "                                                                   "
echo "SET TI=C:\BORLANDC\TSR                                             "
echo "                                                                   "
echo "BCC will search C:\BORLANDC\TSR for all include files not in either"
echo "the current or standard directories.                               "
echo "                                                                   "
echo "Example: t sample -hs -s350                                        "
echo "-------------------------------------------------------------------"

:exit
set filename=
set tsrargs=
