/*
	sprintf.C

	Copyright (C) 1987-1995, Geoff Friesen 
	All rights reserved.
*/

#define INCL_SPRINTF

#ifndef INCL_FORMAT
#include "format.C"
#endif

char *sprintf_buffer;

void sprintf_putc (int c);

/* ---------------------------------------------------------- */
/* int sprintf (char *buffer, const char *fmt, ...);          */
/*                                                            */
/* Output a formatted string to the buffer.  The fmt argument */
/* specifies a string of literal characters and format speci- */
/* fiers.  A variable number of arguments (depending upon the */
/* number of format specifiers) follows.  This function calls */
/* the format function to perform the actual formatting.  The */
/* local function is used to output to the buffer.  The fol-  */
/* lowing format specifiers are valid: c (character), d or i  */
/* (integer), u (unsigned integer), X (uppercase hex) or x    */
/* (lowercase hex).  The return value specifies the number of */
/* characters output.                                         */
/* ---------------------------------------------------------- */

int sprintf (char *buffer, const char *fmt, ...)
{
   int count;

   sprintf_buffer = buffer;

   count = format (sprintf_putc, fmt, (void *) ...);

   *sprintf_buffer = '\0';

   return count;
}

void sprintf_putc (int c)
{
   *sprintf_buffer++ = c;
}
