/*
	fde.C

	Format Directory Entry

	Copyright (C) 1987-1995, Geoff Friesen
	All rights reserved.
*/

#define INCL_FDE

#ifndef INCL_ITOA
#include "itoa.C"
#endif

#ifndef INCL_LTOA
#include "ltoa.C"
#endif

#ifndef INCL_MEMCHR
#include "memchr.C"
#endif

#ifndef INCL_MEMCPY
#include "memcpy.C"
#endif

#ifndef INCL_MEMSET
#include "memset.C"
#endif

#ifndef INCL_STRCAT
#include "strcat.C"
#endif

#ifndef INCL_STRLEN
#include "strlen.C"
#endif

#ifndef INCL_STRLWR
#include "strlwr.C"
#endif

void fde (struct ffblk *de, char *buffer)
{
  int c, tmp;
  unsigned index, length;
  char *ptr, tmpbuf [12];

/* PREPARE BUFFER */

  memset (buffer, ' ', DESIZE-1);
  buffer [DESIZE-1] = '\0';

/* PROCESS DIRECTORY ENTRY NAME */

  length = strlen (de->ff_name);

  if (de->ff_name [0] == '.')
      memcpy (buffer, de->ff_name, length);
  else
  {
     if (!(de->ff_attrib & FA_DIREC))
	 strlwr (de->ff_name);

     if (!(ptr = (char *) memchr (de->ff_name, '.', length)))
	 memcpy (buffer, de->ff_name, length);
     else
     {
	memcpy (buffer, de->ff_name, length-strlen (ptr));
	memcpy (buffer+9, ptr+1, strlen (ptr+1));
     }
  }

  if (de->ff_attrib & FA_LABEL)
      return;

  index = 13;

/* PROCESS FILE SIZE */

  if (!(de->ff_attrib & FA_DIREC))
  {
      _ltoa (de->ff_fsize, tmpbuf);
      length = strlen (tmpbuf);
      memcpy (buffer+index+10-length, tmpbuf, length);
  }
  else
      memcpy (buffer+index+4, "[DIR]", 5);

  index += 12;

/* PROCESS DIRECTORY ENTRY DATE */

  _itoa ((de->ff_fdate & 0x01e0) >> 5, tmpbuf);
  strcat (tmpbuf, "-");
  if ((length = strlen (tmpbuf)) == 2)
      index++;

  memcpy (buffer+index, tmpbuf, length);

  index += length;

  _itoa (de->ff_fdate & 0x001f, tmpbuf);
  strcat (tmpbuf, "-");
  if ((length = strlen (tmpbuf)) == 2)
      buffer [index++] = '0';

  memcpy (buffer+index, tmpbuf, length);

  index += length;

  _itoa (((de->ff_fdate & 0xfe00) >> 9)+80, tmpbuf);
  if ((length = strlen (tmpbuf)) == 1)
      index++;
  if (length == 3)
  {
      length--;
      memcpy (buffer+index, "00", 2);
  }
  else
      memcpy (buffer+index, tmpbuf, length);

  index += (length+2);

/* PROCESS DIRECTORY ENTRY TIME */

  tmp = (unsigned char) ((de->ff_ftime & 0xf800) >> 11);
  c = (tmp >= 12) ? 'p' : 'a';

  if (!tmp)
      tmp = 12;
  else
      if (tmp > 12)
	  tmp -= 12;

  _itoa ((int) tmp, tmpbuf);
  strcat (tmpbuf, ":");
  if ((length = strlen (tmpbuf)) == 2)
      index++;

  memcpy (buffer+index, tmpbuf, length);

  index += length;

  tmp = (unsigned char) ((de->ff_ftime & 0x07e0) >> 5);

  _itoa (tmp, tmpbuf);
  if ((length = strlen (tmpbuf)) == 1)
      buffer [index++] = '0';

  memcpy (buffer+index, tmpbuf, length);

  index += length;

  buffer [index] = c;
}