/*
	event.C

	Copyright (C) 1987-1995, Geoff Friesen
	All rights reserved.
*/

#define INCL_EVENT

#ifndef INCL_MOUSE
#include "mouse.C"
#endif

// QSIZE may be increased if events are being skipped

#define QSIZE                           100

struct
{
   int count;                      /* mouse delay counter */
   int head;                       /* queue head */
   int lparm3;                     /* mouse x position parameter */
   int lparm4;                     /* mouse y position parameter */
   int mexist;                     /* mouse exist flag */
   int pressed;                    /* mouse left button pressed flag */
   int tail;                       /* queue tail */
   int timer_counter [NTIMER];
   int timer_enabled [NTIMER];
   int timer_start [NTIMER];
   int trigger;                    /* num. ticks to wait before storing */
				   /* mouse left button press event */
   event q [QSIZE+1];
   void interrupt (*oldint1c) (void);
}
event_vars;

void far        mhandler        (void);
void interrupt  mhandler_2      (void);
void interrupt  newint1c        (void);

/* ------------------------ */
/* void e_close (void);     */
/*                          */
/* Close the event handler. */
/* ------------------------ */

void e_close (void)
{
   int i;

   setvect (0x1c, event_vars.oldint1c);
   m_restorectx ();

   for (i = 0; i < NTIMER; i++)
	event_vars.timer_enabled [i] = 0;
}

/* ---------------------------------------- */
/* void e_fetch (event *e);                 */
/* Fetch the next event.  NONE is returned  */
/* as the event type if there are no events */
/* in the queue.                            */
/* ---------------------------------------- */

void e_fetch (event *e)
{
   if (event_vars.head == event_vars.tail)
       e->type = NONE;
   else
   {
       disable();
       *e = event_vars.q [event_vars.head = (event_vars.head+1) % QSIZE];
       enable();
   }
}

/* ---------------------- */
/* void e_flush (void);   */
/*                        */
/* Empty the event queue. */
/* ---------------------- */

void e_flush (void)
{
   while (k_iskey ())
      k_fetch ();

   disable();
   event_vars.head = event_vars.tail;
   enable();
}

/* -------------------------------- */
/* int e_gettimer (int id);         */
/*                                  */
/* Retrieve the timer counter value */
/* for the timer identified by id   */
/* (0 <= id < NTIMER).              */
/* -------------------------------- */

int e_gettimer (int id)
{
   int value;

   disable();
   value = event_vars.timer_counter [id];
   enable();

   return value;
}

/* ---------------------------- */
/* int e_gettrigger (void);     */
/*                              */
/* Retrieve the trigger setting */
/* for auto-repeat mouse left   */
/* button down events (1 is the */
/* optimal value).              */
/* ---------------------------- */

int e_gettrigger (void)
{
   return event_vars.trigger;
}

/* ---------------------------------------- */
/* void e_hide (void);                      */
/*                                          */
/* Hide the mouse cursor if a mouse exists. */
/* ---------------------------------------- */

void e_hide (void)
{
   if (event_vars.mexist)
       m_hide ();
}

/* ----------------------- */
/* void e_open (void);     */
/*                         */
/* Open the event handler. */  
/* ----------------------- */

void e_open (void)
{
   int i;

   for (i = 0; i < NTIMER; i++)
	event_vars.timer_enabled [i] = event_vars.timer_start [i] = 0;

   event_vars.mexist = ismoudrv ();
   m_savectx ();

   event_vars.head = event_vars.tail = event_vars.count = 0;
   event_vars.pressed = 0;

   event_vars.oldint1c = getvect (0x1c);
   setvect (0x1c, newint1c);

   if (event_vars.mexist)
       m_insttask (0x7f, _CS, FP_OFF(mhandler));
}

/* ------------------------------------- */
/* void e_settimer (int id, int value);  */
/*                                       */
/* Start a new timer (0 <= id < NTIMER). */
/* The number of ticks to count down     */
/* from is passed in value.              */
/* ------------------------------------- */

void e_settimer (int id, int value)
{
   disable();
   event_vars.timer_counter [id] = event_vars.timer_start [id] = value;
   event_vars.timer_enabled [id] = 1;
   enable();
}

/* ------------------------------ */
/* void e_settrigger (int value); */
/*                                */
/* Define the trigger setting for */
/* auto-repeat left mouse button  */
/* down events.                   */
/* ------------------------------ */

void e_settrigger (int value)
{
   event_vars.trigger = value;
}

/* ---------------------------------------- */
/* void e_show (void);                      */
/*                                          */
/* Show the mouse cursor if a mouse exists. */
/* ---------------------------------------- */

void e_show (void)
{
   if (event_vars.mexist)
       m_show ();
}

/* ------------------------------------ */
/* void e_tresume (int id);             */
/*                                      */
/* Resume the timer that was previously */
/* paused (0 <= id < NTIMER).           */
/* ------------------------------------ */

void e_tresume (int id)
{
   disable();
   event_vars.timer_enabled [id] = 1;
   enable();
}

/* ------------------------------------------- */
/* void e_tsuspend (int id);                   */
/*                                             */
/* Suspend an active timer (0 <= id < NTIMER). */
/* ------------------------------------------- */

void e_tsuspend (int id)
{
   disable();
   event_vars.timer_enabled [id] = 0;
   enable();
}

/* ------------------------- */
/* void far mhandler (void); */
/* ------------------------- */

void far mhandler (void)
{
   mhandler_2 ();
}

/* --------------------------------- */
/* void interrupt mhandler_2 (void); */
/* --------------------------------- */

void interrupt mhandler_2 (void)
{
   unsigned ax, bx, cx, dx, temp;

   ax = _AX;
   bx = _BX;
   cx = _CX;
   dx = _DX;

   if ((temp = (event_vars.tail+1) % QSIZE) == event_vars.head)
       return;

   event_vars.q [event_vars.tail = temp].type = MOUSE;
   event_vars.q [event_vars.tail].parm1 = ax;           /* flags */
   event_vars.q [event_vars.tail].parm2 = bx;           /* button status */
   event_vars.q [event_vars.tail].parm3 = cx;           /* x */
   event_vars.q [event_vars.tail].parm4 = dx;           /* y */

   if (ax & ME_LBP)
   {
       event_vars.pressed = 1;
       event_vars.lparm3 = cx;
       event_vars.lparm4 = dx;
   }

   if (ax & ME_LBR)
       event_vars.count = event_vars.pressed = 0;
}

/* ------------------------------- */
/* void interrupt newint1c (void); */
/* ------------------------------- */

void interrupt newint1c (void)
{
   int i, keystroke, temp;

   (*event_vars.oldint1c) ();

   for (i = 0; i < NTIMER; i++)
	if (event_vars.timer_enabled [i])
	{
	    event_vars.timer_counter [i]--;
	    if (!event_vars.timer_counter [i])
	    {
		event_vars.timer_counter [i] = event_vars.timer_start [i];
		if ((temp = (event_vars.tail+1) % QSIZE) == event_vars.head)
		    return;
		event_vars.q [event_vars.tail = temp].type = TIMER;
		event_vars.q [event_vars.tail].parm1 = i;
	    }
	}

   if (k_iskey ())
   {
       _AH = 0;
       geninterrupt(0x16);

       keystroke = _AX;
       if (keystroke & 0x00ff)
	   keystroke &= 0x00ff;

       if ((temp = (event_vars.tail+1) % QSIZE) == event_vars.head)
	   return;

       event_vars.q [event_vars.tail = temp].type = KEY;
       event_vars.q [event_vars.tail].parm1 = keystroke;
   }

   if (event_vars.pressed)
       if (event_vars.count == event_vars.trigger)  // Wait trigger/18 second
       {
	   if ((temp = (event_vars.tail+1) % QSIZE) == event_vars.head)
	       return;

	   event_vars.q [event_vars.tail = temp].type = MOUSE;
	   event_vars.q [event_vars.tail].parm1 = ME_LBP;
	   event_vars.q [event_vars.tail].parm3 = event_vars.lparm3;
	   event_vars.q [event_vars.tail].parm4 = event_vars.lparm4;

	   event_vars.count = 0;
       }
       else
	   event_vars.count++;
}
