/*
	int2148.C

	Version 1.6

	Memory Experiment Using Interrupt 21h Function 48h

	Copyright (C) 1987-1995, Geoff Friesen 
	All rights reserved.

	Developed with: Borland C++ 3.1
*/

/*
	set ti=c:\borlandc\tsr\tsrlib
	t int2148 -hi
*/

#if !defined(__TINY__)
#error Tiny Memory Model Expected
#endif

#include "tsrlib.H"

char *title = "\r\n"

"ͻ\r\n"
"                                  \r\n"
"                                          \r\n"
"                                            \r\n"
"                          Version 1.6 \r\n"
"                                             \r\n"
"                                              \r\n"
"                                 \r\n"
"                                                       \r\n"
" Copyright (C) 1987-1995, Geoff Friesen                \r\n"
" All rights reserved.                                  \r\n"
"ͼ\r\n"
"$";

#define NCOLS   24
#define NROWS   3

char buffer [(NCOLS+1)*(NROWS+1)*2];

int column = (80-NCOLS)/2;
int row = (25-NROWS)/2;

char *_uitoa (unsigned value, char *string);

void main (void)
{
   unsigned paras;
   char buffer2 [6];
   int cshape, i, vmode, x, y;

   if ((vmode = v_getmode ()) != BW80 && vmode != C80 && vmode != MONO)
       return;

   m_savectx ();

   cshape = v_getshape ();
   v_setshape (0x2000);         /* hide cursor */

   x = v_wherex ();
   y = v_wherey ();

   v_screen (SCREEN_SAVE, column, row, NCOLS+1, NROWS+1, buffer);

   v_setattr (LIGHTGRAY << 4);
   v_border (SINGLE_LINE, column, row, NCOLS, NROWS);
   v_shadow (column, row, NCOLS, NROWS);
   v_clear(column+1, row+1, NCOLS-2, NROWS-2);

   v_gotoxy (column+1, row+1);
   v_cputs ("Free Paragraphs: ");

   _AH = 0x48;
   _BX = 0xffff;
   geninterrupt(0x21);

   paras = _BX;
   v_cputs (_uitoa (paras, buffer2));

   (void) k_fetch ();

   v_screen (SCREEN_RESTORE, column, row, NCOLS+1, NROWS+1, buffer);
   v_gotoxy (x, y);
   v_setshape (cshape);

   m_restorectx ();
}

char *_uitoa (unsigned value, char *string)
{
   unsigned i = 0;

   do
      string [i++] = value%10+'0';
   while ((value /= 10) > 0);

   string [i] = '\0';
   return strrev (string);
}

#ifndef INCL_KFETCH
#include "kfetch.C"
#endif

#ifndef INCL_MOUSE
#include "mouse.C"
#endif

#ifndef INCL_STRREV
#include "strrev.C"
#endif

#ifndef INCL_VBORDER
#include "vborder.C"
#endif

#ifndef INCL_VCPUTS
#include "vcputs.C"
#endif

#ifndef INCL_VGETMODE
#include "vgetmode.C"
#endif

#ifndef INCL_VGETSHAPE
#include "vgetshap.C"
#endif

#ifndef INCL_VPAINT
#include "vpaint.C"
#endif

#ifndef INCL_VSETATTR
#include "vsetattr.C"
#endif

#ifndef INCL_VSETSHAPE
#include "vsetshape.C"
#endif

#ifndef INCL_VSHADOW
#include "vshadow.C"
#endif

#ifndef INCL_VWHEREX
#include "vwherex.C"
#endif

#ifndef INCL_VWHEREY
#include "vwherey.C"
#endif
