/*
	g.C

	Version 1.6

	Graphics Demo

	Copyright (C) 1987-1995, Geoff Friesen
	All rights reserved.

	Developed with: Borland C++ 3.1
*/

/*
	set ti=c:\borlandc\tsr\tsrlib
	t g -hg -i

	The BIOS memory location 0040:0084 is set to the number of
	screen rows less one.  For example, if the screen has been
	set to 25 lines then the value 24 would be stored here.  A
	value of 49 would be stored if 50-line mode were in effect
	(on VGA adaptors).  This address is used by recent adaptor
	BIOSes.  Older BIOSes do not use it.  Therefore, assume it
	to be valid if it returns a 24, 42, or 49.  The 42 is used
	in EGA 43-line mode.
*/

#if !defined(__TINY__)
#error Tiny Memory Model Expected
#endif

#include "tsrlib.H"

#undef abs

char *title = "\r\n"

"ͻ\r\n"
"                                      \r\n"
"                                       \r\n"
"                                        \r\n"
"   Version 1.6                       \r\n"
"                                       \r\n"
"                                       \r\n"
"                                      \r\n"
"                                         \r\n"
" Copyright (C) 1987-1995, Geoff Friesen  \r\n"
" All rights reserved.                    \r\n"
"ͼ\r\n"
"$";

#define NUM_STARS  125

#define PLANE_1    1
#define PLANE_2    2
#define PLANE_3    3

char buffer [8000];

typedef struct star_typ
	{
	   int x, y;    // position of star
	   int plane;   // which plane is star in
	   int color;   // color of star
	   unsigned char back;  // background underneath star
	}
	star, *star_ptr;

int star_first = 1;     // flags first time into star field

star stars [NUM_STARS]; // the star field

int velocity_1 = 1,     // the speeds of each plane
    velocity_2 = 2,
    velocity_3 = 3;

int  abs        (int);
void Delay      (int);
void Init_Stars (void);
void Picture    (void);

void main (void)
{
   RGB_color color, greencolor, redcolor;
   int cshape, done = 0, green = 0, index, nrows, red = 0, vmode, x, y;

   // Make sure that video adaptor is VGA.

   if (v_aa () != VGA_BW && v_aa () != VGA_COLOR)
       return;

   // Make sure that a video text mode is active.

   if ((vmode = v_getmode ()) != BW80 && vmode != C80 && vmode != MONO)
       return;

   // Save mouse context.

   m_savectx ();

   // Determine number of text video mode rows.

   nrows = peekb(0x40, 0x84)+1;
   if (nrows != 25 && nrows != 50)
       nrows = 25;

   // Initialize random number generator seed.

   randomize ();

   // Save cursor shape and hide cursor.

   cshape = v_getshape ();
   v_setshape (0x2000);

   // Save cursor position.

   x = v_wherex ();
   y = v_wherey ();

   // Save screen contents.

   v_screen (SCREEN_SAVE, 1, 1, 80, nrows, buffer);

   // Set 320x200 256-color video mode.

   _AH = 0;
   _AL = 0x13;
   geninterrupt (0x10);

   // Save GREEN palette register.

   g_getpaletteregister (GREEN, &greencolor);

   // Save RED palette register.

   g_getpaletteregister (RED, &redcolor);

   // Initialize GREEN palette entry to BLACK.

   color.red = 0;
   color.green = 0;
   color.blue = 0;
   g_setpaletteregister (GREEN, &color);

   // Initialize RED palette entry to BLACK.

   color.red = 0;
   color.green = 0;
   color.blue = 0;
   g_setpaletteregister (RED, &color);

   // Draw a picture.

   Picture ();

   // Initialize star data structures.

   Init_Stars ();

   // Main loop.

   while (!done)
   {
      color.red = 0;
      color.green = green;
      color.blue = 0;
      g_setpaletteregister (GREEN, &color);

      if (green++ > 255)
	  green = 0;

      color.red = red;
      color.green = 0;
      color.blue = 0;
      g_setpaletteregister (RED, &color);

      if (red++ > 255)
	  red = 0;

      if (k_iskey ())
      {
	  switch (k_fetch ())
	  {
	     case '-': // slow down star field

		  // Decrease velocity of each plane.

		  velocity_1 -= 1;
		  velocity_2 -= 2;
		  velocity_3 -= 3;

		  break;

	     case '=': // speed up star field

		  // Increase velocity of each plane.

		  velocity_1 += 1;
		  velocity_2 += 2;
		  velocity_3 += 3;

		  break;

	     case ESC: // user is exiting

		  done = 1;
	  }
      }

      // Move the star fields.

      for (index = 0; index < NUM_STARS; index++)
      {
	   // Erase the star.

	   if (stars [index].back != 255)
	       g_plot (stars [index].x, stars [index].y,
		       stars [index].back);

	   // Move the star and test for off screen condition.

	   // Each star is in a different plane so test which plane star is
	   // in so that proper velocity may be used.

	   switch (stars [index].plane)
	   {
	      case PLANE_1: // the slowest plane

		   stars [index].x += velocity_1;
		   break;

	      case PLANE_2: // the medium speed plane

		   stars [index].x += velocity_2;
		   break;

	      case PLANE_3: // the fastest plane (near)

		   stars [index].x += velocity_3;
	   }

	   // Test if star went off screen.

	   if (stars [index].x > 319) // off right edge?
	       stars [index].x -= 320; // wrap around
	   else
	   if (stars [index].x < 0) // off left edge?
	       stars [index].x += 320; // wrap around

	   // Save background.

	   stars [index].back = g_read (stars [index].x, stars [index].y);

	   // Check to see if star underneath.

	   if (stars [index].back == 7 || stars [index].back == 8 ||
	       stars [index].back == 15)
	       stars [index].back = 255;

	   // Draw the star at new position.

	   if (g_read (stars [index].x, stars [index].y) != RED)
	       g_plot (stars [index].x, stars [index].y,
		       stars [index].color);
      }

      // Wait a second so we can see the stars, otherwise it will look like
      // warp speed!

      Delay (1);
   }

   // Restore GREEN palette register.

   g_setpaletteregister (GREEN, &greencolor);

   // Restore RED palette register.

   g_setpaletteregister (RED, &redcolor);

   // Restore original video mode.

   _AH = 0;
   _AL = vmode;
   geninterrupt (0x10);

   // If the video text mode was 80x50 (VGA) then make sure that
   // the appropriate font is reloaded after the preceding mode
   // change.

   if (nrows != 25)
   {
       _AX = 0x1112;
       _BL = 0;
       geninterrupt (0x10);
   }

   // Restore screen contents.

   v_screen (SCREEN_RESTORE, 1, 1, 80, nrows, buffer);

   // Restore cursor position.

   v_gotoxy (x, y);

   // Restore cursor shape.

   v_setshape (cshape);

   // Restore mouse context.

   m_restorectx ();
}

// ======================================
// abs
//
// Return the absolute value of a number.
// ======================================

int abs (int value)
{
    return (value < 0) ? -value : value;
}

// ===========================================
// Delay
//
// Pause for a specific number of timer ticks.
// ===========================================

void Delay (int clicks)
{
// this function uses the internal time keeper timer i.e. the one that goes
// at 18.2 clicks/sec to to a time delay.  You can find a 32 bit value of
// this timer at 0000:046Ch

   unsigned int far *clock = (unsigned int far *)0x0000046CL;
   unsigned int now;

// get current time

   now = *clock;

// wait till time has gone past current time plus the amount we eanted to
// wait.  Note each click is approx. 55 milliseconds.

   while (abs (*clock - now) < clicks) {}
}

// ==========================
// Init_Stars
//
// Initialize the star field.
// ==========================

void Init_Stars (void)
{
   int i, j, x, y;

   // For each star, choose a position, plane and color.

   for (i = 0; i < NUM_STARS; i++)
   {
	// Initialize each star to a velocity, position and color.

	do
	{
	   x = rand () % 320;
	   y = rand () % 190;

	   for (j = 0; j < i; j++)
		if (stars [j].x == x && stars [j].y == y ||
		    g_read (x, y) == RED)
		    break;

	   if (j == i)
	       break;
	}
	while (1);

	stars [i].x = x;
	stars [i].y = y;
	stars [i].back = g_read (stars [i].x, stars [i].y);

	// Decide what star plane the star is in.

	switch (rand () % 3)
	{
	   case 0: // plane 1 - the farthest star plane

		// set velocity and color

		stars [i].plane = 1;
		stars [i].color = 8;

		break;

	   case 1: // plane 2 - the medium distance star plane

		// set velocity and color

		stars [i].plane = 2;
		stars [i].color = 7;

		break;

	   case 2: // plane 3 - the nearest star plane

		// set velocity and color

		stars [i].plane = 3;
		stars [i].color = 15;
	}
   }
}

/* ----------------------------- */
/* Picture                       */
/*                               */
/* Draw a picture on the screen. */
/* ----------------------------- */

void Picture (void)
{
   int i;

   for (i = 0; i <= 100; i += 10)
   {
	g_moveto (0, i);
	g_lineto (100-i, 0, RED);

	g_moveto (319, i);
	g_lineto (319-100+i, 0, RED);

	g_moveto (319, 199-i);
	g_lineto (319-100+i, 199, RED);

	g_moveto (0, 199-i);
	g_lineto (100-i, 199, RED);
   }

   g_moveto (96, 192);
   g_writestr ("G: Graphics Demo", GREEN, 1);
}

#ifndef INCL_GRAPHICS
#include "graphics.C"
#endif

#ifndef INCL_KFETCH
#include "kfetch.C"
#endif

#ifndef INCL_KISKEY
#include "kiskey.C"
#endif

#ifndef INCL_MOUSE
#include "mouse.C"
#endif

#ifndef INCL_RANDOM
#include "random.C"
#endif

#ifndef INCL_VAA
#include "vaa.C"
#endif

#ifndef INCL_VGETMODE
#include "vgetmode.C"
#endif

#ifndef INCL_VGETSHAPE
#include "vgetshap.C"
#endif

#ifndef INCL_VGOTOXY
#include "vgotoxy.C"
#endif

#ifndef INCL_VSCREEN
#include "vscreen.C"
#endif

#ifndef INCL_VSETSHAPE
#include "vsetshap.C"
#endif

#ifndef INCL_VWHEREX
#include "vwherex.C"
#endif

#ifndef INCL_VWHEREY
#include "vwherey.C"
#endif
