/*
	ftally.C

	Version 1.6

	Tally all files matching the user-specified filespec.

	Copyright (C) 1987-1995, Geoff Friesen
	All rights reserved.

	Developed with: Borland C++ 3.1
*/

/*
	set ti=c:\borlandc\tsr\tsrlib
	t ftally -hf -i -s512
*/

#if !defined(__TINY__)
#error Tiny Memory Model Expected
#endif

#include "tsrlib.H"

char *title = "\r\n"

"ͻ\r\n"
"                                  \r\n"
"                                         \r\n"
"                                         \r\n"
"                      Version 1.6 \r\n"
"                                          \r\n"
"                                          \r\n"
"                                  \r\n"
"                                                 \r\n"
" Copyright (C) 1987-1995, Geoff Friesen          \r\n"
" All rights reserved.                            \r\n"
"ͼ\r\n"
"$";

#define SPECLEN 60

char filespec [SPECLEN+1];

#define NCOLS   SPECLEN+3
#define NROWS   22

int column = 1;
int row = 1;

char screen_buffer [(NCOLS+1)*(NROWS+1)*2];

#define NATTR   3

int attr [NATTR];

int bw [] =
{
   WHITE,                               /* border */
   LIGHTGRAY,                           /* file name */
   LIGHTGRAY << 4                       /* title */
};

int color [] =
{
   YELLOW,                              /* border */
   CYAN,                                /* file name */
   GREEN                                /* title */
};

void main (void)
{
   long total_size;
   struct ffblk de;
   char buffer [DESIZE];
   int cshape, done, i, tally = 0, vmode, x, y;

   if ((vmode = v_getmode ()) != BW80 && vmode != C80 && vmode != MONO)
       return;

   m_savectx ();

   for (i = 0; i < NATTR; i++)
	attr [i] = (vmode == C80) ? color [i] : bw [i];

   cshape = v_getshape ();
   v_setshape (0x2000);         /* hide cursor */

   x = v_wherex ();
   y = v_wherey ();

   v_screen (SCREEN_SAVE, 1, 1, NCOLS+1, NROWS+1, screen_buffer);

   v_setattr (attr [1]);

   v_paint (' ', column+1, row+1, NCOLS-2, NROWS-2);

   v_setattr (attr [2]);

   v_gotoxy (column+(NCOLS-11)/2, row+1);
   v_cputs ("FTALLY v1.6");

   v_setattr (attr [0]);

   v_border (DOUBLE_LINE, column, row, NCOLS, NROWS);
   v_shadow (column, row, NCOLS, NROWS);

   v_gotoxy (column, row+2);
   v_putch ('', 1);
   v_putch ('', NCOLS-2);
   v_putch ('', 1);

   v_gotoxy (column, row+NROWS-5);
   v_putch ('', 1);
   v_putch ('', NCOLS-2);
   v_putch ('', 1);

   v_gotoxy (column, row+NROWS-3);
   v_putch ('', 1);
   v_putch ('', NCOLS-2);
   v_putch ('', 1);

   v_setattr (attr [1]);

   while (1)
   {
      v_gotoxy (column+1, row+NROWS-2);

      filespec [0] = '\0';
      if (getstr (filespec, SPECLEN) == ESC)
	  break;

      tally = 0;
      total_size = 0;

      v_paint (' ', column+1, row+3, NCOLS-2, NROWS-8);

      i = 0;
      done = findfirst (filespec, &de, 0);
      while (!done)
      {
	 if (i == NROWS-8)
	 {
	     v_scroll (column+1, row+3, NCOLS-2, NROWS-8, SCROLL_UP, 1,
		       attr [1]);
	     i--;
	 }

	 fde (&de, buffer);
	 v_gotoxy (column+(NCOLS-DESIZE)/2, row+3+i++);
	 v_cputs (buffer);

	 tally++;
	 total_size += de.ff_fsize;
	 done = findnext (&de);
      }

      v_gotoxy (column+1, row+NROWS-4);
      v_putch (' ', NCOLS-2);
      v_gotoxy (column+(NCOLS-DESIZE)/2, row+NROWS-4);
      v_cprintf ("Total files = %05d and size = %*lu", tally, 10,
		 total_size);
   }

   v_screen (SCREEN_RESTORE, 1, 1, NCOLS+1, NROWS+1, screen_buffer);
   v_gotoxy (x, y);
   v_setshape (cshape);

   m_restorectx ();
}

#ifndef INCL_FDE
#include "fde.C"
#endif

#ifndef INCL_FIND
#include "find.C"
#endif

#ifndef INCL_GETSTR
#include "getstr.C"
#endif

#ifndef INCL_KFETCH
#include "kfetch.C"
#endif

#ifndef INCL_MOUSE
#include "mouse.C"
#endif

#ifndef INCL_SPRINTF
#include "sprintf.C"
#endif

#ifndef INCL_VBORDER
#include "vborder.C"
#endif

#ifndef INCL_VCPRINTF
#include "vcprintf.C"
#endif

#ifndef INCL_VCPUTS
#include "vcputs.C"
#endif

#ifndef INCL_VGETMODE
#include "vgetmode.C"
#endif

#ifndef INCL_VGETSHAPE
#include "vgetshap.C"
#endif

#ifndef INCL_VGOTOXY
#include "vgotoxy.C"
#endif

#ifndef INCL_VPAINT
#include "vpaint.C"
#endif

#ifndef INCL_VSCREEN
#include "vscreen.C"
#endif

#ifndef INCL_VSCROLL
#include "vscroll.C"
#endif

#ifndef INCL_VSETATTR
#include "vsetattr.C"
#endif

#ifndef INCL_VSETSHAPE
#include "vsetshape.C"
#endif

#ifndef INCL_VSHADOW
#include "vshadow.C"
#endif

#ifndef INCL_VWHEREX
#include "vwherex.C"
#endif

#ifndef INCL_VWHEREY
#include "vwherey.C"
#endif
