(* This is a test program for the TSUNTB.TPU unit
   Updated 27-Jul-89, 18-Oct-89, 4-Jan-91, 27-Oct-91, 24-Aug-92,
           27-Sep-92, 23-Jan-93 *)

uses TSUNTB;

const loop = 200;   (* If you do want to make it quickly, change this to 1 *)

var time : real;    (* For timing the tests *)

procedure LOGO;
begin
  writeln;
  writeln ('TSUNTB unit test by Prof. Timo Salmi');
  writeln ('University of Vaasa, Finland, ts@uwasa.fi');
{$IFDEF VER40}
  writeln ('TP version 4.0');
{$ENDIF}
{$IFDEF VER50}
  writeln ('TP version 5.0');
{$ENDIF}
{$IFDEF VER55}
  writeln ('TP version 5.5');
{$ENDIF}
{$IFDEF VER60}
  writeln ('TP version 6.0');
{$ENDIF}
{$IFDEF VER70}
  writeln ('TP version 7.0');
{$ENDIF}
  writeln;
end;

(* Raise a positive number to a power the traditional way *)
procedure TEST1;
var i : integer;
    a : real;
begin
  time := TIMERFN;
  for i := 1 to loop do
    a := POWERFN (2, 15);
  time := TIMERFN - time;
  writeln ('POWERFN 2^15 = ', a:0:0);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;

(* Raise a longint number to a power fast *)
procedure TEST1A;
var i : integer;
    a : real;
begin
  time := TIMERFN;
  for i := 1 to loop do
    a := POWERLFN (-2, 15);
  time := TIMERFN - time;
  writeln ('POWERLFN -2^15 = ', a:0:0);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;  (* test1a *)

(* Raise any number to a power, the improved function *)
procedure TEST2;
var i : integer;
    a : real;
begin
  time := TIMERFN;
  for i := 1 to loop do
    a := POWERGFN (-2, 15);
  time := TIMERFN - time;
  writeln ('POWERGFN -2^15 = ', a:0:0);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;  (* test2 *)

(* Raise two to a power, that is 2^exponent, very fast *)
procedure TEST3;
var i : integer;
    a : word;
begin
  time := TIMERFN;
  for i := 1 to loop do
    a := TWOTOFN (15);
  time := TIMERFN - time;
  writeln ('TWOTOFN 2^15 = ', a);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;  (* test3 *)

(* Convert a binary string fast to a decimal word *)
procedure TEST4;
var i : integer;
    a : word;
begin
  time := TIMERFN;
  for i := 1 to loop do
                   {123456789 123456}
    a := BINDECFN ('1000000000000000');
  time := TIMERFN - time;
  writeln ('BINDECFN (''1000000000000000'') = ', a);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;  (* test4 *)

(* Convert a decimal word to a binary string fast *)
procedure TEST5A;
const x = 32768;
var i : integer;
    a : string;
begin
  time := TIMERFN;
  for i := 1 to loop do
    a := BINFN (x);
  time := TIMERFN - time;
  writeln ('BINFN (', x:0, ') = ', a);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;  (* test5a *)

(* Convert a decimal longint to a binary string fast *)
procedure TEST5B;
var i : integer;
    a : string;
    x : longint;
begin
  x := 32768;
  time := TIMERFN;
  for i := 1 to loop do
    a := LBINFN (x);
  time := TIMERFN - time;
  writeln ('LBINFN (', x:0, ') = ', a);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;  (* test5b *)

(* Convert a decimal byte to a binary string fast *)
procedure TEST5C;
var i : integer;
    a : string;
    x : longint;
begin
  x := 255;
  time := TIMERFN;
  for i := 1 to loop do
    a := BBINFN (x);
  time := TIMERFN - time;
  writeln ('BBINFN (', x:0, ') = ', a);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;  (* test5c *)

(* Convert a number from any base to any base (2-36) *)
procedure TEST6;
var i      : integer;
    result : string;
    x      : string;
    b1, b2 : byte;
begin
  x := '32768';
  b1 := 10;
  b2 := 2;
  time := TIMERFN;
  for i := 1 to loop do
    result := CONVBFN (x, b1, b2);
  time := TIMERFN - time;
  writeln ('CONVBFN (', x, ',', b1:0, ',', b2:0, ') = ', result);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;  (* test6 *)

(* Convert a hexadecimal string fast to a decimal word *)
procedure TEST7;
var i : integer;
    d : word;
    h : string;
begin
  h := 'F1a7';
  time := TIMERFN;
  for i := 1 to loop do
    d := HEXDECFN (h);
  time := TIMERFN - time;
  writeln ('HEXDECFN (', h, ') = ', d);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;  (* test7 *)

(* Convert a hexadecimal string (max 7FFFFFFF) to a decimal longint *)
procedure TEST7A;
var i : integer;
    d : longint;
    h : string;
begin
  h := '0000F1a7';
  time := TIMERFN;
  for i := 1 to loop do
    d := HEXLNGFN (h);
  time := TIMERFN - time;
  writeln ('HEXLNGFN (', h, ') = ', d);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;  (* test7a *)

(* Convert a decimal word to a hexadecimal string fast *)
procedure TEST8A;
var i : integer;
    a : string;
    d : word;
begin
  d := 32768;
  time := TIMERFN;
  for i := 1 to loop do
    a := HEXFN (d);
  time := TIMERFN - time;
  writeln ('HEXFN (', d:0, ') = $', a);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;  (* test8A *)

(* Convert a decimal longint to a hexadecimal string fast *)
procedure TEST8B;
var i : integer;
    a : string;
    x : longint;
begin
  x := maxint+1;
  time := TIMERFN;
  for i := 1 to loop do
    a := LHEXFN (x);
  time := TIMERFN - time;
  writeln ('LHEXFN (', x:0, ') = $', a);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;  (* test8b *)

(* Convert a decimal byte to a hexadecimal string fast *)
procedure TEST8C;
var i : integer;
    a : string;
    x : byte;
begin
  x := 255;
  time := TIMERFN;
  for i := 1 to loop do
    a := BHEXFN (x);
  time := TIMERFN - time;
  writeln ('BHEXFN (', x:0, ') = $', a);
  writeln ('Elapsed ', time:0:2);
  writeln;
end;  (* test8c *)

procedure TEST9;
var a : word;
begin
  a := BTEWRDFN (1, 2);
  writeln (hi(a), ' ', lo(a));
  writeln (a);
end;  (* test9 *)

procedure TEST10;
var a : longint;
begin
  a := WRDLNGFN (1, 2);
  writeln (HIWORDFN(a), ' ', LOWORDFN(a));
  writeln (a);
end;  (* test10 *)

(* Main program
   If you just want a particular test, comment the others away *)
begin
  LOGO;    (* If you want pauses, insert readln where appropriate *)
  {        (* If you want only part of the tests, comment the others away *)
  TEST1;
  TEST1A;
  TEST2;
  TEST3;
  TEST4;
  }
  TEST5A;
  TEST5B;
  TEST5C;
  {
  TEST6;
  TEST7;
  TEST7A;
  }
  TEST8A;
  TEST8B;
  TEST8C;
  {
  TEST9;
  TEST10;
  }
  write ('Press <-'' '); readln;
end.  (* tsuntb.tst *)
