/************************************************************************
  Author:  SemWare (Sammy Mitchell)
  Date:    April 8, 1993

  Description:

  A couple of macros to shift text, and then move the cursor to the next
  line.

  Usage notes:

  To use, add these macros to your TSE.S file, and key assignments to
  your TSE.KEY file, and re-bind the editor using the -b switch of sc.

  Example key assignments might be:

  <f11>         Align()
  <shift f11>   AlignAtCursor()

  Alternatively, add the key assignments to this file, and load the
  macro (as an external macro) as needed via the LoadMacro command
  (<ctrl f10><L> or 'menu->macro->load')
 ************************************************************************/

// QEdit-type align command
// Align the current line with the indentation of a previous line.
// Would be _much_ simpler if we didn't have to account for hard tabs!
// After aligning the current line, the cursor moves to the next line.
proc Align()
    string text[128]
    integer p = CurrPos()

    PushPosition()
    BegLine()
    if PosFirstNonWhite() and PrevChar() and lFind("[~ \t\x00\xff]","xb")
        text = GetText(1, PosFirstNonWhite() - 1)
        PopPosition()
        PushPosition()
        BegLine()
        DelChar(PosFirstNonWhite() - 1)
        InsertText(text, _INSERT_)
    endif
    PopPosition()
    GotoPos(p)
    Down()
end

// Shift text on the current line so as to be aligned with the cursor,
// for instance, move the cursor to the desired column, press the key
// this command is assigned to, and the text will be shifted such that
// it lines up with the cursor.
// After aligning the current line, the cursor moves to the next line.
proc AlignAtCursor()
    integer p = CurrPos()

    if PosFirstNonWhite()
        ShiftText(CurrPos() - PosFirstNonWhite())
    endif
    GotoPos(p)
    Down()
end

