/****************************************************************************
 *   FILENAME:  C:\TSE\MAC\CALLLIST.S V2.8 (FOR TSE 1.0)                    *
 *   AUTHOR  :  "Buddy" E. Ray Asbury, Jr.                                  *
 *   DATE    :  Fri 03-26-1993 12:27:52                                     *
 *                                                                          *
 *  CallList is designed for SAL application developers to use as an        *
 *  analysis tool.  It generates a listing file which includes each         *
 *  procedure AND MENU within the SAL file, showing                         *
 *                                                                          *
 *       the commands called AND occurrence counts                         *
 *       the other procedures called AND occurrence counts                 *
 *       seperates calls according to the arguments when possible (see     *
 *          modifications lists below for v2.0)                             *
 *       optionally shows the code AND stack sizes for procedures          *
 *       summary of the commands & procedures information for the          *
 *        entire file                                                       *
 *                                                                          *
 *  These features can be helpful WHEN optimizing applications.             *
 *                                                                          *
 *  Since operation of CallList depends upon detecting "words", the WordSet *
 *  must be correctly.  For example, IF your default WordSet does NOT       *
 *  INCLUDE "~", but you use that character in procedure names, CallList    *
 *  must be aware of that in order to function correctly.  In the main      *
 *  function below, simply edit the first SetGlobalInt line for             *
 *  "gCL_WordSet" so that it includes such characters.  At the least,       *
 *  gCL_WordSet should INCLUDE "0..9A..Za..z".  After making this change,   *
 *  IF needed, be sure to recompile this file.  Then, simply place          *
 *  CALLLIST.MAC & CALLLST2.MAC in either                                   *
 *                                                                          *
 *      1.  the current directory                                           *
 *      2.  the directory "pointed" to by MACPATH                           *
 *      3.  the startup directory of The SemWare Editor                     *
 *                                                                          *
 *  Then, start the editor with the file to be analyzed, AND execute        *
 *  CallList.  The SAL file (.S), which must be the current file, is        *
 *  copied to a temporary buffer AND the Copy is used by CallList.  The     *
 *  original SAL file is NOT modified.  During processing, messages will    *
 *  appear to show what CallList is doing.  ON large files, CallList may    *
 *  take several minutes.                                                   *
 *                                                                          *
 *  Here is a sample listing:                                               *
 *                                                                          *
 *      INTEGER PROC mFactor()                                              *
 *        Return()                  Count:    1                             *
 *        Val()                     Count:    1                             *
 *        mGetToken(FALSE)          Count:    3                             *
 *        mSimpleExpression()       Count:    1                             *
 *        mSyntaxError()            Count:    1                             *
 *      END mFactor                                                         *
 *                                                                          *
 *      TOTALS FOR ALL BLOCKS:                                              *
 *        AddLine()                 Count:    4                             *
 *        Ask()                     Count:   17                             *
 *        EmptyBuffer()             Count:    1                             *
 *        EraseDiskFile()           Count:    1                             *
 *        Return()                  Count:  103                             *
 *        Val()                     Count:    8                             *
 *        mGetToken(TRUE)           Count:    1                             *
 *        mGetToken(FALSE)          Count:    5                             *
 *        mSimpleExpression()       Count:    2                             *
 *        mSyntaxError()            Count:    3                             *
 *                                                                          *
 *      END TOTALS           :         Total Call Count: 1780               *
 *                                                                          *
 *  CallList also includes the ability to incorporate map file information. *
 *  IF CallList uses a map file (.MAP) for the SAL file being analyzed, it  *
 *  will also INCLUDE code AND stack sizes in the listing.  To generate a   *
 *  map file, specify the "-m" option WHEN compiling the file  with SC.     *
 *  To determine whether to use a map file OR NOT, main(), below, must Set  *
 *  "gCL_UseMapFile" to one of the following settings:                      *
 *                                                                          *
 *      SetGlobalInt("gCL_UseMapFile", 0) - DO NOT use a map file           *
 *      SetGlobalInt("gCL_UseMapFile", 1) - DO use a map file               *
 *      SetGlobalInt("gCL_UseMapFile", 2) - Ask whether to use a map file   *
 *                                                                          *
 *  IF a map file is used (either by setting "gCL_UseMapFile" to 1 OR by    *
 *  setting it to 2 AND answering yes WHEN asked), CallList first looks for *
 *  a map file with the same name as the current file, but with the .MAP    *
 *  extension.  IF found, that map file is used.  IF it isn't found, the    *
 *  user will be prompted to specify the map file to use.  For example, IF  *
 *  the current file is "TEST.S", CallList would look for "TEST.MAP", AND   *
 *  use it IF found.  IF "TEST.MAP" isn't found, CallList will prompt you   *
 *  to specify the name of the map file to use.                             *
 *                                                                          *
 *  IF a map file is used, the listing will look similar to:                *
 *                                                                          *
 *      INTEGER PROC mFactor()                   Code:    68  Stack:     4  *
 *        Return()                  Count:    1                             *
 *        Val()                     Count:    1                             *
 *        mGetToken(FALSE)          Count:    3  Code:   381  Stack:   261  *
 *        mSimpleExpression()       Count:    1  Code:   145  Stack:     8  *
 *        mSyntaxError()            Count:    1  Code:    32  Stack:     0  *
 *      END mFactor                                                         *
 *                                                                          *
 *      TOTALS FOR ALL BLOCKS:                                              *
 *        AddLine()                 Count:    4                             *
 *        Ask()                     Count:   17                             *
 *        EmptyBuffer()             Count:    1                             *
 *        EraseDiskFile()           Count:    1                             *
 *        Return()                  Count:  103                             *
 *        Val()                     Count:    8                             *
 *        mGetToken(TRUE)           Count:    1  Code:   381  Stack:   261  *
 *        mGetToken(FALSE)          Count:    5  Code:   381  Stack:   261  *
 *        mSimpleExpression()       Count:    2  Code:   145  Stack:     8  *
 *        mSyntaxError()            Count:    3  Code:    32  Stack:     0  *
 *                                                                          *
 *      END TOTALS           :         Total Call Count: 1780               *
 *                                                                          *
 *  Use your imagination - such numbers should HELP to develop more         *
 *  efficient SAL procedures.  For example, although mFactor above looks    *
 *  like it needs 68 bytes for code AND 4 for the stack, it calls           *
 *  another procedure, mGetToken, which requires 381 bytes for code AND     *
 *  261 for the stack. That means mFactor actually needs 449 bytes for      *
 *  code AND 265 for the stack - assuming mGetToken (OR the other called    *
 *  procedures) does NOT call other procedures.                             *
 *                                                                          *
 *  IF you're running out of macro OR stack space, OR are just curious,     *
 *  CallList might be helpful.                                              *
 *                                                                          *
 *  IF you have any questions, OR CallList doesn't work properly, please    *
 *  leave me a Message.                                                     *
 *                                                                          *
 *  Ray Asbury                                                              *
 *                                                                          *
 *  Known Bugs: 02-15-93    ERA Reporting for calls which contain quoted    *
 *                                  strings, is misleading, in that such    *
 *                                  calls will appear in the report without *
 *                                  the quoted strings.  Therefor, two      *
 *                                  calls to the same proc/command, but     *
 *                                  with different quoted strings, will be  *
 *                                  reported together.                      *
 *                                                                          *
 *  Modifications:                                                          *
 *                                                                          *
 *      v2.0    01-22-93    ERA Added gCL_MapFileAltLoc to allow specifying *
 *                                  an alternate location to search for MAP *
 *                                  files                                   *
 *                              Included proc/command arguments in calls,   *
 *                                  provided the proc/command name and args *
 *                                  does not exceed 37 characters in length *
 *      v2.1    02-03-93    ERA Re-compiled for use with TSE .65           *
 *      v2.2    02-15-93    ERA Fixed mismatching of calls with MAP file    *
 *                                  data where the name of the called proc/ *
 *                                  command was a subset of another which   *
 *                                  was found in the MAP file.              *
 *      v2.3    02-17-93    ERA Fixed MAP file conflict when proc has the   *
 *                                  same name as the SAL file               *
 *                              Included ability for user to set whether to *
 *                                  consider case when sorting              *
 *      v2.4    03-03-93    ERA Re-compiled for TSE .67                    *
 *      v2.5    03-05-93    ERA Re-compiled for TSE .68                    *
 *      v2.6    03-24-93    ERA Re-compiled for TSE .72                    *
 *      v2.7    03-26-93    ERA Re-compiled for TSE .73                    *
 *      v2.8    03-26-93    ERA Re-compiled for TSE 1.0                     *
 ****************************************************************************/

CONSTANT kCL_IGNORE_CASE = 1,
         kCL_DONT_IGNORE_CASE = 2

PROC Main()

    SetGlobalStr("gCL_WordSet", ChrSet("0-9A-Z_a-z--"))

        // MODIFY THE ABOVE LINE, IF NEEDED, AS NOTED ABOVE IN THE
        // DOCUMENTATION

        // MAXIMUM LENGTH OF gCL_WordSet IS 256 CHARACTERS

    SetGlobalInt("gCL_UseMapFile", 1)

        // MODIFY THE ABOVE LINE TO DETERMINE WHETHER THE MAP FILE WILL BE
        // USED, WHERE gCL_UseMapFile = 0 FOR NO MAP FILE USAGE,
        //             gCL_UseMapFile = 1 FOR AUTOMATIC MAP FILE USAGE
        //             gCL_UseMapFile = 2 Ask WHETHER TO USE A MAP FILE EVERY
        //                                TIME CallList IS EXECUTED

    SetGlobalStr("gCL_MapFileAltLoc", "C:\")

        // MODIFY THE ABOVE LINE TO SPECIFY AN ALTERNATE LOCATION FOR MAP
        // FILES.  CALLLIST LOOKS FIRST IN THE SAME DIRECTORY AS THE SAL FILE
        // BEING, PROCESSED.  IF A MAP FILE ISN'T FOUND THERE, IT WILL THEN
        // LOOK IN THE DIRECTORY SPECIFIED ABOVE.

        // MAXIMUM LENGTH OF gCL_MapFileAltLoc IS 68 CHARACTERS

    SetGlobalInt("gCL_SortSensitive", kCL_DONT_IGNORE_CASE)

        // MODIFY THE ABOVE LINE TO SPECIFY WHETHER SORTING SHOULD BE CASE
        // SENSITIVE (kCL_DONT_IGNORE_CASE) OR NOT (kCL_IGNORE_CASE)

    ExecMacro("CALLLST2")
    PurgeMacro("CALLLIST")
END Main