_TEXT  segment
       assume  cs:_TEXT

; integer proc getcmdtext(var string cmdline)
;
; stack looks like following:
;
; pointer to 'cmd' string   :   far (dword)
; max_len of 'cmd' string   :   word
; return address            :   far (dword)
;
; the current length of strings is passed in the first word
; of the string itself

CMDTEXT             equ     bp + 6
MAX_LEN             equ     bp + 4

GETCMDTEXT     proc    far     ; procedure must be FAR routine

        mov     bp, sp                  ;set up standard stack frame

        mov     ah,62h
        int     21h                     ;get pointer to psp into bx

        push    ss                      ;point ds to stack for this function
        pop     ds

        les     di, dword ptr [CMDTEXT] ;load es:di with pointer to CMDTEXT

        mov     ds,bx                   ;ds points to psp
        mov     si,80h                  ;point to command tail length byte
        lodsb                           ;get the length
        stosb                           ;write length into return string
        inc     di                      ;skip reserved byte
        mov     cl,al                   ;into cx for repeat
        mov     ch,0                    ;
        rep     movsb                   ;write string

        xor     ax,ax                   ;always return a zero
        cwd
        retf

stuff:  db      'this is a test string                     '

getcmdtext endp

_TEXT   ends
        end
