/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import tea.set.*;

/**
 * This is a demo applet to show using tea.set.Scroller to build a
 * scrolled panel.
 *
 * @see Scroller
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class ScrollPanel extends Applet {
   /**
    * Setup the panel and scroller.
    */
   public void init() {
      setLayout(new BorderLayout());
      
      // create a panel with vertical flow layout
      Panel pnl = new VPanel();
      pnl.add(new Button("Button 1"));
      pnl.add(new Button("Button 2"));
      pnl.add(new Button("Button 3"));
      pnl.add(new Button("Button 4"));
      
      CheckboxGroup cg = new CheckboxGroup();
      Checkbox box;
      pnl.add(new Label("Scroller Option"));
      pnl.add(box = new Checkbox("Horizontal Scroll", cg, true));
      box.addItemListener(new CheckboxItem());
      pnl.add(box = new Checkbox("Horizontal Fill", cg, false));
      box.addItemListener(new CheckboxItem());
      
      // create Scroller
      add("Center", scroll = new Scroller(pnl));
      
      // change line increment to 5 pixels
      // validate() must be called to make sure all necessary scrollbars
      // have be created. otherwise the setUnitIncrement() call is 
      // going to be ignored.
      validate();
      scroll.setUnitIncrement(Scrollbar.VERTICAL, 5);
   }
   
   // handle checkbox events
   class CheckboxItem implements ItemListener {
      public void itemStateChanged(ItemEvent e) {
	 Checkbox box = (Checkbox) e.getSource();
	 if(box.getState()) {
	    if(box.getLabel().equals("Horizontal Scroll")) {
	       scroll.setScrollOption(Scroller.H_SCROLL | Scroller.V_SCROLL);
	    }
	    else if(box.getLabel().equals("Horizontal Fill")) {
	       scroll.setScrollOption(Scroller.H_FILL | Scroller.V_SCROLL);
	    }
	 }
      }
   }
   
   private Scroller scroll;
}

// VPanel is a panel that supports vertical flow layout. The LayoutManager
// should not be changed from the default FlowLayout. 
class VPanel extends Panel {
   // Override the getPreferredSize() method to return a preferred width
   // equals to the maximum width of any child component.
   public Dimension getPreferredSize() {
      Dimension d = new Dimension(0, 0);
      for(int i = 0; i < getComponentCount(); i++) {
	 Component comp = getComponent(i);
	 Point loc = comp.getLocation();
	 Dimension siz = comp.getSize();
	 
	 if(siz.width > d.width) {
	    d.width = siz.width;
	 }
	 
	 if(siz.height + loc.y > d.height) {
	    d.height = siz.height + loc.y;
	 }
      }
      
      return d;
   }
}
