/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import tea.set.*;
import java.awt.*;
import java.applet.*;
import java.net.*;

/**
 * This is a demo applet to show using tea.set.Grid component with
 * different kinds of components.
 *
 * @see Grid
 * @see TextGrid
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class GridComp extends Applet {
   public void init() {
      setLayout(new BorderLayout());
      
      grid = new Grid(8, 3);

      grid.setColHeader(Tool.tokenize("Column1;Column2;Column3", ";"));
      grid.setRowSelectable(true);
      grid.setColSelectable(true);
      
      // first row is a spanning ticker tape taking up all row
      grid.setCell(0, 0, ticker = new TickerTape(message, 4), 1, 3);
      ticker.setBackground(Color.black);
      ticker.setForeground(Color.green);

      // second row contains: text, text field, and text area
      grid.setCell(1, 0, new TextCanvas("Plain text\nMulti-line supported"));
      grid.setCell(1, 1, new TextField("This is a TextField"));
      grid.setAlignment(1, 1, Grid.V_TOP);
      grid.setCell(1, 2, new TextArea("AWT TextArea\nWidget", 2, 18));

      // third row consists of: button, checkbox, and choice.
      grid.setCell(2, 0, new Button("java.awt.Button"));
      grid.setCell(2, 1, new Checkbox("java.awt.Checkbox"));
      Choice choice = new Choice();
      choice.add("Choice");
      choice.add("Component");
      grid.setCell(2, 2, choice);
      
      // setup images array
      images = new Image[10];
      for(int i = 0; i < images.length; i++) {
	 try {
	    URL url = new URL(getDocumentBase(), 
			      "images/Duke/T"+(i+1)+".gif");
	    images[i] = getImage(url);
	 }
	 catch(Exception e) {
	    e.printStackTrace();
	 }
      }

      // forth row consists of: image button, image, and animator
      grid.setCell(3, 0, new ImageButton(images[0]));
      grid.setCell(3, 1, new ImageCanvas(images[0]));
      grid.setCell(3, 2, anim = new Animator(images));
      grid.setAlignment(3, Grid.ALL_CELL, Grid.CENTER_CENTER);
      
      // fifth row consists of a spanning MultiList, and ...
      MultiList mlist = new MultiList(2, 10);
      mlist.setHeader(Tool.tokenize("Column1,Column2", ","));
      mlist.addRow(Tool.tokenize("Row1;Description", ";"));
      mlist.addRow(Tool.tokenize("Row2;Column2", ";"), images[0]);
      mlist.addRow(Tool.tokenize("Row3;Column2", ";"), images[1]);
      mlist.addRow(Tool.tokenize("Row4;Column2", ";"), images[2]);
      mlist.addRow(Tool.tokenize("Row5;Column2", ";"), images[3]);
      mlist.addRow(Tool.tokenize("Row6;Column2", ";"));
      mlist.addRow(Tool.tokenize("Row7;Column2", ";"));
      mlist.addRow(Tool.tokenize("Row8;Column2", ";"));
      grid.setCell(4, 0, mlist, 4, 2); 
      
      // the third column acroll 5th to 7th row
      grid.setCell(4, 2, new MaskText("Tel: ([999]) [999]-[9999]"));
      grid.setCell(5, 2, new ImageLabel(images[0], "Image Label"));
      TextCanvas text = new TextCanvas("A multi-line TextCanvas area\n"+
				       "inside a Scroller.\n" +
				       "Scroller handles the scrolling\n"+
				       "of the text automatically");
      grid.setCell(6, 2, new Scroller(text, false, 100, 30), 2, 1);
      
      // add a border to the grid using Effect3D
      add("Center", new Effect3D(new Scroller(grid), Effect3D.RAISED_BORDER));
   }
   
   /**
    * Applet start method. Starts animation.
    */
   public void start() {
      ticker.start();
      anim.start();
   }
   
   /**
    * Applet stop method. Stops animation.
    */
   public void stop() {
      ticker.stop();
      anim.stop();
   }
   
   // ticker tape message
   private String message = 
   "Any AWT component, or classes extended from AWT\n" +
   "component can be put inside a Grid. This is a \n" +
   "tea.set.TickerTape widget inside a spanning cell.\n" +
   "This grid contains many Java AWT components, and\n" +
   "components in the Tea Set Widget Collection.";
   
   private TickerTape ticker;
   private Animator anim;
   private Grid grid;
   private Image images[];
}
