/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import tea.set.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**
 * FileTree is an example program to demostrate Forest widget. It 
 * takes a path, and generates a directory tree.
 *
 * Bug: Win32 has a bug which hangs a program is the number of 
 * component is too large. This would be a problem if the tree contains
 * too many nodes, since each node is implemented as a component
 * in Tea Set 1.2. In Tea Set Widget Collection 1.2.1, nodes are no 
 * longer components and therefore this problem would not appear.
 *
 * @see Forest
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class FileTree extends Frame {
   /**
    * Create a directory tree from the root path.
    */
   public FileTree(String rootPath) {
      setLayout(new BorderLayout());
    
      // create Forest and set appropriate options
      forest = new Forest(Forest.LINE);
      // use the same separator as the file system for separating nodes
      forest.setSeparator(File.separatorChar);
      // open/close folder only if mouse click is in icon
      forest.setIconOnly(true);
      
      // create nodes
      populateTree(rootPath);
      
      // never close root folder
      forest.forceOpen(rootPath, true);
      
      // put forest inside a Scroller to ensure all parts of forest
      // can be seen
      add("Center", new Scroller(forest, true, 200, 200));
      forest.addActionListener(new ActionListener() {
	 public void actionPerformed(ActionEvent e) {
	    System.out.println("Action:"+forest.getSelectedPath());
	 }
      });
      forest.addItemListener(new ItemListener() {
	 public void itemStateChanged(ItemEvent e) {
	    System.out.println("Select:"+e);
	 }
      });
      
      Button cancel = new Button("Cancel");
      add("North", cancel);
      cancel.addActionListener(new ActionListener() {
	 public void actionPerformed(ActionEvent e) {
	    FileTree.this.dispose();
	    System.exit(0);
	 }
      });
   }

   // populate the tree nodes from the directory information.
   private void populateTree(String rootPath) {
      // add current dir/file to the tree
      forest.add(rootPath);
      
      try {
	 File root = new File(rootPath);
	 
	 if(root.isDirectory()) {
	    String[] files = root.list();
	    
	    if(files != null) {
	       // recursively add all sub nodes to the tree
	       for(int i = 0; i < files.length; i++) {
		  populateTree(rootPath + File.separator + files[i]);
	       }
	    }
	 }
      }
      catch(Exception e) {
	 e.printStackTrace();
      }
   }
   
   /**
    * Pass a directory path as command line parameter. On Win32 platform,
    * beware that the backslash needs to be escaped.
    * For a directory tree from current directory, type:
    * java tea.set.sample.FileTree .
    */
   public static void main(String argv[]) {
      FileTree tree = new FileTree(argv[0]);
      
      tree.pack();
      tree.show();
   }
   
   private Forest forest;
}
