/*
 * Copyright (c) 1996-1997, InetSoft Technology Corp, All Rights Reserved.
 *
 * The software and information contained herein are copyrighted and 
 * proprietary to InetSoft Technology Corp. This software is furnished 
 * pursuant to a written license agreement and may be used, copied, 
 * transmitted, and stored only in accordance with the terms of such 
 * license and with the inclusion of the above copyright notice. Please 
 * refer to the file "COPYRIGHT" for further copyright and licensing 
 * information. This software and information or any other copies 
 * thereof may not be provided or otherwise made available to any 
 * other person. 
 */
package tea.set.sample;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import tea.set.*;

/**
 * This is a demo applet to show using tea.set.Effect3D to build a
 * captioned box.
 *
 * @see Effect3D
 * @version 1.3, 01/31/97
 * @author InetSoft Technology Corp
 */
public class CaptionBox extends Applet {
   public void init() {
      setLayout(new BorderLayout());

      // setup option panel
      Panel pnl = new Panel();
      pnl.setLayout(new GridLayout(4, 1));
      CheckboxGroup cg = new CheckboxGroup();
      Checkbox cb;      
      ItemListener il = new ItemListener() {
	 public void itemStateChanged(ItemEvent e) {
	    Checkbox cbox = (Checkbox) e.getSource();
	    if(cbox.getState()) {
	       if(cbox.getLabel().equals("Raised Border")) {
		  box.setStyle(Effect3D.RAISED_BORDER);
	       }
	       else if(cbox.getLabel().equals("Lowered Border")) {
		  box.setStyle(Effect3D.LOWERED_BORDER);
	       }
	       else if(cbox.getLabel().equals("Raised Surface")) {
		  box.setStyle(Effect3D.RAISED);
	       }
	       else if(cbox.getLabel().equals("Lowered Surface")) {
		  box.setStyle(Effect3D.LOWERED);
	       }
	    }
	 }
      };
      
      pnl.add(cb = new Checkbox("Raised Border", cg, true));
      cb.addItemListener(il);
      pnl.add(cb = new Checkbox("Lowered Border", cg, false));
      cb.addItemListener(il);
      pnl.add(cb = new Checkbox("Raised Surface", cg, false));
      cb.addItemListener(il);
      pnl.add(cb = new Checkbox("Lowered Surface", cg, false));
      cb.addItemListener(il);
      
      // add 3D box to the panel
      add("Center", box = new Effect3D(pnl, "Option Box", 
				       Effect3D.RAISED_BORDER));
   }
   
   private Effect3D box;
}

