/***************************************************************************
 *   TRIVIA.C                                                              *
 *   Copyright (C) 1991 A - Z Computer Solutions.   All Rights Reserved.   *
 *   Trivia                                        - RDWild, August 1991   *
 ***************************************************************************/

#include "stdio.h"
#include "ctype.h"
#include "trivia.h"
#include "majorbbs.h"
#include "usracc.h"
#include "dosface.h"
#include "portable.h"
#include "btvstf.h"

/* Do NOT change the ver number below */
static char ver[]={"Version 2.01 01/12/92 16:57:29"};   /* Version number */

int initrv(),trivia(),triviasts(), trvclean(),trvshd();

#define TRVSTT      31        /* Trivia State */
struct module module31={      /* module interface block */
	'*',                  /* main menu select character (config'able) */
	"",                   /* description for main menu  (config'able) */
	initrv,                      /* system initialization routine     */
	NULL,                        /* user logon supplemental routine   */
	trivia,                      /* input routine if selected         */
	triviasts,                   /* status-input routine if selected  */
	NULL,                        /* hangup (lost carrier) routine     */
	trvclean,                    /* midnight cleanup routine          */
	NULL,                        /* delete-account routine            */
	trvshd,                      /* finish-up (sys shutdown) routine  */
};

static FILE *trvmb;     /* Trivia configuration variables */
static BTVFILE *btvquest, *btvusrinfo, *btvhscore;  /* Btrieve file pointer for control file */

struct trvquest {                       /* Question data block for btv file     */
	long questnum;                  /*   Key for Btrieve */
	char approv;                    /*   A = Approved, U = Unapproved       */
	char question[80];              /*   question                           */
	char answer[40];                /*   answer to question.                */
	char userid[UIDSIZ];    /* Userid who wrote question          */
	char spare[255-134];    /* space for graceful upgrade, Do NOT use! */
} *trvquest;

struct trvusrinfo {                     /* Info about user */
	char userid[UIDSIZ];            /* User-id name */
	long score;                     /* Current score of user */
	int plays;                      /* Number of Plays today? */
	char spare[128-15];             /* Space for graceful upgrade, Do NOT use! */
} *trvusrinfo;

#define TIMEOUT 1

struct trvusr {                         /* Data block of info for each user */
	long score;                             /* Current score of user. */
	char question[80];                      /* Question */
	char answer[40];                        /* Answer to Question! */
	FILE *tfp;                              /* File Ptr for use with instructions */
	int plays;                              /* Number of plays today! */
	int flags;
} *trvusr;

#define SCORENUM        10

struct trvhscore {                                      /* Hi Scores database info */
	char sdummy;                                    /* Dummy field for Btrieve */
	long score[SCORENUM];                   /* List of hi scores */
	char userid[SCORENUM][UIDSIZ];  /* List of Userids for Hi Scores */
	int htime[SCORENUM];                    /* Time user reached high score */
	int hdate[SCORENUM];                    /* Date user reached high score */
    long curquest;                         /* The Current Question Number */
    long lastquest;                   /* The Last Question in the Database */
    int resetdays;                                      /* Number of days before Score is Rest */
    char sspare[255-163];                /* Spare Space for gracful upgrade */
} *trvhscore;

int nlvtrv;                             /* allow non-live users to play Trivia? */
int tnplay;                             /* Number of Plays per Day allowed */
int trvscor1, trvscor2, trvscor3;       /* Configurable Score for right Quest */
int trvtmout;                           /* TimeOut Time for Game */
int scoredays;                          /* Number of days for Rest of Score */
int trvtime[256];                       /* Allocate time units based on number of users */
int vmode;                              /* Current Validation Direction */
long curuquest = 0;             /* current unvalidated question number */

#define VMFIRST 1
#define VMNEXT          2
#define VMPREV          4
#define VMFIND          8
#define VMAPPR          16
#define VMUNAP          32
#define VMDEL           64

rttrv() /* Real Time Kick for Trivia Time Outs */
{
	int i;

	for (i=0; i<(nterms); i++) {
		if (trvtime[i] != 0) {
			trvtime[i]--;
			if (trvtime[i] == 0) btuinj(i, 249);
		}
	}
	rtkick(1, rttrv);
}

initrv()                                        /* initialize Trivia stuff */
{

	trvmb=opnmsg("TRIVIA.MCV");
	nlvtrv=ynopt(NLVTRV);
	tnplay=numopt(TNPLAY, 0, 10);   /* 0 = Unlimited Number of Plays per day */
	trvscor1=numopt(TSCOR1, -32767, 32767);
	trvscor2=numopt(TSCOR2, -32767, 32767);
	trvscor3=numopt(TSCOR3, -32767, 32767);
	trvtmout=numopt(TRVOUT, 0, 32767); /* Amount of Time before TimeOut */
	scoredays=numopt(TRVRSC, 0, 365);
	inimid(TRVSTT,TRVSEL,TRVMNU);

	trvhscore=(struct trvhscore *)alcmem(sizeof(struct trvhscore));
	btvhscore=opnbtv("trvhscor.dat", sizeof(struct trvhscore));
	if (!alobtv(trvhscore,0)) {
		setmem(trvhscore,sizeof(struct trvhscore),0);
		insbtv(trvhscore);
	} else gcrbtv(trvhscore, 0);

	trvquest=(struct trvquest *)alcmem(sizeof(struct trvquest));
	btvquest=opnbtv("trvquest.dat",sizeof(struct trvquest));
	if (alobtv(trvquest, 0)) {
		if (trvquest->questnum == 0) {    /* Database Needs Converting from old Format */
			delbtv();
			trvhscore->lastquest=0;
			do {
				trvhscore->lastquest++;
			} while (acqbtv(trvquest, &trvhscore->lastquest, 0));
		}
	}

	if (trvhscore->lastquest == 0) {
		trvhscore->lastquest = 1;
		while (acqbtv(trvquest, &trvhscore->lastquest, 0)) {
			trvhscore->lastquest++;
		}
	}

	trvusrinfo=(struct trvusrinfo *)alcmem(sizeof(struct trvusrinfo));
	btvusrinfo=opnbtv("trvuser.dat",sizeof(struct trvusrinfo));

	dclvda(sizeof(struct trvusr));
	setmem(trvtime,(sizeof(int) * nterms-1),0);
	rtkick(1, rttrv);
}

void sendlmenu(void)            /* Send Long Menu to User */
{
	btuxmt(usrnum,"[2J");
	prfmsg(HELLO);
	prf("     %s\r\r", ver);
	if (usrptr->flags&ISYSOP) {
		prfmsg(TMENUS);
	} else {
		prfmsg(TMENU);
	}
	usrptr->substt=1;
	return;
}

void sendsmenu(void)            /* Send Short Menu to User */
{
	if (usrptr->flags&ISYSOP) {
		prfmsg(TMENUS2);
	} else {
		prfmsg(TMENU2);
	}
	usrptr->substt=1;
	return;
}

savequest()                             /* Save a new question to drive */
{
	setbtv(btvquest);
    trvhscore->lastquest++;
    if (trvhscore->curquest == 0 || trvhscore->curquest > trvhscore->lastquest) trvhscore->curquest=1;
	setmem(trvquest,sizeof(struct trvquest),0);
    trvquest->questnum = trvhscore->lastquest;
	if (usrptr->flags&ISYSOP) {
		trvquest->approv = 'A';
	} else {
		trvquest->approv = 'U';
	}
	strcpyd(trvquest->question, trvusr->question, 1, sizeof(trvusr->question));
	strcpyd(trvquest->answer, trvusr->answer, 1, sizeof(trvusr->answer));
	memcpy(trvquest->userid, usaptr->userid, UIDSIZ);
	dinsbtv(trvquest);
}

int strcpyd(char *dest, char *source, int start, int length)
{
	int curr;
	int strsize;

	strsize = sizeof(source);
	if (strsize > length+start) return(0);
	for (curr=start; curr<=(length+start); curr++) {
		dest[curr-start] = source[curr];
	}
	return(1);      /* Return 1=work done 0=Error */
}

getquest(char rtype) /* Get a question from drive */
{
	setbtv(btvquest);
    if (trvhscore->lastquest == 0) return(0);
	setmem(trvquest,sizeof(struct trvquest),0);
	switch(rtype) {
		case 'A':
			do {
			 if (trvhscore->curquest > trvhscore->lastquest) trvhscore->curquest=1;
			 acqbtv(trvquest, &trvhscore->curquest, 0);
			 trvhscore->curquest++;
			} while (trvquest->approv != 'A');
			break;

		case 'U':       /* Get Unvalidated Question */
			do {
				acqbtv(trvquest, &curuquest, 0);
				curuquest++;
		} while (trvquest->approv != 'U' && curuquest <= trvhscore->lastquest);
		  if (curuquest >= trvhscore->lastquest) {
				curuquest=0;
				return(0);
			}
			break;

		case 'D':
			return(0);
	}
	memcpy(trvusr->question, trvquest->question, sizeof(trvusr->question));
	memcpy(trvusr->answer, trvquest->answer, sizeof(trvusr->answer));
	return(1);
}

showquest(int questime)     /* Show what the answer would look like with chars */
{                       /* ie. the work 'Coke and Pepsi' would look like */
			/* 'xxxx xxx xxxxx' */

	int x;

	btuxnf(usrnum, 0, 19);
	btuxmt(usrnum,"[2J");
	prfmsg(TASKQES, questime, trvusr->question);
	btumil(usrnum, strlen(trvusr->answer));
	for (x=0; x<=(strlen(trvusr->answer)-1); x++) {
		if (trvusr->answer[x] > 'A' || trvusr->answer[x] < 'z') {
			if (trvusr->answer[x] == ' ') {
				prf("%c", trvusr->answer[x]);
			} else prf("x");
		}
	}
	if (usaptr->ansifl&ANSON) {
		prf("[[[%02dD", strlen(trvusr->answer));
	} else {
		for (x=0; x<=(strlen(trvusr->answer)-1); x++) {
			prf("%c", (char)8);
		}
	}
}

getusrinfo()    /* Get info from user btrieve database */
{
	int there;

	setbtv(btvusrinfo);
	setmem(trvusrinfo,sizeof(struct trvusrinfo),0);
	there=acqbtv(trvusrinfo, usaptr->userid, 0);
	if (there == 0) {
		trvusrinfo->score = 0;
		trvusrinfo->plays = 0;
		memcpy(trvusrinfo->userid, usaptr->userid, UIDSIZ);
		insbtv(trvusrinfo);
	}
	trvusr->score=trvusrinfo->score;
	trvusr->plays=trvusrinfo->plays;
}

saveusrinfo()   /* Update info to user database file */
{
	int there;

	setbtv(btvusrinfo);
	setmem(trvusrinfo,sizeof(struct trvusrinfo),0);
	there=acqbtv(trvusrinfo, usaptr->userid, 0);
	if (there == 1) {
		trvusrinfo->score = trvusr->score;
		trvusrinfo->plays = trvusr->plays;
		updbtv(trvusrinfo);
	}
}

addquest()      /* Start the process of adding a question */
{
	btuxmt(usrnum,"[2J");
	prf("\rSelected Add Questions:\r");
	prf("Type in a Question up to 79 Characters and then type '/s' on a Blank line\r");
	outprf(usrnum);
	usrptr->substt=10;
	bgnedt(1, sizeof(trvusr->question), trvusr->question, 1, NULL);
}

checkscore()    /* Check to see if user is on high score list */
{
int i;

	for (i=0; i <SCORENUM; i++) {
		if (sameas(trvhscore->userid[i], usaptr->userid)) {
			trvhscore->score[i] = trvusr->score;
			if (i!=0 && trvhscore->score[i] > trvhscore->score[i-1]) {
				strcpy(trvhscore->userid[i], trvhscore->userid[i-1]);
				trvhscore->score[i] = trvhscore->score[i-1];
				trvhscore->hdate[i] = trvhscore->hdate[i-1];
				trvhscore->htime[i] = trvhscore->htime[i-1];

				strcpy(trvhscore->userid[i-1], usaptr->userid);
				trvhscore->score[i-1]=trvusr->score;
				trvhscore->hdate[i-1]=today();
				trvhscore->htime[i-1]=now();
			}
			return;
		}
	}

	for (i=0; i < SCORENUM; i++) {
		if (trvusr->score > trvhscore->score[i]) {
			movmem(&trvhscore->userid[i],&trvhscore->userid[i+1],
			   (SCORENUM-(i+1))*UIDSIZ);
			movmem(&trvhscore->score[i],&trvhscore->score[i+1],
			   (SCORENUM-(i+1))*sizeof(long));
			movmem(&trvhscore->hdate[i],&trvhscore->hdate[i+1],
			   (SCORENUM-(i+1))*sizeof(int));
			movmem(&trvhscore->htime[i],&trvhscore->htime[i+1],
			   (SCORENUM-(i+1))*sizeof(int));
			strcpy(trvhscore->userid[i],usaptr->userid);
			trvhscore->score[i]=trvusr->score;
			trvhscore->hdate[i]=today();
			trvhscore->htime[i]=now();
			return;
		}
	}
}

displayhscore() /* Display high scores to user */
{
	int i;

	prf("Place       Score        User-id        Date       Time \r");
	prf("-----     ---------     ---------     --------     -----\r");
	for (i=0 ; i < SCORENUM; i++) {
		prf(" %2d       %9s     %9s     %8s     %5s\r",i+1,ltoa(trvhscore->score[i]),
		trvhscore->userid[i],ncdate(trvhscore->hdate[i]),
		nctime(trvhscore->htime[i]));
	}
	prf("\rDays Till ACT Scores Reset: %d\r\r", trvhscore->resetdays);
	sendsmenu();
}

vquest()        /* Get and show Validate Question */
{
	if (getquest('U') == 1) {
		prf("\r\33[31mQuestion:\33[36m%s\r", trvusr->question);
		prf("\33[31mAnswer:\33[36m%s\r", trvusr->answer);
		prf("\r\rEnter \33[31mD\33[36m)elete, \33[31mS\33[36m)kip Question, \33[31mV\33[36m)alidate, \33[31mE\33[36m)xit :");
	} else return(0);
}

static trivia()                      /* Trivia handler  */
{
	char *cp;
	char key;

	trvusr=(struct trvusr *)vdaptr;
	setmbk(trvmb);

	if (usrptr->flags&INJOIP) {
		if (trvusr->flags&TIMEOUT) {
		} else {
			switch(usrptr->substt) {
				case 1:
					sendsmenu();
					break;

				case 20:
					showquest(1);
					break;

				case 21:
					showquest(2);
					break;

				case 22:
					showquest(3);
					break;
			}
			outprf(usrnum);
			return(1);
		}
	}

	do {
		bgncnc();
		switch(usrptr->substt) {
		case 0:
			shocst(1, "%s GAME ACCESS: Trivia!", usaptr->userid);
			cncchr();
			sendlmenu();
			if (!nlvtrv && usrptr->class < PAYING) {
				prfmsg(REJECT);
				prfmsg(GOODBY);
				return(0);
			}
		  outprf(usrnum);
		  break;
	case 1:
		  usrptr->substt=1;
		  key=cncchr();
		  if (usrptr->flags&ISYSOP) {
			switch(key) {
				case 'E':
					btuxmt(usrnum,"[2J");
					prfmsg(TMENUE);
					usrptr->substt=5;
					break;
			}
		  }
		  switch(key) {
			case 'I':
				usrptr->substt=60;
				btuinj(usrnum, CYCLE);
				break;

			case 'S':
				prf("\r                 High Scores!\r");
				getusrinfo();
				prf("\rName: %s\r", usaptr->userid);
				prf("Score: %s\r", ltoa(trvusr->score));
				prf("Plays Today: %d\r\r", trvusr->plays);
				displayhscore();
				break;

			case 'P':
				getusrinfo();
				if (trvusr->plays < tnplay || tnplay == 0) {
					trvusr->plays++;
					if (getquest('A') == 1) {
						showquest(1);
						usrptr->substt = 20;
						trvtime[usrnum] = trvtmout;
					} else {
						prf("\rSorry No Questions to Answer at this time!\r");
						sendsmenu();
					}
				} else {
					prf("\rSorry you may only Answer %d Questions a Day, Please call back tommorow!\r", trvusr->plays);
					sendsmenu();
				}
				break;

			case 'X': /* Exit back to main menu */
				shocst(1, "%s GAME EXIT: Trivia!", usaptr->userid);
				rstrxf();       /* Restore screen back to normal using Majorbbs.c routine */
				prfmsg(GOODBY);
				return(0);

			case '?':
				sendlmenu();
				break;

			default:
				if (usrptr->substt==1) sendsmenu();
				break;
		  }
		  outprf(usrnum);
		  break;

	case 2:
		  prfmsg(THANKS,usaptr->userid);
		  prfmsg(GOODBY);
		  shocst(1, "%s GAME EXIT: Trivia!", usaptr->userid);
		  return(0);

	case 5:
		key=cncchr();
		switch(key) {
			case 'E':
				if (trvhscore->lastquest == 0 ) {
					prf("\rNo Questions Currently avalable to Edit!\r");
				}
				vmode = VMFIRST;
				usrptr->substt = 45;    /* Entering New Valadate Area */
				btuinj(usrnum, CYCLE);
				break;

			case 'A':
				addquest();
				break;

			case 'R':
				trvclean();
				trvusr->score = 0;
				prf("Reseting User Scores....\r\r");
				prfmsg(TMENUE);
				break;

			case 'X':
				sendsmenu();
				break;

			case '?':
				prfmsg(TMENUE);
				break;

			default:
				prfmsg(TMENUES);
				break;
		}
		outprf(usrnum);
		break;

	case 9: /* Ask if want to add question to database (y/n) */
		rstrxf();
		key=cncyesno();
		switch(key) {
			case 'Y':
				addquest();
				break;

			case 'N':
				sendsmenu();
				break;

			default:
				prf("\rWould you like to enter a question (Y/N)? ");
				break;
		}
		outprf(usrnum);
		break;

	case 10: /* Add Question Editor Status */
		if (dunedt()) {
			usrptr->substt=11;
			btuxmt(usrnum,"[2J");
			prf("OK, Now enter the Answer to your Question.  Please use Correct spelling!\r");
			outprf(usrnum);
			bgnedt(1, sizeof(trvusr->answer), trvusr->answer, 1, NULL);
		}
		break;

	case 11: /* Add Answer Editor Status */
		if (dunedt()) {
			if (usrptr->flags&ISYSOP) {
				usrptr->substt=13;
			} else usrptr->substt=12;
			btuxmt(usrnum,"[2J");
			prf("\rQuestion:%s\r", trvusr->question);
			prf("Answer:%s\r", trvusr->answer);
			prf("Good, Is this OK? (Y/N):");
			outprf(usrnum);
		}
		break;

	case 12: /* Save Question and Exit, Normal User */
		if (cncchr() == 'Y') {
			savequest();
		}
		sendsmenu();
		outprf(usrnum);
		break;

	case 13: /* Save Question and Exit, Sysop User */
		if (cncchr() == 'Y') {
			savequest();
		}
		prfmsg(TMENUES);
		outprf(usrnum);
		usrptr->substt=5;
		break;

	case 20: /* ---- Ask Question and see if right! ---- */
		cp = cncall();
		if (sameas(cp, trvusr->answer)) {
			trvusr->score += trvscor1;
			saveusrinfo();
			prf("\rIts RIGHT!!! You get %d Points.\r\r", trvscor1);
			trvtime[usrnum] = 0;
			btumil(usrnum,DFTIMX); /* Reset line length back to normal */
			checkscore();
			prf("\rWould you like to enter a question (Y/N)? ");
			usrptr->substt=9;
		} else {
			showquest(2);
			usrptr->substt=21;
			trvtime[usrnum] = trvtmout;
		}
		outprf(usrnum);
		break;

	case 21: /* ---- Ask Question second time and see if right ---- */
		cp = cncall();
		if (sameas(cp, trvusr->answer)) {
			trvusr->score += trvscor2;
			saveusrinfo();
			prf("\rIts RIGHT!!! You get %d Points.\r\r", trvscor2);
			trvtime[usrnum] = 0;
			btumil(usrnum,DFTIMX); /* Reset line length back to normal */
			checkscore();
			prf("\rWould you like to enter a question (Y/N)? ");
			usrptr->substt=9;
		} else {
			showquest(3);
			usrptr->substt=22;
			trvtime[usrnum] = trvtmout;
		}
		outprf(usrnum);
		break;

	case 22:
		cp = cncall();
		prf("\rQuestion #%s", ltoa(trvhscore->curquest));
		if (sameas(cp, trvusr->answer)) {
			trvusr->score += trvscor3;
			checkscore();
			prf("\rIts RIGHT!!! You get %d Points.\r\r", trvscor3);
		} else {
			prf("\rSorry!!!, You did not get it right this time.\r\r");
		}
		trvtime[usrnum] = 0;
		btumil(usrnum,DFTIMX); /* Reset line length back to normal */
		saveusrinfo();
		prf("\rWould you like to enter a question (Y/N)? ");
		usrptr->substt=9;
		outprf(usrnum);
		break;

	case 40:        /* New Validation Menu and Functions */
		switch(cncchr()) {
			case 'N':   /* Show Next Question */
				vmode = VMNEXT;
				usrptr->substt = 45;
				btuinj(usrnum, CYCLE);
				break;

			case 'P':   /* Show Previous Question */
				vmode = VMPREV;
				usrptr->substt = 45;
				btuinj(usrnum, CYCLE);
				break;

			case 'F':   /* Find Unvalidated Questions */
				prf("\rSearching .");
				outprf(usrnum);
				vmode = VMFIND;
				usrptr->substt = 45;
				btuinj(usrnum, CYCLE);
				break;

			case 'C':   /* Change Status of Question */
				prfmsg(CSTAT);
				usrptr->substt = 50;
				outprf(usrnum);
				break;

			case 'E':   /* Edit Question for Errors */
				sprintf(trvusr->question, "%s", trvquest->question);
				sprintf(trvusr->answer, "%s", trvquest->answer);
				prfmsg(EDQST1, trvusr->question, trvusr->answer);
				usrptr->substt = 51;
				outprf(usrnum);
				break;

			case 'X':   /* Exit Back to main menu */
				prf("\r");
				sendsmenu();
				outprf(usrnum);
				break;

			default:
				prfmsg(VQUEST, trvquest->userid, ltoa(curuquest),
				    trvquest->approv, trvquest->question,
				    trvquest->answer);
				outprf(usrnum);
				break;
		  }
		  break;

		case 50:
			switch(cncchr()) {
				case 'A':               /* Set Status to Approved */
					vmode = VMAPPR;
					usrptr->substt = 45;
					btuinj(usrnum, CYCLE);
					break;

				case 'D':               /* Set Status to Deleted */
					vmode = VMDEL;
					usrptr->substt = 45;
					btuinj(usrnum, CYCLE);
					break;

				case 'U':               /* Set Status to Unapproved */
					vmode = VMUNAP;
					usrptr->substt = 45;
					btuinj(usrnum, CYCLE);
					break;

				default:                /* Don't Change the Status */
					prfmsg(VQUEST, trvquest->userid, ltoa(curuquest),
					    trvquest->approv, trvquest->question,
					    trvquest->answer);
					outprf(usrnum);
					usrptr->substt = 40;
					break;
			}
			break;

		case 51:
			switch(cncchr()) {
				case '1':   /* 1 = Edit Question */
					usrptr->substt=52;
					sprintf(trvquest->question, " %s", trvusr->question);
					sprintf(trvquest->answer, " %s", trvusr->answer);
					movmem(trvquest->question, trvusr->question, sizeof(trvquest->question));
					movmem(trvquest->answer, trvusr->answer, sizeof(trvquest->answer));
					bgnedt(0, sizeof(trvusr->question), trvusr->question, 0, NULL);
					break;

				case '2':   /* 2 = Edit Answer */
					usrptr->substt=52;
					sprintf(trvquest->question, " %s", trvusr->question);
					sprintf(trvquest->answer, " %s", trvusr->answer);
					movmem(trvquest->question, trvusr->question, sizeof(trvquest->question));
					movmem(trvquest->answer, trvusr->answer, sizeof(trvquest->answer));
					bgnedt(0, sizeof(trvusr->answer), trvusr->answer, 0, NULL);
					break;

				case 'S':   /* Save and Exit */
					if (acqbtv(trvquest, &curuquest, 0)) {
						sprintf(trvquest->question, "%s", trvusr->question);
						sprintf(trvquest->answer, "%s", trvusr->answer);
						updbtv(trvquest);
					}
					prfmsg(VQUEST, trvquest->userid, ltoa(curuquest),
					    trvquest->approv, trvquest->question,
					    trvquest->answer);
					outprf(usrnum);
					usrptr->substt = 40;
					break;

				case 'X':   /* Just Exit, Don't Save */
					prfmsg(VQUEST, trvquest->userid, ltoa(curuquest),
					    trvquest->approv, trvquest->question,
					    trvquest->answer);
					outprf(usrnum);
					usrptr->substt = 40;
					break;

				default:
					prfmsg(EDQST1, trvusr->question, trvusr->answer);
					outprf(usrnum);
					break;
			}
			break;

		case 52:
			if (dunedt()) {
				usrptr->substt = 51;
				strcpyd(trvquest->question, trvusr->question, 1, sizeof(trvusr->question));
				strcpyd(trvquest->answer, trvusr->answer, 1, sizeof(trvusr->answer));
				movmem(trvquest->question, trvusr->question, sizeof(trvquest->question));
				movmem(trvquest->answer, trvusr->answer, sizeof(trvquest->answer));
				prfmsg(EDQST1, trvusr->question, trvusr->answer);
				outprf(usrnum);
			}
			break;
	}
} while (!endcnc());
return(1);
}

static triviasts()
{
	int oba;
	char buff[256];

	trvusr=(struct trvusr *)vdaptr;
	setmbk(trvmb);
	if (status == 249) {
		trvusr->flags|=TIMEOUT;
		othusn = usrnum;
		prf("\r\r\33[31mTimes UP!!!!\33[36m\r");
		btucli(usrnum);
		injoth();
		return;
	}

	if (status == 240) {
		switch(usrptr->substt) {
			case 45:        /* Cycled Validaton Get Routine */
				setbtv(btvquest);
				if (trvhscore->lastquest == 0) {
					sendsmenu();
					return;
				}
				setmem(trvquest, sizeof(struct trvquest), 0);
				switch(vmode) {
					case VMFIRST:
						curuquest=1;
						acqbtv(trvquest, &curuquest, 0);
						prfmsg(VQUEST, trvquest->userid, ltoa(curuquest),
							trvquest->approv, trvquest->question,
							trvquest->answer);
						usrptr->substt = 40;
						break;

					case VMNEXT:
						curuquest++;
						if (curuquest > trvhscore->lastquest) curuquest = trvhscore->lastquest;
						if (acqbtv(trvquest, &curuquest, 0)) {
							prfmsg(VQUEST, trvquest->userid, ltoa(curuquest),
								trvquest->approv, trvquest->question,
								trvquest->answer);
							usrptr->substt = 40;
						}
						break;

					case VMPREV:
						curuquest--;
						if (curuquest < 1) curuquest=1;
						if (acqbtv(trvquest, &curuquest, 0)) {
							prfmsg(VQUEST, trvquest->userid, ltoa(curuquest),
								trvquest->approv, trvquest->question,
								trvquest->answer);
							usrptr->substt = 40;
						}
						break;

					case VMFIND:
						if (++curuquest > trvhscore->lastquest) curuquest = trvhscore->lastquest;
						if (acqbtv(trvquest, &curuquest, 0)) {
							if (trvquest->approv != 'U') {
								prf(".");
								outprf(usrnum);
								if (curuquest == trvhscore->lastquest) {
									usrptr->substt = 40;
								} else {
									usrptr->substt = 45;
									btuinj(usrnum, CYCLE);
								}
							} else usrptr->substt = 40;
							if (usrptr->substt == 40) {
								prfmsg(VQUEST, trvquest->userid, ltoa(curuquest),
									trvquest->approv, trvquest->question,
									trvquest->answer);
							}
						}
						break;

					case VMAPPR:
					case VMUNAP:
					case VMDEL:
						if (acqbtv(trvquest, &curuquest, 0)) {
							if (vmode == VMAPPR) trvquest->approv = 'A';
							if (vmode == VMUNAP) trvquest->approv = 'U';
							if (vmode == VMDEL) trvquest->approv = 'D';
							updbtv(trvquest);
						}
						prfmsg(VQUEST, trvquest->userid, ltoa(curuquest),
							trvquest->approv, trvquest->question,
							trvquest->answer);
						usrptr->substt = 40;
						break;
				}
				outprf(usrnum);
				break;

			case 60:        /* Cycle Open Read of Instruction File. */
				if ((trvusr->tfp=fopen("trivia.ins",FOPRA)) != NULL) {
					btuoes(usrnum,1);
					btuxmt(usrnum,"[2J");
					usrptr->substt=61;
					btuinj(usrnum, CYCLE);
				} else {
					btuxmt(usrnum,"[2J");
					prf("Against the Clock Trivia: Can't Find Instruction File!\r");
					prf("                          Please Notify the Sysop\r\r");
					sendsmenu();
					outprf(usrnum);
					usrptr->substt=1;
				}
				break;

			case 61:
				oba=min(btuoba(usrnum), sizeof(buff));
				if (!feof(trvusr->tfp)) {
					fgets(buff, oba, trvusr->tfp);
				}
				if (feof(trvusr->tfp)) {
					fclose(trvusr->tfp);
					btuoes(usrnum, 0);
					sendsmenu();  /* Reprints short menu */
				} else {
					prf("%s",buff);
					usrptr->substt=61;
					btuinj(usrnum, CYCLE);
				}
				outprf(usrnum);
				break;

			default:
				dfsthn();
				return;
		}
	} else {
		dfsthn();
	}
}

trvclean()      /* midnight cleanup routine */
{
	int there;
	long tmplastq, tmpcurrq;

	setbtv(btvusrinfo);
	setmem(trvusrinfo,sizeof(struct trvusrinfo),0);

	if (trvhscore->resetdays != 0) trvhscore->resetdays--;

	there=alobtv(trvusrinfo, 0);
	if (there == 1) {
		trvusrinfo->plays = 0;
		if (trvhscore->resetdays == 0) trvusrinfo->score = 0;
		updbtv(trvusrinfo);
	}
	while (qnxbtv()) {
		gcrbtv(trvusrinfo, 0);
		trvusrinfo->plays = 0;
		if (trvhscore->resetdays == 0) trvusrinfo->score = 0;
		updbtv(trvusrinfo);
	}

	if (trvhscore->resetdays > scoredays || trvhscore->resetdays == 0) {
		tmplastq=trvhscore->lastquest;
		tmpcurrq=trvhscore->curquest;
		setmem(trvhscore,sizeof(struct trvhscore),0);
		trvhscore->resetdays = scoredays;
		trvhscore->lastquest = tmplastq;
		trvhscore->curquest = tmpcurrq;
	}
}

trvshd()                      /* System shutdown routine                   */
{
	if (trvmb != NULL) {    /* Close MSG file */
		clsmsg(trvmb);
		trvmb=NULL;
	}
	if (btvquest != NULL) { /* Update and Close Question database */
		clsbtv(btvquest);
	}
	if (btvusrinfo != NULL) clsbtv(btvusrinfo);     /* Close user file */
	if (btvhscore != NULL) {
		setbtv(btvhscore);
		alobtv(btvhscore->data,0);
		updbtv(trvhscore);
		clsbtv(btvhscore);      /* Close High Score file */
	}
}
