{$A+,B-,D-,E-,F-,I-,L-,N-,O+,R-,S-,V-}
(******************************************************************************)
(*                      Hydra Bi-directional Protocol                         *)
(*                                                   *)
(*                                                                            *)
(*                         Low Level String Handler                           *)
(*                                                                            *)
(* BY: Adam Blake                                      Wandoo Valley Software *)
(*     Arjen Lentz                                         and Lentz Software *)
(* VER: 1.00                                                      Development *)
(* DATE: 5th August 1993                                   (c) Copyright 1993 *)
(* LANGUAGE: Turbo Pascal v6.0                  All Rights Reserved Worldwide *)
(******************************************************************************)
(* Pretty basic, but it works. You can substitute your own routines           *)
Unit h_String;
Interface


Function StLoCase( St : string ) : string;

Function StUpCase( St : string ) : string;

Function NulSearch( var Buffer ) : word;

(******************************************************************************)
Implementation


Function StUpCase( St : string ) : string;
var
  I : integer;
begin
  For I := 1 to Length(St) do
    St[I] := UpCase(St[I]);
  StUpCase := St;
end;


Function StLoCase( St : string ) : string;
var
  I : integer;
begin
  For I := 1 to Length(St) do
    If (St[I] >= 'A') and (St[I] <= 'Z') then
      St[I] := Chr(Ord(St[I]) + 32);
  StLoCase := St;
end;


Function NulSearch( var Buffer ) : word; Assembler;
asm;
  CLD

  LES     DI, [Buffer]            (* ES:DI = Buffer *)
  XOR     AL, AL                  (* Looking for nul (0) *)
  MOV     CX, -1
  REPNE   SCASB
  XCHG    AX,CX
  NOT     AX
  DEC     AX
end;

(**********************************MAINLINE************************************)

end.

