(******************************************************************************)
(*                      Hydra Bi-directional Protocol                         *)
(*                                                   *)
(*                                                                            *)
(*          Write/Read longint into Buffer Include File : HYDRA.PAS           *)
(*                                                                            *)
(* BY: Adam Blake                                      Wandoo Valley Software *)
(*     Arjen Lentz                                         and Lentz Software *)
(* VER: 1.00                                                      Development *)
(* DATE: 5th August 1993                                   (c) Copyright 1993 *)
(* LANGUAGE: Turbo Pascal v6.0                  All Rights Reserved Worldwide *)
(******************************************************************************)

const
  HexDigit : array[0..15] of char = '0123456789abcdef';


Function h_GetLong( Index : byte ) : longint; (*Index = 1 - 3*)
var
  Long : longint;
begin
  Move(RxBuf^[(Index - 1) * SizeOf(longint)],Long,SizeOf(longint));
  h_GetLong := Long;
end;


Procedure h_PutLong( Index : byte; Value : longint ); (*Index = 1 - 3*)
begin
  Move(Value,TxBufIn^[(Index - 1) * SizeOf(longint)],SizeOf(Value));
end;


Procedure h_PutHex( Offset : integer; Value : longint );
var
  Count : byte;
begin
  Inc(Offset,8);
  For Count := 1 to 8 do
    begin
      Dec(Offset);
      TxBufIn^[Offset] := Ord(HexDigit[byte(Value) and $0f]);
      Value := Value shr 4;
    end;
end;


Function h_GetHex( Offset : integer ) : longint;
var
  Digit,
  Count : byte;
  Value : longint;
begin
  Value := 0;

  For Count := 1 to 8 do
    begin
      Digit := RxBuf^[Offset] - 48;
      If Digit > 9 then Dec(Digit,39);
      If Digit and $F0 <> 0 then
        begin
          h_GetHex := 0;
          Exit;
        end;
      Value := (Value shl 4) + Digit;
      Inc(Offset);
    end;

  h_GetHex := Value;
end;

(* End of INCLUDE file h_Long.inc *)

