{
HK>  I'm trying to make a program with a external Array, but I can't make it
  >  load the Array so that I can use it. What I'm really trying to do is to
  >  have an external file with one word on each line (line 1 -> array[1],
  >  line 2 -> array[2] and so on) It is an array of string.

  I'll assume you have up to 1500 strings in your external file and that
  it is declared as text. You need an array of pointers to strings, so
  they can be stored on the heap, where you have more room.
}

  const
    MAX = 1500;  { max number of strings }
  var
    MyArray=array[1..MAX] of ^string;
    NString : word;

  {-----------------------------}
  procedure LoadStringArray;
  var
    f : text;
    s : string;

  begin
    assign(f,'strings.txt');
    reset(f);
    NString:= 0;
    while not eof(f) do begin
      inc(NString);
      readln(f,s);
      getmem(MyArray[NString],succ(length(s)));
      MyArray[NString]^:= s;
    end;
    close(f);
  end;

  {------------------------------}
  begin
    LoadStringArray;
  end.

{
  After loading it you can access the individual strings as MyArray[i]^.
  You will also want to write a DisposeStringArray procedure to prevent
  heap leaks...
---
 * D.W.'s TOOLBOX, Atlanta GA, 404-471-6636
}
