{
  The  problem with the DPMI-code was that the flag-variable must lie in
  the  first 1MB of memory, of course! Thus, the following code does the
  job as I originally wanted it to do:
}

PROGRAM TestTimerFunctions;
{Demonstrates use of the INT15-async-timer services with DPMI}
{Kai Rohrbacher, kai.rohrbacher@logo.ka.sub.org}

{$IFDEF DPMI}
USES CRT,WinAPI;
{$ELSE}
USES CRT;
{$ENDIF}

FUNCTION ATClockAvailable:BOOLEAN; {real mode function}
VAR Flag:BYTE;
    p:POINTER;
    i:WORD;
BEGIN
 Flag:=0; p:=@Flag;
 IF Test8086<>0  {is it at least an AT?}
  THEN ASM {yes, have a closer look:}
         STI
         XOR CX,CX     {trigger after 1us}
         MOV DX,1
         LES BX,p      {set Flag to $80 after this time}
         MOV AX,8300h  {run asynchron to rest of program}
         INT 15h       {go!}
       END;
 Delay(1);             {wait a 1000us}
 ATClockAvailable:=Flag=$80 {Flag=$80, if it worked}
END;

TYPE Treg=RECORD  {stuff for that dumb DPMI-server}
           CASE BYTE OF
            0:(LoLo,LoHi,HiLo,HiHi:BYTE);
            1:(Lo16,Hi16:WORD);
          END;
     Tregisters32=
       RECORD
         EDI,ESI,EBP,junk32,EBX,EDX,ECX,EAX:Treg;
         Flags32,ES,DS,FS,GS,IP,CS,SP,SS:WORD
       END;
VAR regs32:Tregisters32;

FUNCTION EmulateInt(IntNr:BYTE; VAR regs32:Tregisters32):BOOLEAN;
ASSEMBLER; {emulate real mode interrupt IntNr with registers regs32}
ASM
  MOV AX,300h   {emulate INT}
  XOR BH,BH     {no A20 gate reset, please}
  MOV BL,IntNr  {INT to emulate}
  XOR CX,CX     {no parameter passing via PM stack}
  LES DI,regs32 {pointer to register set}
  INT 31h       {go for it}
  CMC           {carry flag set if error, reflect this}
  MOV AX,0      {as a BOOLEAN value: return TRUE if C=0}
  ADC AX,AX     {and FALES otherwise}
END;

{$IFDEF DPMI}
FUNCTION DPMI_ATClockAvailable:BOOLEAN; {protected mode function}
VAR long:LONGINT;
    selector,segment:WORD;
BEGIN
 long:=GlobalDosAlloc(1);  {allocate DOS-memory for flag}
 selector:=long AND $FFFF; {flag = DPMI_MEM[selector:0] }
 segment :=long SHR 16;    {     = DOS_MEM [segment :0] }
 MEM[selector:0]:=0;       {reset flag to 0}

 regs32.ECX.Lo16:=0;
 regs32.EDX.Lo16:=1;       {trigger flag after 1us}
 regs32.ES :=segment; regs32.EBX.Lo16:=0;
 regs32.EAX.Lo16:=$8300;

 IF NOT EmulateInt($15,regs32)
  THEN WRITELN('Something went wrong in the INT-emulation!?');

 Delay(1); {INT-emulation went ok, look for timer event:}
           {wait 1000us, so event must have happened:}
 {Flag now should have been set to $80:}
 DPMI_ATClockAvailable:=MEM[selector:0]=$80;
 IF long<>0 THEN GlobalDosFree(selector); {release flag memory}
END;
{$ENDIF}

BEGIN
{$IFDEF DPMI}
 IF DPMI_ATClockAvailable
{$ELSE}
 IF ATClockAvailable
{$ENDIF}
  THEN WRITELN('INT15h-timer-routine available!')
  ELSE WRITELN('INT15h-timer-routine doesn''t work!');
END.

{
TNX to all who helped pointing this one out!
0  0        0    Kai Rohrbacher
0 0               UKB8@IBM3090.RZ.UNI-KARLSRUHE.DE
00    000  00      UKB8@DKAUNI2.BITNET
0 0  0  0   0       kai.rohrbacher@logo.ka.sub.org
0  0  0000 000       2:2476/451.7 <- Fido-Classic!

--- 
 * Origin: for all (x,y): IF x and y=0 THEN PutPixel(x,y,white) (2:2476/451.7)
}