{
 > I'm searching for an easy way to switch the Num-Lock feature ON/OFF by
 > software. Same thing for Caps-lock and Scroll-lock. So if you have a
 > nice routine that swiches Num-Lock,Caps-lock and/or Scroll-lock on
 > and off

I do not remember if I got this from this conference or the SWAG.
Anyway I have compiled it with tp 5.5, and it works.

(*  *)
(*             Original code by Bo Bendtsen                       *)

{
This Program will toggle, Turn on, or Turn off the Caps Lock, Num
Lock, and Scroll Lock lights. and when its done it tells you the
state of each key.
}

Program KeySet;
Const
  CapsState   = $40; { Mask For Caps Lock state }
  NumState    = $20; { Mask For Num Lock state }
  ScrollState = $10; { Mask For Scroll Lock state }
Var
  Kb : Byte Absolute $0040:$0017; { Address of keyboard flags }
  I  : Byte;
  S  : String;
begin
  if ParamCount = 0 then
  begin
    WriteLn;
    WriteLn(' Command line options:');
    WriteLn;
    WriteLn(' C toggle Cap lock state');
    WriteLn(' N toggle Num lock state');
    WriteLn(' S toggle Scroll lock state');
    WriteLn(' C+ N+ and/or S+ to turn on');
    WriteLn(' C- N- and/or S- to turn off');
    Halt(1);
  end;
  For I := 1 to ParamCount Do
  begin
    S := ParamStr(I);
    S[1] := UpCase(S[1]);
    { toggle Caps Lock }
    if S = 'C' then Kb := Kb xor CapsState;
    { toggle Num Lock }
    if S = 'N' then Kb := Kb xor NumState;
    { toggle Scroll Lock }
    if S = 'S' then Kb := Kb xor ScrollState;
    { Set Caps Lock on }
    if S = 'C+' then Kb := Kb or CapsState;
    { Set Num Lock on }
    if S = 'N+' then Kb := Kb or NumState;
    { Set Scroll Lock on }
    if S = 'S+' then Kb := Kb or ScrollState;
    { Set Caps Lock off }
    if S = 'C-' then Kb := Kb and not (CapsState or not Kb);
    { Set Num Lock off }
    if S = 'N-' then Kb := Kb and not (NumState or not Kb);
    { Set Scroll Lock off }
    if S = 'S-' then Kb := Kb and not (ScrollState or not Kb);
  end;

  Write('Caps Lock  : ');
  if (Kb and CapsState) = CapsState then
    WriteLn('ON')
  else
    WriteLn('off');

  Write('Num Lock   : ');
  if (Kb and NumState) = NumState then
    WriteLn('ON')
  else
    WriteLn('off');

  Write('Scroll Lock: ');
  if (Kb and ScrollState) = ScrollState then
    WriteLn('ON')
  else
    WriteLn('off');
end.

{
--- 
 * Origin: The Enchanted Realm (1:375/19.101)
}
