{
 OB> I am therefore searching for a writexy routine (or something like that),
 OB> written in BASM (or even better in INLINE code), cuz the only thing I've
 OB> got is written entirely in Pascal using pointers, and I think using ASM it
 OB>  would be quite a bit faster !?

 OB> Any help would be *greatly* appreciated!

Whipped this up for you.. Don't know if it is as optimized as it could be, but
it IS compiled and even TESTED :-) If you don't receive it (due to its
length), don't kill me: kill the people that use unusable software that pukes
on long messages...
}

{$G+} Unit FastText;

{ Unit for fast writes in Text mode }
{ By Christian Tiberg, 2:200/602 } { Released to the public domain }

Interface

{ Initialize video-mode specifics }
Procedure InitFastWrite;
{ Write the string st at x,y with color f,b } Procedure WriteXY(x, y: Byte;
txt: String; f, b: Byte);

Implementation

{ Might consider moving these variables to the Interface section, if you use }
{ them anywhere else in your program }
Var
    VidSeg: Word;
    VidMode: Byte;
    BytesPerLine: Byte;

Procedure InitFastWrite;

    Begin
      Asm
       mov ah, 0Fh
       int 10h
       mov VidMode, al
      End;
      Case VidMode Of
       0, 1:
          Begin
           VidSeg := $B800;
           BytesPerLine := 80;
          End;
       2, 3:
          Begin
           VidSeg := $B800;
           BytesPerLine := 160;
          End;
       7:
          Begin
           VidSeg := $B000;
           BytesPerLine := 160;
          End;
      End;
    End;

Procedure WriteXY(x, y: Byte; txt: String; f, b: Byte); Assembler;

    Asm
      push ds          { preserve DS, a must-have }

      mov  di, VidSeg  { This must be before DS is modified, since it }
      mov  es, di      { accesses vars in DSeg }
      mov  dh, BytesPerLine

      lds  si, txt  { get the strings address into DS:SI }

      mov  al, y
      xor  ah, ah   { y is only a byte, so zero out AH }

      shl  ax, 4
      mov  bx, ax   { BX := y * 16 }
      shl  ax, 2
      add  ax, bx   { AX := y * 80 }

      cmp  dh, 80   { DH is the saved copy of BytesPerLine }
      je   @@L1     { If only 80 bytes/line, no more shifting }

      shl  ax, 1

@@L1: mov  bl, x
      xor  bh, bh
      add  ax, bx
      mov  di, ax   { ES:DI points to x, y on screen }

      mov  ah, b
      shl  ah, 4
      or   ah, f    { AH contains the attribute for the text }

      lodsb
      mov  cl, al
      xor  ch, ch   { CX contains the length of the string }

@@L2: lodsb
      stosw         { This puts the string on the screen }
      loop @@L2

      pop     ds    { DS must be restored, if TP/BP is not to crash }
    End;

End.

{
Christian

--- 
 * Origin: Silver Bullet BBS - 044-120288 - 22.00-07.00 (2:200/602)
}
