{
JD>  I need some source code that would allow me to stuff my keyboard
JD>  buffer.  
}

{ --------------- Start cut here ------------------ }

  Function InsertKey(key : Word) : Boolean;
  {-Insert a key into the keyboard buffer. Key must be passed
    with the MSB being the scan code of the key you want inserted
    and the LSB being the ascii code. For keys that return an
    extended code (cursor keys function keys etc.) the LSB must be
    zero and the MSB the scan code. Returns true if successfull. }
  Var
    OldTail        : Word;
    BufferStart    : Word absolute $40:$80;         {-Address of the keyboard
                                                      buffer }
    BufferEnd      : Word absolute $40:$82;
    Head           : Word absolute $40:$1A;
    Tail           : Word absolute $40:$1C;

  Begin
    InsertKey := True;
    MemW[$0040:tail] := key;      {-Insert the keypress             }
    OldTail := tail;              {-Keep record of tail position in }
    {-case the key buffer was full    }
    If tail = BufferEnd Then      {-wrap around to Start of buffer  }
      tail := BufferStart
    Else
      Inc(tail, 2);               {-To allow for newly inserted key }
    If tail = head Then
    Begin {-No room for inserting the key so}
      tail := OldTail;            {-restore the status quo          }
      InsertKey := False;
    End;                          {-if tail = head}
  End;                            {-InsertKey}

  Procedure StuffString(Var St : String);
    {-stuff st into the keyboard buffer}
  Var
    x              : Byte;
    sa             : Array[0..16] Of Byte Absolute St;
  Begin
    x := 0;
    Repeat                        {-until the buffer is full or }
      Inc(x);
    Until Not InsertKey(sa[x]) Or (x = sa[0]);
  End;


{ ----------------------------- End cut here ----------------- }

{
    Note that the above code doesn't work correctly under DesqView.  Well, it
 works CORRECTLY, it just doesn't work as one would want it to!  Other than
 that, it works fine.


Jeff

--- 
 * Origin: NightWind (1:135/362)
}
