Unit PalChg;
Interface
Type
  TPalette16 = array[0..15] of array[0..2] of Byte;
  TPalette256 = array[0..255] of array[0..2] of Byte;
procedure SetVGAPalette16(PalBuf : TPalette16);
procedure SetVGAPalette256(PalBuf : TPalette256);
Implementation
procedure SetVGAPalette16(PalBuf : TPalette16);
var
  Reg:                                  Registers;
begin
  reg.ax:=$1012;       {Code for chg. palette}
  reg.bx:=0;           {start with color 0}
  reg.cx:=16;          {change 16 colors}
  reg.es:=Seg(PalBuf); {address: segment}
  reg.dx:=Ofs(PalBuf); {address: offset}
  intr($10, reg);      {interrupt call}
end;
procedure SetVGAPalette256(PalBuf : TPalette256);
var
  Reg:                                  Registers;
begin
  reg.ax:=$1012;       {code for chg. palette}
  reg.bx:=0;           {start with color 0}
  reg.cx:=256;         {change 256 colors}
  reg.es:=Seg(PalBuf); {address: segment}
  reg.dx:=Ofs(PalBuf); {address: offset}
  intr($10, reg);      {interrupt call}
end;
End.
{
------------------------------------------------------------------------
I hope it does the trick, and I hope the comments are helpful.  This
works fine under a BGI driver or under your own "driver" (i.e. just
direct video access).  And it's pretty fast.
About the PCX code...  I have code that is for CGA, EGA, 16-color VGA,
and 256-color VGA.  But it's way too long.  I'm working on trimming it
to the 256-color stuff only and putting it in the form of a unit.  I
should be able to upload that within a few days.

Rodney
---
  Cam-Mail v1.40: The Computer Connection....C'vlle, Va. 804-974-9306 (14.4)
 * The DC Information Exchange (703)836-0748
}

