{
 TD> Or even better, whats the idea behind
 TD> "transparent" objects.  Like in the demo, Unreal, where it says
 TD> "OBVIOUSLY IT CAN BE DONE" or something like that... Any information
 TD> is VALUED! :) Thanks.

        Transparent objects are rather simple.  What you do is
set up your palette so pure colors are represented by powers of
two.  This way you can "mix" your colors by ORing the values
together.  For simplicity's sake, this example will use 3 colors:

        Bit  7 6 5 4 3 2 1 0
                       | | |
                       | | +----> Red
                       | +------> Green
                       +--------> Blue

So now you would set your palette up as follows:

    All single colors:

      2^0 = 1   --   Red
      2^1 = 2   --   Green
      2^2 = 4   --   Blue

    All possible 2 color mixes:

      2^0 OR 2^1 = 1 OR 2 = 3   --   Red + Green  = Yellow
      2^0 OR 2^2 = 1 OR 4 = 5   --   Red + Blue   = Magenta
      2^1 OR 2^2 = 2 OR 4 = 6   --   Green + Blue = Cyan

    All possible 3 color mixes:

      2^0 OR 2^1 OR 2^2 = 1 OR 2 OR 4 = 7  --  R + G + B = White

So our palette is set up as:

        0 - Black
        1 - Red
        2 - Green
        3 - Yellow
        4 - Blue
        5 - Magenta
        6 - Cyan
        7 - White

Now let's say we have a Red, Green, and a Blue square.  The
bitmap of the red square will be made up of bytes of the value 1,
the green square will be made up of the value 2, and the blue
square will be made up of the value 4 as so:

           Red             Green              Blue

         11111111         22222222          44444444
         11111111         22222222          44444444
         11111111         22222222          44444444
         11111111         22222222          44444444

To put the squares, you just have to OR put them to your frame
buffer.  If they overlap, they will automatically mix as so:

     The 3 overlaping bitmaps       The 3 overlaping bitmaps
     in frame buffer using an       in frame buffer showing
     OR'd image put:                what colors are where:

            11111111                      RRRRRRRR
            11111111                      RRRRRRRR
            111133332222                  RRRRYYYYGGGG
            155577776222                  RMMMWWWWCGGG
             44466666222                   BBBCCCCCGGG
             44466666222                   BBBCCCCCGGG
             44444444                      BBBBBBBB

The following example program uses this bit scheme:

        Bit  7 6 5 4 3 2 1 0
             |   | | | +-+-+---> Color Intensity (0:Least - 7:Full)
             |   | | +---------> Red
             |   | +-----------> Green
             |   +-------------> Blue
             +-----------------> Grey
}

Program Transparent;
{                                       }
{   Example of How Transparency Works   }
{                                       }
{  Programmed by David Dahl @ 1:272/38  }
{                                       }
{     This program is PUBLIC DOMAIN     }
{                                       }
Uses CRT, Palette;

Type ImageArray = Array [0..15, 0..15] of Byte;

     LocationRec = Record
                         X : Integer;
                         Y : Integer;
                   End;

     VGABufferArray = Array[0..199, 0..319] of Byte;
     VGABufferPtr   = ^VGABufferArray;

Const BobTemplate : ImageArray =
              ((00,00,00,00,00,00,07,07,07,07,00,00,00,00,00,00),
               (00,00,00,00,07,07,04,04,04,04,06,05,00,00,00,00),
               (00,00,00,07,04,04,04,04,04,04,04,04,04,00,00,00),
               (00,00,07,04,04,04,04,04,04,04,04,04,04,03,00,00),
               (00,07,04,04,04,04,04,04,04,04,04,04,04,04,02,00),
               (00,07,04,04,04,04,04,04,04,04,04,04,04,04,01,00),
               (07,04,04,04,04,04,04,04,04,04,04,04,04,04,04,01),
               (07,04,04,04,04,04,04,04,04,04,04,04,04,04,04,01),
               (07,04,04,04,04,04,04,04,04,04,04,04,04,04,04,01),
               (07,04,04,04,04,04,04,04,04,04,04,04,04,04,04,01),
               (00,06,04,04,04,04,04,04,04,04,04,04,04,04,01,00),
               (00,06,04,04,04,04,04,04,04,04,04,04,04,04,01,00),
               (00,00,05,04,04,04,04,04,04,04,04,04,04,01,00,00),
               (00,00,00,04,04,04,04,04,04,04,04,04,01,00,00,00),
               (00,00,00,00,03,02,04,04,04,04,01,01,00,00,00,00),
               (00,00,00,00,00,00,01,01,01,01,00,00,00,00,00,00));

      MaxBob = 2; { 3 Bobs (0 .. 2) }

Var VGA        : VGABufferPtr;
    BackGround : VGABufferPtr;
    WorkPage   : VGABufferPtr;

    Pal : PaletteArray;

    BobImage    : Array[0..MaxBob] of ImageArray;
    BobLocation : Array[0..MaxBob] of LocationRec;

    Counter1 : Integer;
    Counter2 : Integer;

{-[ Set VGA Mode 13h (320 X 200 X 256 Chain 4) ]------------------------}
Procedure SetMode13h; Assembler;
ASM
   MOV AX, $13
   INT $10
End;
{-[ Put A 16 X 16 Image by ORing it With Background ]-------------------}
Procedure Put16X16ImageOR (Var Bob    : ImageArray;
                               X, Y   : Integer);
Var CounterX,
    CounterY  : Integer;
Begin
     For CounterY := 0 to 15 do
      For CounterX := 0 to 15 do
       WorkPage^[CounterY + Y, CounterX + X] :=
        WorkPage^[CounterY + Y, CounterX + X] OR Bob[CounterX, CounterY];
End;
{-[ Update Bob Positions ]----------------------------------------------}
Procedure UpdateBobs;
Var BobCounter : Integer;
Begin
     For BobCounter := 0 to MaxBob do
     Begin
          Inc (Counter1, 1);
          While (Counter1 >= 360) do
             Dec(Counter1, 360);

          If (Counter1 MOD 2) = 0
          Then
          Begin
               Inc(Counter2,1);
               While (Counter2 >= 360) do
                     Dec(Counter2, 360);
          End;

          BobLocation[BobCounter].X := 160 +
             Round(90 * -Sin((Counter1 + (BobCounter*Counter2))*PI/180));

          BobLocation[BobCounter].Y := 95 +
             Round(60 * Cos((Counter2 + (BobCounter*Counter1))*PI/180));

     End;
End;
{-[ Draw All Bobs To Work Buffer ]--------------------------------------}
Procedure DrawBobs;
Var BobCounter : Integer;
Begin
     For BobCounter := 0 to MaxBob do
         Put16X16ImageOR (BobImage[BobCounter],
            BobLocation[BobCounter].X, BobLocation[BobCounter].Y);
End;
{-[ Initialize Variables ]----------------------------------------------}
Procedure InitializeVariables;
Const Tbl : Array [0..MaxBob] of Byte = (8, 16, 32);
Var BobCounter : Integer;
    CX, CY     : Integer;
Begin
     { Make Individual Bobs From Template }
     For BobCounter := 0 to MaxBob do
     Begin
          BobImage[BobCounter] := BobTemplate;

          For CY := 0 to 15 do
              For CX := 0 to 15 do
                  If BobImage[BobCounter][CX,CY] <> 0
                  Then
                      BobImage[BobCounter][CX,CY] :=
                         BobImage[BobCounter][CX,CY] OR Tbl[BobCounter];
     End;

     Counter1 := 0;
     Counter2 := 0;
End;
{-[ Build Palette ]-----------------------------------------------------}
Procedure BuildPalette;
Var ColorCounter : Integer;
Begin
     { Initialize Palette Buffer To All Black }
     FillChar (Pal, SizeOf(Pal), 0);

     For ColorCounter := 0 to 7 do
     Begin
      { Make Red, Green, and Blue Bobs }
      Pal[ColorCounter OR 08].Red   := 21 + (ColorCounter * 6);
      Pal[ColorCounter OR 16].Green := 21 + (ColorCounter * 6);
      Pal[ColorCounter OR 32].Blue  := 21 + (ColorCounter * 6);

      { Make Colors Where Red and Green Bobs Overlap }
      Pal[ColorCounter OR 08 OR 16].Red   := 21 + (ColorCounter * 6);
      Pal[ColorCounter OR 08 OR 16].Green := 21 + (ColorCounter * 6);

      { Make Colors Where Red and Blue Bobs Overlap }
      Pal[ColorCounter OR 08 OR 32].Red  := 21 + (ColorCounter * 6);
      Pal[ColorCounter OR 08 OR 32].Blue := 21 + (ColorCounter * 6);

      { Make Colors Where Green and Blue Bobs Overlap }
      Pal[ColorCounter OR 16 OR 32].Green := 21 + (ColorCounter * 6);
      Pal[ColorCounter OR 16 OR 32].Blue  := 21 + (ColorCounter * 6);

      { Make Colors Where Red, Green and Blue Bobs Overlap }
      Pal[ColorCounter OR 08 OR 16 OR 32].Red   := 21+(ColorCounter * 6);
      Pal[ColorCounter OR 08 OR 16 OR 32].Green := 21+(ColorCounter * 6);
      Pal[ColorCounter OR 08 OR 16 OR 32].blue  := 21+(ColorCounter * 6);
     End;

     { Make Colors Where The Grey Square Overlaps The Bobs }
     For ColorCounter := 128 to 255 do
     Begin
      Pal[ColorCounter].Red   := (Pal[ColorCounter-128].Red   DIV 4)+14;
      Pal[ColorCounter].Green := (Pal[ColorCounter-128].Green DIV 4)+14;
      Pal[ColorCounter].Blue  := (Pal[ColorCounter-128].Blue  DIV 4)+14;
     End;
End;
{-[ Draw Grey Square In Background Buffer ]-----------------------------}
Procedure BuildBackground;
Var Y, X : Integer;
Begin
     FillChar (BackGround^, SizeOf(BackGround^), 0);

     For Y := 50 to 150 do
     For X := 100 to 220 do
         BackGround^[Y, X] := 128;

End;
{=[ Main Program ]======================================================}
Begin
     VGA := Ptr ($A000,$0000);
     New (WorkPage);
     New (BackGround);

     InitializeVariables;
     BuildPalette;
     BuildBackground;

     SetMode13h;
     SetPalette (Pal);

     Repeat
           UpdateBobs;               { Update Bob Positions }
           WorkPage^ := BackGround^; { Clear WorkPage With Static Image }
           DrawBobs;                 { Draw Bobs }

           { Wait For Retrace }
           Repeat Until ((Port[$3DA] AND 8) <> 0);

           VGA^ := WorkPage^;        { Display Page }
     Until KeyPressed;

     TextMode (C80);

     Dispose (BackGround);
     Dispose (WorkPage);
End.


{
---
 * Origin: PDN HQ (914)344-0350 HST/V32T 343-7540 HST/V32b (1:272/38)
}

