{
 JG> If I have some points in 3D space:
 JG>  How can I look at them from another angle?

By rotating the stuff three dimensionally, using the following formula's:

  i := (cosin(phiy)*dot[n].x - sinus(phiy)*dot[n].z) div divd;
  j := (cosin(phiz)*dot[n].y - sinus(phiz)*i) div divd;
  k := (cosin(phiz)*dot[n].z + sinus(phiy)*dot[n].x) div divd;
  x := (cosin(phiz)*i + sinus(phiz)*dot[n].y) div divd;
  y := (cosin(phix)*j + sinus(phix)*k) div divd;
  z := (cosin(phix)*k - sinus(phix)*j) div divd;

And then you can project the stuff to the screen (inc. perspective) using
these two:

  xp := (-x*dist) div (z-dist);
  yp := (-y*dist) div (z-dist);

The above six formula's are for integer-math. You should make a cosine and
sine table (360 bytes long, for example), and give the angle in degrees (phix,
phiy and phiz). The table should be multiplied by 'divd', which should be 128
for best result. Like this:
}

  type styp = array[0..255] of integer;
  var stab : styp;

  procedure csin(var stab : styp); var i : byte; begin
    for i := 0 to 255 do stab[i] := round(sin(2*i*pi/255)*divd); end;

  function sinus(i : byte) : integer; begin
    sinus := stab[i]; end;

  function cosin(i : byte) : integer; begin
    cosin := stab[(i+192) mod 255]; end;

{
Well, this should get things going.
Btw: 'csin' (calculate-sine-table) makes a table of length 256. So a cosine is
calculated using the following principle: sin(a) = cos(a+0.5*pi)... sorta...

'Dist' in the perspective formula's is the distance from viewpoint to the
object (sorta...;-) It's adviseble to put it in an array, so you can draw it
once, and clear it later, before calculating the new values.

Otherwise, try to find one of the rotational-stuff I posted a lot here.
I'm afraid it can't be find in the Swag (kind of a lame update, the last one).
Anyway, I hope to release all my graphics-stuff one day in an archive...
 _    _
|_]  | _
|__].|__].

--- 
 * Origin: F'req CR at 2:285/20 for a RA-Caller Maintenance prg. (2:285/213.8)
}