{
AW> that was 10 times as large as the original ASCII file.  Is there anyway
AW> to shrink this file without changing the data type too much?  (I need to
AW> Use Seek.)

Write only as many bytes to the file as the individual string needs.
Ie., for an 11-character string, store 12 bytes (11 + length byte).

If you have to make absolute seeks (ie., to read the n'th element
without reading the (n-1)'th preceding elements), maintain an "index"
for the data file as well:

---
}
 
uses
  Crt, Dos;

const
  MaxNumOfElements = 400; (* 400 * 4 = 1600 bytes *)

var
  Index : array[1..MaxNumOfElements] of Longint;
  IndexSize : Word;
  IndexFileName : PathStr;

procedure InitIndex (FileName : PathStr);
var
  IdxF : file;
begin
  IndexFileName:=FileName;
  IndexSize:=0;
  Assign(IdxF, FileName);
  {$I-}
  Reset(IdxF, SizeOf(Longint));
  if IOResult <> 0 then
    Exit;
  IndexSize:=FileSize(IdxF);
  BlockRead(IdxF, Index, IndexSize);
  Close(IdxF);
  {$I+}
end;

procedure DoneIndex;
var
  IdxF : file;
begin
  Assign(IdxF, IndexFileName);
  {$I-}
  Rewrite(IdxF, SizeOf(Longint));
  BlockWrite(IdxF, Index, IndexSize);
  Close(IdxF);
  {$I+}
end;

function NthOffset (N : Longint) : Longint;
begin
  NthOffset:=Index[N];
end;

procedure AddIndex (Offset : Longint);
begin
  Inc(IndexSize);
  Index[IndexSize]:=Offset;
end;

(* ... sample program ... *)

var
  F : file of Byte;

procedure WriteStr (S : string);
var
  L     : Longint;
  Count : Word;
begin
  L:=FileSize(F);
  AddIndex(L);
  Seek(F, L);
  BlockWrite(file(F), S[0], Length(S) + 1, Count);
end;

procedure ReadNthStr (N : Longint; var S : string);
var
  Count : Word;
begin
  Seek(F, NthOffset(N));
  BlockRead(file(F), S[0], SizeOf(S), Count);
end;

function RandomString : string;
var
  S    : string;
  SLen : Byte absolute S;
begin
  for SLen:=1 to Random(30) + 1 do
    S[SLen]:=Chr(65 + Random(26));
  RandomString:=S;
end;

var
  L : Longint;
  S : string;
begin
  Randomize;

  InitIndex('STRINGS.IDX');

  Assign(F, 'STRINGS.DAT');
  {$I-}
  Reset(F);
  if IOResult <> 0 then
    Rewrite(F);

  for L:=1 to 100 do
    begin
      S:=RandomString;
      WriteStr(S);
      ClrEol;
      Write(L:8, ' ', S, #13);
    end;
  ClrEol;
  for L:=1 to 100 do
    begin
      ReadNthStr(L, S);
      WriteLn(L:8, ' ', S);
    end;

  Close(F);
  {$I+}

  DoneIndex;
end.
{
---

The example program will create a data file of 100 strings and read
strings of numbers 1 through 100.  Note that InitIndex loads a
possible index file into memory, DoneIndex writes the memory index
file to disk.

Hence the limit is about 16380 elements in the index array.  If you
want a larger index array, store it dynamically in pieces of, say, 200
elements, like this:

        type
          PieceIndexArray = array[1..200] of Longint;
          IndexArray = array[1..4000] of ^PieceIndexArray;

        var
          Index : IndexArray;

If you need help as to how to rewrite the code, just ask.

                    ttyl, Lew.
                    lew.romney@thcave.bbs.no
---
 * Thunderball Cave BBS, Oslo Norway 47 22 56 70 18
}
