/*
  T_EXEC.PRG
  Author:  D.B. McDonald  [ CIS 76334,3521 ]
  Created: April 25, 1993

  Version: 1.20.00
  Update:  May 15, 1993

     Main program for TOUCH

     This routine uses Clipper Tools functions:
        SETFDATI(), TOKENINIT(), TOKENNEXT(), TOKENEND()

*/

* -------------------------------------------------------------------------- *
#include "common.ch"
#include "simpleio.ch"
#include "directry.ch"

//... Directory array subscript names derived from 'directry.ch'
#translate .Name => \[ F_NAME ]
#translate .Size => \[ F_SIZE ]
#translate .Date => \[ F_DATE ]
#translate .Time => \[ F_TIME ]
#translate .Attr => \[ F_ATTR ]

#define CRLF chr(13) + chr(10)


* -------------------------------------------------------------------------- *
* t_Execute( [<cSpec>] )
*    - main program executive
*
Procedure t_Execute( cSpec )
* -------------------------------------------------------------------------- *
   local dDate := NIL
   local cTime := NIL
   local nOff  := 0
   local cArg  := lower( DosParam() )
   local aFile := iif( cSpec == NIL, {}, Directory( cSpec ) )
   local lHelp := ( '-h' $ cArg .or. '/h' $ cArg .or. '/?' $ cArg )
   local lDate := ( '-d' $ cArg .or. '/d' $ cArg )
   local lTime := ( '-t' $ cArg .or. '/t' $ cArg )
   local lVerb := ( '-v' $ cArg .or. '/v' $ cArg )
   local lNow  := ( '-n' $ cArg .or. '/n' $ cArg )
   local nErr  := 0
   local lErr  := .T.

   //... -n option overrides -d and -t options
   if ( lNow )
      dDate := Date()
      cTime := Time()
   else
      //... Strip Date from DOS command line
      if ( lDate )
         dDate := GetArg( 'd', cArg ) &&... Date is a string at this point
         dDate := iif( empty( dDate ), Date(), cToD( dDate ) )
      endif
      //... Strip Time from DOS command line
      if ( lTime )
         cTime := GetArg( 't', cArg )
         cTime := iif( empty( cTime ), Time(), cTime )
      endif
   endif

   if ( lHelp )
      t_Syntax()
   elseif ( empty( aFile ) )
      OutStd( "No files found" )
   elseif ( lDate .or. lTime .or. lNow )
      if ( lVerb )
         aeval( aFile, { |file| OutFile( file ), ;
                                OutStd( ' => ' ), ;
                                iif( ( lErr := fSetDaTim( file, dDate, cTime ) ), OutFile( directory( file.Name )[1] ), OutStd( 'Unchanged' ) ), ;
                                OutStd( CRLF ), nErr += iif( lErr,0,1 ) } )
      else
         aeval( aFile, { |file| lErr := fSetDaTim( file, dDate, cTime ), nErr += iif( lErr,0,1 ) } )
      endif
   else
      aeval( aFile, {|file| OutFile( file ), OutStd( CRLF ) } )
   endif

   //... Set DOS errorlevel return code to the number of 'Unchanged'
   //... files.  Maximum value of return code is 255
   ErrorLevel( min(  nErr, 255 ) )

return


* -------------------------------------------------------------------------- *
* OUTFILE( <aFile> ) --> NIL
*  - formatted output of file name with date and time attributes
*
Static Procedure OutFile( a )
* -------------------------------------------------------------------------- *
  OutStd( PadR( a.Name, 13 ) + PadR( a.Date, 09 ) + PadR( a.Time, 09 ) )
Return


* -------------------------------------------------------------------------- *
* FSETDATIM( <aFile>, [<dDate>], [<cTime>] ) --> <lError>
*    - change the date and/or time stamp of a file
*    - if either date or time is NIL use the file's original date or time
*
Static Function fSetDaTim( aFile, dDate, cTime )
* -------------------------------------------------------------------------- *
  default dDate to aFile.Date, ;
          cTime to aFile.Time
return SetfDaTi( aFile.Name, dDate, cTime )


* -------------------------------------------------------------------------- *
* GETARG( <cOption> )
*    - return the arguement for an option
*    - this function assumes the option exists
*
Static Function GetArg( cOpt, cArgLst )
* -------------------------------------------------------------------------- *
  local cArg := ''

  //... Tokenize arguement list  
  TokenInit( @cArgLst, space(1) )

  //... scan arguement list until the arguement option is found
  while ! ( TokenEnd() .or. '-' + cOpt $ cArg .or. '/' + cOpt $ cArg  )
     cArg := TokenNext( cArgLst )
  enddo

//... return arguement portion of the option
return SubStr( cArg, 3 )
