/*
  BLINKER.PRG
  Author:  D.B. McDonald  [ CIS 76334,3521 ]
  Created: April 25, 1993

  Version: 1.10.00
  Update:  May 13, 1993

     Clipper 5.2 INITializing procedure.

     Save Blinker 2.0 serial number information and demonstration limits
     in static arrays for use by external routines.

     This routine requires Clipper Tools:
        TokenInit(), TokenNext(), TokenEnd()

*/
#include "common.ch"
announce Blinker2

* -------------------------------------------------------------------------- *
Static Blinker  := {}
static Serial   := {}


* -------------------------------------------------------------------------- *
init procedure BlinkerData()
* -------------------------------------------------------------------------- *
  //... Get Blinker Serial Number
  Serial := TokenArray( bliSerNum() )

  //... Get Blinker Demo information
  Blinker := { bliVerNum(), bliDemCal(), bliDemDte(), bliDemMin() }

return


* -------------------------------------------------------------------------- *
Function SerNum( n )
* -------------------------------------------------------------------------- *
return iif( n == NIL, Serial, Serial[ n ] )


* -------------------------------------------------------------------------- *
Function BlinkDemo( n )
* -------------------------------------------------------------------------- *
return iif( n == NIL, Blinker, Blinker[ n ] )


* ---------------------------------------------------------------------------
FUNCTION TokenArray( cList, cDelim, nSkip )
* ---------------------------------------------------------------------------
  local aList := {}

  if ( cList # NIL )

     //... Add tokens to the array as along as there are tokens in the string
     TokenInit( @cList, iif( cDelim == NIL, ',', cDelim ), nSkip )
     while ! TokenEnd()
        aAdd( aList, TokenNext( cList ) )
     end

  endif

// Return the array
return aList
