Option Explicit

'Global vars

'Stores handle of the control with help text on display
Dim hwndCurrentControl As Integer

'Constants

' BorderStyle (form)
'Global Const NONE = 0          ' 0 - None
Rem Global Const FIXED_SINGLE = 1   ' 1 - Fixed Single
Rem Global Const SIZABLE = 2        ' 2 - Sizable (Forms only)
Rem Global Const FIXED_DOUBLE = 3   ' 3 - Fixed Double (Forms only)

' GetSystemMetrics() codes
Global Const SM_CXSCREEN = 0
Global Const SM_CYSCREEN = 1
Global Const SM_CXVSCROLL = 2
Global Const SM_CYHSCROLL = 3
Global Const SM_CYCAPTION = 4
Global Const SM_CXBORDER = 5
Global Const SM_CYBORDER = 6
Global Const SM_CXDLGFRAME = 7
Global Const SM_CYDLGFRAME = 8
Global Const SM_CYVTHUMB = 9
Global Const SM_CXHTHUMB = 10
Global Const SM_CXICON = 11
Global Const SM_CYICON = 12
Global Const SM_CXCURSOR = 13
Global Const SM_CYCURSOR = 14
Global Const SM_CYMENU = 15
Global Const SM_CXFULLSCREEN = 16
Global Const SM_CYFULLSCREEN = 17
Global Const SM_CYKANJIWINDOW = 18
Global Const SM_MOUSEPRESENT = 19
Global Const SM_CYVSCROLL = 20
Global Const SM_CXHSCROLL = 21
Global Const SM_DEBUG = 22
Global Const SM_SWAPBUTTON = 23
Global Const SM_RESERVED1 = 24
Global Const SM_RESERVED2 = 25
Global Const SM_RESERVED3 = 26
Global Const SM_RESERVED4 = 27
Global Const SM_CXMIN = 28
Global Const SM_CYMIN = 29
Global Const SM_CXSIZE = 30
Global Const SM_CYSIZE = 31
Global Const SM_CXFRAME = 32
Global Const SM_CYFRAME = 33
Global Const SM_CXMINTRACK = 34
Global Const SM_CYMINTRACK = 35
Global Const SM_CMETRICS = 36

'TYpes
Type POINTAPI
	x As Integer
	y As Integer
End Type

'API declarations
Declare Function WindowFromPoint Lib "User" (ByVal ptScreen As Any) As Integer
Declare Function GetSystemMetrics Lib "User" (ByVal nIndex As Integer) As Integer
Declare Sub GetCursorPos Lib "User" (lpPoint As POINTAPI)
Declare Function SetParent Lib "USER" (ByVal hWndChild%, ByVal hWndNewParent%) As Integer
Declare Function GetParent Lib "USER" (ByVal hWnd%) As Integer
Declare Sub ClientToScreen Lib "USER" (ByVal hWnd%, lpPoint As POINTAPI)
Declare Sub ScreenToClient Lib "USER" (ByVal hWnd%, lpPoint As POINTAPI)
Declare Function GetMapMode Lib "GDI" (ByVal hdc%) As Integer
Declare Function GetDC Lib "USER" (ByVal hWnd%) As Integer

Sub CheckForToolHelp (picMessage As PictureBox)

'This function checks the position of the mouse. If it positioned over
'a control that has toolhelp in its tag property then the help is displayed
'If it is not then the toolhelp is switched off.

Dim ptCursorPos As POINTAPI
Dim lPoint As Long
Dim hWnd As Integer
Dim cc%

    On Error GoTo CheckForToolHelp_Err

    'Get the current cursor position in screen coords (API Call)
    GetCursorPos ptCursorPos

    'Convert the point structure to a long so that it can be passed by
    'value to the ChildWindowFromPoint function. You cannot pass structures
    'by value to API functions. What a great help. Thanks microsoft!
    lPoint = ptCursorPos.y
    lPoint = lPoint * (256 ^ 2)
    lPoint = lPoint + ptCursorPos.x

    'Disable the picbox. It will still be visible but will not be picked up
    'by the WindowFromPoint function. This will stop the message flashing
    'when a tool help message pops up underneath the cursor when the cursor
    'is over a control
    picMessage.Enabled = False

    'Get the window handle of the child control that the cursor is positioned
    'over if any. This function will not return a window handle if the control
    'is invisible or disabled according to the documentation.
    hWnd = WindowFromPoint(ByVal lPoint)

    'Get the control from the window handle and display the
    'help text if there is any
    For cc% = 0 To Screen.ActiveForm.Controls.Count - 1

	If Screen.ActiveForm.Controls(cc%).hWnd = hWnd Then

	    'If control has no tag property an error is generated
	    'and Resume Next is executed. This should be a bit better cos
	    'it won't trap any errors.
	    If Screen.ActiveForm.Controls(cc%).Tag <> "" Then

		'Only display help text if the mouse has moved onto a different
		'control. This stops the help text flashing when left over the
		'same control
		If hwndCurrentControl <> hWnd Then
		    hwndCurrentControl = hWnd
		    DisplayToolHelp Screen.ActiveForm.Controls(cc%), picMessage
		End If
		Exit Sub

	    End If
	End If

    Next cc%

    'If no message was found to display then make the message box
    'invisible. Set current toolhelp control to NULL
    hwndCurrentControl = 0
    picMessage.Visible = False

    Exit Sub

CheckForToolHelp_Err:

    'This ought to check specifically for a No Such Property error
    Resume Next

End Sub

Sub DisplayToolHelp (cmdButton As Control, picMessage As PictureBox)

'This procedure displays a yellow tool help label next to the command button
'passed to the function. The text displayed is held in the tag property of
'the command button. If the text is blank then no help is displayed.
'The function moves and sizes the picture box containing the help to a
'position next to the command control and sizes it so that it can display
'the whole text and be completely on the form.

'This function can be called directly without making a call to CheckForToolHelp()
'However this function does not control the switching off of the text or when
'the text is switched on. It is better to call CheckForToolHelp(..) in
'response to a timer event.

Dim nBorderWidth As Integer
Dim nBorderHeight As Integer
Dim nTitleBarHeight As Integer
Dim nResponse As Integer
Dim hwndControlParent As Integer
Dim ptMessagePos As POINTAPI

    'Get border width, height and title bar depth of container form
    nBorderHeight = GetBorderHeight(cmdButton.Parent)
    nBorderWidth = GetBorderWidth(cmdButton.Parent)
    nTitleBarHeight = GetTitleBarHeight()


    'Size the picture box to fit the text in using the text length of the
    'tag property of the control and the font size of the picture box.
    picMessage.Width = picMessage.TextWidth(cmdButton.Tag & " ")
    picMessage.Height = picMessage.TextHeight(cmdButton.Tag) * 1.2

    'Get the container of the command button which may be the form
    hwndControlParent = GetParent(cmdButton.hWnd)

    'Calculate the coordinates of where the text message should appear
    'relative to the button's container
    ptMessagePos.y = cmdButton.Top + cmdButton.Height + 50
    ptMessagePos.x = cmdButton.Left

    'Turn these coordinates into screen coordinates
    'Convert to pixels before calling API. This is because the VB scalemode
    'is NOT related to the Windows DC Mapping Mode (for some reason ?). The
    'default scale mode in VB is in twips. A call to the API will reveal
    'that Windows thinks the mapping mode is MM_TEXT which is pixels!. So
    'a call to ClientToScreen for a default form or control will expect
    'to get coordinates in pixels and NOT twips. Thanks again Microsoft.

    ptMessagePos.x = ptMessagePos.x / Screen.TwipsPerPixelX
    ptMessagePos.y = ptMessagePos.y / Screen.TwipsPerPixelY
    ClientToScreen ByVal hwndControlParent, ptMessagePos

    'Turn the screen coordinates back into coordinates relative to the
    'main form and NOT relative to the container object
    ScreenToClient ByVal cmdButton.Parent.hWnd, ptMessagePos

    'Convert back to twips
    ptMessagePos.x = ptMessagePos.x * Screen.TwipsPerPixelX
    ptMessagePos.y = ptMessagePos.y * Screen.TwipsPerPixelY

    'Position the picture box
    picMessage.Top = ptMessagePos.y
    picMessage.Left = ptMessagePos.x

    'If the picture box is positioned off the active form to the bottom or
    'to the right move it back onto the form.
    If picMessage.Left + picMessage.Width > (picMessage.Parent.Width - nBorderWidth) Then
	picMessage.Left = (picMessage.Parent.Width - nBorderWidth) - picMessage.Width - 150
    End If

    If picMessage.Top + picMessage.Height > (picMessage.Parent.Height - (nBorderHeight * 2) - nTitleBarHeight) Then
	picMessage.Top = (picMessage.Parent.Height - (nBorderHeight * 2) - nTitleBarHeight) - picMessage.Height
    End If


    'Clear the previous text from the picture box and reset draw start
    'position to origin.
    picMessage.Cls

    'Print the message in the picture box
    picMessage.Print cmdButton.Tag

    'Make the picture box visible
    picMessage.Visible = True


End Sub

Function GetBorderHeight (oForm As Form) As Integer

'Returns the border height of the form passed in the args

Dim nBorderHeightType As Integer
Dim nBorderHeight As Integer

    'Find out what type of window frame the form has and set
    'the border width to retrieve
    Select Case oForm.BorderStyle

    Case FIXED_SINGLE
	nBorderHeightType = SM_CYBORDER

    Case SIZABLE
	nBorderHeightType = SM_CYFRAME

    Case FIXED_DOUBLE
	nBorderHeightType = SM_CYDLGFRAME

    Case Else
	GetBorderHeight = 0
	Exit Function

    End Select

    'Call Windows API to get the border height
    nBorderHeight = GetSystemMetrics(ByVal nBorderHeightType)

    'Convert to client coordinates
    nBorderHeight = nBorderHeight * Screen.TwipsPerPixelY

    GetBorderHeight = nBorderHeight


End Function

Function GetBorderWidth (oForm As Form) As Integer

'Returns the border width of the form passed in the args

Dim nBorderWidthType As Integer
Dim nBorderWidth As Integer

    'Find out what type of window frame the form has and set
    'the border width to retrieve
    Select Case oForm.BorderStyle

    Case FIXED_SINGLE
	nBorderWidthType = SM_CXBORDER

    Case SIZABLE
	nBorderWidthType = SM_CXFRAME

    Case FIXED_DOUBLE
	nBorderWidthType = SM_CXDLGFRAME

    Case Else
	GetBorderWidth = 0
	Exit Function

    End Select

    'Call Windows API to get the border width in screen coordinates
    nBorderWidth = GetSystemMetrics(ByVal nBorderWidthType)

    'Convert to client coorinates
    nBorderWidth = nBorderWidth * Screen.TwipsPerPixelX

    GetBorderWidth = nBorderWidth


End Function

Function GetTitleBarHeight () As Integer

'Returns the title bar height of a window
'The API call returns the window title height plus the height of a non
'sizable window frame

Dim nTitleBarHeight As Integer

    'Returns screen coordinates
    nTitleBarHeight = GetSystemMetrics(ByVal SM_CYCAPTION)

    'Convert height to client coordinates
    nTitleBarHeight = nTitleBarHeight * Screen.TwipsPerPixelY

    GetTitleBarHeight = nTitleBarHeight

End Function

