
//******************** User Program List structure

typedef struct UserProgStruct
{
	BOOL	fActive;			// TRUE if the strings below have been allocated.
	NPSTR	szPath;				// Full path to program to execute.
	NPSTR	szDescription;		// Description to appear in menu.
} USERPROG;


typedef struct PreLoadProgStruct
{
	BOOL	fActive;			// TRUE if the string below has been allocated.
	NPSTR	szPath;				// Full path to program to execute.
	HINSTANCE hInst;			// Instance handle of program.
	HWND	hWnd;				// Main window handle of program.
} PRELOADPROG;


//******************** Menu Item identifiers
// An extension's menu item ID must be in the range 1 through 99

#define IDM_ABOUT				10

#define	IDM_USERPROG			20
#define	IDM_MAXUSERPROG			40
#define	NUM_USERPROGS			( IDM_MAXUSERPROG - IDM_USERPROG )
#define	NUM_PRELOADPROGS		5

//******************** Misc. defines

#define PATH_NAME_LEN			260
#define	PROG_DESC_LENGTH		32
#define	ENTRY_TAG_LENGTH		16
#define	MAX_CMDLINE_LENGTH		128

//******************** Function prototypes

int CALLBACK LibMain( HANDLE hLibInst, WORD wDataSeg, WORD cbHeapSize,
						LPSTR lpszCmdLine );

int CALLBACK WEP( int bSystemExit );

HMENU CALLBACK FMExtensionProc( HWND hWndXtension, WORD wMesssage, LONG lParam);

void NameMenu( LPSTR szName );

int InitializeMenu( HMENU hMenu );

void CleanUpMenu( void );

void PreLoadPrograms();

HWND DetermineProgramHandle( HINSTANCE hInst );

void KillPreLoadedPrograms();

void UserProgram( WORD wProgNumber, HWND hWndExtension );

BOOL CALLBACK AboutDlgProc( HWND hDlg, UINT wMsg, WPARAM wParam, LPARAM lParam );

