/* test.c */

#include <stdio.h>
#include <conio.h>
#include <malloc.h>
#include <io.h>
#include <fcntl.h>
#include <i86.h>
#include "modplay.h"

#define MUSICVOLUME 192

void FadeInMusic(void)
{
    int Volume;
    for (Volume = 0; Volume <= MUSICVOLUME; Volume++) {
        MODSetMusicVolume(Volume);
        delay(6);
    }
}
void FadeOutMusic(void)
{
    int Volume;
    for (Volume = MUSICVOLUME; Volume >= 0; Volume--) {
        MODSetMusicVolume(Volume);
        delay(8);
    }
}

void TestSample(void)
{
    Sample *Ding;
    if ((Ding = MODLoadSample("DING.WAV")) != NULL) {
        printf("Press any key to test the WAV file and ESC to exit.\n");
        while (getch() != 27)
            MODPlaySample(4,Ding);
        MODFreeSample(Ding);
    }
    else {
        printf("Error loading WAV file. Press any key to exit.\n");
        getch();
    }
}

void main(void)
{
    Module *Song;
    word Port;
    byte IRQ,DRQ;

    if (MODDetectCard(&Port,&IRQ,&DRQ)) {
        printf("Sound Blaster not found.\n");
        return;
    }
    printf("Sound Blaster found at Addr:%03x IRQ:%d DMA:%d\n",Port,IRQ,DRQ);
    if ((Song = MODLoadModule("TEST.MOD")) != NULL) {
        if (MODPlayModule(Song,5,22222,Port,IRQ,DRQ))
            printf("Error initializing the sound system.\n");
        else {
            printf("Playing music...\n");
            FadeInMusic();
            TestSample();
            FadeOutMusic();
            MODStopModule();
        }
        MODFreeModule(Song);
    }
    else {
        printf("Error loading modulefile.\n");
    }
    return;
}

