%
% "least_sq.t" solves for least square error
% coefficients in:
%
%       y = a + b x + c x^2
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

const DIM : int := 3

program

    var n : int
    var x, y , det: real
    var v, w : rmatrix
    var a, b : rvector
    label program_exit :

    prompt "how many data points?"
    get n

    put "           x           y"
    loop

        exit when n <= 0

        prompt "x?"
        get x
        prompt "y?"
        get y

        put x:12:6, y:12:6

        w[0,0] := w[0,0] + 1.0
        w[0,1] := w[0,1] + x
        w[0,2] := w[0,2] + x * x

        w[1,0] := w[1,0] + x
        w[1,1] := w[1,1] + x * x
        w[1,2] := w[1,2] + x * x * x

        w[2,0] := w[2,0] + x * x
        w[2,1] := w[2,1] + x * x * x
        w[2,2] := w[2,2] + x * x * x * x

        b[0] := b[0] + y
        b[1] := b[1] + x * y
        b[2] := b[2] + x * x * y
    
        decr n

    end loop

    det := invert( w, v, true )

    if det = 0.0 then

        put "singular!"
        goto program_exit

    end if

    mul_mat_vec( v, b, a )

    put "\ncoefficients:"
    put "a = ", a[0]:12:8
    put "b = ", a[1]:12:8
    put "c = ", a[2]:12:8

    program_exit:

end program