%
% "easter.t" computes the date of Easter
%
% Adapted from a BASIC program which appeared in 
% Astronomical Computing, Sky & Telescope, March, 1986
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

program

    var year : int
    var ans : string
    label another :

    another :
    
    loop

        prompt "Year?"
        get year
        exit when year >= 1583

    end loop

    easter_day( year )

    prompt "Another? Y or N "
    get ans

    if ans[0] = 'Y' or ans[0] = 'y' then
        goto another
    end if

end program

%
% compute the date of easter for a year after 1582
%
procedure easter_day( y : int )

    var a, b, c, d, e, f, g, h, i, j, k, m, n, p : int
    var temp : real
    var mon : string

    temp := y / 19
    a := floor( ( temp - floor( temp ) ) * 19 + 0.001 )

    temp := y / 100
    b := floor( temp )
    c := floor( ( temp - floor( temp ) ) * 100 + 0.001 )

    temp := b / 4
    d := floor( temp )
    e := floor( ( temp - floor( temp ) ) *4 + 0.001 )
    f := floor( ( ( b + 8 ) / 25 ) + 0.001 )
    g := floor( ( b - f + 1 ) / 3 )

    temp := ( 19 * a + b - d - g + 15 ) / 30
    h := floor( ( temp - floor( temp ) ) * 30 + 0.001 )

    temp := c / 4
    i := floor( temp )
    j := floor( ( temp - i ) * 4 + 0.001 )

    temp := ( 32 + 2 * e + 2 * i - h - j ) / 7
    k := floor( ( temp - floor( temp ) ) * 7 + 0.001 )
    m := floor( ( a + 11 * h + 22 * k ) / 451 )

    temp := ( h + k - 7 * m + 114 ) / 31
    n := floor( temp )
    p := floor( ( temp - n ) * 31 + 0.001 )

    mon := "April "
    if n = 3 then
        mon := "March "
    end if

    put "In ", y, " Easter is on: ", mon, p + 1

end procedure