%
% complex.t contains complex arithmetic functions
% for use in programs; to use add this file name
% to the list of project files in your "*.prt" file
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

type complex : record

               re : real
               im : real

               end record

%
% complex assignment
%
procedure cmov( var dest, srce : complex )

    dest.re := srce.re
    dest.im := srce.im

end procedure   

%
% complex addition
%
procedure cadd( var dest, srce : complex )

    dest.re := dest.re + srce.re
    dest.im := dest.im + srce.im

end procedure

%
% complex subtraction
%
procedure csub( var dest, srce : complex )

    dest.re := dest.re - srce.re
    dest.im := dest.im - srce.im

end procedure

%
% complex multiplication
%
procedure cmul( var dest, srce : complex )

    var temp : complex
    
    temp.re := dest.re * srce.re - dest.im * srce.im
    temp.im := dest.im * srce.re + dest.re * srce.im
    dest.re := temp.re
    dest.im := temp.im

end procedure

%
% complex division
%
procedure cdiv( var dest, srce : complex )

    var d : real
    var temp : complex

    d := srce.re * srce.re + srce.im * srce.im
    temp.re := ( dest.re * srce.re + srce.im * dest.im ) / d
    temp.im := ( dest.im * srce.re - dest.re * srce.im ) / d
    dest.re := temp.re
    dest.im := temp.im

end procedure

%
% complex absolute magnitude
%
function cabs( var a : complex ) : real

    var rv : real

    rv := sqrt( a.re * a.re + a.im * a.im )

    return rv

end function

%
% convert cartesian coordinates to angle
%
function argmt( y, x : real ) : real

    var rv : real
    
    rv := arctanxy( x, y )

    if rv < 0.0 then

        rv := rv + 2 * arcsin( 1 )

    end if

    return rv

end function

%
% complex square root
%
procedure csqrt( var z, ans : complex )

    var x, y, r, a : real

    r := sqrt( sqrt( z.re * z.re + z.im * z.im ) )
    a := 0.5 * argmt( z.im, z.re )

    ans.re := r * cos( a )
    ans.im := r * sin( a )               

end procedure

%
% convert complex number to a string
%
function cstr( var c : complex ) : string

    var s : string
    var re, im : real

    re := c.re
    im := c.im

    if im >= 0.0 then
        s := frealstr(re,14,9 ) & " +" & frealstr(im,12,9 ) & "j"
    else
        im := -im
        s := frealstr(re,14,9 ) & " -" & frealstr(im,12,9 ) & "j"
    end if

    return s

end function