***************************************************************************

; inspired from 'TolleUhr' by Matthias Fleischer - translated to assembler
; (gcc is good - i am better !)

; uhr v0.1 - 24/02/94 by Gunther Nikl - project started
; uhr v1.2 - 07/03/94 by Gunther Nikl - newlooskmenus, localized, bugfixed

***************************************************************************

; include stuff

		include	lvo30/dos_lib.i
		include	lvo30/exec_lib.i
		include	lvo30/icon_lib.i
		include	lvo30/locale_lib.i
		include	lvo30/gadtools_lib.i
		include	lvo30/graphics_lib.i
		include	lvo30/intuition_lib.i
		include	support/defs.i

; specific define(s)

_LVOBeginIO	equ	-30			; for audio

; macro stuff

MITEM		macro
		IFEQ	NARG-5
ItemCount	set	\5
		ENDC
		dc.b	\1,\2,\3,\4
ItemCount	set	ItemCount+1
		endm

WINIT		macro				; idcmp,wintitle,gadgetanz
		dc.w	\1
		dc.b	\2,\3
		endm

GITEM		macro				; left,top,width,height,gtext,kind
		dc.b	\1,\2,\3,\4,\5,\6
		endm

ADDCMD		macro				; Table,Function,[Number]
		IFEQ	NARG-3
\1Num		set	\3
		ENDC
		dc.w	\1\2-\1Tab
\1Num		set	\1Num+1
		endm

ADDLOC		macro
		IFEQ	NARG-2
LocCount	set	\2
		ENDC
		dc.w	m_\1-LocaleTab
\1		equ	LocCount
LocCount	set	\1+1
		endm

; global stuff

	STRUCT Globals
	  ULONG	SysBase,0
	  ULONG	WbMsg
	  ULONG	DosBase
	  ULONG	IconBase
	  ULONG	IntBase
	  ULONG	GfxBase
	  ULONG	GadsBase
	  ULONG	LocBase
	  ULONG	Catalog
	  ULONG	OurTask

	  ULONG	TimerPort
	  ULONG	TimerIO
	  ULONG	AudioPort
	  ULONG	AudioIO,2
	  ULONG	WaveForm

	  ULONG	VisualInfo
	  ULONG	Menus
	  ULONG	WinPtr
	  ULONG	RPort1

	  ULONG	ColWin,2
	  ULONG	AlmWin,2
	  ULONG	AboutReq

	  ULONG	Links
	  ULONG	Oben
	  ULONG	Breite
	  ULONG	Hoehe
	  ULONG	BoLeft
	  ULONG	BoTop
	  ULONG	Breit2
	  ULONG	Hoehe2
	  ULONG	ReDrawx1
	  ULONG	ReDrawy1
	  ULONG	ReDrawx2
	  ULONG	ReDrawy2
	  ULONG	xMask
	  ULONG	yMask
	  ULONG	Buf
	  ULONG	imClass
	  ULONG	imCode
	  ULONG	PlayTune
	  ULONG	WbArg
	  ULONG	oldPri
	  ULONG	color

	  UWORD	std
	  UWORD	min
	  UWORD	sec
	  UWORD	alstd
	  UWORD	almin
	  UWORD	st
	  UWORD	mi
	  UWORD	xOffset
	  UWORD	yOffset
	  UWORD	GadSize

	  UBYTE	EndAll
	  UBYTE	Active
	  UBYTE	TimerOpen
	  UBYTE	TimerSent
	  UBYTE	AudioOpen
	  UBYTE	AudioSent,2
	  UBYTE	SoundOn
	  UBYTE	sekunden
	  UBYTE	oval
	  UBYTE	schatten
	  UBYTE	hires
	  UBYTE	interlace
	  UBYTE	smarthour
	  UBYTE	zeigen
	  UBYTE	zeigertyp
	  UBYTE	zeigerbreite
	  UBYTE	rahmenanz
	  UBYTE	chime
	  UBYTE	xDouble
	  UBYTE	yDouble
	  UBYTE	alarm
	  UBYTE	reqnr
	  UBYTE	filter
	  UBYTE	closegad

	  UBYTE	pad,3

	  UBYTE	TextAttr,8
	  UBYTE	Pens,16
	  UBYTE	Must,4
	  UBYTE	NewWinBuf,48
	  UBYTE	GadgetBuf,44*4
	  UBYTE	MenuBuf,63*20
	  UBYTE	RPort2,100
	  UBYTE	BitMap1,40
	  UBYTE	TempRas,8
	  UBYTE	AreaInf,24
	  UBYTE	Table,28
	  UBYTE	Muster,32
	  UBYTE	NewGad,32
	  UBYTE	EasyBuf,20
	  UBYTE	Ergebnis,20*4
	LABEL gb_SIZEOF

PubScreen	equ	NewWinBuf+30

bp		equr	a4			; the base register

***************************************************************************

		SECTION start,CODE

start		link	bp,#gb_SIZEOF		; make room on the stack
		move.w	#(~gb_SIZEOF>>2),d1
		move.l	bp,a1
1$		clr.l	-(a1)			; clear local var area
		dbra	d1,1$
		move.l	4,a6
		move.l	a6,SysBase(bp)		; cache SysBase
		suba.l	a1,a1
		RECALL	FindTask		; use system function ..
		move.l	d0,a2
		move.l	a2,OurTask(bp)		; cache task ptr
		tst.l	172(a2)
		bne.s	fromCLI
fromWB		lea	92(a2),a0		; get wbmsg
		RECALL	WaitPort
		lea	92(a2),a0
		RECALL	GetMsg
		move.l	d0,WbMsg(bp)
fromCLI		bsr	main			; call main
		move.l	WbMsg(bp),d2
		beq.s	1$
		RECALL	Forbid
		move.l	d2,a1
		RECALL	ReplyMsg		; reply wbsmg
1$		moveq	#0,d0
		unlk	bp
		rts

***************************************************************************

OpenMainWin	lea	NewWinBuf(bp),a0	; init & open main window
		move.w	Links+2(bp),d0
		swap	d0
		move.w	Oben+2(bp),d0
		move.w	Breite+2(bp),d1
		swap	d1
		move.w	Hoehe+2(bp),d1
		movem.l	d0/d1,0(a0)		; size
		move.b	#1,9(a0)
		move.l	#$c0306,10(a0)		; idcmp
		move.l	#$200840,14(a0)		; flags
		lea	GadgetBuf(bp),a1
		move.l	a1,18(a0)		; gadgets
		move.l	#10<<16+10,38(a0)
		moveq	#-1,d0
		move.l	d0,42(a0)
		move.w	#15,46(a0)		; type
		CALL	OpenWindow,IntBase(bp)
		move.l	d0,WinPtr(bp)
		beq.s	1$			; no window !
		move.l	d0,a0
		move.l	50(a0),RPort1(bp)
		suba.l	a1,a1
		lea	ProgName(pc),a2
		RECALL	SetWindowTitles		; set new screen title
		move.l	WinPtr(bp),a0
		move.l	Menus(bp),a1
		RECALL	SetMenuStrip		; attach menus
		moveq	#0,d0
		move.b	Pens+0(bp),d0
		move.l	RPort1(bp),a1
		CALL	SetAPen,GfxBase(bp)
		bsr	NewSize2		; update gfx stuff
		beq.s	1$
		bsr	NextTick
		bsr	Rahmen
		bsr	ZifferBlatt
		bsr	Zeichnen
1$		rts

***************************************************************************

InitClock	bsr	SetPattern		; set new pattern
		lea	TextAttr(bp),a0		; init font struct
		lea	TopazName(pc),a1
		move.l	a1,(a0)+
		move.l	#$80001,(a0)
		lea	GadgetBuf(bp),a1	; init gfx stuff
		lea	GadgetList(pc),a0
		moveq	#1,d0
		moveq	#3,d1
12$		move.w	d0,8(a1)		; width
		move.w	d0,10(a1)		; height
		move.b	(a0)+,13(a1)		; flags
		move.b	d0,15(a1)		; activation
		move.b	(a0)+,17(a1)		; type
		lea	44(a1),a1
		move.l	a1,-44(a1)
		dbra	d1,12$
		clr.l	-44(a1)			; clear last ptr
		lea	MenuList(pc),a2
		lea	MenuBuf(bp),a3
		moveq	#ItemCount-1,d2
11$		move.b	(a2)+,0(a3)		; type
		move.b	(a2)+,d0
		ext.w	d0
		ext.l	d0
		bmi.s	10$
		bsr	GetLocStr		; get localized string
10$		move.l	d0,2(a3)
		move.b	(a2)+,11(a3)		; flags
		moveq	#0,d0
		move.b	(a2)+,d0		; mutual exclude
		bpl.s	9$
		andi.w	#$7f,d0
		lsl.w	#5,d0
9$		move.l	d0,12(a3)
		lea	20(a3),a3		; next menu
		dbra	d2,11$
		moveq	#AboutKey,d0		; command keys for project menu
		bsr	GetLocStr
		move.l	d0,MenuBuf+1*20+6(bp)
		moveq	#SaveKey,d0
		bsr	GetLocStr
		move.l	d0,MenuBuf+2*20+6(bp)
		moveq	#QuitKey,d0
		bsr	GetLocStr
		move.l	d0,MenuBuf+3*20+6(bp)
		move.l	PubScreen(bp),a0
		suba.l	a1,a1
		CALL	GetVisualInfoA,GadsBase(bp)
		move.l	d0,VisualInfo(bp)
		beq	1$
		moveq	#20,d2
		move.w	#$100,d0		; prepare menus
		lea	MenuBuf(bp),a0
		tst.b	sekunden(bp)
		beq.s	8$			; no secs !
		or.w	d0,5*20+10(a0)
8$		tst.b	oval(bp)
		beq.s	7$			; no oval !
		or.w	d0,6*20+10(a0)
7$		moveq	#8,d1
		add.b	zeigen(bp),d1		; what to show
		mulu	d2,d1
		or.w	d0,10(a0,d1.w)
		moveq	#14,d1
		add.b	zeigertyp(bp),d1	; handtype
		mulu	d2,d1
		or.w	d0,10(a0,d1.w)
		moveq	#19,d1
		add.b	zeigerbreite(bp),d1	; handwidth
		mulu	d2,d1
		or.w	d0,10(a0,d1.w)
		tst.b	schatten(bp)
		beq.s	6$			; no shadow
		or.w	d0,24*20+10(a0)
6$		moveq	#26,d1
		add.b	rahmenanz(bp),d1	; bordercnt
		mulu	d2,d1
		or.w	d0,10(a0,d1.w)
		tst.b	hires(bp)
		beq.s	5$
		or.w	d0,30*20+10(a0)
5$		tst.b	interlace(bp)
		beq.s	4$
		or.w	d0,31*20+10(a0)
4$		moveq	#33,d1
		add.b	chime(bp),d1
		mulu	d2,d1
		or.w	d0,10(a0,d1.w)
		tst.b	smarthour(bp)
		beq.s	3$
		or.w	d0,37*20+10(a0)
3$		tst.b	closegad(bp)
		beq.s	2$
		or.w	d0,41*20+10(a0)
2$		suba.l	a1,a1
		RECALL	CreateMenusA
		move.l	d0,Menus(bp)
		beq.s	1$			; no menus !
		move.l	d0,a0
		move.l	VisualInfo(bp),a1
		lea	MenuTag(pc),a2
		RECALL	LayoutMenusA
		tst.l	d0
		beq.s	1$			; error !
		bsr	OpenMainWin
1$		rts

***************************************************************************

OpenDevs	CALL	CreateMsgPort,SysBase(bp)	; init device stuff
		move.l	d0,TimerPort(bp)
		beq.s	1$
		move.l	d0,a0
		moveq	#40,d0
		RECALL	CreateIORequest
		move.l	d0,TimerIO(bp)
		beq.s	1$
		move.l	d0,a1
		lea	TimerName(pc),a0
		moveq	#1,d0			; UNIT_VBLANK
		moveq	#0,d1
		RECALL	OpenDevice
		tst.l	d0
		bne.s	2$			; no timer.device !
		st	TimerOpen(bp)
		RECALL	CreateMsgPort
		move.l	d0,AudioPort(bp)
		beq.s	1$
		move.l	d0,a0
		moveq	#68,d0
		RECALL	CreateIORequest
		move.l	d0,AudioIO+4(bp)
		beq.s	1$
		moveq	#68,d0
		move.l	AudioPort(bp),a0
		RECALL	CreateIORequest
		move.l	d0,AudioIO+0(bp)
		beq.s	1$
		move.l	d0,a1
		lea	AudioName(pc),a0
		moveq	#0,d0
		moveq	#0,d1
		RECALL	OpenDevice
		tst.l	d0
		bne.s	2$			; no audio.device !
		st	AudioOpen(bp)
		moveq	#8,d0
		move.l	#$10003,d1
		RECALL	AllocVec
		move.l	d0,WaveForm(bp)
		beq.s	1$
		move.l	d0,a0
		move.l	#$7f807f80,0(a0)	; rectangle
1$		rts
2$		moveq	#0,d0
		bra.s	1$

***************************************************************************

ParseArgs	move.l	WbMsg(bp),d0		; check for cli or wb
		suba.l	a0,a0
		beq	ParseCLI

MergeToolTypes	movem.l	d2-d6/a2/a3,-(sp)
		moveq	#0,d4
		lea	linefeed(pc),a2		; default string
		moveq	#1,d2
		move.l	d0,a3
		move.l	28(a3),d3
		move.l	36(a3),a3
		subq.w	#1,d3
		bcs	2$			; what's this !?
		beq.s	9$			; sm_NumArgs == 1 !
		addq.w	#8,a3
9$		move.l	a3,WbArg(bp)		; store for later use
		move.l	0(a3),d1
		CALL	CurrentDir,DosBase(bp)
		move.l	d0,d3			; save old dir
		move.l	4(a3),a0
		CALL	GetDiskObjectNew,IconBase(bp)
		move.l	d0,d6
		move.l	d3,d1			; return to olddir
		CALL	CurrentDir,DosBase(bp)
		tst.l	d6
		beq.s	2$			; no icon ?!
		move.l	d6,a0
		move.l	54(a0),a0		; calc needed buffer length
		moveq	#0,d5
8$		move.l	(a0)+,d1
		beq.s	6$			; table end
		move.l	d1,a1
7$		tst.b	(a1)+
		bne.s	7$
		sub.l	d1,a1
		add.l	a1,d5
		bra.s	8$
6$		move.l	d5,d0			; adjust to multiple of eight
		addq.l	#7,d0
		andi.w	#-8,d0
		moveq	#0,d1
		CALL	AllocVec,SysBase(bp)
		move.l	d0,d4
		beq.s	2$			; no buffer
		move.l	d6,a2
		move.l	54(a2),a2
		move.l	d4,a1
5$		move.l	(a2)+,d0
		beq.s	3$			; table end
		move.l	d0,a0
4$		move.b	(a0)+,(a1)+		; build argument string
		bne.s	4$
		move.b	#' ',-1(a1)
		bra.s	5$
3$		move.b	#10,-(a1)		; terminate string
		move.l	d6,a0
		CALL	FreeDiskObject,IconBase(bp)
		move.l	d4,a2
		move.l	d5,d2
2$		move.l	d2,d0
		move.l	a2,a0
		bsr.s	ParseCLI		; parse string
		move.l	d0,d2
		move.l	d4,d0
		beq.s	1$			; have we a vector ?
		move.l	d0,a1
		CALL	FreeVec,SysBase(bp)	; free arg string
1$		move.l	d2,d0
		movem.l	(sp)+,d2-d6/a2/a3
		rts

ParseCLI	movem.l	d2-d4/a2/a3,-(sp)
		move.l	a0,a2			; save args
		move.l	d0,a3
		moveq	#5,d1
		moveq	#0,d2
		CALL	AllocDosObject,DosBase(bp)
		move.l	d0,d3
		beq.s	7$
		move.l	d0,a0
		movem.l	a2/a3,0(a0)		; CS_Source,CS_Length
		lea	template(pc),a1
		move.l	a1,d1
		lea	Ergebnis(bp),a1
		move.l	a1,d2
		tst.l	0(a0)
		bne.s	8$			; is WB
		addq.l	#3,d1
		addq.l	#4,d2
8$		RECALL	ReadArgs
7$		move.l	d0,d4
		lea	Ergebnis+4(bp),a2
		moveq	#50,d0			; erg[0]
		moveq	#0,d1
		bsr	GetLong
		move.l	d0,Oben(bp)
		moveq	#50,d0			; erg[1]
		moveq	#0,d1
		bsr	GetLong
		move.l	d0,Links(bp)
		moveq	#108,d0			; erg[2]
		moveq	#10,d1
		bsr	GetLong
		move.l	d0,Breite(bp)
		moveq	#54,d0			; erg[3]
		moveq	#10,d1
		bsr	GetLong
		move.l	d0,Hoehe(bp)
		move.l	(a2)+,d0		; erg[4]
		move.b	d0,sekunden(bp)
		lea	Must(bp),a1		; erg[5]
		move.l	a1,a0
		moveq	#4-1,d0
		bsr	ReadStr
		move.l	(a2)+,d0		; erg[6]
		move.b	d0,oval(bp)
		move.l	(a2)+,d0		; erg[7]
		move.b	d0,schatten(bp)
		moveq	#1,d0
		moveq	#4,d1
		bsr	GetByte			; erg[8]
		move.b	d0,zeigen(bp)
		moveq	#2,d0
		moveq	#3,d1
		bsr	GetByte			; erg[9]
		move.b	d0,zeigertyp(bp)
		moveq	#2,d0
		moveq	#4,d1
		bsr	GetByte			; erg[10]
		move.b	d0,zeigerbreite(bp)
		lea	Pens(bp),a1
		lea	pens(pc),a0
		moveq	#14-1,d0
		bsr	ReadStr			; erg[11]
		moveq	#3,d0
		moveq	#5,d1
		bsr	GetByte			; erg[12]
		cmpi.b	#3,d0
		bcs.s	6$
		moveq	#1,d1
		and.b	d0,d1
		move.b	d1,hires(bp)
		subq.b	#4,d0
		scc	interlace(bp)
		moveq	#2,d0
6$		move.b	d0,rahmenanz(bp)
		moveq	#0,d0
		moveq	#4,d1
		bsr	GetByte			; erg[13]
		cmpi.b	#3,d0
		bcs.s	5$
		st	smarthour(bp)
		subq.b	#2,d0
5$		move.b	d0,chime(bp)
		move.l	(a2)+,d0		; erg[14]
		move.b	d0,closegad(bp)
		move.l	IntBase(bp),a6
		move.l	(a2)+,d0		; erg[15]
		beq.s	4$
		move.l	d0,a0
		RECALL	LockPubScreen
		tst.l	d0			; ok ?
		bne.s	3$
4$		move.l	d0,a0			; lock default pub screen
		RECALL	LockPubScreen
3$		move.l	d0,PubScreen(bp)
		moveq	#5,d0
		moveq	#20,d1
		bsr	GetByte			; erg[16]
		move.l	OurTask(bp),a1
		CALL	SetTaskPri,SysBase(bp)
		move.l	d0,oldPri(bp)		; save old pri
		move.l	DosBase(bp),a6
		move.l	d4,d1
		beq.s	2$
		RECALL	FreeArgs
2$		move.l	d3,d2
		beq.s	1$
		moveq	#5,d1
		RECALL	FreeDosObject
1$		move.l	PubScreen(bp),d0	; can we continue ?
		movem.l	(sp)+,d2-d4/a2/a3
		rts

GetLong		bsr.s	GetVal
		beq.s	1$
		cmp.l	d1,d2
		bcs.s	1$
		move.l	d2,d0
1$		rts

GetByte		bsr.s	GetVal
		beq.s	1$
		cmp.l	d2,d1
		bcs.s	1$
		move.l	d2,d0
1$		rts

GetVal		move.l	(a2)+,d2
		beq.s	1$
		move.l	d2,a0
		move.l	0(a0),d2
		cmp.l	a2,d2			; for flags !
1$		rts

ReadStr		move.w	d0,d1
5$		move.b	0(a0,d0.w),0(a1,d0.w)	; copy defaults
		dbra	d0,5$
		move.l	(a2)+,d0
		beq.s	1$			; no argument !
		move.l	d0,a0
		move.b	(a0)+,d0		; if (*sorc='$'||toupper(*sorc)='X'||..)
		cmpi.b	#'$',d0
		beq.s	4$
		andi.b	#$5f,d0
		cmpi.b	#'X',d0
		beq.s	4$
		move.b	-1(a0),d0
		lsl.w	#8,d0
		move.b	(a0)+,d0
		andi.w	#$ff5f,d0
		cmpi.w	#'0X',d0
		bne.s	3$
4$		move.b	(a0)+,d0		; while (*sorc++ && *sorc++ && n--)
		beq.s	1$
		tst.b	(a0)
		beq.s	1$
		bsr.s	xtod
		lsl.b	#4,d0
		move.b	d0,(a1)
		move.b	(a0)+,d0
		bsr.s	xtod
		or.b	d0,(a1)+		; *dest++=xtod(sorc[-1])<<4+xtdo(*sorc);
		dbra	d1,4$
		bra.s	1$
3$		subq.w	#2,a0			; else {
2$		move.b	(a0)+,d0		;   while (*sorc++ && n--)
		beq.s	1$
		bsr.s	xtod
		move.b	d0,(a1)+		;     *dest++=xtod(*sorc);
		dbra	d1,2$			; }
1$		rts

xtod		subi.b	#'0',d0			; if (a >='0' && a<='9')
		bcs.s	2$			;   return (a-'0');
		cmpi.b	#10,d0
		bcs.s	1$
		cmpi.b	#'a'-'0',d0		; if (a >='a' && a<='f')
		bcs.s	3$			;   return (a-'a'+10);
		subi.b	#32,d0
3$		subq.b	#7,d0			; if (a >='A' && a<='F');
		cmpi.b	#10,d0			;   return (a-'A'+10);
		bcs.s	2$
		cmpi.b	#16,d0
		bcs.s	1$
2$		moveq	#0,d0			; return(0);
1$		rts

***************************************************************************

OpenLibs	move.l	SysBase(bp),a6		; open all libs
		lea	DosName(pc),a1
		bsr.s	OpenLib
		move.l	d0,DosBase(bp)
		beq.s	1$			; no dos v37+ !
		lea	IconName(pc),a1
		bsr.s	OpenLib
		move.l	d0,IconBase(bp)
		beq.s	1$			; no icon v37+ !
		lea	IntName(pc),a1
		bsr.s	OpenLib
		move.l	d0,IntBase(bp)
		beq.s	1$			; no intuition v37+ !
		lea	GfxName(pc),a1
		bsr.s	OpenLib
		move.l	d0,GfxBase(bp)
		beq.s	1$			; no graphics v37+ !
		lea	GadsName(pc),a1
		bsr.s	OpenLib
		move.l	d0,GadsBase(bp)
		beq.s	1$			; no gadtools v37+ !
		lea	LocName(pc),a1
		moveq	#38,d0
		RECALL	OpenLibrary
		move.l	d0,LocBase(bp)
		beq.s	2$			; no locale v38+ !
		suba.l	a0,a0
		lea	LocCat(pc),a1		; our catalog 
		suba.l	a2,a2
		CALL	OpenCatalogA,d0
		move.l	d0,Catalog(bp)
2$		moveq	#1,d0			; all ok  
1$		rts

OpenLib		moveq	#37,d0			; open lib v37+
		jmp	_LVOOpenLibrary(a6)

***************************************************************************

main		movem.l	d2-d7/a2-a6,-(sp)	; main program
		bsr	OpenLibs
		beq	1$
		bsr	OpenDevs
		beq	1$
		bsr	ParseArgs
		beq	1$
		bsr	InitClock
		beq	1$
9$		moveq	#0,d1			; while ( !CTRL_C && !EndAll) {
		moveq	#$40,d0
		lsl.w	#6,d0			; CTRL_C
		move.l	TimerPort(bp),a1
		move.b	15(a1),d1
		bset	d1,d0
		move.l	AudioPort(bp),a1
		move.b	15(a1),d1
		bset	d1,d0
		move.l	WinPtr(bp),a1
		move.l	86(a1),a1
		move.b	15(a1),d1
		bset	d1,d0
		move.l	AboutReq(bp),d1
		beq.s	7$			; no about requester
		move.l	d1,a1
		move.l	86(a1),a1
		move.b	15(a1),d1
		bset	d1,d0
7$		move.l	ColWin(bp),d1
		beq.s	6$			; no color window
		move.l	d1,a1
		move.l	86(a1),a1
		move.b	15(a1),d1
		bset	d1,d0
6$		move.l	AlmWin(bp),d1
		beq.s	5$			; no alarm window
		move.l	d1,a1
		move.l	86(a1),a1
		move.b	15(a1),d1
		bset	d1,d0
5$		CALL	Wait,SysBase(bp)
		btst	#12,d0			; CTRL_C ?
		bne.s	1$
		move.l	TimerPort(bp),a0	; if (GetMsg(TimerPort))
		RECALL	GetMsg
		tst.l	d0
		beq.s	3$
		bsr	NextTick		; if (NextTick())
		beq.s	4$
		bsr	ZifferBlatt
		bsr	TestAlarm
4$		bsr	Zeichnen
3$		move.l	AudioPort(bp),a0	; if (GetMsg(AudioPort))
		RECALL	GetMsg
		tst.l	d0
		beq.s	2$
		bsr	PlayNote
2$		bsr	CheckAboutReq
		bsr	CheckAlmWin
		bsr	CheckColWin
		bsr	CheckMainWin
		beq	9$			; }
1$		bsr	CloseGfx
		bsr	CloseDevs
		bsr	CloseLibs
		movem.l	(sp)+,d2-d7/a2-a6	; exit main 
		rts

***************************************************************************

CloseLibs	move.l	Catalog(bp),d0		; close catalog
		beq.s	3$
		move.l	d0,a0
		CALL	CloseCatalog,LocBase(bp)
3$		move.l	SysBase(bp),a6		; close all libs
		move.l	LocBase(bp),a1
		bsr.s	2$
		move.l	GadsBase(bp),a1
		bsr.s	2$
		move.l	GfxBase(bp),a1
		bsr.s	2$
		move.l	IntBase(bp),a1
		bsr.s	2$
		move.l	IconBase(bp),a1
		bsr.s	2$
		move.l	DosBase(bp),a1
2$		move.l	a1,d0
		beq.s	1$
		RECALL	CloseLibrary
1$		rts

***************************************************************************

CloseDevs	move.l	SysBase(bp),a6		; free device stuff
		move.l	OurTask(bp),a1
		move.l	oldPri(bp),d0
		RECALL	SetTaskPri		; restore old pri
		tst.b	AudioOpen(bp)		; free audio stuff
		beq.s	4$
		move.l	AudioIO+4(bp),a2
		tst.b	AudioSent+1(bp)
		beq.s	7$			; io not active
		bsr.s	StopIO
7$		move.l	AudioIO+0(bp),a2
		tst.b	AudioSent+0(bp)
		beq.s	6$			; io not active
		bsr.s	StopIO
6$		tst.b	SoundOn(bp)
		beq.s	5$			; no channels allocated
		bsr	EndTune
5$		bsr.s	CloseDev
4$		move.l	AudioIO+4(bp),a0	; delete io's && port
		bsr.s	DeleteIO
		move.l	AudioIO+0(bp),a0
		bsr.s	DeleteIO
		move.l	AudioPort(bp),a0
		bsr.s	DeletePort
		move.l	WaveForm(bp),d0
		beq.s	3$			; no wave mem
		move.l	d0,a1
		RECALL	FreeVec
3$		tst.b	TimerOpen(bp)		; free timer stuff
		beq.s	1$
		move.l	TimerIO(bp),a2
		tst.b	TimerSent(bp)
		beq.s	2$			; io not active
		bsr.s	StopIO
2$		bsr.s	CloseDev
1$		move.l	TimerIO(bp),a0		; delete io && port
		bsr.s	DeleteIO
		move.l	TimerPort(bp),a0
		bsr.s	DeletePort
		rts

;--------------------------------------------------------------------------

StopIO		move.l	a2,a1			; end active io
		RECALL	AbortIO
		move.l	a2,a1
		jmp	_LVOWaitIO(a6)

;--------------------------------------------------------------------------

CloseDev	move.l	a2,a1			; close device
		jmp	_LVOCloseDevice(a6)

;--------------------------------------------------------------------------

DeleteIO	move.l	a0,d0
		beq.s	1$			; no ioreq
		RECALL	DeleteIORequest
1$		rts

;--------------------------------------------------------------------------

DeletePort	move.l	a0,d0
		beq.s	1$			; no port
		RECALL	DeleteMsgPort
1$		rts

***************************************************************************

NewSize1	movem.l	d2/a2/a6,-(sp)		; free gfx stuff 2
		move.l	GfxBase(bp),a6
		move.l	Buf(bp),d0
		beq.s	4$
		move.l	d0,a0
		move.l	Breit2(bp),d0
		move.l	Hoehe2(bp),d1
		RECALL	FreeRaster		; free buffer
		clr.l	Buf(bp)
4$		lea	BitMap1+8(bp),a2
		move.b	BitMap1+5(bp),d2
		beq.s	1$
3$		move.l	0(a2),d0
		beq.s	2$			; nothing !
		move.l	d0,a0
		move.l	Breit2(bp),d0
		move.l	Hoehe2(bp),d1
		RECALL	FreeRaster		; free bitplane
2$		clr.l	(a2)+
		subq.b	#1,d2
		bne.s	3$			; not ready
1$		movem.l	(sp)+,d2/a2/a6
		rts

;--------------------------------------------------------------------------

CloseAboutReq	move.l	AboutReq(bp),d0
		beq.s	1$
		move.l	d0,a0
		CALL	FreeSysRequest,IntBase(bp)
		clr.l	AboutReq(bp)
1$		rts

;--------------------------------------------------------------------------

CloseGfx	bsr.s	NewSize1		; free gfx stuff
		bsr.s	CloseAboutReq
		bsr.s	CloseAlmWin
		bsr.s	CloseColWin
		move.l	IntBase(bp),a6
		move.l	WinPtr(bp),d0
		beq.s	4$
		move.l	d0,a0
		move.l	a0,-(sp)
		CALL	ClearMenuStrip,IntBase(bp)
		move.l	(sp)+,a0
		RECALL	CloseWindow
4$		move.l	GadsBase(bp),a6
		move.l	Menus(bp),d0
		beq.s	3$
		move.l	d0,a0
		RECALL	FreeMenus
3$		move.l	VisualInfo(bp),d0
		beq.s	2$
		move.l	d0,a0
		RECALL	FreeVisualInfo
2$		move.l	PubScreen(bp),d0
		beq.s	1$
		suba.l	a0,a0
		move.l	d0,a1
		CALL	UnlockPubScreen,IntBase(bp)
1$		rts

;--------------------------------------------------------------------------

CloseAlmWin	lea	AlmWin(bp),a2		; discard alarm window
		bra.s	CloseWinGT

CloseColWin	lea	ColWin(bp),a2		; discard color window

CloseWinGT	move.l	0(a2),d0
		beq.s	1$
		move.l	0(a2),a0
		CALL	CloseWindow,IntBase(bp)
		clr.l	(a2)+			; clear pointer !
		move.l	0(a2),a0
		CALL	FreeGadgets,GadsBase(bp)
1$		rts

***************************************************************************

CheckAboutReq	move.l	a6,-(sp)
		move.l	AboutReq(bp),d0
		beq.s	1$
		move.l	d0,a0
		move.l	86(a0),a0
		CALL	GT_GetIMsg,GadsBase(bp)
		move.l	d0,a1
		move.l	a1,d0
		beq.s	1$
		RECALL	GT_ReplyIMsg
		bsr	CloseAboutReq
1$		move.l	(sp)+,a6
		rts

***************************************************************************

CheckAlmWin	movem.l	d2/d3/a2/a3/a6,-(sp)
		move.l	AlmWin(bp),d2
		beq	1$
		move.l	d2,a2
9$		move.l	86(a2),a0
		CALL	GT_GetIMsg,GadsBase(bp)
		move.l	d0,a1
		move.l	a1,d0
		beq	1$
		move.l	20(a1),d2		; imCode
		move.w	24(a1),d3		; imClass
		move.l	28(a1),a3		; IAdress
		RECALL	GT_ReplyIMsg
		moveq	#($200>>3),d0		; CLOSEWINDOW
		lsl.w	#3,d0
		cmp.l	d0,d2
		beq.s	2$
		moveq	#$40,d0			; GADGETUP
		cmp.l	d0,d2
		beq.s	8$
		moveq	#$10,d0			; MOUSEMOVE
		bne.s	9$
8$		move.w	38(a3),d0
		subq.w	#1,d0			; hour slider ?
		bne.s	7$
		move.w	d3,st(bp)
		bra.s	9$
7$		subq.w	#1,d0			; minute SLIDER ?
		bne.s	6$
		move.w	d3,mi(bp)
		bra.s	9$
6$		subq.w	#1,d0			; USE ?
		bne.s	5$
		move.w	st(bp),alstd(bp)
		move.w	mi(bp),almin(bp)
		st	alarm(bp)
		bra.s	2$
5$		subq.w	#1,d0			; CANCEL ?
		bne.s	9$
2$		bsr	CloseAlmWin
		tst.b	alarm(bp)
		beq.s	1$			; 
		move.l	Menus(bp),a0
		move.l	#$8e1,d0		; FULLMENUNUM(1,7,1);
		CALL	ItemAddress,IntBase(bp)
		move.l	d0,a2
		move.w	#$100,d0
		and.w	12(a2),d0
		bne.s	1$			; already on !
		move.l	WinPtr(bp),a0
		RECALL	ClearMenuStrip
		or.w	#$100,12(a2)		; item->Flags |= CHECKED;
		move.l	WinPtr(bp),a0
		move.l	Menus(bp),a1
		RECALL	ResetMenuStrip
1$		movem.l	(sp)+,d2/d3/a2/a3/a6
		rts

***************************************************************************

CheckColWin	movem.l	d2/d3/a2/a6,-(sp)
		move.l	ColWin(bp),d2
		beq.s	1$
		move.l	d2,a2
3$		move.l	86(a2),a0
		CALL	GT_GetIMsg,GadsBase(bp)
		move.l	d0,a1
		move.l	a1,d0
		beq.s	1$
		move.l	20(a1),d2		; imClass
		move.w	24(a1),d3		; imCode
		RECALL	GT_ReplyIMsg
		moveq	#($200>>3),d0		; CLOSEWINDOW
		lsl.w	#3,d0
		cmp.l	d0,d2
		beq.s	2$
		moveq	#$40,d0			; GADGETUP
		cmp.l	d0,d2
		bne.s	3$
		move.l	color(bp),a0
		move.b	d3,0(a0)		; set new color
		bsr	SetPattern
		bsr	Rahmen
		bsr	ZifferBlatt
		bsr	Zeichnen
2$		bsr	CloseColWin
1$		movem.l	(sp)+,d2/d3/a2/a6
		rts

***************************************************************************

CheckMainWin	movem.l	d2/d3/a2/a3/a6,-(sp)
4$		move.l	WinPtr(bp),a0		; while (GT_GetIMsg(window->UserPort)))
		move.l	86(a0),a0
		CALL	GT_GetIMsg,GadsBase(bp)
		move.l	d0,a1
		move.l	a1,d0
		beq.s	1$			; no msg !
		move.l	20(a1),imClass(bp)
		move.w	24(a1),imCode+2(bp)
		RECALL	GT_ReplyIMsg
		move.l	IntBase(bp),a6		; load libbase reg
		move.l	imClass(bp),d3
		moveq	#0,d0
		moveq	#2,d2
		cmp.l	d2,d3
		beq	3$			; CASE NEWSIZE
		moveq	#2,d0
		moveq	#4,d2
		cmp.l	d2,d3
		beq.s	3$			; CASE REFRESHWINDOW
		moveq	#4,d0
		moveq	#($100>>2),d2
		add.w	d2,d2
		add.w	d2,d2
		cmp.l	d2,d3
		beq.s	3$			; CASE MENUPICK
		moveq	#6,d0
		add.l	d2,d2
		cmp.l	d2,d3
		beq.s	3$			; case CLOSEWINDOW
		moveq	#8,d0
		moveq	#1,d1
		moveq	#4,d2
		swap	d2
		cmp.l	d2,d3
		beq.s	3$			; CASE ACTIVEWINDOW
		moveq	#0,d1
		add.l	d2,d2
		cmp.l	d2,d3
		bne.s	2$			; not CASE INACTIVEWINDOW
3$		move.w	msgTab(pc,d0.w),d0
		jsr	msgTab(pc,d0.w)
2$		tst.b	EndAll(bp)
		beq.s	4$			; not quit !
1$		movem.l	(sp)+,d2/d3/a2/a3/a6
		rts

msgTab		ADDCMD	msg,NewSize,0
		ADDCMD	msg,Refresh
		ADDCMD	msg,MenuPick
		ADDCMD	msg,CloseWin
		ADDCMD	msg,ActInact

;--------------------------------------------------------------------------

msgNewSize	bsr	NewSize1
		bsr	NewSize2
		beq.s	msgCloseErr		; error !
		bsr	Rahmen
		bsr	ZifferBlatt
		bra	Zeichnen

;--------------------------------------------------------------------------

msgRefresh	move.l	BoLeft(bp),d0
		move.l	d0,ReDrawx1(bp)
		move.l	BoTop(bp),d1
		move.l	d1,ReDrawy1(bp)
		add.l	Breit2(bp),d0
		subq.l	#1,d0
		move.l	d0,ReDrawx2(bp)
		add.l	Hoehe2(bp),d1
		subq.l	#1,d1
		move.l	d1,ReDrawy2(bp)
		move.l	WinPtr(bp),a0
		RECALL	BeginRefresh
		bsr	Rahmen
		bsr	Zeichnen
		moveq	#1,d0
		move.l	WinPtr(bp),a0
		jmp	_LVOEndRefresh(a6)

;--------------------------------------------------------------------------

msgCloseWin	tst.b	closegad(bp)
		beq.s	msgCloseErr+4		; close gadget off !

msgCloseErr	st	EndAll(bp)
		rts

;--------------------------------------------------------------------------

msgActInact	move.b	d1,Active(bp)
		bra	Rahmen

;--------------------------------------------------------------------------

msgMenuPick	move.l	imCode(bp),d2		; while (code != MENUNULL) {
		cmpi.w	#-1,d2
		beq.s	1$
		move.l	d2,d0
		move.l	Menus(bp),a0
		CALL	ItemAddress,IntBase(bp)
		move.l	d0,a2
		move.w	32(a2),imCode+2(bp)
		moveq	#$1f,d0
		and.w	d2,d0			; MENUNUM
		add.w	d0,d0			; now index !
		move.w	d2,d1
		lsr.w	#5,d1
		andi.w	#$3f,d1			; ITEMNUM
		lsr.w	#8,d2
		lsr.w	#3,d2
		andi.w	#$1f,d2			; SUBNUM
		move.w	menuTab(pc,d0.w),d0
		jsr	menuTab(pc,d0.w)	; execute CASE
		bsr	msgNewSize
		bne.s	msgMenuPick		; no error !
1$		rts				; }

menuTab		ADDCMD	menu,Project,0
		ADDCMD	menu,Settings
		ADDCMD	menu,Colors
		ADDCMD	menu,Pattern

;--------------------------------------------------------------------------

menuProject	add.w	d1,d1			; now index !
		move.w	projectTab(pc,d1.w),d1
		jmp	projectTab(pc,d1.w)

projectTab	ADDCMD	project,About,0
		ADDCMD	project,Save
		dc.w	msgCloseErr-projectTab	; quit really !

projectAbout	tst.l	AboutReq(bp)
		bne.s	1$
		lea	EasyBuf(bp),a2
		moveq	#20,d0
		move.l	d0,(a2)+		; structSize
		clr.l	(a2)+			; flags
		moveq	#About,d0
		bsr	GetLocStr
		move.l	d0,(a2)+		; reqTitle
		lea	ProgName(pc),a0
		move.l	a0,(a2)+		; reqText
		moveq	#Description,d0
		bsr	GetLocStr
		move.l	d0,(a2)			; gadText
		moveq	#0,d0
		move.l	WinPtr(bp),a0
		lea	EasyBuf(bp),a1
;		suba.l	a3,a3			; we don't have args !
		RECALL	BuildEasyRequestArgs
		move.l	d0,AboutReq(bp)
1$		rts

;--------------------------------------------------------------------------

menuSettings	add.w	d1,d1			; now index !
		move.w	settingsTab(pc,d1.w),d1
		moveq	#1,d0
		and.b	12(a2),d0		; checked=item.Flags&CHECKED;
		jmp	settingsTab(pc,d1.w)

settingsTab	ADDCMD	settings,Secs,0
		ADDCMD	settings,Oval
		ADDCMD	settings,Show
		ADDCMD	settings,Hands
		ADDCMD	settings,Shadow
		ADDCMD	settings,Border
		ADDCMD	settings,Chime
		ADDCMD	settings,Alarm
		ADDCMD	settings,CloseG

settingsSecs	move.b	d0,sekunden(bp)		; seconds on/off
		tst.b	TimerSent(bp)
		beq.s	1$
		move.l	TimerIO(bp),a1
		CALL	AbortIO,SysBase(bp)
		move.l	TimerIO(bp),a1
		RECALL	WaitIO
		clr.b	TimerSent(bp)
1$		bra	NextTick

settingsOval	move.b	d0,oval(bp)		; rectangle/oval
		rts

settingsShow	beq.s	1$			; zifferblatt
		move.b	d2,zeigen(bp)
1$		rts

settingsHands	beq.s	1$			; hands
		lea	zeigerbreite(bp),a2
		subq.w	#5,d2
		bcc.s	2$			; 5-9
		addq.w	#5,d2
		lea	zeigertyp(bp),a2
2$		move.b	d2,0(a2)
1$		rts

settingsShadow	move.b	d0,schatten(bp)		; shadow on/off
		rts

settingsBorder	lea	interlace(bp),a0	; border type
		subq.w	#5,d2
		beq.s	2$
		lea	hires(bp),a0
		addq.w	#1,d2
		beq.s	2$
		tst.b	d0
		beq.s	1$
		lea	rahmenanz(bp),a0
		addq.w	#4,d2
		move.w	d2,d0
2$		move.b	d0,0(a0)		; interlace,hires or rahmenanz
1$		rts

settingsChime	lea	smarthour(bp),a0	; chime
		subq.w	#4,d2
		beq.s	2$
		tst.b	d0
		beq.s	1$
		lea	chime(bp),a0
		addq.w	#4,d2
		move.w	d2,d0
2$		move.b	d0,0(a0)		; smarthour or chime
1$		rts

settingsAlarm	subq.w	#1,d2			; which subitem ?
		bcc.s	alarmOn

alarmSet	tst.l	AlmWin(bp)
		bne.s	1$			; already open !
		suba.l	a1,a1
		pea	almgadtags2(pc)
		pea	2			; TAG_MORE,almgadtags2
		pea	fmt5(pc)
		pea	$8008002A		; GSTL_Format,fmt5
		moveq	#0,d1
		move.w	almin(bp),d1
		move.l	d1,-(sp)
		pea	$80080028		; GSTL_Level,minute
		move.l	sp,d1
		suba.l	a0,a0
		pea	almgadtags1(pc)
		pea	2			; TAG_MORE,almgadtags1
		pea	fmt4(pc)
		pea	$8008002A		; GSTL_Format,fmt4
		moveq	#0,d0
		move.w	alstd(bp),d0
		move.l	d0,-(sp)
		pea	$80080028		; GSTL_Level,hour
		move.l	sp,d0
		movem.l	d0/d1/a0/a1,-(sp)
		lea	almwintab(pc),a0
		move.l	sp,a1			: **ptr
		bsr	CreateRequest
		lea	16*4(sp),sp
		movem.l	d0/d1,AlmWin(bp)	; store window && gadgets
1$		rts

alarmOn		move.b	d0,alarm(bp)		; alarm on/off
		rts

settingsCloseG	move.b	d0,closegad(bp)		; close gadget on/off
		rts

;--------------------------------------------------------------------------

menuColors	lea	Pens(bp),a1		; colors
		bra.s	GetColor

;--------------------------------------------------------------------------

menuPattern	lea	Must(bp),a1		; pattern

;--------------------------------------------------------------------------

GetColor	tst.l	ColWin(bp)		; already open ?
		bne.s	1$
		lea	0(a1,d1.w),a1		; color entry
		move.l	a1,color(bp)
		lea	colwintab(pc),a0
		clr.l	-(sp)			; TAG_DONE
		moveq	#0,d0
		move.b	BitMap1+5(bp),d0
		move.l	d0,-(sp)
		pea	$80080010		; GTPA_Depth
		move.l	sp,-(sp)
		move.l	sp,a1			; **ptr
		bsr	CreateRequest
		lea	16(sp),sp
		movem.l	d0/d1,ColWin(bp)	; store window && gadgets
1$		rts

***************************************************************************

NextTick	movem.l	d2/d3/d4/a2/a6,-(sp)
		move.l	TimerIO(bp),a2
		move.w	#10,28(a2)
		move.l	a2,a1
		CALL	DoIO,SysBase(bp)	; TR_GETSYSTIME
		move.l	32(a2),d2
		move.l	#1100000,d0
		sub.l	36(a2),d0
		move.l	d0,36(a2)		; tv_micro
		moveq	#0,d0
		tst.b	sekunden(bp)
		bne.s	1$
		move.l	d2,d0
		moveq	#60,d1
		bsr	LDiv			; sec = 59-sec%60
		moveq	#59,d0
		sub.l	d1,d0
1$		move.l	d0,32(a2)		; tv_secs
		move.w	#9,28(a2)
		move.l	a2,a1
		RECALL	SendIO			; TR_ADDREQUEST
		st	TimerSent(bp)
		move.w	min(bp),d4		; oldmin
		move.l	d2,d0
		moveq	#60,d1
		bsr	LDiv			; min = sec/60
		exg.l	d0,d2
		moveq	#60,d1
		bsr	LDiv			; sec = sec%60
		move.w	d1,sec(bp)
		move.l	d2,d0
		moveq	#12,d1
		bsr	LDiv			; std = min/12
		move.l	d0,d3
		move.l	d2,d0
		moveq	#60,d1
		bsr	LDiv			; min = min%60
		move.w	d1,min(bp)
		move.l	d3,d0
		moveq	#60,d1
		bsr	LDiv			; std = std%60
		move.w	d1,std(bp)
		move.w	min(bp),d0
		sub.w	d4,d0			; oldmin != min
		movem.l	(sp)+,d2/d3/d4/a2/a6
		rts

;--------------------------------------------------------------------------

SetAPen		ext.w	d0			; set pen
		ext.l	d0
		move.l	a2,a1
		jmp	_LVOSetAPen(a6)

Move		move.l	a2,a1			; moveto
		jmp	_LVOMove(a6)

Draw		move.l	a2,a1			; drawto
		jmp	_LVODraw(a6)

Rahmen		movem.l	d2-d7/a2/a6,-(sp)
		move.l	GfxBase(bp),a6		; setup regs
		move.l	RPort1(bp),a2
		move.l	Breite(bp),d4
		move.l	Hoehe(bp),d5
		move.b	rahmenanz(bp),d7
		beq	1$			; no border ...
		move.b	Pens+11(bp),d2
		move.b	Pens+12(bp),d3
		tst.b	Active(bp)
		beq.s	4$
		cmpi.b	#1,d7			; rahmenanz
		bne.s	4$
		exg.l	d2,d3
4$		move.b	d2,d0
		bsr.s	SetAPen			; SetAPen(rp,a?b:c);
		moveq	#1,d0
		moveq	#-1,d1
		add.l	d5,d1
		bsr.s	Move			; Move(rp,1,hoehe-1);
		moveq	#-1,d0
		add.l	d4,d0
		moveq	#-1,d1
		add.l	d5,d1
		bsr.s	Draw			; Draw(rp,breite-1,hoehe-1);
		moveq	#-1,d0
		add.l	d4,d0
		moveq	#1,d1
		bsr.s	Draw			; Draw(rp,breite-1,1);
		move.b	d3,d0
		bsr.s	SetAPen			; SetAPen(rp,a?c:b);
		moveq	#0,d0
		moveq	#-1,d1
		add.l	d5,d1
		bsr.s	Move			; Move(rp,0,hoehe-1);
		moveq	#0,d0
		moveq	#0,d1
		bsr.s	Draw			; Draw(rp,0,0);
		moveq	#-1,d0
		add.l	d4,d0
		moveq	#0,d1
		bsr.s	Draw			; Draw(rp,breite-1,0);
		cmpi.b	#2,d7
		bne	1$
		move.l	BoLeft(bp),d6
		move.l	BoTop(bp),d7
		move.b	Pens+12(bp),d0
		bsr	SetAPen			; SetAPen(rp,pens[12]);
		move.l	d6,d0
		move.l	d5,d1
		sub.l	d7,d1
		bsr	Move			; Move(rp,boleft,hoehe-botop);
		move.l	d4,d0
		sub.l	d6,d0
		move.l	d5,d1
		sub.l	d7,d1
		bsr	Draw			; Draw(rp,breite-boleft,hoehe-botop);
		move.l	d4,d0
		sub.l	d6,d0
		move.l	d7,d1
		bsr	Draw			; Draw(rp,breite-boleft,botop);
		move.b	Pens+11(bp),d0
		bsr	SetAPen
		moveq	#-1,d0
		add.l	d6,d0
		move.l	d5,d1
		sub.l	d7,d1
		bsr	Move			; Move(rp,boleft-1,hoehe-botop);
		moveq	#-1,d0
		add.l	d6,d0
		moveq	#-1,d1
		add.l	d7,d1
		bsr	Draw			; Draw(rp,boleft-1,botop-1);
		move.l	d4,d0
		sub.l	d6,d0
		moveq	#-1,d1
		add.l	d7,d1
		bsr	Draw			; Draw(rp,breite-boleft,botop-1);
		move.b	Pens+10(bp),d0
		tst.b	Active(bp)
		beq.s	3$			; window not active 
		move.b	Pens+13(bp),d0
3$		bsr	SetAPen
		tst.b	hires(bp)
		beq.s	2$
		moveq	#1,d0
		moveq	#1,d1
		moveq	#2,d2
		moveq	#-2,d3
		add.l	d5,d3
		bsr.s	RectFill		; RectFill(rp,1,1,2,hoehe-2);
		moveq	#-3,d0
		add.l	d4,d0
		moveq	#1,d1
		moveq	#-2,d2
		add.l	d4,d2
		moveq	#-2,d3
		add.l	d5,d3
		bsr.s	RectFill		; RectFill(rp,breite-3,1,breite-2,hoehe-2);
2$		tst.b	interlace(bp)
		beq.s	1$
		moveq	#1,d0
		moveq	#1,d1
		moveq	#-2,d2
		add.l	d4,d2
		moveq	#2,d3
		bsr.s	RectFill		; RectFill(rp,1,1,breite-2,2);
		moveq	#1,d0
		moveq	#-3,d1
		add.l	d5,d1
		moveq	#-2,d2
		add.l	d4,d2
		moveq	#-2,d3
		add.l	d5,d3
		bsr.s	RectFill		; RectFill(rp,1,hoehe-3,breite-2,hoehe-2);
1$		move.b	Pens+0(bp),d0
		bsr	SetAPen			; SetAPen(rp,pens[0]);
		movem.l	(sp)+,d2-d7/a2/a6
		rts

RectFill	move.l	a2,a1			; fill rectangle
		jmp	_LVORectFill(a6)

;--------------------------------------------------------------------------

NewSize2	movem.l	d2/d3/a2/a6,-(sp)
		moveq	#2,d1			; cmp value
		move.b	rahmenanz(bp),d0
		tst.b	hires(bp)
		beq.s	9$
		cmp.b	d1,d0
		bne.s	9$
		moveq	#4,d0
9$		move.b	d0,BoLeft+3(bp)
		move.b	rahmenanz(bp),d0
		tst.b	interlace(bp)
		beq.s	8$
		cmp.b	d1,d0
		bne.s	8$
		moveq	#4,d0
8$		move.b	d0,BoTop+3(bp)
		move.l	WinPtr(bp),a0
		move.w	8(a0),Breite+2(bp)	; window->width
		move.w	10(a0),Hoehe+2(bp)	; window->height
		move.l	BoLeft(bp),d0
		add.l	d0,d0
		sub.l	Breite(bp),d0
		neg.l	d0
		move.l	d0,Breit2(bp)		; Breit2 = Breite-BoLeft<<1
		move.l	BoTop(bp),d0
		add.l	d0,d0
		sub.l	Hoehe(bp),d0
		neg.l	d0
		move.l	d0,Hoehe2(bp)		; Hoehe2 = Hoehe-BoTop<<1
		moveq	#12,d2			; cmp value
		moveq	#-2,d1			; cmp value
		moveq	#0,d0
		cmp.w	xMask+2(bp),d1
		bne.s	7$
		cmp.l	Breit2(bp),d2
		bcc.s	7$			; <= 12 !
		moveq	#1,d0
7$		move.b	d0,xDouble(bp)		; set value
		moveq	#0,d0
		cmp.w	yMask+2(bp),d1
		bne.s	6$
		cmp.l	Hoehe2(bp),d2
		bcc.s	6$			; <= 12 !
		moveq	#1,d0
6$		move.b	d0,yDouble(bp)		; set value
		moveq	#0,d0
		moveq	#25,d1
		cmp.l	Breit2(bp),d1
		bcc.s	5$			; <= 25 !
		moveq	#1,d0
		add.l	d1,d1
		cmp.l	Breit2(bp),d1
		bcc.s	5$			; <= 50 !
		moveq	#2,d0
5$		move.w	d0,xOffset(bp)		; set value
		moveq	#0,d0
		moveq	#25,d1
		cmp.l	Hoehe2(bp),d1
		bcc.s	4$			; <= 25 !
		moveq	#1,d0
		add.l	d1,d1
		cmp.l	Hoehe2(bp),d1
		bcc.s	4$			; <= 50 !
		moveq	#2,d0
4$		move.w	d0,yOffset(bp)		; set value
		move.l	Breite(bp),d0
		move.l	Hoehe(bp),d1
		cmp.l	d1,d0
		bcs.s	3$
		move.l	d1,d0
3$		asr.w	#3,d0
		cmp.w	GadSize(bp),d0
		beq.s	10$			; don't update gadgets
		move.w	d0,GadSize(bp)
		move.l	WinPtr(bp),a0
		lea	GadgetBuf(bp),a1
		moveq	#-1,d0
		CALL	RemoveGList,IntBase(bp)	; remove gadgets
		lea	sizes(pc),a0
		lea	GadgetBuf(bp),a1
		moveq	#3,d3
2$		moveq	#3,d2
		moveq	#4,d1
1$		move.b	(a0)+,d0
		ext.w	d0
		muls	GadSize(bp),d0
		move.w	d0,0(a1,d1.w)		; set new positions
		addq.w	#2,d1
		dbra	d2,1$
		lea	44(a1),a1
		dbra	d3,2$
		move.l	WinPtr(bp),a0
		lea	GadgetBuf(bp),a1
		moveq	#0,d0
		moveq	#4,d1
		moveq	#0,d2
		RECALL	AddGList		; add gadgets again
10$		lea	RPort2(bp),a1
		CALL	InitRastPort,GfxBase(bp)
		moveq	#0,d0
		move.l	PubScreen(bp),a0
		move.b	189(a0),d0		; BitMap.Depth
		move.l	Breit2(bp),d1
		move.l	Hoehe2(bp),d2
		lea	BitMap1(bp),a0
		RECALL	InitBitMap
		lea	BitMap1+8(bp),a2
		move.b	BitMap1+5(bp),d2
11$		move.l	Breit2(bp),d0
		move.l	Hoehe2(bp),d1
		RECALL	AllocRaster
		move.l	d0,(a2)+
		beq.s	12$			; error no mem !
		subq.b	#1,d2
		bne.s	11$
		lea	BitMap1(bp),a0
		move.l	a0,RPort2+4(bp)		; RastPort.BitMap = BitMap
		move.l	Breit2(bp),d0
		move.l	Hoehe2(bp),d1
		RECALL	AllocRaster
		move.l	d0,Buf(bp)
		beq.s	12$			; no bitplane !
		move.l	Buf(bp),a1
		lea	TempRas(bp),a0
		moveq	#15,d1			; RASSIZE(Breite,Hoehe)
		add.w	Breit2+2(bp),d1
		asr.w	#3,d1
		moveq	#-2,d0
		and.w	d1,d0
		mulu	Hoehe2+2(bp),d0
		RECALL	InitTmpRas
		move.l	d0,RPort2+12(bp)	; RastPort.TmpRas = TempRas
		lea	AreaInf(bp),a0
		lea	Table(bp),a1
		moveq	#5,d0
		RECALL	InitArea
		lea	AreaInf(bp),a0
		move.l	a0,RPort2+16(bp)	; RastPort.AreaInfo = AreaInf
12$		movem.l	(sp)+,d2/d3/a2/a6
		rts

;--------------------------------------------------------------------------

ZifferBlatt	movem.l	d2-d7/a2/a3/a6,-(sp)
		subq.w	#8,sp			; local vars
		move.l	GfxBase(bp),a6
		lea	RPort2(bp),a2
		move.l	Breit2(bp),d4
		move.l	Hoehe2(bp),d5
		andi.w	#$fff7,32(a2)		; BNDRYOFF(RastPort)
		moveq	#-1,d0
		bsr	SetAPen
		lea	Muster(bp),a0		; SetAfPt(RastPort,Muster,Anz)
		move.l	a0,8(a2)
		st	29(a2)
		moveq	#0,d0
		moveq	#0,d1
		moveq	#-1,d2
		add.l	d4,d2
		moveq	#-1,d3
		add.l	d5,d3
		bsr	RectFill
		clr.l	8(a2)			; SetAfPt(RastPort,Muster,Anz)
		clr.b	29(a2)
		moveq	#1,d6			; a=(zeigen>1?(zeigen==3?60:15):(zeigen?5:1));
		move.b	zeigen(bp),d0
		beq.s	9$
		moveq	#5,d6
		cmpi.b	#1,d0
		beq.s	9$
		moveq	#15,d6
		cmpi.b	#3,d0
		bne.s	9$
		moveq	#60,d6
9$		cmpi.b	#4,d0
		bcc	2$			; zeigen >= 4 !
		moveq	#0,d7
8$		lea	srect(pc),a3
		tst.b	oval(bp)
		beq.s	7$
		lea	sinus(pc),a3
7$		move.l	d4,d2
		asr.l	#1,d2
		move.b	0(a3,d7.w),d0
		ext.w	d0
		muls	d4,d0
		divs	#300,d0
		and.l	xMask(bp),d0
		add.l	d0,d2			; x=x0+(array[i]*Breit2/300)&xMask
		move.l	d5,d3
		asr.l	#1,d3
		move.b	60(a3,d7.w),d0
		ext.w	d0
		muls	d5,d0
		divs	#300,d0
		and.l	yMask(bp),d0
		sub.l	d0,d3			; y=y0-(array[i]*Hoehe2/300)&yMask
		move.l	d7,d0			; if (i%5) { draw minute }
		divu	#5,d0
		swap	d0
		tst.w	d0
		beq	5$
		subq.w	#1,d0			; if (i%5==1)
		bne.s	6$
		move.b	Pens+9(bp),d0
		bsr	SetPens			; set apen + open
6$		move.l	d4,d0
		moveq	#100,d1
		add.l	d1,d1
		bsr	LDiv
		move.l	d0,0(sp)		; Breit2/200
		move.l	d5,d0
		moveq	#100,d1
		add.l	d1,d1
		bsr	LDiv
		move.l	d0,4(sp)		; Hoehe2/200
		move.l	d2,d0
		add.l	0(sp),d0
		move.l	d3,d1
		bsr	AreaMove
		move.l	d2,d0
		move.l	d3,d1
		add.l	4(sp),d1
		bsr	AreaDraw
		move.l	d2,d0
		sub.l	0(sp),d0
		move.l	d3,d1
		bsr	AreaDraw
		move.l	d2,d0
		move.l	d3,d1
		sub.l	4(sp),d1
		bsr	AreaDraw
		bra.s	4$
5$		swap	d0			; else { draw hour }
		lea	dx1(pc),a3
		lea	0(a3,d0.w),a3		; calc table entry
		lea	pent(pc),a0
		move.b	0(a0,d0.w),d0
		lea	Pens(bp),a0
		move.b	0(a0,d0.w),d0
		bsr	SetPens			; set apen + open
		bsr	MoveHour
		bsr	DrawHour
		bsr	DrawHour
		bsr	DrawHour
4$		bsr	AreaEnd
		add.l	d6,d7
		moveq	#59,d0
		cmp.l	d7,d0
		bcc	8$			; not ready
2$		tst.b	schatten(bp)
		beq.s	1$
		move.w	std(bp),0(sp)
		move.w	#440,2(sp)
		move.b	Pens+5(bp),d0		; apen && open
		move.b	d0,4(sp)
		move.b	d0,5(sp)
		st	6(sp)
		bsr	Zeiger
		move.w	min(bp),0(sp)
		move.w	#300,2(sp)
		bsr	Zeiger
1$		move.w	std(bp),0(sp)
		move.w	#440,2(sp)
		move.b	Pens+3(bp),4(sp)	; apen && open
		move.b	Pens+4(bp),5(sp)
		clr.b	6(sp)
		bsr	Zeiger
		move.w	min(bp),0(sp)
		move.w	#300,2(sp)
		move.b	Pens+1(bp),4(sp)
		move.b	Pens+2(bp),5(sp)
		bsr	Zeiger
		move.l	BoLeft(bp),d0		; set redraw stuff
		move.l	d0,ReDrawx1(bp)
		move.l	BoTop(bp),d1
		move.l	d1,ReDrawy1(bp)
		add.l	Breit2(bp),d0
		subq.l	#1,d0
		move.l	d0,ReDrawx2(bp)
		add.l	Hoehe2(bp),d1
		subq.l	#1,d1
		move.l	d1,ReDrawy2(bp)
		addq.w	#8,sp
		movem.l	(sp)+,d2-d7/a2/a3/a6
		rts

MoveHour	bsr.s	SetNewXY		; move hour pos
		move.l	d2,d0
		move.l	d3,d1

AreaMove	move.l	a2,a1			; area move stub
		jmp	_LVOAreaMove(a6)

DrawHour	lea	24(a3),a3		; draw a hour
		bsr.s	SetNewXY
		move.l	d2,d0
		move.l	d3,d1

AreaDraw	move.l	a2,a1			; area draw stub
		jmp	_LVOAreaDraw(a6)

AreaEnd		move.l	a2,a1			; area end stub
		jmp	_LVOAreaEnd(a6)

SetNewXY	moveq	#100,d1			; update x && y
		move.b	0(a3),d0
		ext.w	d0
		muls	d4,d0
		divs	d1,d0
		add.w	d0,d2			; x+=Breit2*dx?[b]/100
		move.b	12(a3),d0
		ext.w	d0
		muls	d5,d0
		divs	d1,d0
		add.w	d0,d3			; y+=Hoehe2*dy?[b]/100
		rts

SetPens		move.l	d0,-(sp)		; save pen number
		bsr	SetAPen
		move.l	(sp)+,d0

SetOPen		cmpi.w	#39,20(a6)		; SetOPen v39+
		bcs.s	1$
		ext.w	d0
		ext.l	d0
		move.l	a2,a0
		jmp	_LVOSetOutlinePen(a6)
1$		move.b	d0,27(a2)		; SetOPen pre v39+
		or.w	#8,32(a2)
		rts

;--------------------------------------------------------------------------

Zeiger		lea	4(sp),a0		; get structure start
		movem.l	d2-d7/a2/a3/a6,-(sp)
		move.l	GfxBase(bp),a6
		move.l	a0,a3			; save struct ptr
		lea	RPort2(bp),a2
		move.l	Breit2(bp),d2
		move.l	Hoehe2(bp),d3
		lea	handwidth(pc),a1
		moveq	#0,d1
		move.b	zeigerbreite(bp),d1
		add.w	d1,d1
		move.w	0(a1,d1.w),d1
		lea	sinus(pc),a0
		adda.w	0(a3),a0
		move.b	60(a0),d7		; y2
		ext.w	d7
		muls	d3,d7
		divs	2(a3),d7
		ext.l	d7
		move.b	0(a0),d6		; x2
		ext.w	d6
		muls	d2,d6
		divs	2(a3),d6
		ext.l	d6
		move.b	0(a0),d5		; y1
		ext.w	d5
		muls	d3,d5
		divs	d1,d5
		ext.l	d5
		move.b	60(a0),d4		; x1
		ext.w	d4
		muls	d2,d4
		divs	d1,d4
		ext.l	d4
		asr.l	#1,d3			; y0
		asr.l	#1,d2			, x0
		tst.b	6(a3)
		beq.s	1$
		add.w	yOffset(bp),d3
		add.w	xOffset(bp),d2
1$		move.b	4(a3),d0
		bsr	SetAPen
		move.b	5(a3),d0
		bsr	SetOPen
		bsr.s	DrawHand
		movem.l	(sp)+,d2-d7/a2/a3/a6
		rts

DrawHand	moveq	#0,d0
		move.b	zeigertyp(bp),d0
		beq.s	1$
		pea	AreaEnd(pc)		; last area cmd
		add.w	d0,d0
1$		move.w	ZeigerTab(pc,d0.w),d0
		jmp	ZeigerTab(pc,d0.w)

ZeigerTab	ADDCMD	Zeiger,0,0		; CASE line
		ADDCMD	Zeiger,1		; case triangle
		ADDCMD	Zeiger,2		; case rhombus
		ADDCMD	Zeiger,3		; case rectangle

Zeiger0		move.b	5(a3),d0
		bsr	SetAPen			; SetAPen(rp,open)
		move.l	d2,d0
		move.l	d3,d1
		bsr	Move			; Move(rp,x0,y0)
		move.l	d2,d0
		add.l	d6,d0
		move.l	d3,d1
		sub.l	d7,d1
		bsr	Draw			; Draw(rp,x0+x2,y0-y2)
		tst.b	xDouble(bp)
		beq.s	2$
		moveq	#1,d0
		add.l	d2,d0
		move.l	d3,d1
		bsr	Move			; Move(rp,x0+1,y0)
		moveq	#1,d0
		add.l	d2,d0
		add.l	d6,d0
		move.l	d3,d1
		sub.l	d7,d1
		bsr	Draw			; Draw(rp,x0+x2+1,y0-y2)
2$		tst.b	yDouble(bp)
		beq.s	1$
		move.l	d2,d0
		moveq	#1,d1
		add.l	d3,d1
		bsr	Move			; Move(rp,x0,y0+1)
		move.l	d2,d0
		add.l	d6,d0
		moveq	#1,d1
		add.l	d3,d1
		sub.l	d7,d1
		bsr	Draw			; Draw(rp,x0+x2,y0-y2+1)
1$		rts

Zeiger1		move.l	d2,d0
		add.l	d6,d0
		move.l	d3,d1
		sub.l	d7,d1
		bsr	AreaMove		; AreMove(rp,x0+x2,y0-y2);
		move.l	d6,d0
		asr.l	#2,d0
		neg.l	d0
		add.l	d4,d0
		add.l	d2,d0
		move.l	d7,d1
		asr.l	#2,d1
		add.l	d5,d1
		add.l	d3,d1
		bsr	AreaDraw		; AreaMove(rp,x0+x1-x2/4,y0+y1+y2/4);
		move.l	d6,d0
		asr.l	#2,d0
		neg.l	d0
		sub.l	d4,d0
		add.l	d2,d0
		move.l	d7,d1
		asr.l	#2,d1
		sub.l	d5,d1
		add.l	d3,d1
		bra	AreaDraw		; AreaDraw(rp,x0-x1-x2/4,y0-y1+y2/4);

Zeiger2		move.l	d2,d0
		add.l	d6,d0
		move.l	d3,d1
		sub.l	d7,d1
		bsr	AreaMove		; AreMove(rp,x0+x2,y0-y2);
		move.l	d2,d0
		add.l	d4,d0
		move.l	d3,d1
		add.l	d5,d1
		bsr	AreaDraw		; AreaDraw(rp,x0+x1,y0+y1);
		move.l	d6,d0
		asr.l	#2,d0
		neg.l	d0
		add.l	d2,d0
		move.l	d7,d1
		asr.l	#2,d1
		add.l	d3,d1
		bsr	AreaDraw		; AreaDraw(rp,x0-x2/4,y0+y2/4);
;		move.l	d2,d0
;		sub.l	d4,d0
;		move.l	d3,d1
;		sub.l	d5,d1
;		bra	AreaDraw		; AreaDraw(rp,x0-x1,y0-y1);
		bra.s	Zeiger23

Zeiger3		move.l	d4,d0
		asr.l	#1,d0
		sub.l	d0,d2
		add.l	d6,d2
		move.l	d2,d0
		move.l	d5,d1
		asr.l	#1,d1
		add.l	d7,d1
		sub.l	d1,d3
		move.l	d3,d1
		bsr	AreaMove		; AreMove(rp,x0+=x2-x1/2,y0-=y2+y1/2);
		add.l	d4,d2
		move.l	d2,d0
		add.l	d5,d3
		move.l	d3,d1
		bsr	AreaDraw		; AreaDraw(rp,x0+=x1,y0+=y1);
		move.l	d6,d0
		asl.l	#2,d0
		add.l	d6,d0
		asr.l	#2,d0
		sub.l	d0,d2
		move.l	d2,d0
		move.l	d7,d1
		asl.l	#2,d1
		add.l	d7,d1
		asr.l	#2,d1
		add.l	d1,d3
		move.l	d3,d1
		bsr	AreaDraw		; AreaDraw(rp,x0-=x2*5/4,y0+=y2*5/4);
Zeiger23	sub.l	d4,d2
		move.l	d2,d0
		sub.l	d5,d3
		move.l	d3,d1
		bra	AreaDraw		; AreaDraw(rp,x0-=x1,y0-=y1);

;--------------------------------------------------------------------------

Zeichnen	movem.l	d2-d7/a2/a6,-(sp)
		move.l	GfxBase(bp),a6
		move.l	RPort1(bp),a2
		move.l	a2,a1			; RastPort
		lea	BitMap1(bp),a0		; BitMap
		move.l	ReDrawx1(bp),d0
		move.l	d0,d2
		sub.l	BoLeft(bp),d0		; redrawx1-boleft
		move.l	ReDrawy1(bp),d1
		move.l	d1,d3
		sub.l	BoTop(bp),d1		; redrawy1-botop
		move.l	ReDrawx2(bp),d4
		sub.l	d2,d4
		addq.l	#1,d4			; redrawx2-redrawx1+1
		move.l	ReDrawy2(bp),d5
		sub.l	d3,d5
		addq.l	#1,d5			; redrawy2-redrawy1+1
		moveq	#256-$c0,d6
		neg.b	d6
		RECALL	BltBitMapRastPort
		tst.b	sekunden(bp)
		beq	1$
		move.l	Breite(bp),d2
		asr.l	#1,d2			; redrawx1/2
		move.l	Hoehe(bp),d3
		asr.l	#1,d3			; redrawy1/2
		lea	sinus(pc),a0
		add.w	sec(bp),a0
		move.b	0(a0),d4
		ext.w	d4
		muls	Breit2+2(bp),d4
		divs	#300,d4
		ext.l	d4
		add.l	d2,d4			; redrawx2=redrawx1+sinus[sec]*Breit2/300;
		move.b	60(a0),d5
		ext.w	d5
		muls	Hoehe2+2(bp),d5
		divs	#300,d5
		ext.l	d5
		neg.l	d5
		add.l	d3,d5			; redrawy2=redrawy1+cosinus[sec]*Hoehe2/300;
		move.l	d2,d0
		move.l	d3,d1
		bsr	Move			; Move(rp,redrawx1,redrawy1);
		move.l	d4,d0
		move.l	d5,d1
		bsr	Draw			; Draw(rp,redrawx2,redrawy2);
		move.b	xDouble(bp),d6		; if (doublex)
		beq.s	7$
		moveq	#1,d0
		add.l	d2,d0
		move.l	d3,d1
		bsr	Move			; Move(rp,redrawx1+1,redrawy1);
		moveq	#1,d0
		add.l	d4,d0
		move.l	d5,d1
		bsr	Draw			; Draw(rp,redrawx2+1,redrawy2);
7$		move.b	yDouble(bp),d7		; if (doubley)
		beq.s	6$
		move.l	d2,d0
		moveq	#1,d1
		add.l	d3,d1
		bsr	Move			; Move(rp,redrawx1,redrawy1+1);
		move.l	d4,d0
		moveq	#1,d1
		add.l	d5,d1
		bsr	Draw			; Draw(rp,redrawx2,redrawy2+1);
6$		cmp.l	d2,d4			; if (redrawx1 > redrawx2)
		bcc.s	5$
		exg.l	d2,d4			; redrawx1 <-> redrawx2
5$		tst.b	d6			; if (doublex)
		beq.s	4$
		addq.l	#1,d4			; redrawx2++;
4$		move.l	d2,ReDrawx1(bp)
		move.l	d4,ReDrawx2(bp)
		cmp.l	d3,d5			; if (redrawy1 > redrawy2)
		bcc.s	3$
		exg.l	d3,d5			; redrawy1 <-> redrawy2
3$		tst.b	d7			; if (doubley)
		beq.s	2$
		addq.l	#1,d5			; redrawy2++
2$		move.l	d3,ReDrawy1(bp)
		move.l	d5,ReDrawy2(bp)
1$		moveq	#1,d0			; all ok (for flags!)
		movem.l	(sp)+,d2-d7/a2/a6
		rts

***************************************************************************

SetPattern	movem.l	d2-d7,-(sp)
		move.w	#$5555,d2
		move.w	#$aaaa,d3
		lea	Must(bp),a0
		move.b	(a0)+,d4		; a
		move.b	(a0)+,d5		; b
		move.b	(a0)+,d6		; c
		move.b	(a0),d7			; d
		moveq	#-2,d0			; if (a!=b || c!=d)
		cmp.b	d4,d5
		bne.s	5$
		cmp.b	d6,d7
		bne.s	5$
		moveq	#-1,d0			; if (a==b && c==d)
5$		move.w	d0,xMask+2(bp)
		moveq	#-2,d0			; if (a!=c || b!=d)
		cmp.b	d4,d6
		bne.s	4$
		cmp.b	d5,d7
		bne.s	4$
		moveq	#-1,d0			; if (a==c && b==d)
4$		move.w	d0,yMask+2(bp)
		lea	Muster(bp),a0
		moveq	#0,d1
3$		btst	d1,d4			; (a&1<<i?0x5555:0)
		sne	d0
		ext.w	d0
		and.w	d2,d0
		btst	d1,d5			; (b&1<<i?0xaaaa:0)
		beq.s	2$
		or.w	d3,d0
2$		move.w	d0,(a0)+		; Muster[i][0]
		btst	d1,d6			; (c&1<<i?0x5555:0)
		sne	d0
		ext.w	d0
		and.w	d2,d0
		btst	d1,d7			; (d&1<<i?0xaaaa:0)
		beq.s	1$
		or.w	d3,d0
1$		move.w	d0,(a0)+		; Muster[i][1]
		addq.w	#1,d1
		cmpi.w	#8,d1
		bcs.s	3$			; for (i=0;i<8;i++)
		movem.l	(sp)+,d2-d7
		rts

***************************************************************************

projectSave	move.l	WbMsg(bp),d0
		beq.s	getname

cdtoicon	movem.l	d2/a2/a6,-(sp)		; wb
		move.l	WbArg(bp),d2
		beq.s	1$
		move.l	d2,a2
		move.l	0(a2),d1
		CALL	CurrentDir,DosBase(bp)	; change dir to icon
		move.l	d0,d2
		move.l	4(a2),a0
		bsr.s	savePrefs		; savePrefs(wa_name);
		move.l	d2,d1
		RECALL	CurrentDir		; set olddir
1$		movem.l	(sp)+,d2/a2/a6
		rts

getname		movem.l	d2/d3/a6,-(sp)		; cli
		moveq	#120,d0
		moveq	#0,d1
		CALL	AllocVec,SysBase(bp)
		move.l	d0,d3
		beq.s	1$
		move.l	d3,d1
		moveq	#120,d2
		CALL	GetProgramName,DosBase(bp)
		tst.l	d0
		beq.s	2$
		move.l	d3,a0
		bsr.s	savePrefs		; savePrefs(argv[0]);
2$		move.l	d3,a1
		CALL	FreeVec,SysBase(bp)
1$		movem.l	(sp)+,d2/d3/a6
		rts

savePrefs	movem.l	d2-d7/a2/a3/a6,-(sp)
		move.l	a0,d4			; save name ptr
		CALL	GetDiskObjectNew,IconBase(bp)
		move.l	d0,d7
		beq	1$
		moveq	#(((tt_Num*40)+15)&$fff0)>>4,d6
		lsl.w	#4,d6
		move.l	d7,a1
		move.l	54(a1),d1
		move.l	d1,a1
19$		tst.l	(a1)+
		bne.s	19$
		sub.l	d1,a1
		add.l	d6,a1
		moveq	#tt_Num*4,d0
		add.l	a1,d0
		moveq	#0,d1
		CALL	AllocVec,SysBase(bp)
		move.l	d0,d5
		beq	2$			; no buffer for ptr && tooltypes
		add.l	d5,d6
		move.l	d7,a0
		move.l	54(a0),a0
		move.l	d6,a1
18$		move.l	(a0)+,(a1)+		; copy ptrs to tooltypes
		bne.s	18$
		move.l	IconBase(bp),a6
		moveq	#0,d2
17$		move.l	d2,d0
		bsr	GetToolType
		move.l	a0,a3
		move.l	d6,a0
		move.l	a3,a1
		RECALL	FindToolType
		tst.l	d0
		beq.s	14$
		move.l	d6,a2
16$		addq.w	#4,a2
		tst.l	0(a2)
		beq.s	15$
		move.l	a2,a0
		move.l	a3,a1
		RECALL	FindToolType
		tst.l	d0
		bne.s	16$
15$		move.l	(a2)+,-8(a2)		; remove ptr to tooltype
		bne.s	15$
14$		addq.w	#1,d2
		cmpi.w	#tt_Num,d2
		bcs.s	17$
		lea	fmt1(pc),a0
		move.l	a0,d2			; format string
		move.l	d6,a2
13$		tst.l	(a2)+
		bne.s	13$
		subq.w	#4,a2			; ttypes[k]
		move.l	d5,a3			; buffer for sprintf
		moveq	#0,d0			; TOP
		move.l	WinPtr(bp),a1
		moveq	#0,d1
		move.w	6(a1),d1		; window->TopEdge
		bsr	SetToolType
		moveq	#1,d0			; LEFT
		move.l	WinPtr(bp),a1
		moveq	#0,d1
		move.w	4(a1),d1		; window->LeftEdge
		bsr	SetToolType
		moveq	#2,d0			; WIDTH
		move.l	Breite(bp),d1
		bsr	SetToolType
		moveq	#3,d0			; HEIGHT
		move.l	Hoehe(bp),d1
		bsr	SetToolType
		moveq	#4,d0			; SHOWFACE
		moveq	#0,d1
		move.b	zeigen(bp),d1
		bsr	SetToolType
		moveq	#5,d0			; HANDTYPE
		moveq	#0,d1
		move.b	zeigertyp(bp),d1
		bsr	SetToolType
		moveq	#6,d0			; HANDWIDTH
		moveq	#0,d1
		move.b	zeigerbreite(bp),d1
		bsr	SetToolType
		moveq	#7,d0			; BORDERTYPE
		moveq	#0,d1
		move.b	rahmenanz(bp),d1
		cmpi.w	#2,d1
		bne.s	11$
		tst.b	hires(bp)
		beq.s	12$
		addq.w	#1,d1
12$		tst.b	interlace(bp)
		beq.s	11$
		addq.w	#2,d1
11$		bsr	SetToolType
		moveq	#8,d0			; CHIME
		moveq	#0,d1
		move.b	chime(bp),d1
		beq.s	10$
		tst.b	smarthour(bp)
		beq.s	10$
		addq.w	#2,d1
10$		bsr	SetToolType
		lea	fmt2(pc),a0		; new format string
		move.l	a0,d2
		tst.b	sekunden(bp)
		beq.s	9$
		moveq	#9,d0			; SECONDS
		bsr	SetToolType
9$		tst.b	oval(bp)
		beq.s	8$
		moveq	#10,d0			; OVAL
		bsr	SetToolType
8$		tst.b	schatten(bp)
		beq.s	7$
		moveq	#11,d0			; SHADOW
		bsr	SetToolType
7$		tst.b	closegad(bp)
		beq.s	6$
		moveq	#12,d0			; CLOSEGAD
		bsr	SetToolType
6$		lea	fmt3(pc),a0
		move.l	a0,d2
		moveq	#13,d0			; DRAWPENS
		bsr	SetToolType
		lea	Pens(bp),a0
		moveq	#14-1,d0
		bsr	SetStr
		moveq	#14,d0			; PATTERN
		bsr	SetToolType
		lea	Must(bp),a0
		moveq	#4-1,d0
		bsr	SetStr
		clr.l	(a2)			; end list
		move.l	d4,a0
		move.l	d7,a1
		move.l	54(a1),d2		; ttypes1=dobj->ToolTypes;
		move.l	d6,54(a1)		; dobj->ToolTypes=ttypes2;
		RECALL	PutDiskObject
		move.l	d7,a1
		move.l	d2,54(a1)		; dobj->ToolTypes=ttypes1;
3$		move.l	d5,a1
		CALL	FreeVec,SysBase(bp)
2$		move.l	d7,a0
		CALL	FreeDiskObject,IconBase(bp)
1$		movem.l	(sp)+,d2-d7/a2/a3/a6
		rts

SetToolType	move.l	a3,(a2)+		; store ptr
		bsr.s	GetToolType
		move.l	a0,d0
		movem.l	d0/d1/a2/a6,-(sp)	; stuff args && save regs
		move.l	d2,a0
		move.l	sp,a1
		lea	sc_put(pc),a2
		CALL	RawDoFmt,SysBase(bp)	; sprintf()
		movem.l	(sp)+,d0/d1/a2/a6
		move.l	a3,a0
		move.l	a0,d0
1$		tst.b	(a0)+			; calc string length
		bne.s	1$
		suba.l	d0,a0
		adda.l	a0,a3			; next buffer
		rts

sc_put		move.b	d0,(a3)+		; stuffchar()
		rts

GetToolType	lea	tt_Tab(pc),a0		; get ptr to tooltype
		add.w	d0,d0
		adda.w	0(a0,d0.w),a0
		rts

SetStr		move.l	-4(a2),a3		; make a string
2$		tst.b	(a3)+
		bne.s	2$
		subq.w	#1,a3
1$		move.b	(a0),d1
		lsr.b	#4,d1
		bsr.s	dtox			; convert to decimal
		move.b	d1,(a3)+
		moveq	#$f,d1
		and.b	(a0)+,d1
		bsr.s	dtox			; convert to decimal
		move.b	d1,(a3)+
		dbra	d0,1$
		clr.b	(a3)+			; end string
		rts

dtox		addi.b	#'0',d1			; make ascii
		cmpi.b	#'9'+1,d1
		bcs.s	1$
		addq.b	#7,d1
1$		rts

***************************************************************************

TestAlarm	movem.l	d2/d3,-(sp)		; check for beep
		moveq	#0,d3
		move.w	std(bp),d3
		move.w	min(bp),d2
; st2 = std/5;
		divu	#5,d3
; if (!st2)
		tst.w	d3
		bne.s	7$
;    st2=12;
		moveq	#12,d3
; if (alarm && almin==min && alstd==st2)
7$		tst.b	alarm(bp)
		beq.s	6$
		lea	alarmtune(pc),a0
		cmp.w	almin(bp),d2
		bne.s	6$
		cmp.w	alstd(bp),d3
		beq.s	2$
; if (chime && !min)
6$		move.b	chime(bp),d1
		beq.s	1$
		tst.w	d2
		bne.s	5$
; calc -> &hourtune[smarthour?24-st2*2:22]
		lea	hourtune(pc),a0
		moveq	#22*2,d0
		tst.b	smarthour(bp)
		beq.s	3$
		moveq	#24*2,d0
		add.w	d3,d3
		add.w	d3,d3
		sub.w	d3,d0
		bra.s	3$
; if (chime==2 && (min==15 || min==30 || min==45))
5$		subq.b	#2,d1
		bne.s	1$
		lea	quartertune(pc),a0
		moveq	#6*2,d0			; max value
4$		subq.w	#2*2,d0
		sub.w	#15,d2
		bcs.s	1$			; diffrent from 15,30,45
		bne.s	4$
; startune(tune);
3$		lea	0(a0,d0.w),a0
2$		move.l	a0,PlayTune(bp)		; store tune address
		bsr.s	StartTune
1$		movem.l	(sp)+,d2/d3
		rts

;--------------------------------------------------------------------------

StartTune	movem.l	a2/a6,-(sp)
		tst.b	SoundOn(bp)
		bne.s	1$
		move.l	AudioIO+0(bp),a2
		move.b	#90,9(a2)		; ln_Pri = 90;
		move.w	#32,28(a2)		; io_Command = ADCMD_ALLOCATE;
		move.b	#1<<6,30(a2)		; io_Flags = ADIOF_NOWAIT;
		lea	cmap(pc),a0
		move.l	a0,34(a2)		; ioa_Data = ChannelMap;
		moveq	#4,d0
		move.l	d0,38(a2)		; ioa_Length = 4;
		move.l	a2,a1
		CALL	BeginIO,20(a1)
		move.l	a2,a1
		CALL	WaitIO,SysBase(bp)
		tst.l	d0
		bne.s	1$			; error !
		st	SoundOn(bp)
		moveq	#2,d0
		and.b	$bfe001,d0
		bne.s	2$			; filter is off !
		ori.b	#2,$bfe001
		st	filter(bp)
2$		move.l	a2,a0
		move.l	AudioIO+4(bp),a1
		moveq	#68,d0
		RECALL	CopyMemQuick		; fill second request
		bsr.s	PlayNote
		bsr.s	PlayNote
1$		movem.l	(sp)+,a2/a6
		rts

;--------------------------------------------------------------------------

PlayNote	move.l	a6,-(sp)
		moveq	#0,d0
		moveq	#0,d1
		move.b	reqnr(bp),d1		; old reqnr
		seq	d0
		neg.b	d0
		move.b	d0,reqnr(bp)		; new reqnr
		lea	AudioSent(bp),a1
		clr.b	0(a1,d1.w)		; audsent[reqnr]=0;
		move.l	PlayTune(bp),a0
		tst.w	0(a0)
		bne.s	2$			; tune not ready
		tst.b	0(a1,d0.w)
		bne.s	3$			; not last
		move.l	SysBase(bp),a6
		bsr.s	EndTune			; free channels
3$		bra.s	1$
2$		st	0(a1,d1.w)		; audsent[reqnr]=1;
		add.w	d1,d1
		add.w	d1,d1
		lea	AudioIO+0(bp),a1
		move.l	0(a1,d1.w),a1
		move.w	#3,28(a1)		; io_Command = CMD_WRITE;
		move.b	#1<<4,30(a1)		; io_Flags = ADIOF_PERVOL;
		add.l	WaveForm(bp),d1
		move.l	d1,34(a1)		; ioa_Data = &waveform[reqnr*4];
		moveq	#4,d0
		move.l	d0,38(a1)		; ioa_Length = 4;
		move.w	#500,42(a1)		; ioa_Period = 500;
		move.w	#64,44(a1)		; ioa_Volume = 64;
		move.w	0(a0),46(a1)		; ioa_Cycles = *playtune++;
		addq.l	#2,PlayTune(bp)
		CALL	BeginIO,20(a1)
1$		move.l	(sp)+,a6
		rts

;--------------------------------------------------------------------------

EndTune		clr.b	SoundOn(bp)
		tst.b	filter(bp)		; trigger filter ?
		beq.s	1$
		and.b	#$fd,$bfe001		; filter on
		clr.b	filter(bp)
1$		move.l	AudioIO+0(bp),a1
		move.w	#9,28(a1)		; ioa_Command = ADCMD_FREE
		jmp	_LVODoIO(a6)

***************************************************************************

; a0 - window table
; a1 - gadget tags

CreateRequest	movem.l	d2-d4/a2/a3/a6,-(sp)
		move.l	a0,a3
		move.l	a1,d2
		lea	NewWinBuf+18(bp),a0	; *glistpointer (temp)
		clr.l	(a0)
		CALL	CreateContext,GadsBase(bp)
		move.l	d0,d4
		beq	1$
		lea	NewWinBuf(bp),a2
		move.l	#100<<16+100,0(a2)	; left && top
		clr.l	4(a2)			; width && height
		moveq	#0,d0
		move.w	(a3)+,d0		; flags as a word
		move.l	d0,10(a2)		; idcmp
		move.l	#$1100e,14(a2)		; flags
		moveq	#0,d0
		move.b	(a3)+,d0		; string number
		bsr	GetLocStr
		move.l	d0,26(a2)		; window title
		clr.w	NewGad+16(bp)		; clear gadget id
		move.b	(a3)+,d3		; gadget counter
4$		lea	NewGad(bp),a2		; structure to fill
		move.l	WinPtr(bp),a0
		move.l	46(a0),a0		; screen
		moveq	#0,d0			; LeftEdge
		move.b	(a3)+,d0
		add.b	36(a0),d0		; screen->WBorLeft;
		move.w	d0,0(a2)
		moveq	#1,d0			; TopEdge
		add.b	(a3)+,d0
		add.b	35(a0),d0		; screen->WBorTop
		add.w	142(a0),d0		; screen->RastPort.TxHeight
		move.w	d0,2(a2)
		move.b	(a3)+,5(a2)		; Width
		move.b	(a3)+,7(a2)		; Height
		moveq	#0,d0
		move.b	(a3)+,d0
		beq.s	3$			; no text
		bsr	GetLocStr
3$		lea	TextAttr(bp),a0
		movem.l	d0/a0,8(a2)		; text && font to use
		addq.w	#1,16(a2)		; increment GadgetID
		move.l	VisualInfo(bp),22(a2)
		moveq	#0,d0
		move.b	(a3)+,d0
		move.l	d4,a0
		lea	NewGad(bp),a1
		move.l	d2,a2
		move.l	0(a2),a2
		RECALL	CreateGadgetA
		move.l	d0,d4
		beq.s	2$			; error !
		addq.l	#4,d2
		subq.b	#1,d3
		bne.s	4$			; not ready
		lea	NewWinBuf(bp),a0
		lea	windowtags(pc),a1
		CALL	OpenWindowTagList,IntBase(bp)
		move.l	d0,d2
		beq.s	2$			; no window ...
		move.l	d2,a0
		move.w	#-1,a1
		lea	ProgName(pc),a2
		RECALL	SetWindowTitles		; according screentitle
		move.l	d2,a0
		suba.l	a1,a1
		CALL	GT_RefreshWindow,GadsBase(bp)
		move.l	d2,d0
		move.l	NewWinBuf+18(bp),d1	; return glist
		bra.s	1$
2$		move.l	NewWinBuf+18(bp),a0	; glistpointer
		CALL	FreeGadgets,GadsBase(bp)
		moveq	#0,d0
1$		movem.l	(sp)+,d2-d4/a2/a3/a6
		rts

***************************************************************************

GetLocStr	move.l	a6,-(sp)		; get localized string
		lea	LocaleTab(pc),a1
		move.l	d0,d1
		add.w	d0,d0
		add.w	0(a1,d0.w),a1		; default !
		move.l	a1,d0
		tst.l	Catalog(bp)
		beq.s	1$			; no catalog !
		move.l	Catalog(bp),a0
		move.l	d1,d0
		CALL	GetCatalogStr,LocBase(bp)
1$		move.l	(sp)+,a6
		rts

***************************************************************************

; 32-bit division (only positive values!)

LDiv		movem.l	d2/d3,-(sp)
		move.w	d1,d3
		move.w	d0,d2
		clr.w	d0
		swap	d0
		divu.w	d3,d0
		move.l	d0,d1
		swap	d0
		move.w	d2,d1
		divu.w	d3,d1
		move.w	d1,d0
		clr.w	d1
		swap	d1
		movem.l	(sp)+,d2/d3
		rts

***************************************************************************

; static data

GadgetList	dc.b	$03,$80			; GTYP_CLOSE
		dc.b	$13,$40			; GTYP_DEPTH
		dc.b	$1b,$10			; GTYP_SIZING
		dc.b	$63,$20			; GTYP_WDRAGGING

sizes		dc.b	0,0,3,2,-3,0,3,2,-3,-2,3,2,0,2,0,-4

colwintab	WINIT	$240,Choose,1		; window && gadget defintion
		GITEM	4,2,144,68,0,8

almwintab	WINIT	$270,Alarm,4		; window && gadget definition
		GITEM	42,15,20,39,0,11
		GITEM	82,15,20,39,0,11
		GITEM	2,58,70,12,Use,1
		GITEM	76,58,70,12,Cancel,1

		cnop	0,4

almgadtags1	dc.l	$80080026,1		; GSTL_Min,1
		dc.l	$80080027,12		; GSTL_Max,12
		dc.l	$80080029,10		; GSTL_MaxLevelLen,10
		dc.l	$8008002B,4		; GSTL_PlaceText,PLACETEXT_ABOVE
		dc.l	$80031001,2		; PGA_FREEDOM,LORIENT_VERT
		dc.l	$80030016,1		; GA_Relverify,TRUE
		dc.l	0

almgadtags2	dc.l	$80080026,0		; GSTL_Min,0
		dc.l	$80080027,59		; GSTL_Max,59
		dc.l	$80080029,5		; GSTL_MaxLevelLen,5
		dc.l	$8008002B,4		; GSTL_PlaceText,PLACETEXT_ABOVE
		dc.l	$80031001,2		; PGA_FREEDOM,LORIENT_VERT
		dc.l	$80030016,1		; GA_Relverify,TRUE
		dc.l	0

windowtags	dc.l	$80000076,148		; WA_InnerWidth,width
		dc.l	$80000077,72		; WA_InnerHeight,height
		dc.l	0

MenuTag		dc.l	$80080043,1		; GTMN_NewLookMenus,TRUE
		dc.l	0

MenuList	MITEM   1,Project,0,0,0		; menu structure (compact)
		 MITEM   2,About,0,0
		 MITEM	 2,SavePrefs,0,0
		 MITEM	 2,Quit,0,0
		MITEM	1,Settings,0,0
		 MITEM	 2,Seconds,9,0
		 MITEM	 2,Oval,9,0
		 MITEM	 2,Show,0,0
		  MITEM	  3,Minutes,1,2|4|8|16
		  MITEM	  3,Hours,1,1|4|8|16
		  MITEM	  3,Quarter,1,1|2|8|16
		  MITEM	  3,One,1,1|2|4|16
		  MITEM	  3,None,1,1|2|4|8
		 MITEM	 2,Hands,0,0
		  MITEM	  3,Line,1,2|4|8
		  MITEM	  3,Triangle,1,1|4|8
		  MITEM	  3,Rhombus,1,1|2|8
		  MITEM	  3,Rectangle,1,1|2|4
		  MITEM	  3,-1,0,0
		  MITEM	  3,VeryThin,1,128+(2|4|8|16)
		  MITEM	  3,Thin,1,128+(1|4|8|16)
		  MITEM	  3,Normal,1,128+(1|2|8|16)
		  MITEM	  3,Thick,1,128+(1|2|4|16)
		  MITEM	  3,VeryThick,1,128+(1|2|4|8)
		 MITEM	 2,Shadow,9,0
		 MITEM	 2,Border,0,0
		  MITEM	  3,None,1,2|4
		  MITEM	  3,Single,1,1|4
		  MITEM	  3,Double,1,1|2
		  MITEM	  3,-1,0,0
		  MITEM	  3,Hires,9,0
		  MITEM	  3,Interlace,9,0
		 MITEM	 2,Chime,0,0
		  MITEM	  3,None,1,2|4
		  MITEM	  3,Hours,1,1|4
		  MITEM	  3,Quarter,1,1|2
		  MITEM	  3,-1,0,0
		  MITEM	  3,Smart,9,0
		 MITEM	 2,Alarm,0,0
		  MITEM	  3,Set,0,0
		  MITEM	  3,On,9,0
		 MITEM	 2,CloseGad,9,0
		MITEM	1,Colors,0,0
		 MITEM	 2,Seconds,0,0
		 MITEM	 2,MinAPen,0,0
		 MITEM	 2,MinOPen,0,0
		 MITEM	 2,HourAPen,0,0
		 MITEM	 2,HourOPen,0,0
		 MITEM	 2,Shadow,0,0
		 MITEM	 2,Str12,0,0
		 MITEM	 2,Quarter,0,0
		 MITEM	 2,Hours,0,0
		 MITEM	 2,Minutes,0,0
		 MITEM	 2,Border0,0,0
		 MITEM	 2,Border1,0,0
		 MITEM	 2,Border2,0,0
		 MITEM	 2,Border3,0,0
		MITEM	1,Pattern,0,0
		 MITEM	 2,Color0,0,0
		 MITEM	 2,Color1,0,0
		 MITEM	 2,Color2,0,0
		 MITEM	 2,Color3,0,0

LocaleTab	ADDLOC	Project,0		; all strings
		ADDLOC	About
		ADDLOC	AboutKey
		ADDLOC	SavePrefs
		ADDLOC	SaveKey
		ADDLOC	Quit
		ADDLOC	QuitKey
		ADDLOC	Settings
		ADDLOC	Seconds
		ADDLOC	Oval
		ADDLOC	Show
		ADDLOC	Minutes
		ADDLOC	Hours
		ADDLOC	Quarter
		ADDLOC	One
		ADDLOC	None
		ADDLOC	Hands
		ADDLOC	Line
		ADDLOC	Triangle
		ADDLOC	Rhombus
		ADDLOC	Rectangle
		ADDLOC	VeryThin
		ADDLOC	Thin
		ADDLOC	Normal
		ADDLOC	Thick
		ADDLOC	VeryThick
		ADDLOC	Shadow
		ADDLOC	Border
		ADDLOC	Single
		ADDLOC	Double
		ADDLOC	Hires
		ADDLOC	Interlace
		ADDLOC	Chime
		ADDLOC	Smart
		ADDLOC	Alarm
		ADDLOC	Set
		ADDLOC	On
		ADDLOC	CloseGad
		ADDLOC	Colors
		ADDLOC	MinAPen
		ADDLOC	MinOPen
		ADDLOC	HourAPen
		ADDLOC	HourOPen
		ADDLOC	Str12
		ADDLOC	Border0
		ADDLOC	Border1
		ADDLOC	Border2
		ADDLOC	Border3
		ADDLOC	Pattern
		ADDLOC	Color0
		ADDLOC	Color1
		ADDLOC	Color2
		ADDLOC	Color3
		ADDLOC	Description
		ADDLOC	Choose
		ADDLOC	Use
		ADDLOC	Cancel

LOCALE_START					; locale area begin

; CATALOG TolleUhr
; VERSION 1.2
; CATDATE 07.03.94

m_Project	dc.b	'Project',0
; D			'Projekt',0
m_About		dc.b	'About',0
; D			'ber',0
m_AboutKey	dc.b	'?',0
; D			'?',0
m_SavePrefs	dc.b	'Save Prefs',0
; D			'Speichern',0
m_SaveKey	dc.b	'S',0
; D			'S',0
m_Quit		dc.b	'Quit',0
; D			'Ende',0
m_QuitKey	dc.b	'Q',0
; D			'E',0
m_Settings	dc.b	'Settings',0
; D			'Einstellungen',0
m_Seconds	dc.b	'Seconds',0
; D			'Sekunden',0
m_Oval		dc.b	'Oval',0
; D			'Oval',0
m_Show		dc.b	'Show',0
; D			'Zeigen',0
m_Minutes	dc.b	'Minutes',0
; D			'Minuten',0
m_Hours		dc.b	'Hours',0
; D			'Stunden',0
m_Quarter	dc.b	'Quarter',0
; D			'Viertel',0
m_One		dc.b	'One',0
; D			'Eins',0
m_None		dc.b	'None',0
; D			'Nichts',0
m_Hands		dc.b	'Hands',0
; D			'Zeiger',0
m_Line		dc.b	'Line',0
; D			'Linie',0
m_Triangle	dc.b	'Triangle',0
; D			'Dreieck',0
m_Rhombus	dc.b	'Rhombus',0
; D			'Raute',0
m_Rectangle	dc.b	'Rectangle',0
; D			'Rechteck',0
m_VeryThin	dc.b	'Very Thin',0
; D			'Sehr Dnn',0
m_Thin		dc.b	'Thin',0
; D			'Dnn',0
m_Normal	dc.b	'Normal',0
; D			'Normal',0
m_Thick		dc.b	'Thick',0
; D			'Dick',0
m_VeryThick	dc.b	'Very Thick',0
; D			'Sehr Dick',0
m_Shadow	dc.b	'Shadow',0
; D			'Schatten',0
m_Border	dc.b	'Border',0
; D			'Rand',0
m_Single	dc.b	'Single',0
; D			'Einfach',0
m_Double	dc.b	'Double',0
; D			'Doppelt',0
m_Hires		dc.b	'HiRes',0
; D			'HiRes',0
m_Interlace	dc.b	'Interlace',0
; D			'Interlace',0
m_Chime		dc.b	'Chime',0
; D			'Glocke',0
m_Smart		dc.b	'Smart',0
; D			'Elegant',0
m_Alarm		dc.b	'Alarm',0
; D			'Alarm',0
m_Set		dc.b	'Set',0
; D			'Stellen',0
m_On		dc.b	'On',0
; D			'An',0
m_CloseGad	dc.b	'Close Gadget',0
; D			'Close Gadget',0
m_Colors	dc.b	'Colors',0
; D			'Farben',0
m_MinAPen	dc.b	'Min. APen',0
; D			'Min. APen',0
m_MinOPen	dc.b	'Min. Open',0
; D			'Min. OPen',0
m_HourAPen	dc.b	'Hour Apen',0
; D			'Std. APen',0
m_HourOPen	dc.b	'Hour Open',0
; D			'Std. OPen',0
m_Str12		dc.b	'12',0
; D			'12',0
m_Border0	dc.b	'Border 0',0
; D			'Rand 0',0
m_Border1	dc.b	'Border 1',0
; D			'Rand 1',0
m_Border2	dc.b	'Border 2',0
; D			'Rand 2',0
m_Border3	dc.b	'Border 3',0
; D			'Rand 3',0
m_Pattern	dc.b	'Pattern',0
; D			'Muster',0
m_Color0	dc.b	'Color 0',0
; D			'Farbe 0',0
m_Color1	dc.b	'Color 1',0
; D			'Farbe 1',0
m_Color2	dc.b	'Color 2',0
; D			'Farbe 2',0
m_Color3	dc.b	'Color 3',0
; D			'Farbe 3',0
m_Description	dc.b	'a really nice clock !',0
; D			'Eine wirklich tolle Uhr !',0
m_Choose	dc.b	'Choose one:',0
; D			'Whle eine:',0
m_Use		dc.b	'Use',0
; D			'Benutzen',0
m_Cancel	dc.b	'Cancel',0
; D			'Abbruch',0

LOCALE_END					; locale area end

DosName		dc.b	'dos.library',0
IconName	dc.b	'icon.library',0
IntName		dc.b	'intuition.library',0
GfxName		dc.b	'graphics.library',0
GadsName	dc.b	'gadtools.library',0
LocName		dc.b	'locale.library',0
LocCat		dc.b	'tolleuhr.catalog',0
TimerName	dc.b	'timer.device',0
AudioName	dc.b	'audio.device',0
TopazName	dc.b	'topaz.font',0

template	dc.b	'/M,TOP/N,LEFT/N,WIDTH/N,HEIGHT/N,SECONDS/S,PATTERN/K,'
		dc.b	'OVAL/S,SHADOW/S,SHOWFACE/N,HANDTYPE/N,HANDWIDTH/N,'
		dc.b	'DRAWPENS/K,BORDERTYPE/N,CHIME/N,CLOSEGAD/S,'
		dc.b	'PUBSCREEN/K,TASKPRI/N',0

linefeed	dc.b	10,0

		dc.b	'$VER:'
ProgName	dc.b	'TolleUhr 1.2 (07.03.94)  1993/94 by M.Fleischer and G.Nikl',0

fmt1		dc.b	'%s=%ld',0		; format templates for tooltypes
fmt2		dc.b	'%s',0
fmt3		dc.b	'%s=0x',0
fmt4		dc.b	'%2ld',0
fmt5		dc.b	'%02ld',0

		cnop	0,2

; !!!! do NOT change table order !!!!!

tt_Tab		ADDCMD	tt_,top,0
		ADDCMD	tt_,left
		ADDCMD	tt_,width
		ADDCMD	tt_,height
		ADDCMD	tt_,showface
		ADDCMD	tt_,handtype
		ADDCMD	tt_,handwidth
		ADDCMD	tt_,bordertype
		ADDCMD	tt_,chime
		ADDCMD	tt_,seconds
		ADDCMD	tt_,oval
		ADDCMD	tt_,shadow
		ADDCMD	tt_,closegad
		ADDCMD	tt_,drawpens
		ADDCMD	tt_,pattern

tt_top		dc.b	'TOP',0
tt_left		dc.b	'LEFT',0
tt_width	dc.b	'WIDTH',0
tt_height	dc.b	'HEIGHT',0
tt_showface	dc.b	'SHOWFACE',0
tt_handtype	dc.b	'HANDTYPE',0
tt_handwidth	dc.b	'HANDWIDTH',0
tt_bordertype	dc.b	'BORDERTYPE',0
tt_chime	dc.b	'CHIME',0
tt_seconds	dc.b	'SECONDS',0
tt_oval		dc.b	'OVAL',0
tt_shadow	dc.b	'SHADOW',0
tt_closegad	dc.b	'CLOSEGAD',0
tt_drawpens	dc.b	'DRAWPENS',0
tt_pattern	dc.b	'PATTERN',0

		cnop	0,2

handwidth	dc.w	4000,3250,2500,1750,1000

; sound data

alarmtune	dc.w	800,800,800,800,800,800,800,1600
		dc.w	800,800,800,800,800,800,800,1600
		dc.w	800,800,800,800,800,800,800,1600
		dc.w	800,800,800,800,800,800,800,1600
		dc.w	800,800,800,800,800,800,800,4,0

hourtune	dc.w	800,1600,800,1600,800,1600,800,1600
		dc.w	800,1600,800,1600,800,1600,800,1600
		dc.w	800,1600,800,1600,800,1600,800,4,0

quartertune	dc.w	400,400,400,400,400,4,0

; sound channel allocation map

cmap		dc.b	1,2,4,8

; Farbnummern (defaults)

pens		dc.b	2,0,2,0,2,1,2,2,2,2,0,1,2,3

; Indizes fuer Zifferblatt

pent		dc.b	6,8,8,7,8,8,7,8,8,7,8,8

; fr ovales Zifferblatt

sinus		dc.b	$00,$0D,$1A,$27,$34,$40,$4B,$55,$5E,$67
		dc.b	$6E,$74,$79,$7C,$7E,$7F,$7E,$7C,$79,$74
		dc.b	$6E,$67,$5E,$55,$4B,$40,$34,$27,$1A,$0D
		dc.b	$00,$F3,$E6,$D9,$CC,$C0,$B5,$AB,$A2,$99
		dc.b	$92,$8C,$87,$84,$82,$81,$82,$84,$87,$8C
		dc.b	$92,$99,$A2,$AB,$B5,$C0,$CC,$D9,$E6,$F3

cosinus		dc.b	$7F,$7E,$7C,$79,$74,$6E,$67,$5E,$55,$4B
		dc.b	$40,$34,$27,$1A,$0D,$00,$F3,$E6,$D9,$CC
		dc.b	$C0,$B5,$AB,$A2,$99,$92,$8C,$87,$84,$82
		dc.b	$81,$82,$84,$87,$8C,$92,$99,$A2,$AB,$B5
		dc.b	$C0,$CC,$D9,$E6,$F3,$00,$0D,$1A,$27,$34
		dc.b	$40,$4B,$55,$5E,$67,$6E,$74,$79,$7C,$7E

; fr rechteckiges Zifferblatt

srect		dc.b	$00,$0D,$1B,$29,$39,$49,$5C,$6F,$7C,$7F
		dc.b	$7F,$7F,$7F,$7F,$7F,$7F,$7F,$7F,$7F,$7F
		dc.b	$7F,$7F,$7C,$6F,$5C,$49,$39,$29,$1B,$0D
		dc.b	$00,$F3,$E5,$D7,$C7,$B7,$A4,$91,$84,$81
		dc.b	$81,$81,$81,$81,$81,$81,$81,$81,$81,$81
		dc.b	$81,$81,$84,$91,$A4,$B7,$C7,$D7,$E5,$F3

crect		dc.b	$7F,$7F,$7F,$7F,$7F,$7F,$7F,$7C,$6F,$5C
		dc.b	$49,$39,$29,$1B,$0D,$00,$F3,$E5,$D7,$C7
		dc.b	$B7,$A4,$91,$84,$81,$81,$81,$81,$81,$81
		dc.b	$81,$81,$81,$81,$81,$81,$81,$84,$91,$A4
		dc.b	$B7,$C7,$D7,$E5,$F3,$00,$0D,$1B,$29,$39
		dc.b	$49,$5C,$6F,$7C,$7F,$7F,$7F,$7F,$7F,$7F

; Daten fr Zifferblatt

dx1		dc.b	$FE,$02,$01,$FE,$01,$02,$FE,$FE,$FF,$FE,$FF,$FE
dy1		dc.b	$FC,$FF,$FE,$FE,$02,$01,$FE,$01,$02,$FE,$FE,$FF
dx2		dc.b	$04,$FE,$01,$04,$01,$FE,$04,$02,$FF,$04,$FF,$02
dy2		dc.b	$00,$03,$02,$00,$FE,$FD,$00,$FD,$FE,$00,$02,$03
dx3		dc.b	$00,$FE,$FD,$00,$FD,$FE,$00,$02,$03,$00,$03,$02
dy3		dc.b	$08,$FF,$02,$04,$FE,$01,$04,$01,$FE,$04,$02,$FF
dx4		dc.b	$FC,$02,$FF,$FC,$FF,$02,$FC,$FE,$01,$FC,$01,$FE
dy4		dc.b	$00,$FD,$FE,$00,$02,$03,$00,$03,$02,$00,$FE,$FD

		end
