{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - REIGISTER PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: REGISTER.PAS
              Helps the user create a Registration form.
}

Program REGISTER;

{$I GOLDFLAG.INC}

uses CRT, GoldAttr, GoldMisc, GoldFast, GoldList, Goldkey, GoldDir, GoldDate,
          GoldStr, GoldWin, GoldLink, GoldIO, GoldIO2, GoldIO3, GoldRead;

var
  Response: integer;
  {IO form vars}
  Name,
  Address,
  City,
  State,
  Zip,
  Country,
  Tel,
  Fax,
  EMail: string[80];
  Copies: longint;
  PostalZone: integer;
  PrevPayment: integer;
  Creditcash: byte;
  Visa: byte;
  CardName,
  CardAddress,
  CardNum,
  CardExpire: string;

  CostUnit,
  CostTaxes,
  CostShip,
  CostTotal: real;

const
   CashTax = 0.08;
   CreditTax = 0.0825;
   BasePrice = 89.95;
   ShipUS = 6.00;
   ShipCanada = 10.00;
   ShipMexico = 15.00;
   ShipEurope = 25.00;
   ShipOther = 30.00;
   ValError = ' Validation Error ';

{$F+}
procedure CheckPayment(CurrentField:byte;var Refresh:byte);
{Manages field enabling based on value of payment method}
var
  FieldState: gActiveState;

   procedure GrayFields;
   var I: integer;
   begin
      if (PrevPayment = CreditCash) then
         exit;
      if CreditCash > 1 then
         FieldState := FldOff
      else
         FieldState := FldOn;
      for I := 11 to 15 do
        FieldSetState(I,FieldState);
      PrevPayment := CreditCash;
      Refresh := RefreshAll;
   end;

   function Value(Input:Real):string;
   begin
      Value := padright('$'+RealtoStr(Input,2),8,' ');
   end;

   procedure UpdateCost;
   const RM=68;
   begin
      CostUnit := BasePrice*Copies;
      case PostalZone of
        1: CostShip := 0.00;
        2,3: CostShip := ShipUS*Copies;
        4: CostShip := ShipCanada*Copies;
        5: CostShip := ShipMexico*Copies;
        6: CostShip := ShipEurope*Copies;
        else
           CostShip := ShipOther*Copies;
      end;
      if PostalZone <> 2 then
         CostTaxes := 0
      else
      begin
         if CreditCash = 1 then
            CostTaxes := (CostShip + CostUnit) * CreditTax
         else
            CostTaxes := (CostShip + CostUnit) * CashTax
      end;
      CostTotal := CostUnit + CostShip + CostTaxes;
      WriteRight(RM,20,blueonlightgray,Value(CostUnit));
      if CostShip = 0 then
      begin
         WriteRight(RM,21,blueonlightgray,'Unknown');
         WriteRight(RM,22,blueonlightgray,'Unknown');
         WriteRight(RM,23,blueonlightgray,'Unknown');
      end
      else
      begin
         WriteRight(RM,21,blueonlightgray,Value(CostShip));
         WriteRight(RM,22,blueonlightgray,Value(CostTaxes));
         WriteRight(RM,23,blueonlightgray,Value(CostTotal));
      end;
   end;

begin
   case CurrentField of
     0,10: begin
        GrayFields;
        UpdateCost;
     end;
     16,17: UpdateCost;
   end;
end; {CheckFormats}
{$F-}

{$F+}
function MyFinishHook:byte;
{}
begin
   MyFinishHook := 0; {assume all is well}
   {check to see that the postal zone is assigned}
   if PostalZone = 1 then
   begin
      PromptOk(ValError,'You must select a postal zone before printing');
      MyFinishHook := 16;
   end
   else if CreditCash = 1 then
   begin
      if length(CardNum) < 10 then
      begin
        PromptOk(ValError,'Enter a valid card number');
        MyFinishHook := 14;
      end
      else if length(CardExpire) < 4 then
      begin
        PromptOk(ValError,'Enter your cards expiration date in the MM/YY format.');
        MyFinishHook := 15;
      end;
   end;
end;
{$F-}

procedure InitVars;
const
   LM = 21; {left margin}
   XM = 5;  {extra indent}
begin
   Name := '';
   Address := '';
   City := '';
   State := '';
   Zip := '';
   Country := '';
   Tel := '';
   Fax := '';
   Email := '';
   Copies := 1;
   Visa := 1;
   PrevPayment := -1; {ensures fields are enabled first time through}
   Creditcash := 1;
   PostalZone := 1;
   CardName := 'As Above';
   CardAddress := 'As Above';
   CardNum := '';
   CardExpire := '';
   CreateForms(1);
   {Set up the Hind hook for checking field entries on the fly}
   AssignHindHook(CheckPayment);
   AssignFinishedHook(MyFinishHook);
   SetValidation(ValidateAtEnd);
   KwikAddField(1,LM,3);
   KwikAddField(2,LM,4);
   KwikAddField(3,LM,5);
   KwikAddField(4,LM,6);
   KwikAddField(5,58,6);
   KwikAddField(6,LM,7); {country}
   KwikAddField(7,10,8); {tel}
   KwikAddField(8,33,8); {fax }
   KwikAddField(9,58,8); {email}
   KwikAddField(10,LM,10); {cash or credit}
   KwikAddField(11,LM+33,10); {credit type}
   KwikAddField(12,LM+XM,15); {credit name}
   KwikAddField(13,LM+XM,16); {credit address}
   KwikAddField(14,LM+XM,17); {credit number}
   KwikAddField(15,LM+50,17); {expires}
   KwikAddField(16,LM+XM,19); {postal zone}
   KwikAddField(17,LM+19,20); {how many}
   { buttons }
   KwikAddField(18, 10, 22);
   KwikAddLastField(19, 30,22);
   { Name }
   StringField(1,Name,Replicate(55,'*'));
   SetLabel(1,LabelLeft,LabelLeft,'~N~ame');
   SetHK(1,305);
   SetMessage(1,0,0,'Enter your first and last name');
   FieldRules(1,NoRules+EraseDefault,[NoChar],[NoChar]);
   { Address }
   StringField(2,Address,Replicate(55,'*'));
   SetLabel(2,LabelLeft,LabelLeft,'~A~ddress');
   SetHK(2,286);
   SetMessage(2,0,0,'Enter your street + apartment address');
   FieldRules(2,NoRules+EraseDefault,[NoChar],[NoChar]);
   { City }
   StringField(3,City,Replicate(30,'*'));
   SetLabel(3,LabelLeft,LabelLeft,'~C~ity');
   SetHK(3,302);
   SetMessage(3,0,0,'Enter your city');
   FieldRules(3,NoRules+EraseDefault,[NoChar],[NoChar]);
   { State }
   StringField(4,State,Replicate(22,'*'));
   SetLabel(4,LabelLeft,LabelLeft,'~S~tate/Province');
   SetHK(4,287);
   SetMessage(4,0,0,'Enter your State or Province');
   { Zip }
   StringField(5,Zip,Replicate(18,'*'));
   SetLabel(5,LabelLeft,LabelLeft,'~Z~ip/Postcode');
   SetHK(5,300);
   SetMessage(5,0,0,'Enter your Zip or Postal code');
   { Country }
   StringField(6,Country,Replicate(30,'*'));
   SetLabel(6,LabelLeft,LabelLeft,'~C~ountry');
   SetHK(6,302);
   SetMessage(6,0,0,'Enter your country (blank for USA)');
   { Telephone }
   StringField(7,Tel,Replicate(18,'*'));
   SetLabel(7,LabelLeft,LabelLeft,'~T~el');
   SetHK(7,276);
   SetMessage(7,0,0,'Enter your daytime telephone number');
   { Fax }
   StringField(8,Fax,Replicate(18,'*'));
   SetLabel(8,LabelLeft,LabelLeft,'~F~ax');
   SetHK(8,289);
   SetMessage(8,0,0,'Enter your FAX telephone number');
   { Email }
   StringField(9,Email,Replicate(18,'*'));
   SetLabel(9,LabelLeft,LabelLeft,'~E~mail');
   SetHK(9,289);
   SetMessage(9,0,0,'Enter your Email address');
   { Payment method }
   RadioField(10,20,4,CreditCash);
   RadioAddItem(10,1,1,'Credit Card','Paying by credit card',302);
   RadioAddItem(10,1,2,'Cash','Sending US dollar bills',294);
   RadioAddItem(10,1,3,'Check','Sending a US dollar check with an ABA routing number',294);
   RadioAddItem(10,1,4,'Money Order','Sending US dollar money order',294);
   SetLabel(10,LabelLeft,LabelLeft,'Payment method');
   {Card Type}
   RadioField(11,22,4,Visa);
   RadioAddItem(11,1,1,'Visa','Paying with Visa card',0);
   RadioAddItem(11,1,2,'Mastercard','Paying with Mastercard',0);
   RadioAddItem(11,1,3,'Discover','Paying with Discover card',0);
   RadioAddItem(11,1,4,'American Express','Paying with American Express card',0);
   SetLabel(11,LabelLeft,LabelLeft,'Card Type');
   { Credit Name }
   StringField(12,CardName,Replicate(30,'!'));
   SetLabel(12,LabelLeft,LabelLeft,'Card Holder''s Name');
   SetMessage(12,0,0,'Enter the name exactly as it appears on the card');
   { Credit Address }
   ScrollField(13,CardAddress,30,80);
   SetLabel(13,LabelLeft,LabelLeft,'Holder''s Address');
   SetMessage(13,0,0,'Enter the card holder''s address');
   {card number}
   StringField(14,CardNum,Replicate(30,'#'));
   SetLabel(14,LabelLeft,LabelLeft,'Card Number');
   SetMessage(14,0,0,'Enter your credit card number');
   {card expires}
   StringField(15,CardExpire,'##/##');
   SetLabel(15,LabelLeft,LabelLeft,'Card Expires');
   SetMessage(15,0,0,'When does the card expire? Format MM/YY');
   {Postal Zone}
   SpinDropListField(16,16,PostalZone);
   ListKwikAddItem(16,'(Not assigned)|Texas|USA|Canada|Mexico|Europe|Australasia|Other');
   SetLabel(16,LabelLeft,LabelLeft,'Postal Zone');
   SetMessage(16,0,0,'Select general postal zone (for computing S&H and taxes)');

   {Num copies}
   SpinLongField(17,Copies,2,1,95,1);
   SetLabel(17,LabelLeft,LabelLeft,'Number of copies              ');
   SetMessage(17,0,0,'How many copies of Gold do you want to order?');
   { Buttons }
   ButtonField(18,' Print Order ',Finished);
   SetMessage(18,0,0,'Print the order form');
   ButtonDefaultField(19,'  Close Form  ',Escaped);
   SetMessage(19,0,0,'Quit without printing the order form');
end;

procedure SetBackground;
begin
   Clear(whiteonblue,chr(177));
   ClearLine(1,lightgrayonblue);
   ClearLine(25,lightgrayonblue);
   WriteCenter(1,0,'Gold Registration');
   WriteCenter(25,0,'Copyright 1986-1995 TechnoJock Software, Inc.');
end;

procedure Benefits;
var
   StrLL: StringLL;
   Ecode: integer;
begin
   Clear(whiteonblue,chr(177));
   StrLLInit(StrLL);
   ECode := 0;
   inc(ECode, StrLLAdd(StrLL,'Gold is distributed as a ~Shareware~ product. When you register '));
   inc(ECode, StrLLAdd(StrLL,'your copy of the program, you not only get the latest version'));
   inc(ECode, StrLLAdd(StrLL,'of the toolkit, you also receive the following bonus features:'));
   inc(ECode, StrLLAdd(StrLL,''));
   inc(ECode, StrLLAdd(StrLL,'~Books~       You get two professionally bound and typeset manuals!'));
   inc(ECode, StrLLAdd(StrLL,''));
   inc(ECode, StrLLAdd(StrLL,'~Desktop~     The desktop unit allows you to easily create desktop'));
   inc(ECode, StrLLAdd(StrLL,'            applications with pulldown menus, status bar, etc.'));
   inc(ECode, StrLLAdd(StrLL,'            Run DEMOVIEW.EXE to see a slick desktop in action.'));
   inc(ECode, StrLLAdd(StrLL,''));
   inc(ECode, StrLLAdd(StrLL,'~Calculator~  Add a fully functional calculator to your apps with a'));
   inc(ECode, StrLLAdd(StrLL,'            couple of lines of code.'));
   inc(ECode, StrLLAdd(StrLL,''));
   inc(ECode, StrLLAdd(StrLL,'~INI Unit~    This unit makes it a snap to add Windows-style INI'));
   inc(ECode, StrLLAdd(StrLL,'            file support to your programs.'));
   inc(ECode, StrLLAdd(StrLL,''));
   inc(ECode, StrLLAdd(StrLL,'~Online Help~ The entire function reference as a BP7 help file.'));
   if ECode = 0 then
     PromptOKStrLL(' Benefits of Registration ',StrLL)
   else
     PromptOK(' OOPS ', 'There is insufficient memory to display the benefits');
   StrLLDestroy(StrLL);  {dispose of linked list}
end;

procedure OrderIt;
var
  PChoice: byte;

   procedure SetScreen;
   begin
      Clear(whiteonlightgray,' ');
      Box3D(1,1,80,24,blackonlightgray,whiteonlightgray,1);
      HorizLine(3,78,9,blackonlightgray,1);
      HorizLine(3,78,18,blackonlightgray,1);
      WriteCenter(1,whiteonred,' GOLD Order Form ' );
      ClearLine(25,lightgrayonblue);
      WriteAT(64,19,MagentaonLightgray,'Cost');
      WriteAT(55,20,MagentaonLightgray,'Gold');
      WriteAT(55,21,MagentaonLightgray,'S & H');
      WriteAT(55,22,MagentaonLightgray,'Taxes');
      WriteAT(55,23,MagentaonLightgray,'TOTAL');
   end;

   procedure PrintTheForm;
   const
      LM = 15;      {left margin}
      CM=  40;      {cash margin}
   var
     ThePort: Text;
   begin
     assign(ThePort,'LPT'+IntToStr(PChoice));
     rewrite(ThePort);
     writeln(ThePort,'GOLD Order Form        Printed: '+FancyDateStr(TodayInJul,false,false));
     writeln(ThePort);
     writeln(ThePort,Padleft('Name:',LM,' ')+Name);
     writeln(ThePort,Padleft('Address:',LM,' ')+Address);
     writeln(ThePort,Padleft('City/St/Zip:',LM,' ')+City+', '+State+', '+Zip);
     writeln(ThePort,Padleft('Country:',LM,' ')+Country);
     writeln(ThePort,'Tel: '+tel+' Fax: '+Fax+' Email: '+Email);
     writeln(ThePort);
     writeln(ThePort,Padleft('Copies:',LM,' ')+IntToStr(Copies));
     writeln(ThePort,Padleft('Extended price:',CM,' ')+PadRight('$'+RealToStr(CostUnit,2),8,' '));
     writeln(ThePort,Padleft('Taxes:',CM,' ')+PadRight('$'+RealToStr(CostTaxes,2),8,' '));
     writeln(ThePort,Padleft('Shipping & Handling:',CM,' ')+PadRight('$'+RealToStr(CostShip,2),8,' '));
     writeln(ThePort,Padleft('Total Cost:',CM,' ')+PadRight('$'+RealToStr(CostTotal,2),8,' '));
     writeln(ThePort);
     if Creditcash = 1 then {credit card order}
     begin
        writeln(ThePort);
        writeln(ThePort,'** CREDIT CARD ORDER **');
        writeln(ThePort);
        writeln(ThePort,Padleft('Card Holder:',LM,' ')+CardName);
        writeln(ThePort,Padleft('Card Address:',LM,' ')+CardAddress);
        write(ThePort,Padleft('Card Type:',LM,' '));
        case Visa of
          1: writeln(ThePort,'VISA');
          2: writeln(ThePort,'MASTERCARD');
          3: writeln(ThePort,'DISCOVER');
          4: writeln(ThePort,'AMERICAN EXPRESS');
        end;
        writeln(ThePort,Padleft('Card Number:',LM,' ')+CardNum);
        insert('/',CardExpire,3);
        writeln(ThePort,Padleft('Expires:',LM,' ')+CardExpire);
        writeln(ThePort);
        writeln(ThePort,'Mail or FAX to:');
        writeln(ThePort,Padleft('',LM,' ')+'Public Software Library');
        writeln(ThePort,Padleft('',LM,' ')+'PO Box 35705');
        writeln(ThePort,Padleft('',LM,' ')+'Houston TX 77235-5705');
        writeln(ThePort,Padleft('',LM,' ')+'USA');
        writeln(ThePort,Padleft('',LM,' ')+'FAX: (713) 524 6398');
    end
     else
     begin
        writeln(ThePort);
        writeln(ThePort,'** CASH/CHECK/MONEY ORDER **');
        writeln(ThePort);
        writeln(ThePort,'Mail to:');
        writeln(ThePort,Padleft('',LM,' ')+'TJ Software, Inc.');
        writeln(ThePort,Padleft('',LM,' ')+'6212 Sea Isle, Suite 300');
        writeln(ThePort,Padleft('',LM,' ')+'Galveston TX 77554');
        writeln(ThePort,Padleft('',LM,' ')+'USA');
        writeln(ThePort,Padleft('',LM,' ')+'FAX: (713) 524 6398');
     end;
     writeln(ThePort);
     writeln(ThePort,'In the software business since Tuesday!');
   end;

begin
   SetScreen;
   DisplayForm;
   if EditForm(1) = Finished then
   begin
      repeat
        PChoice := PromptRadio(0,0,'Which printer port?',
          'Select a printer', 'LPT1|LPT2|LPT3',1);
        if ReadVars.LastAction <> Escaped then
        begin
          MiscVars.LptPort := pred(PChoice);
          if not PrinterReady then
            PromptOK(' Printer Error ', 'Check the printer is online and ready, or choose another port')
          else  {lets print the sucker}
          begin
             PrintTheForm;
             PChoice := 0;
             PromptOK(' Thank-you ', 'We appreciate your support!');
          end;
        end;
      until (PChoice = 0) or (ReadVars.LastAction = Escaped);
   end;
end;

begin
{$IFOPT D+}
  HeapRecord;
{$ENDIF}
  MouseShow(true);
  InitVars;
  Response := 1;
  repeat
    SetBackground;
    Response := PromptCustom(' Gold Registration ','|This application explains the '+
      'benefits of registering|Gold, and provides a fill-in-the-blanks '+
      'form to help|you print an order form. Alternatively, you can edit|'+
      'and print the text file ORDERFRM.DOC.|',' ~B~enefits ','  ~O~rder  ','   ~Q~uit   ',
      304,280,272,Response,0);
    if Response = 1 then
      Benefits
    else if Response = 2 then
      OrderIt;
  until Response = 3;
  MouseShow(false);
  DisposeFields;
  DisposeForms;
  ResetStartupMode;
{$IFOPT D+}
  HeapCheck;
{$ENDIF}
end.