{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit                       }
{                Version: GOLD                                             }
{                Build:   1.00                                             }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                    {**********************************}
                    {**       Unit:   GTTTREAD       **}
                    {**********************************}

{$S-,R-,V-}
{$IFNDEF DEBUG}
   {$D-}
{$ENDIF}

Unit GTTTREAD;

Interface

uses CRT, GoldAttr, GoldFast, GoldWin, GoldStr, GoldKey, GoldHard;

type
   RDisplay = record
      WhiteSpace: char;       {used to pad input field - default }
      AllowEsc: boolean;      {allow the he user to escape?}
      Beep: boolean;          {allow the old proverbial beep}
      Insert: boolean;        {initially in insert mode?}
      BegCursor: boolean;     {place cursor at beginning of line}
      AllowNull: boolean;     {allow user to input a '' or null value}
      RightJustify: boolean;  {right justify string on termination}
      EraseDefault: boolean;  {clear entry of alphanumeric pressed}
      SuppressZero: boolean;  {have empty field is value = zero}
      FCol: byte;             {normal foreground color of input field}
      BCol: byte;             {normal background of input field}
      HiFCol: byte;           {highlighted fgnd color for ReadSelect}
      HiBCol: byte;           {highlighted bgnd color for ReadSelect}
      LoFCol: byte;           {normal fgnd color for ReadSelect}
      LoBCol: byte;           {normal bgnd color for ReadSelect}
      PFcol: byte;            {prompt foreground color}
      PBCol: byte;            {prompt background color}
      BoxFCol: byte;          {box foreground color}
      BoxBCol: byte;          {Box background color}
      MsgFCol: byte;          {Foreground color for error messages}
      MsgBCol: byte;          {Background color for error messages}
      MsgLine: byte;          {line for error messages}
      Endchars: set of char;  {end of input chars}
      RealDP: byte;           {no of decimal places on real}
   end;

const NoPrompt:string[1] = '';

var   RTTT: RDisplay;
      RChar: char;
      RNull: boolean;

procedure DefaultSettings;
procedure ReadLine(X,Y,L,F,B,Format: byte; var Text: string);
procedure ReadString(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                                       var Txt: StrScreen);
procedure ReadStringUpper(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                                       var Txt: StrScreen);
procedure ReadPassword(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                                       var Txt: StrScreen);
procedure ReadAlpha(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                                       var Txt: StrScreen);
procedure ReadYN(X,Y: byte; Prompt: StrScreen; BoxType: byte;
                                       var Yes:Boolean);
procedure ReadByte(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                                       var B : byte; Min, Max: byte);
procedure ReadWord(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                                       var W: word; Min, Max: word);
procedure ReadInt(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                                       var W: integer; Min, Max: integer);
procedure ReadLongInt(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                                       var W: longint; Min, Max: longint);
procedure ReadReal(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                                       var W: real; Min, Max: real);
procedure ReadSelect(X,Y: byte;Pmt,Txt: StrScreen;var Choice: byte);

Implementation

const
    PassChar    = #15;
    CursorRight = #205;
    CursorLeft  = #203;
    CursorDown  = #208;
    CursorUp    = #200;
    EnterKey    = #13;
    EscKey      = #27;
    EndKey      = #207;
    HomeKey     = #199;
    DelKey      = #211;
    Backspace   = #8;
    InsKey      = #210;
    Zap         = #160;      {Alt D to delete the field}
    MinInt      = -32768;
    MaxLongInt:longint  =  2147483647;
    MinLongInt:longint  = -2147483647;
    MaxWord             =  65535;
    MinWord             =  0;

var
   CursorX,
   CursorY,
   ScanTop,
   ScanBot: byte;

procedure DefaultSettings;
begin
   with RTTT do
   begin
      WhiteSpace := #250;
      Beep := true;
      BegCursor := false;
      Insert := false;
      AllowEsc := true;
      AllowNull := true;
      RightJustify := false;
      EraseDefault := false;
      SuppressZero := true;
      EndChars := [#13,#133];  {Enter}
      RealDP := 2;
      if not ColorScreen then
      begin
         FCol := black;
         BCol := lightgray;
         HiFCol := white;
         HiBCol := black;
         LoFCol := lightgray;
         LoBCol := black;
         PFCol := white;
         PBCol := black;
         BoxFCol := white;
         BoxBCol := black;
         MsgFCol := white;
         MsgBCol := black;
         MsgLine := 0;
      end else
      begin
         FCol := black;
         BCol := lightgray;
         HiFCol := black;
         HiBCol := lightgray;
         LoFCol := lightgray;
         LoBCol := black;
         PFCol := white;
         PBCol := black;
         BoxFCol := white;
         BoxBCol := black;
         MsgFCol := lightred;
         MsgBCol := black;
         MsgLine := 0;
      end;
   end;
end; { DefaultSettings }

procedure Clang;
{}
begin
   if RTTT.Beep then
   begin
      sound(500);
      delay(50);
      nosound;
   end;
end; { Clang }

procedure ReadLine(X,Y,L,F,B,Format: byte; var Text: string);
{
X is X coord of first character in field
Y is Y coord of field
L is the maximum length of the input field
F is the foreground color
B is the background color
Format Codes:      1   Any String
                   2   Force Upper String
                   3   Yes/No
                   4   Alphabetics only
                   5   Integer
                   6   LongInteger
                   7   Real
                   8   Word
                   11  Echo a Password
Text is a string updated with the string equivalent of user input
}
var
    TempText: string;
    CursorPos: byte;
    InsertMode,
    Password,
    Alldone: boolean;
    FirstCharPress: boolean;
    Ch: char;

    procedure CheckParameters;
    begin
       TempText := Text;
       if length(TempText) > L then
          Delete(Temptext,L+1,length(TempText)-L);
       if not X in [1..80] then
          X := 1;
       if X + L - 1 > 80 then
          X := 81 - L;
       if not Y in [1..25] then
          Y := 1;
       if RTTT.BegCursor then
          CursorPos := 1
       else
       begin
          if length(TempText) < L then
             CursorPos := length(TempText) + 1
          else
             CursorPos := length(TempText);
       end;
       InsertMode := RTTT.Insert;
       Alldone := False;
       if Format = 11 then
       begin
          Password := true;
          Format := 1;
       end else
          Password := false;
    end;  { CheckParameters }

    function FillWhiteSpace(Str: string): string;
    var I : integer;
    begin
       if Password then
          Str := replicate(length(Str),PassChar);
       while length(Str) < L do
             Str := Str + RTTT.WhiteSpace;
       FillWhiteSpace := Str;
    end; { FillWhiteSpace }

    procedure MoveTheCursor;
    begin
       GotoXY(X+CursorPos-1,Y);
    end;  { MoveTheCursor }

    procedure WriteString;
    begin
       WriteAT(X,Y,Cattr(F,B),FillWhiteSpace(TempText));
       MoveTheCursor;
    end; { WriteString }

    procedure EraseField;
    begin
       TempText := '';
       CursorPos := 1;
       WriteString;
    end; { EraseField }

    procedure CharBackspace;
    begin
       if CursorPos > 1 then
       begin
          CursorPos := Pred(CursorPos);
          Delete(TempText,CursorPos,1);
          WriteString;
       end;
    end; { CharBackspace }

    procedure CharDel;
    begin
       if CursorPos <= length(TempText) then
       begin
          Delete(TempText,CursorPos,1);
          WriteString;
       end;
    end;   { CharDel }

    procedure AddChar(Ch:char);
    begin
       if InsertMode then
       begin
          if length(TempText) < L then
          begin
             Insert(Ch,TempText,CursorPos);
             if CursorPos < L then
                CursorPos := Succ(CursorPos);
          end;
       end else {not insertmode}
       begin
          delete(TempText,CursorPos,1);
          insert(Ch,TempText,CursorPos);
          if CursorPos < L then
             CursorPos := Succ(CursorPos);
       end;   {if insert}
       WriteString;
    end;   { AddChar }

begin                  {main Procedure ReadLine}
   CheckParameters;
   RNull := false;
   CursorFind(CursorX,CursorY,ScanTop,ScanBot);
   if RTTT.Insert then
      CursorHalf
   else
      CursorOn;
   WriteString;
   FirstCharPress := true;
   repeat
      Ch := Getkey;
      if Format in [2,3] then
         Ch := upcase(Ch);
      if Ch in RTTT.EndChars then
      begin
         AllDone := True;
         if Ch <> #027 then
            Text := TempText;
      end else
      begin
         Case Ch of
            #131,              {mouseright}
            CursorRight   : begin
                               if (CursorPos < L)
                               and (CursorPos <= length(TempText)) then
                               begin
                                  CursorPos := Succ(CursorPos);
                                  MoveTheCursor;
                               end;
                            end;
            #130,               {mouseleft}
            CursorLeft    : begin
                               if CursorPos > 1 then
                               begin
                                  CursorPos := Pred(CursorPos);
                                  MoveTheCursor;
                               end;
                            end;
            HomeKey       : begin
                               CursorPos := 1;
                               MoveTheCursor;
                            end;
            EndKey        : begin
                               if CursorPos < L then
                               if length(TempText) < L then
                                   CursorPos := length(TempText) + 1
                               else
                                   CursorPos := L;
                               MoveTheCursor;
                            end;
             InsKey       : if Format <> 3 then   {don't allow insert on Y/N!}
                            begin
                               InsertMode := not InsertMode;
                               if InsertMode then
                                  CursorHalf
                               else
                                  CursorOn;
                            end;
             DelKey       : CharDel;
             Zap          : EraseField;
             #132,
             EscKey       : if RTTT.AllowEsc then
                               Alldone := true
                            else
                               Clang;
             #133         : begin
                               Alldone := true;
                               Text := TempText;
                            end;
             #128,#129    : ; {absorb stray mouse movement to avoid Clang'n}
             BackSpace    :  CharBackspace;
             EnterKey     :  begin
                                Alldone := true;
                                Text := TempText;
                             end;
            #33 .. #42,                                 {! to *}
            #44,#47,                                    {, /}
            #58 .. #64,                                 {: to @}
            #91 .. #96,                                 {[ to '}
            #123 .. #126  : if (Format in [1,2]) then {{ to ~}
                            begin
                               if FirstCharPress and RTTT.EraseDefault then
                                  EraseField;
                               AddChar(Ch);
                            end else
                               Clang;
            #43, #45      : if (Format in [1,2])       { + - }
                            or ( (CursorPos=1) and (Format in [5,6,7])) then
                            begin
                               if FirstCharPress and RTTT.EraseDefault then
                                  EraseField;
                               AddChar(Ch);
                            end else
                               Clang;
            #46           : if (Format in [1,2])       {.}
                            or ( (Pos('.',TempText)=0) and (Format = 7)) then
                            begin
                               if FirstCharPress and RTTT.EraseDefault then
                                  EraseField;
                               AddChar(Ch);
                            end else
                               Clang;
            #48..#57      : if (Format in [1..2,5..8]) then {0 to 9}
                            begin
                               if FirstCharPress and RTTT.EraseDefault then
                                  EraseField;
                               AddChar(Ch);
                            end else
                               Clang;
            #32,                                              {space}
            #65..#77,                                         {A to M}
            #79..#88,                                         {O to X}
            #90,                                              {Z}
            #97..#255     : if (Format in [1,2,4]) then      {a to z}
                            begin
                               if FirstCharPress and RTTT.EraseDefault then
                                  EraseField;
                               AddChar(Ch);
                            end else
                               Clang;
            #78,#89       : if (Format in [1..4]) then        {N Y}
                            begin
                               AddChar(Ch);
                               if Format = 3 then
                               begin
                                  Alldone := true;
                                  Text := TempText;
                               end;
                            end else
                               Clang;
         end; {case}
      end;
      FirstCharPress := false;
   until Alldone;
   RChar := Ch;
   if  RTTT.RightJustify
   and (Format > 4) then
   begin
      WriteAT(X,Y,Cattr(F,B),replicate(L,RTTT.Whitespace));
      WriteAT(X+L-Length(TempText),Y,Cattr(F,B),Text);
   end else
   WriteAT(X,Y,Cattr(F,B),FillWhiteSpace(Text));
   GotoXY(CursorX,CursorY);
   CursorSize(ScanTop,ScanBot);
end;  { ReadLine }

procedure DisplayBoxAndPrompt(var X1,Y: byte; BoxType: byte;
                                 Prompt: StrScreen; L: byte);
{ensures that the input will fit on the screen, then draws box and prompt}
const
    Upchar = '^';
    DnChar = '';
var P, width: byte;
    InBorder: byte;    {is title in box border - 0 no, 1 upper, 2 lower}
begin
   if not ( (Y-ord(BoxType > 0)) in [1..HardVars.Depth] ) then
      Y := 2;
   if (X1 < 1) then
      X1 := 2;
   P := length(Prompt);
   if (P > 1) and (Boxtype > 0) then    {check and see if prompt is in box}
   begin
      if Prompt[1] = Upchar then
      begin
         delete(Prompt,1,1);
         dec(P);
         InBorder := 1;
      end else
      if Prompt[1] = DnChar then
      begin
         delete(Prompt,1,1);
         dec(P);
         InBorder := 2;
      end else
      InBorder := 0;
   end else
   InBorder := 0;
   if InBorder > 0 then                      {determine dimensions of box}
   begin
      if P > L then
         width := succ(P)
      else
         width := succ(L);
   end else
   width := succ(P+l);
   if pred(X1 + width) > 80 then
      X1 :=  succ(80 - width);
   if BoxType > 0 then         {draw the box}
      FBox(X1,pred(Y),X1+width,succ(Y),Cattr(RTTT.BoxFCol,RTTT.BoxBCol),BoxType);
   if P > 0 then               {Draw the prompt}
   case InBorder of
      0 : if BoxType> 0 then
             WriteAT(succ(X1),Y,Cattr(RTTT.PFcol,RTTT.PBCol),Prompt) {left Justified in upper border}
          else
             WriteAT(X1,Y,Cattr(RTTT.PFcol,RTTT.PBCol),Prompt);
      1 : WriteAT(succ(X1),pred(Y),Cattr(RTTT.PFcol,RTTT.PBCol),Prompt);
      2 : WriteAT(X1+width-P,succ(Y),Cattr(RTTT.PFcol,RTTT.PBCol),Prompt);   {right justified in lower border}
   end;
   if InBorder > 0 then        {return var X1 adjusted to position of input field}
   begin
      if Boxtype > 0 then
         X1 := succ(X1);
   end else
   begin
      if Boxtype > 0 then
         X1 := succ(X1) + p
      else
         X1 := X1 + P;
   end;
end; { DisplayBoxAndPrompt }

procedure ReadString(X,Y,L: byte; Prompt: StrScreen;
                      BoxType: byte; var Txt: StrScreen);
{}
begin
   DisplayBoxandPrompt(X,Y,Boxtype,Prompt,L);
   ReadLine(X,Y,L,RTTT.FCol,RTTT.BCol,1,Txt);
end; { ReadString }

procedure ReadStringUpper(X,Y,L: byte; Prompt: StrScreen;
                            BoxType: byte; var Txt: StrScreen);
{}
begin
   Txt := SetUpper(Txt);
   DisplayBoxandPrompt(X,Y,Boxtype,Prompt,L);
   ReadLine(X,Y,L,RTTT.FCol,RTTT.BCol,2,Txt);
end; { ReadStringUpper }

procedure ReadPassword(X,Y,L: byte; Prompt: StrScreen;
                        BoxType: byte; var Txt: StrScreen);
{}
begin
   DisplayBoxandPrompt(X,Y,Boxtype,Prompt,L);
   ReadLine(X,Y,L,RTTT.FCol,RTTT.BCol,11,Txt);
end; { ReadPassword }

procedure ReadAlpha(X,Y,L: byte; Prompt: StrScreen;
                     BoxType: byte; var Txt: StrScreen);
{}
begin
   DisplayBoxandPrompt(X,Y,Boxtype,Prompt,L);
   ReadLine(X,Y,L,RTTT.FCol,RTTT.BCol,4,Txt);
end; { ReadAlpha }

procedure ReadYN(X,Y: byte; Prompt: StrScreen; BoxType: byte; var Yes: boolean);
{}
var GlobalInsert: boolean;
    Txt: StrScreen;
begin
   if Yes then
      Txt := 'Y'
   else
      Txt := 'N';
   GlobalInsert := RTTT.insert;
   RTTT.Insert := false;            {force to overwrite mode}
   DisplayBoxandPrompt(X,Y,Boxtype,Prompt,1);
   ReadLine(X,Y,1,RTTT.FCol,RTTT.BCol,3,Txt);
   RTTT.Insert := GlobalInsert;    {reset back}
   if Txt = 'Y' then
      Yes := true
   else
      Yes := false;
end; { ReadYN }

{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\}

procedure InvalidMessage(Y: byte; var CH: char);
{}
begin
   Clang;
   TempMessageCH(1,Y,Cattr(RTTT.MsgFcol,RTTT.MsgBCol),
               PadCenter('Invalid number - press any key to resume',80,' '),CH);
end; { InvalidMessage }

procedure OutOfRangeMessage(Y: byte; MinS,MaxS: StrScreen; var CH: char);
{}
var S: StrScreen;
begin
   Clang;
   S := 'Error value must be in the range '+MinS+' to '+MaxS+' - press any key to resume';
   TempMessageCh(1,Y,Cattr(RTTT.MsgFcol,RTTT.MsgBCol),PadCenter(S,80,' '),CH);
end; { OutOfRangeMessage }

function MessageLine(Y: byte): byte;
{}
begin
   if (RTTT.MsgLine = 0) or (RTTT.MsgLine > HardVars.Depth) then
   begin
      if Y < HardVars.Depth then    {set message Line}
         MessageLine := succ(Y)
      else
         MessageLine := pred(Y);
   end else
      MessageLine := RTTT.MsgLine;
end;  { MessageLine }

{\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\}

procedure ReadByte(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                    var B: byte; Min, Max: byte);
{}
var Temp: byte;
    Txt: StrScreen;
    Valid: boolean;
    Code: integer;
    YT: byte;
    CHB: char;
begin
   if Max = 0 then
      Max := 255;
   if Min >= Max then
       Min := 0;
   if (B < Min) or (B > Max) then
      B := Min;
   if ((B = 0) and RTTT.SuppressZero) then
      Txt := ''
   else
      Txt := IntToStr(B);
   Temp := B;
   Valid := false;
   DisplayBoxandPrompt(X,Y,Boxtype,Prompt,L);
   YT := MessageLine(Y);
   repeat
      ReadLine(X,Y,L,RTTT.FCol,RTTT.BCol,8,Txt);
      if ((RChar = #027) and RTTT.AllowEsc)
         or ((Txt = '') and (RTTT.AllowNull)) then
      begin
         if Txt = '' then RNull := true;
            exit;
      end else
      begin
         val(Txt,Temp,code);
         if code <> 0 then
         begin
            InvalidMessage(YT,CHB);
            if ChB = #027 then
               Txt := IntToStr(B);
         end else
         begin
            if (Temp < Min)
               or (Temp > Max)
               or ((length(Txt) > 2) and (Txt > '255')) then
            begin
               OutOfRangeMessage(Yt,IntToStr(Min),IntToStr(Max),CHB);
               if ChB = #027 then
                  Txt := IntToStr(B);
            end else
            begin
               B := temp;
               Valid := true;
            end;
         end;
      end;
   until Valid or ((RChar = #027) and RTTT.AllowEsc);
end; { ReadByte }

procedure ReadWord(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                                    var W: word; Min, Max: word);
{}
var Temp: word;
    Txt: StrScreen;
    Valid: boolean;
    Code: integer;
    YT: byte;
    ChW: char;
begin
   if Max = 0 then
      Max := MaxWord;
   if Min >= Max then
       Min := MinWord;
   if (W < Min) or (W > Max) then
        W := Min;
   if ((W = 0) and RTTT.SuppressZero) then
       Txt := ''
   else
       Txt := IntToStr(W);
   Temp := W;
   Valid := false;
   DisplayBoxandPrompt(X,Y,Boxtype,Prompt,L);
   YT := MessageLine(Y);
   repeat
      ReadLine(X,Y,L,RTTT.FCol,RTTT.BCol,8,Txt);
      if ((RChar = #027) and RTTT.AllowEsc)
      or ((Txt = '') and (RTTT.AllowNull)) then
      begin
         if Txt = '' then RNull := true;
            exit;
      end else
      begin
         val(Txt,Temp,code);
         if code <> 0 then
         begin
            InvalidMessage(YT,ChW);
            if ChW = #027 then
               Txt := IntToStr(W);
         end else
         begin
            if (Temp < Min)
               or (Temp > Max)
               or ((length(Txt) > 4) and (Txt > IntToStr(MaxWord))) then
            begin
               OutOfRangeMessage(Yt,IntToStr(Min),IntToStr(Max),ChW);
               if ChW = #027 then
                  Txt := IntToStr(W);
            end else
            begin
               W := temp;
               Valid := true;
            end;
         end;
      end;
   until Valid  or ((RChar = #027) and RTTT.AllowEsc);
end; { ReadWord }

procedure ReadInt(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                             var W: integer; Min, Max: integer);
{}
var Temp: integer;
    Txt: StrScreen;
    Valid: boolean;
    Code: integer;
    YT: byte;
    ChI: char;
begin
   if Max = 0 then
      Max := MaxInt;
   if Min >= Max then
       Min := MinInt;
   if (W < Min) or (W > Max) then
        W := Min;
   if ((W = 0) and RTTT.SuppressZero) then
       Txt := ''
   else
       Txt := IntToStr(W);
   Temp := W;
   Valid := false;
   DisplayBoxandPrompt(X,Y,Boxtype,Prompt,L);
   YT := MessageLine(Y);
   repeat
      ReadLine(X,Y,L,RTTT.FCol,RTTT.BCol,5,Txt);
      if ((RChar = #027) and RTTT.AllowEsc)
      or ((Txt = '') and (RTTT.AllowNull)) then
      begin
         if Txt = '' then RNull := true;
            exit;
      end else
      begin
         val(Txt,Temp,code);
         if code <> 0 then
         begin
            InvalidMessage(YT,ChI);
            if ChI = #027 then
               Txt := InttoStr(W);
         end else
         begin
            if (Temp < Min) or (Temp > Max) then
            begin
               OutOfRangeMessage(Yt,IntToStr(Min),IntToStr(Max),ChI);
               if ChI = #027 then
                  Txt := InttoStr(W);
            end else
            begin
               W := temp;
               Valid := true;
            end;
         end;
      end;
   until Valid  or ((RChar = #027) and RTTT.AllowEsc);
end; { ReadInt }

procedure ReadLongInt(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                                 var W: longint; Min, Max: longint);
{}
var Temp: longint;
    Txt: StrScreen;
    Valid: boolean;
    Code: integer;
    YT: byte;
    ChI: char;
begin
   if Max = 0 then
      Max := MaxLongInt;
   if Min >= Max then
       Min := MinLongInt;
   if (W < Min) or (W > Max) then
        W := Min;
   if ((W = 0) and RTTT.SuppressZero) then
       Txt := ''
   else
       Txt := IntToStr(W);
   Temp := W;
   Valid := false;
   DisplayBoxandPrompt(X,Y,Boxtype,Prompt,L);
   YT := MessageLine(Y);
   repeat
      ReadLine(X,Y,L,RTTT.FCol,RTTT.BCol,5,Txt);
      if ((RChar = #027) and RTTT.AllowEsc)
      or ((Txt = '') and (RTTT.AllowNull)) then
      begin
         if Txt = '' then RNull := true;
            exit;
      end else
      begin
         val(Txt,Temp,code);
         if code <> 0 then
         begin
            InvalidMessage(YT,ChI);
            if ChI = #027 then
               Txt := InttoStr(W);
         end else
         begin
            if (Temp < Min) or (Temp > Max) then
            begin
               OutOfRangeMessage(Yt,IntToStr(Min),IntToStr(Max),ChI);
               if ChI = #027 then
                  Txt := InttoStr(W);
            end else
            begin
               W := temp;
               Valid := true;
            end;
         end;
      end;
   until Valid  or ((RChar = #027) and RTTT.AllowEsc);
end; { ReadLongInt }

procedure ReadReal(X,Y,L: byte; Prompt: StrScreen; BoxType: byte;
                                    var W: real; Min, Max: real);
{}
var Temp: Real;
    Txt: StrScreen;
    Valid: boolean;
    Code: integer;
    YT: byte;
    ChR: char;
begin
   if Max = 0 then
      Max := 99999999;
   if Min >= Max then
       Min := -99999999;
   if (W < Min) or (W > Max) then
        W := Min;
   if Min < 0 then    {add room for - sign}
       inc(L);
   if ((W = 0.0) and RTTT.SuppressZero) then
       Txt := ''
   else
       Txt := RealToStr(W,RTTT.RealDP);
   Temp := W;
   Valid := false;
   DisplayBoxandPrompt(X,Y,Boxtype,Prompt,L);      {5.00b}
   YT := MessageLine(Y);
   repeat
      ReadLine(X,Y,L,RTTT.FCol,RTTT.BCol,7,Txt);
      if ((RChar = #027) and RTTT.AllowEsc)
      or ((Txt = '') and (RTTT.AllowNull)) then
      begin
         if Txt = '' then RNull := true;
            exit;
      end else
      begin
         val(Txt,Temp,code);
         if code <> 0 then
         begin
            InvalidMessage(YT,ChR);
            if ChR = #027 then
               Txt := RealtoStr(W,RTTT.RealDP);
         end else
         begin
            if (Temp < Min) or (Temp > Max) then
            begin
               OutOfRangeMessage(Yt,RealToStr(Min,RTTT.RealDP),RealToStr(Max,RTTT.RealDP),ChR);
               if ChR = #027 then
                  Txt := RealtoStr(W,RTTT.RealDP);
            end else
            begin
               W := temp;
               Valid := true;
            end;
         end;
      end;
   until Valid  or ((RChar = #027) and RTTT.AllowEsc);
end; { ReadReal }

procedure ReadSelect(X,Y: byte;Pmt,Txt: StrScreen;var Choice: byte);
{}
const
     UpChar: string[1] = '^';
     JoinChar: string[1] = '';
var
  W: byte;
  I: integer;
  Horiz: boolean;

     function ReplaceJoinChar(Str: string): string;
     {}
     var I: integer;
     begin
         for I := 1 to length(Str) do
             if Str[I] = JoinChar then
                Str[I] := ' ';
         ReplaceJoinChar := Str;
     end; { ReplaceJoinChar }

     procedure HiLightWord(W: byte;Hi: boolean);
     {}
     var Col: byte;
     begin
        if Hi then
           Col := Cattr(RTTT.HiFCol,RTTT.HiBcol)
        else
           Col := Cattr(RTTT.LoFcol,RTTT.LoBcol);
        if Horiz then
           WriteAT(pred(X)+PosWord(W,Txt),Y,Col,ReplaceJoinChar(ExtractWords(W,1,Txt)))
        else
           WriteAT(X,pred(Y)+W,Col,ReplaceJoinChar(ExtractWords(W,1,Txt)));
        if Hi then
        begin
           if Horiz then
              GotoXY(pred(X)+PosWord(W,Txt),Y)
           else
              GotoXY(X,Pred(Y)+W);
        end;
     end;  { HiLightWord }

     procedure ProcessKeys;
     {}
     var ChP: char;
         Finished: boolean;
     begin
        Finished := false;
        repeat
           ChP := getKey;
           if ChP in RTTT.EndChars then
              Finished := True
           else
              case upcase(ChP) of
                 #132,
                 EscKey      : if RTTT.AllowEsc then
                                  Finished := true;
                 ' ',#9,                                 {tab}
                 CursorDown,
                 CursorRight : begin
                                  HiLightWord(Choice,false);
                                  if Choice < W then
                                     inc(Choice)
                                  else
                                     Choice := 1;
                                  HiLightWord(Choice,true);
                               end;
                 #143,                     {Shift tab}
                 CursorUp,
                 CursorLeft  : begin
                                  HiLightWord(Choice,false);
                                  if Choice > 1 then
                                     dec(Choice)
                                  else
                                     Choice := W;
                                  HiLightWord(Choice,true);
                               end;
                 #131        : if (Choice < W) and Horiz then    {mouse right}
                               begin
                                  HiLightWord(Choice,false);
                                  inc(Choice);
                                  HiLightWord(Choice,true);
                               end;
                 #130        : if (Choice > 1) and Horiz then    {mouse left}
                               begin
                                  HiLightWord(Choice,false);
                                  dec(Choice);
                                  HiLightWord(Choice,true);
                               end;
                 #129        : if (Choice < W) and (Horiz = false) then    {mouse down}
                               begin
                                  HiLightWord(Choice,false);
                                  inc(Choice);
                                  HiLightWord(Choice,true);
                               end;
                 #128        : if (Choice > 1) and (Horiz = false) then    {mouse up}
                               begin
                                  HiLightWord(Choice,false);
                                  dec(Choice);
                                  HiLightWord(Choice,true);
                               end;

              end; {case}
           until Finished;
           RChar := ChP;
     end;  { ProcessKeys }

begin
   if Txt[1] = UpChar then
   begin
      Horiz := False;
      delete(Txt,1,1);
   end else
      Horiz := true;
   W := Wordcnt(Txt);
   if W < 2 then
      exit;              {only show choices if there are two or more}
   CursorFind(CursorX,CursorY,ScanTop,ScanBot);   {record cursor settings}
   if (Choice > W) or (Choice < 1) then           {check that W is sensible}
      Choice := 1;
   if Pmt <> '' then
   begin
      WriteAT(X,Y,Cattr(RTTT.PFcol,RTTT.PBCol),Pmt);
      X := X+length(Pmt);
   end;
   for I := 1 to W do
       HiLightWord(I,False);
   CursorOn;
   HiLightWord(Choice,True);
   Processkeys;
   GotoXY(CursorX,CursorY);           {reset cursor}
   CursorSize(ScanTop,ScanBot);
end;  { ReadSelect }

begin
   DefaultSettings;
end.
