{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit                       }
{                Version: GOLD                                             }
{                Build:   1.00                                             }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                    {*********************************}
                    {**       Unit:   GOLDSTR       **}
                    {*********************************}

{++++++++++++++++++++++++++++++} unit GOLDSTR; {++++++++++++++++++++++++++++}

{$I GOLDFLAG.INC}
{$IFNDEF GOLDSTR}
   {$DEFINE GOLDSTR}
{$ENDIF}

{++++++++++++++++++++++++++++++++} INTERFACE {+++++++++++++++++++++++++++++++}

Uses GoldReal,CRT;

const
   MaxAlphaChars = 40;
   MaxSqzChars = 5;
   MaskChr: word = 42;

   ThouChr = ',';
   {
   DecimalChr = '.';
   CurrencyChr = '$';
   }

type
   StrErrMsgFunc = function (Ecode:integer):string;

   StrAlphabet = string[MaxAlphaChars];

   gJust = (JustLeft,JustCenter,JustRight);
   gCase = (Lower,Upper,Proper,Leave);
   gCharSet = set of char;

   StrSet = record
      EncryptionCode: byte;
      PuncChars: gCharSet;
      LowerStr: StrAlphabet;
      UpperStr: StrAlphabet;
      LineBreak: char;
      TabBreak: char;
      ECode: integer;
      EMsgFunc: StrErrMsgFunc;
      SqzChars: string[MaxSqzChars];
      SuppressErrors: boolean;
   end;

var
   StrVars: StrSet;

Const
   HiMarker: char = '~';
   Floating = 255;
   NumSet: set of char = ['0','1','2','3','4','5','6','7','8','9'];
   Fmtchars: set of char = ['!','#','@','*'];
   PuncChars: set of char = ['!',',',';',':','.','?','"',''''];
   CRLF:string[2] = #13#10;

function LastStrError: integer;
function Replicate(N : byte; Character:char): string;
function PicFormat(Input,Picture:string;Pad:char;RightJustify:boolean): string;
function TruncFormat(Input:string;Start,Len:byte; Pad:char):string;
function Squeeze(L:char;Str:string;Width:byte): string;
function FirstCapitalPos(Str:string): byte;
function FirstCapital(Str:string): char;
function Pad(PadJust:gJust;Str:string;Size:byte;ChPad:char):string;
function PadLeft(Str:string;Size:byte;ChPad:char):string;
function PadCenter(Str:string;Size:byte;ChPad:char):string;
function PadRight(Str:string;Size:byte;ChPad:char):string;
function TabSubStr(Source:string; TabCount:byte):string;
function Last(N:byte;Str:string):string;
function First(N:byte;Str:string):string;
function AdjCase(NewCase:gCase;Str:string):string;
function SetUpper(Str:string):string;
function SetLower(Str:string):string;
function SetProper(Str:string):string;
function OverType(N:byte;StrS,StrT:string):string;
function Strip(L,C:char;Str:string):string;
function LastPos(C:char;Str:string):byte;
function PosAfter(C:char;Str:string;Start:byte):byte;
function LastPosBefore(C:char;Str:string;Last:byte):byte;
function NthPos(Nth:byte;St,Src:string): byte;
function PosWord(Wordno:byte;Str:string):byte;
function WordCnt(Str:string):byte;
function ExtractWords(StartWord,NoWords:byte;Str:string):string;
{numbers}
function ValidInt(Str:string):boolean;
function ValidHEXInt(Str:string):boolean;
function ValidReal(Str:string):boolean;
function StrToInt(Str:string):integer;
function StrToLong(Str:string):Longint;
function LongToFmtStr(Number:longint):string;
function HEXStrToLong(Str:string):longint;
function StrToReal(Str:string):extended;
function RealToStr(Number:extended;Decimals:byte):string;
function IntToStr(Number:longint):string;
function IntToHEXStr(Number:longint;Width:integer):string;
function Decimals (L:byte):byte;
function RealToSciStr(Number:extended; D:byte):string;
function NthNumber(InStr:string;Nth:byte) : char;
{character testing/conversion}
function  IsUpper(K:word): boolean;
function  IsLower(K:word): boolean;
function  IsDigit(K:word): boolean;
function  IsLetter(K:word): boolean;
function  IsPunctuation(K:word): boolean;
function  GetUpCase(Ch:char):char;
function  GetLoCase(Ch:char):char;
function  CapitalWord(W:word):word;
{misc}
function  CharCount(Ch:Char;Str:string):byte;
function  WidestLine(Str:string):byte;
function  LineCount(Str:string):byte;
{encryption}
function  DeCode(Str: string): string;
function  EnCode(Str: string): string;
{unit initialization}

procedure StrDefaultSettings;
procedure GoldStrInit;

{$IFDEF TTT5}

function Str_to_Int(Str:string):integer;
function Str_to_Long(Str:string):longint;
function Str_to_Real(Str:string):real;
function Real_to_str(Number:real;Decimals:byte):string;
function Int_to_Str(Number:longint):string;
function Real_to_SciStr(Number:real; D:byte):string;

{$ENDIF}
{+++++++++++++++++++++++++++++} IMPLEMENTATION {+++++++++++++++++++++++++++++}
{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
function StrEMsg(ECode:integer): string;
{}
begin
   case Ecode of
      1001: StrEMsg := 'Number to string conversion error';
      1002: StrEMsg := 'String to long conversion error';
      1003: StrEMsg := 'String to real conversion error';
      1004: StrEMsg := 'String to integer conversion error';
      else
         StrEMsg := 'Internal String error';
   end; {case}
end; { StrEMsg }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure StrSetError(ECode:integer);
{}
{$IFOPT D+}
var Ch: char;
    Msg: string;
{$ENDIF}
begin
   StrVars.Ecode := ECode;
{$IFOPT D+}  {if debug active display an error message and terminate}
   if (Ecode <> 0) and (StrVars.SuppressErrors = false) then
   begin
      str(Ecode,Msg);
      Msg := Msg+': '+StrVars.EMsgFunc(Ecode);
      writeln(' GoldStr Error - ',Msg);
      Ch := ReadKey;
      if Ch = #27 then
         Halt;
   end;
{$ENDIF}
end; { StrSetError }

function LastStrError: integer;
{}
begin
   LastStrError := StrVars.ECode;
end; { LastStrError }

                      {******************************}
                      {**  Miscellaneous Routines  **}
                      {******************************}
function Replicate(N: byte; Character:char): string;
{returns a string with Character repeated N times}
var tempstr: string;
begin
    if N = 0 then
       TempStr := ''
    else
    begin
       fillchar(tempstr,N+1,Character);
       Tempstr[0] := chr(N);
    end;
    Replicate := Tempstr;
end; { Replicate }

function PicFormat(Input,Picture:string;Pad:char;RightJustify:boolean): string;
{}
var
   TempStr: string;
   I,J,K: byte;
begin
   J := 0;
   if Picture = '' then
      TempStr := Input
   else
   begin
      if RightJustify then
      begin
         J := succ(length(Picture));
         K := length(Input);
         for I := length(Picture) downto 1 do
         begin
            if not (Picture[I] in FmtChars) then
            begin
               TempStr[I] := Picture[I] ;  {force any none format charcters into string}
               dec(J);
            end else    {format character}
            begin
               if K > 0  then
               begin
                  TempStr[I] := Input[K];
                  dec(K);
               end else
                  TempStr[I] := Pad;
            end;
         end;
      end else
      begin
         for I := 1 to length(Picture) do
         begin
            If not (Picture[I] in Fmtchars) then
            begin
               TempStr[I] := Picture[I] ;  {force any none format charcters into string}
               inc(J);
            end else    {format character}
            begin
               If I - J <= length(Input) then
                  TempStr[I] := Input[I - J]
               else
                  TempStr[I] := Pad;
            end;
         end;
      end;
      TempStr[0] := char(length(Picture));  {set initial byte to string length}
   end;
   PicFormat := Tempstr;
end; { PicFormat }

function TruncFormat(Input:string;Start,Len:byte; Pad:char):string;
{Returns a substring starting in char position Start for Len bytes; when
necessary, padding with the Pad char}
var L: byte;
begin
   if Start > 1 then
      delete(Input,1,pred(Start));
   L := length(Input);
   if L = Len then
      TruncFormat := Input
   else if L > Len then
      TruncFormat := copy(Input,1,Len)
   else
      TruncFormat := Padleft(Input,Len,Pad);
end; { TruncFormat }

function Squeeze(L:char; Str:string;Width:byte): string;
{}
var
   Temp: string;
   Morelen: byte;
begin
   if Width = 0 then
      Squeeze := ''
   else
   begin
      MoreLen := length(StrVars.SqzChars);
      fillchar(Temp[1],Width,' ');
      Temp[0] := chr(Width);
      if length(Str) < Width then
         move(Str[1],Temp[1],length(Str))
      else
      begin
         if upcase(L) = 'L' then
         begin
            move(Str[1],Temp[1],pred(width));
            move(StrVars.SqzChars[1],Temp[pred(Width)],length(StrVars.SqzChars));
         end else
         begin
            move(StrVars.SqzChars[1],Temp[1],MoreLen);
            move(Str[length(Str)-width+succ(MoreLen)],Temp[succ(MoreLen)],Width-pred(MoreLen));
         end;
      end;
      Squeeze := Temp;
   end;
end; { Squeeze }

function SqueezePath(L:char; Str:string;Width:byte): string;
{}
begin
{$IFOPT D+}
  { set error: DING BAT! passed length is to short }
{$ELSE}

{$ENDIF}
   SqueezePath := Squeeze(L,Str,Width);
end;

function FirstCapitalPos(Str : string): byte;
{}
var StrPos: byte;
begin
   StrPos := 1;
   while (StrPos <= length(Str))  and (IsUpper(ord(Str[StrPos])) = false) do
      StrPos := Succ(StrPos);
   if StrPos > length(Str) then
      FirstCapitalPos  := 0
   else
      FirstCapitalPos := StrPos;
end; { FirstCapitalPos }

function FirstCapital(Str : string): char;
{}
var B: byte;
begin
   B := FirstCapitalPos(Str);
   if B > 0 then
      FirstCapital := Str[B]
   else
      FirstCapital := #0;
end; { Firstcapital }

function Pad(PadJust:gJust;Str:string;Size:byte;ChPad:char):string;
{}
begin
   case PadJust of
      JustLeft:  Pad := PadLeft(Str,Size,ChPad);
      JustCenter:Pad := PadCenter(Str,Size,ChPad);
      JustRight: Pad := PadRight(Str,Size,ChPad);
   end; {case}
end; { Pad }

function PadLeft(Str:string;Size:byte;ChPad:char):string;
var temp: string;
begin
   fillchar(Temp[1],Size,ChPad);
   Temp[0] := chr(Size);
   if length(Str) <= Size then
      move(Str[1],Temp[1],length(Str))
   else
      move(Str[1],Temp[1],size);
   PadLeft := Temp;
end; { PadLeft }

function PadCenter(Str:string;Size:byte;ChPad:char):string;
{}
var
   Temp: string;
   L: byte;
begin
   fillchar(Temp[1],Size,ChPad);
   Temp[0] := chr(Size);
   L := length(Str);
   if L <= Size then
      move(Str[1],Temp[((Size - L) div 2) + 1],L)
   else
      Temp := copy(Str,1,L);
   PadCenter := temp;
end; { PadCenter }

function PadRight(Str:string;Size:byte;ChPad:char):string;
{}
var
  temp: string;
  L: integer;
begin
   fillchar(Temp[1],Size,ChPad);
   Temp[0] := chr(Size);
   L := length(Str);
   if L <= Size then
      move(Str[1],Temp[succ(Size - L)],L)
   else
      move(Str[1],Temp[1],size);
   PadRight := Temp;
end; { PadRight }

function TabSubStr(Source:string; TabCount:byte):string;
{}
var
  P: byte;
  Counter:integer;
begin
   Counter := 1;
   if Source[length(Source)] <> StrVars.TabBreak then
      Source := Source + StrVars.TabBreak;
   P := pos(StrVars.TabBreak,Source);
   while (Counter < TabCount) and (P <> 0) do
   begin
      delete(Source,1,P);
      inc(Counter);
      P := pos(StrVars.TabBreak,Source);
   end;
   if Counter = TabCount then
   begin
      if P = 0 then
         TabSubStr := Source
      else
         TabSubStr := copy(Source,1,pred(P));
   end
   else
      TabSubStr := '';
end; {TabSubStr}

function Last(N:byte;Str:string):string;
{}
begin
   if N > length(Str) then
      Last := Str
   else
      Last := copy(Str,succ(length(Str) - N),N);
end;  { Last }

function First(N:byte;Str:string):string;
{}
begin
   if N > length(Str) then
      First := Str
   else
      First := copy(Str,1,N);
end;  { First }

function AdjCase(NewCase:gCase;Str:string):string;
{}
begin
   case Newcase of
      Upper: Str := SetUpper(Str);
      Lower: Str := SetLower(Str);
      Proper: Str := SetProper(Str);
      Leave:{do nothing};
   end;
   AdjCase := Str;
end; { AdjCase }

function SetUpper(Str:string):string;
var I: integer;
begin
   for I := 1 to length(Str) do
      Str[I] := GetUpcase(Str[I]);
   SetUpper := Str;
end; { SetUpper }

function SetLower(Str:string):string;
var I: integer;
begin
   for I := 1 to length(Str) do
      Str[I] := GetLocase(Str[I]);
   SetLower := Str;
end; { SetLower }

function SetProper(Str:string):string;
var I: integer;
  SpaceBefore: boolean;
begin
   SpaceBefore := true;
   Str := SetLower(Str);
   for I := 1 to length(Str) do
      if SpaceBefore and IsLower(ord(Str[I])) then
      begin
         SpaceBefore := False;
         Str[I] := GetUpcase(Str[I]);
      end else
         if (SpaceBefore = False) and (Str[I] = ' ') then
            SpaceBefore := true;
   SetProper := Str;
end; { SetProper }

function OverType(N:byte;StrS,StrT:string):string;
{Overlays StrS onto StrT at Pos N}
var L: byte;
    StrN: string;
begin
   L := N + pred(length(StrS));
   if L < length(StrT) then
      L := length(StrT);
   if L > 255 then
      Overtype := copy(StrT,1,pred(N)) + copy(StrS,1,255-N)
   else
   begin
      fillchar(StrN[1],L,' ');
      StrN[0] := chr(L);
      move(StrT[1],StrN[1],length(StrT));
      move(StrS[1],StrN[N],length(StrS));
      OverType := StrN;
   end;
end; { OverType }

function Strip(L,C:char;Str:string):string;
{L is left,center,right,all,ends}
var I:  byte;
begin
   case Upcase(L) of
      'L' : begin       {Left}
               while (Str[1] = C) and (length(Str) > 0) do
                  Delete(Str,1,1);
            end;
      'R' : begin       {Right}
               while (Str[length(Str)] = C) and (length(Str) > 0) do
                  Delete(Str,length(Str),1);
            end;
      'B' : begin       {Both left and right}
               while (Str[1] = C) and (length(Str) > 0) do
                  Delete(Str,1,1);
               while (Str[length(Str)] = C) and (length(Str) > 0)  do
                  Delete(Str,length(Str),1);
            end;
      'A' : begin       {All}
               I := 1;
               repeat
                  if (Str[I] = C) and (length(Str) > 0) then
                     Delete(Str,I,1)
                  else
                     I := succ(I);
               until (I > length(Str)) or (Str = '');
            end;
   end;
   Strip := Str;
end;  { Strip }

function LastPos(C:char;Str:string):byte;
{}
var I: byte;
begin
   I := succ(length(Str));
   repeat
      dec(I);
   until (I = 0) or (Str[I] = C);
   LastPos := I;
end;  { LastPos }

function PosAfter(C:char;Str:string;Start:byte):byte;
{}
var I: byte;
begin
   I := length(Str);
   if (I = 0) or (Start > I) then
      PosAfter := 0
   else
   begin
      dec(Start);
      repeat
         inc(Start)
      until (Start > I) or (Str[Start] = C);
      if Start > I then
         PosAfter := 0
      else
         PosAfter := Start;
   end;
end; { PosAfter }

function LastPosBefore(C:char;Str:string;Last:byte):byte;
{}
begin
   Str := copy(Str,1,Last);
   LastPosBefore := LastPos(C,Str);
end; { LostPosBefore }

function LocWord(StartAT,Wordno:byte;Str:string):byte;
{local proc used by PosWord and Extract word}
var W, L: integer;
    Spacebefore: boolean;
begin
   if (Str = '') or (wordno < 1) or (StartAT > length(Str)) then
   begin
      LocWord := 0;
      exit;
   end;
   SpaceBefore := true;
   W := 0;
   L := length(Str);
   StartAT := pred(StartAT);
   while (W < Wordno) and (StartAT <= length(Str)) do
   begin
      StartAT := succ(StartAT);
      if SpaceBefore and (Str[StartAT] <> ' ') then
      begin
         W := succ(W);
         SpaceBefore := false;
      end else
         if (SpaceBefore = false) and (Str[StartAT] = ' ') then
            SpaceBefore := true;
   end;
   if W = Wordno then
      LocWord := StartAT
   else
      LocWord := 0;
end; { LocWord }

function NthPos(Nth:byte;St,Src:string): byte;
{returns the starting position of the Nth occurrence of St within Src}
var I,N,LenSt: byte;
begin
   N := 0;
   I := 0;
   LenSt := length(St);
   St := SetUpper(St);
   while I < succ((length(Src)-length(St))) do
   begin
      inc(I);
      if (SetUpper(copy(Src,I,LenSt)) = St) then
      begin
         inc(N);
         if (Nth = N) then
         begin
            NthPos := I;
            exit;
         end;
      end;
   end;
end;

function PosWord(Wordno:byte;Str:string):byte;
begin
   PosWord := LocWord(1,wordno,Str);
end; { PosWord }

function WordCnt(Str:string):byte;
var
  W,I: integer;
  SpaceBefore: boolean;
begin
   if Str = '' then
   begin
      WordCnt := 0;
      exit;
   end;
   SpaceBefore := true;
   W := 0;
   For  I :=  1 to length(Str) do
   begin
      if SpaceBefore and (Str[I] <> ' ') then
      begin
         W := succ(W);
         SpaceBefore := false;
      end else
         if (SpaceBefore = false) and (Str[I] = ' ') then
            SpaceBefore := true;
   end;
   WordCnt := W;
end; { WordCnt }

function ExtractWords(StartWord,NoWords:byte;Str:string):string;
var Start, finish: integer;
begin
   if Str = '' then
   begin
      ExtractWords := '';
      exit;
   end;
   Start := LocWord(1,StartWord,Str);
   if Start <> 0 then
      finish := LocWord(Start,succ(NoWords),Str)
   else
   begin
      ExtractWords := '';
      exit;
   end;
   if finish = 0 then
      finish := succ(length(Str));
   repeat
      finish := pred(finish);
   until Str[finish] <> ' ';
   ExtractWords := copy(Str,Start,succ(finish-Start));
end; { ExtractWords }

function ValidInt(Str:string):boolean;
{}
var Temp: longint;
    Code: integer;

  function NoLetters:boolean;
  var I: integer;
      Bad: boolean;
  begin
     NoLetters := true;
     for I := 1 to length(Str) do
     begin
        if (Str[I] in ['0'..'9','+','-']) = false then  {1.00b}
           NoLetters := false;
     end;
  end; { NoLetters }

begin
   if length(Str) = 0 then
      ValidInt := true
   else
   begin
      val(Str,temp,code);
      ValidInt := (Code = 0) and Noletters;
   end;
end; { ValidInt }

function ValidHEXInt(Str:string):boolean;
{}
var Temp: longint;
    Code: integer;
begin
   if length(Str) = 0 then
      ValidHEXInt := true
   else
   begin
      val(Str,temp,code);
      ValidHEXInt := (Code = 0);
   end;
end; { ValidHEXInt }

function IntToStr(Number:longint):string;
{}
var Temp: string;
begin
   Str(Number,temp);
   IntToStr := temp;
end; { IntToStr }

function IntToHEXStr(Number:longint;Width:integer):string;
{}
const
   HEXChars: array [0..15] of char = '0123456789ABCDEF';
var
   I: integer;
   Str: string;
   BitsToShift: byte;
   Chr: char;
begin
   Str := '';
   for I := 7 downto 0 do
   begin
      BitsToShift := I*4;
      Chr := HEXChars[ (Number shr BitsToShift) and $F];
      if not ((Str = '') and (Chr = '0')) then
         Str := Str + Chr;
   end;
   if ( Width in [1..4] ) then
      IntToHEXStr := PadRight(Str,Width,'0')
   else
      IntToHEXStr := Str;
end; { IntToHEXStr }

function ValidReal(Str:string):boolean;
{}
var Code: integer;
    Temp: extended;
begin
   if length(Str) = 0 then
      ValidReal := true
   else
   begin
      if Copy(Str,1,1)='.' Then
         Str:='0'+Str;
      if (Copy(Str,1,1)='-') and (Copy(Str,2,1)='.') Then
         Insert('0',Str,2);
      if Str[length(Str)] = '.' then
         Delete(Str,length(Str),1);
      val(Str,temp,code);
      ValidReal := (Code = 0);
   end;
end; { ValidReal }

function StrToReal(Str:string):extended;
var code: integer;
    Temp: extended;
begin
   if length(Str) = 0 then
      StrToReal := 0
   else
   begin
      if Copy(Str,1,1)='.' Then
         Str:='0'+Str;
      if (Copy(Str,1,1)='-') and (Copy(Str,2,1)='.') Then
         Insert('0',Str,2);
      if Str[length(Str)] = '.' then
         Delete(Str,length(Str),1);
      val(Str,temp,code);
      if code = 0 then
         StrToReal := temp
      else
      begin
         StrSetError(1003);
         StrToReal := 0;
      end;
   end;
end; { StrToReal }

function RealToStr(Number:extended;Decimals:byte):string;
var Temp: string;
begin
   Str(Number:20:Decimals,Temp);
   repeat
      if copy(Temp,1,1) = ' ' then delete(Temp,1,1);
   until copy(temp,1,1) <> ' ';
   if Decimals = Floating then
   begin
      Temp := Strip('R','0',Temp);
      if Temp[length(temp)] = '.' then
         Delete(temp,length(temp),1);
   end;
   RealToStr := Temp;
end; { RealToStr }

function StrToInt(Str:string):integer;
var temp,code : integer;
begin
   if (length(Str) = 0) or (Str = '-') or (str = '+') then
      StrToInt := 0
   else
   begin
      val(Str,temp,code);
      if code = 0 then
         StrToInt := temp
      else
      begin
         StrToInt := 0;
         StrSetError(1004);  { String to integer conversion error }
      end;
   end;
end; { StrToInt }

function StrToLong(Str:string):Longint;
var code: integer;
    Temp: longint;
begin
   if length(Str) = 0 then
      StrToLong := 0
   else
   begin
      val(Str,temp,code);
      if code = 0 then
         StrToLong := temp
      else
      begin
         StrToLong := 0;
         StrSetError(1002) { Error converting StrToLong }
      end;
   end;
end; { StrToLong }

function LongToFmtStr(Number:longint):string;
{}
var FStr: string;
    DP: integer;
begin
   Fstr := IntToStr(Number);
   DP := length(FStr) - 2;
   while (DP > 1) and IsDigit(ord(FStr[pred(DP)])) do
   begin
      insert(ThouChr,FStr,DP);
      dec(DP,3);
   end;
   LongToFmtStr := FStr;
end; { LongToFmtStr }

function HEXStrToLong(Str:string):longint;
{}
begin
   if Str = '' then
      HEXStrToLong := 0
   else
   begin
      if Str[1] <> '$' then
         Str := '$'+Str;
      HEXStrtoLong := StrToLong(Str);
   end;
end; { HEXStrToLong }

function Decimals (L:byte):byte;
{INTERNAL}
var Expnt: byte;
    Temp: shortint;
begin
{$IFDEF FLOAT}
   Expnt := 4;
{$ELSE}
   {$IFDEF FLOATEM}
   Expnt := 4;
   {$ELSE}
   Expnt := 2;
   {$ENDIF}
{$ENDIF}
   Temp := L-Expnt-5;
   if temp > 0 then
      Decimals := Temp
   else
      Decimals := 0;
end; { Decimals }

function RealToSciStr(Number:extended; D:byte):string;
{Credits: Michael Harris, Houston.
          Peter Sands, Australia
          Frans van Capelle, Amsterdam
 Thanks!}
Const
    DamnNearUnity = 9.99999999E-01;
Var
    Temp : extended;
    Power: integer;
    Value: string;
    Sign : char;
    Expnt: byte;
begin
   if Number = 1.0 then
      RealToSciStr := '1.000'
   else if Number = 0.0 then
      RealToSciStr := '0.000'
   else
   begin
      Temp := Number;
      Power := 0;
      if abs(Number) > 1.0 then
      begin
         while abs(Temp) >= 10.0 do
         begin
            Inc(Power);
            Temp := Temp/10.0;
         end;
         Sign := '+';
      end else
      begin
         while abs(Temp) < DamnNearUnity do
         begin
            Inc(Power);
            Temp := Temp * 10.0;
         end;
         Sign := '-';
      end;
      Value := RealToStr(Temp,D);
{$IFDEF FLOAT}
      Expnt := 4;
{$ELSE}
   {$IFDEF FLOATEM}
      Expnt := 4;
   {$ELSE}
      Expnt := 2;
   {$ENDIF}
{$ENDIF}
      RealToSciStr := Value+'E'+Sign+Padright(IntToStr(Power),Expnt,'0');
   end;
end; { RealToSciStr }

function NthNumber(InStr:string;Nth:byte): char;
{Returns the nth number in an alphanumeric string}
var
   Counter: byte;
   B, Len: byte;
begin
    Counter := 0;
    B := 0;
    Len := length(InStr);
    repeat
       Inc(B);
       If InStr[B] in ['0'..'9'] then
          Inc(Counter);
    until (Counter = Nth) or (B = Len);
    if counter = Nth then  {1.00}
       NthNumber := InStr[B]
    else
       NthNumber := #0;
end; { NthNumber }

                  {*************************************}
                  {**  Case Conversion/International  **}
                  {*************************************}

function CapitalWord(W:word):word;
{Converts the character represented by W to uppercase and
 returns the word value of the capital letter}
var Ch: char;
begin
   if W > 255 then
      CapitalWord := W
   else
      CapitalWord := ord(GetUpcase(char(W)));
end; { CapitalWord }

function IsUpper(K:word): boolean;
{}
begin
   if K > 255 then
     IsUpper := false
   else
     IsUpper := pos(chr(K),StrVars.UpperStr) > 0;
end; { IsUpper }

function IsLower(K:word): boolean;
{}
begin
   if K > 255 then
     IsLower := false
   else
     IsLower := pos(chr(K),StrVars.LowerStr) > 0;
end; { IsLower }

function IsDigit(K:word): boolean;
{}
begin
   IsDigit := chr(K) in NumSet;
end; { IsDigit }

function IsLetter(K:word): boolean;
{}
begin
   if K > 255 then
     IsLetter := false
   else
     IsLetter := pos(chr(K),StrVars.LowerStr+StrVars.UpperStr) > 0;
end; { IsLetter }

function IsPunctuation(K:word): boolean;
{}
begin
   if K > 255 then
     IsPunctuation := false
   else
     IsPunctuation := chr(K) in StrVars.PuncChars;
end; { IsPunctuation }

function GetUpCase(Ch:char):char;
{}
var P: byte;
begin
   P := pos(Ch,StrVars.LowerStr);
   if P = 0 then
      GetUpCase := Ch
   else
      GetUpCase := StrVars.UpperStr[P];
end; { GetUpCase }

function GetLoCase(Ch:char):char;
{}
var P: byte;
begin
   P := pos(Ch,StrVars.UpperStr);
   if P = 0 then
      GetLoCase := Ch
   else
      GetLoCase := StrVars.LowerStr[P];
end; { GetLoCase }

                          {**********************}
                          {**  Line Splitting  **}
                          {**********************}

function CharCount(Ch:Char;Str:String):byte;
{Returns the total number of times Ch occurs in Str}
var C,L:byte;
    I:integer;
begin
   C := 0;
   L := length(Str);
   for I := 1 to L do
      if Str[I] = Ch then
         inc(C);
    CharCount := C;
end; { CharCount }

function WidestLine(Str:string):byte;
{Searches for the embedded line break character and returns the
 length of the longest line-element}
var
   P,L,TempL: byte;
   TempStr: string;
begin
   P := pos(StrVars.LineBreak,Str);
   if P = 0 then
      WidestLine := length(strip('A',HiMarker,Str))
   else
   begin
      L := pred(P);
      delete(Str,1,P);
      while Str <> '' do
      begin
         P := pos(StrVars.LineBreak,Str);
         if P = 0 then
         begin
            TempL := length(strip('A',HiMarker,Str));
            if TempL > L then
               L := TempL;
            Str := '';
         end else
         begin
            TempStr := copy(Str,1,pred(P));
            delete(Str,1,P);
            TempL := length(strip('A',HiMarker,TempStr));
            if TempL > L then
               L := TempL;
         end;
      end;
      WidestLine := L;
   end;
end; { WidestLine }

function LineCount(Str:string):byte;
{}
var P: byte;
begin
   P := pos(StrVars.LineBreak,Str);
   if P = 0 then
      LineCount := 1
   else
      LineCount := succ(CharCount(StrVars.LineBreak,Str));
end; { LineCount }

                        {**************************}
                        {**  Encryption Methods  **}
                        {**************************}

function DeCode(Str: string): string;
{}
var Ch: byte;
    I,L: integer;
    TempStr: string;
begin
   with StrVars do
   begin
      L := length(Str);
      if L > 0 then
      begin
         for I := 1 to L do
         begin
            Ch := EncryptionCode XOR ord(Str[I]);
            TempStr[I] := chr(Ch);
         end;
         TempStr[0] := Str[0];
         DeCode := TempStr;
      end else
         DeCode := '';
   end;
end; { DeCode }

function EnCode(Str: string): string;
{}
var Ch: byte;
    I,L: integer;
    TempStr: string;
begin
   with StrVars do
   begin
      L := length(Str);
      if L > 0 then
      begin
         for I := 1 to L do
         begin
            Ch := EncryptionCode XOR ord(Str[I]);
            TempStr[I] := chr(Ch);
         end;
         TempStr[0] := Str[0];
         EnCode := TempStr;
      end else
         EnCode := '';
   end;
end; { EnCode }

              {*********************************************}
              {**  U N I T   I N I T I A L I Z A T I O N  **}
              {*********************************************}
procedure StrDefaultSettings;
{}
begin
   with StrVars do
   begin
      { it is much safer to keep the encryption code
        between 128 and 255.  Values between 0 and 127
        ocassionally produce a Ctrl-Z or EOF character.
        This produces a premature end-of-file.  }
      EncryptionCode := 134;
      LowerStr := 'abcdefghijklmnopqrstuvwxyz';
      UpperStr := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
      PuncChars := [',',';',':','.',' '];
      LineBreak := '|';
      TabBreak := '|';
      SqzChars := '..';
      SuppressErrors := false;
   end;
end; { StrDefaultSettings }

procedure GoldStrInit;
{}
begin
   with StrVars do
   begin
      Ecode := 0;
      EMsgFunc := StrEMsg;
   end;
   StrDefaultSettings;
end; { GoldStrInit }

{$IFDEF TTT5}

function Str_to_Int(Str:string):integer;
{included for TTT5 compatibility}
begin
   Str_To_Int := StrToInt(Str);
end; { Str_To_Int }

function Str_to_Long(Str:string):Longint;
{included for TTT5 compatibility}
begin
   Str_To_Long := StrToLong(Str);
end; { Str_To_Long }

function Str_to_Real(Str:string):real;
{included for TTT5 compatibility}
begin
   Str_To_Real := StrToReal(Str);
end; { Str_To_Long }

function Real_to_str(Number:real;Decimals:byte):string;
{included for TTT5 compatibility}
begin
   Real_To_Str := RealToStr(Number,Decimals);
end; { Real_To_Str }

function Int_to_Str(Number:longint):string;
{included for TTT5 compatibility}
begin
   Int_To_Str := IntToStr(Number);
end; { Int_To_Str }

function Real_to_SciStr(Number:real; D:byte):string;
{included for TTT5 compatibility}
begin
   Real_To_SciStr := RealToSciStr(Number,D);
end; { Real_to_SciStr }

{$ENDIF}

begin
   GoldStrInit;
end.
