{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit                       }
{                Version: GOLD                                             }
{                Build:   1.00                                             }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                    {*********************************}
                    {**       Unit:   GOLDIO3       **}
                    {*********************************}

{+++++++++++++++++++++++++++++++} unit GOLDIO3; {++++++++++++++++++++++++++++}

{$I GOLDFLAG.INC}
{$IFNDEF GOLDIO3}
   {$DEFINE GOLDIO3}
{$ENDIF}

{++++++++++++++++++++++++++++++++} INTERFACE {+++++++++++++++++++++++++++++++}

uses DOS, CRT,
     GoldAttr, GoldHard, GoldTint, GoldMisc, GoldKey, GoldFast,
     GoldWin, GoldLink, GoldStr, GoldDate, GoldIO,
     GoldList, GoldIO2, GoldReal, GoldCal, GoldMemo;

const
   FixedFld = succ(ListFld);
   RealStrElementLength = 30;

type
   FixedRealStr = string[RealStrElementLength];

   FixedInfoPtr = ^FixedInfo;
   FixedInfo = record
      WholeP: byte;
      WholeStr: FixedRealStr;
      DPStr: FixedRealStr;
      Pad:char;
      EMax:extended;
      EMin:extended;
      EDelta:extended; {used in spin field}
   end; {FixedInfo}

   IO3Set = record
      SpinUpKey: word;
      SpinDownKey: word;
      SpinUp: char;
      SpinDown: char;
      DropDownKey: word;
      DropDown: char;
      IconPadLeft:char;
      IconPadRight:char;
   end; {IO3Set}

procedure AddHotKeyField(FieldID:integer; Key:word; Action:gAction);
procedure FixedRealField(FieldID:integer; var Realvar:Extended;Whole,DP:byte;Min,Max:extended);
procedure SpinLongField(FieldID:integer; var LongIntvar:LongInt;Width:byte;Min,Max,Increment : LongInt);
procedure SpinRealField(FieldID:integer; var Realvar:extended;Whole,DP:byte;Min,Max,Delta:extended);
procedure SpinDateField(FieldID:integer; var Datevar:Dates; DateFormat:gDate;DefFormat:string; Min,Max : Dates);
procedure DropDateField(FieldID:integer; var Datevar:Dates; DateFormat:gDate;DefFormat:string; Min,Max : Dates);
procedure SpinDropDateField(FieldID:integer; var Datevar:Dates; DateFormat:gDate;
                            DefFormat:string; Min,Max : Dates);
procedure DropListField(FieldID:integer; width:byte; var SelectedItem:integer);
procedure SpinListField(FieldID:integer; width:byte; var SelectedItem:integer);
procedure SpinDropListField(FieldID:integer; width:byte; var SelectedItem:integer);
procedure EditDropListField(FieldID:integer; var Strvar:string;FieldL,MaxL:byte);
procedure HotspotField(FieldID:integer; W,D: byte; Action:gAction);
procedure BrowseField(FieldID:integer; width,depth:byte; var ListDetails: ListCfg);
procedure MemoField(FieldID:integer; width,depth:byte;var Memo:MemoCfg);

var
   IO3Vars: IO3Set;

{+++++++++++++++++++++++++++++} IMPLEMENTATION {+++++++++++++++++++++++++++++}

                           {*******************}
                           {**  HotKeyField  **}
                           {*******************}
{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure NoDisplay(FSP:FieldSettingsPtr;Status:gStatus);
{Doesn't draw anything}
begin
end; { FixedDisplay }

function NoKeyHandler(InKey:word;X,Y:byte):gAction;
begin
   NoKeyHandler := none;
end; { NoKeyHandler }

function StandardHotKeyHandler(FNP:FieldSettingsPtr;var Key:word;var Act:gAction):boolean;
{}
var Selected: boolean;
begin
   if FNP <> nil then with FNP^ do
      Selected := (Key <> 0) and (Key = HotKey) and (Active = FldOn)
   else
      Selected := false;
   if Selected then
   begin
      Key := 0;  {absorb the key}
      Act := gAction(FNP^.OMisc);
   end;
   StandardHotkeyHandler := Selected;
end; { StandardHotKeyHandler }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure AddHotKeyField(FieldID:integer; Key:word; Action:gAction);
{}
var FieldDetails: FieldSettingsPtr;
begin
   CheckFormAllocation;
   FieldDetails := AllocateNewField;
   if FieldDetails <> nil then
      with FieldDetails^ do
      begin
         ID := FieldID;
         if ID = 1 then
         begin
            Upfield := IDLastField;
            Downfield := 2;
            Leftfield := IDLastField;
            Rightfield := 2;
         end
         else
         begin
            Upfield := pred(ID);
            Downfield := succ(ID);
            Leftfield := pred(ID);
            Rightfield := succ(ID);
         end;
         X1 := 1;
         Y1 := 1;
         Y2 := 1;
         IconWidth := 0;
         HotKey := Key;
         HotKeyHook := StandardHotKeyHandler;
         DisplayHook := NoDisplay;
         ProcessKeyHook := NoKeyHandler;
         SuspendHook := SuspendOK;
         RefreshFieldHook := DoNothing;
         UpdateVarHook := DoNothing;
         DisposeHook := BasicDisposeHook;
         Message := '';
         FieldLabel := '';
         FieldFmt := '';
         MsgX := 0;
         MsgY := 0;
         FieldRules := 0;
         inc(IOVars.Form[IOVars.CurrentForm]^.TotalFields);
         AllowChar := [NoChar];
         DisAllowChar := [NoChar];
         FieldType := IOHotkey;
         UsesCursors := false;
         UsesEnter := false;
         Active := FldOn;
         Visible := false;
         OMisc := ord(Action);
      end;
end; {AddHotKeyField}

                         {************************}
                         {**  Fixed Real Field  **}
                         {************************}

procedure Condense(FSP:FieldSettingsPtr);
{Compacts the input string}
begin
   with FSP^ do
   with FixedInfoPtr(DataPtr)^ do
   begin
      if WholeStr [1] = '-' then
      begin
         delete(WholeStr,1,1);
         WholeStr := '-'+padright(Strip('A',Pad,WholeStr),pred(WholeP),Pad);
      end
      else
         WholeStr := padright(Strip('A',Pad,WholeStr),WholeP,Pad);
      DPStr := padleft(Strip('A',Pad,DPStr),RealDP,'0');
      end;
end; { Condense }

procedure FixedSetNull(FSP:FieldSettingsPtr);
{}
begin
   with FSP^ do
   with FixedInfoPtr(DataPtr)^ do
   begin
      CursorX := 1;
      StrLocX := pred(wholep);
      WholeStr:= replicate(WholeP,Pad);
      DPStr :=  replicate(RealDP,Pad);
   end;
end; {FixedSetNull}

procedure FixedRedisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
var
  ValStr: StrScreen;
  A,P:byte;
begin
   with FSP^ do
   with IOVars.Form[IOVars.CurrentForm]^ do
   with FixedInfoPtr(DataPtr)^ do
   begin
      if not (Status in [Activate,HiStatus]) then
         Condense(FSP);
      ValStr := WholeStr;
      if RealDP > 0 then
         ValStr := ValStr+DecimalSep+DPStr;
      if Status in [Activate,HiStatus] then
      begin
          GotoXY(X1+pred(StrLocX),Y1);
          if FirstCharPress
          and ((length(WholeStr) <> 0) or (length(WholeStr) <> 0))
          and IsRule(FieldRules,EraseDefault) then
          begin
             P := 1;
             while (WholeStr[P] = Pad) and (P <= length(WholeStr)) do
                inc(P);
             if P <= length(WholeStr) then
             begin
               WriteAT(X1,Y1,Col[IOEditHi],copy(ValStr,1,pred(P)));
               WriteAT(X1+pred(P),Y1,Col[IOEditErase],copy(ValStr,P,80));
             end
             else
               WriteAT(X1,Y1,Col[IOEditErase],ValStr)
          end
          else
             WriteAT(X1,Y1,Col[IOEditHi],ValStr);
          exit;
      end
      else if Active = FldOn then
         A := Col[IOEditNorm]
      else
         A := Col[IOEditOff];
      WriteRight(X2,Y1,A,ValStr);
   end;
end; { FixedRedisplay }

function FixedValStr(FSP:FieldSettingsPtr): string;
{INTERNAL - returns the field value in a real string format}
var ValStr: string;
begin
   if (FSP <> nil) then
   begin
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         Condense(FSP);
         ValStr := WholeStr+DecimalSep+DPStr;
         ValStr := strip('A',Pad,ValStr);
      end;
      FixedValStr := ValStr
  end
  else
     FixedValStr := '';
end; { FixedValStr }


{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure FixedRefresh(FSP:FieldSettingsPtr);
{Updates the field's display based on the new value of the real field}
var
   TempStr: string;
   P: byte;
begin
   if (FSP <> nil) then
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         DPStr := replicate(RealDP,Pad);
         if IsRule(FieldRules,SuppressZero)
         and (RPtr^ = 0.0) then
             WholeStr := replicate(WholeP,Pad)
         else
         begin
            TempStr := RealToStr(RPtr^,RealDP);
            P := pos('.',TempStr);
            if (P = 0) or (RealDP = 0) then
               WholeStr := padright(TempStr,WholeP,Pad)
            else
            begin
               WholeStr := padright(copy(TempStr,1,pred(P)),WholeP,Pad);
               DPStr := padleft(copy(TempStr,succ(P),RealDP),RealDP,Pad);
            end;
         end;
         {now do something with the cursor!!}
         StrLocX := 1;
         GotoXY(X1+pred(StrLocX),Y1);
      end;
end; {FixedRefresh}

procedure FixedUpdate(FSP:FieldSettingsPtr);
{}
var ValStr: string;
begin
   if (FSP <> nil) then
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         ValStr := FixedValStr(FSP);
         if ValidReal(ValStr) then
            RPtr^ := StrToReal(ValStr)
         else
            RPtr^ := 0.0;
      end;
end; { FixedUpdate }

function FixedSuspend:boolean;
{Checks for Min and Max and null}
var
  VR: extended;
  FSP:FieldSettingsPtr;

begin
   FSP := ActiveForm^.ActiveFieldPtr^.FieldInfo;
   with FSP^ do
   with FixedInfoPtr(DataPtr)^ do
   begin
      FixedSuspend := true;
      Condense(FSP);
      if (WholeStr = '') and (DPStr = '') then
      begin
         if not IsRule(FieldRules,AllowNull) then
         begin
            {Not empty message}
            FixedSuspend := false;
         end;
         exit;
      end
      else
      begin
         if (EMin <> EMax) then  {need to check range}
         begin
            VR := StrToReal(strip('A',Pad,WholeStr+'.'+DPStr));
            if (VR < EMin) or (VR > EMax) then
            begin
               OutOfRangeMessage(RealToStr(EMin,RealDP),RealToStr(EMax,RealDP));
               FixedSuspend := false;
            end;
         end;
      end;
   end;
end; { FixedSuspend }

procedure FixedDisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
begin
   FixedRedisplay(FSP,Status);
end; { FixedDisplay }

function FixedKeyHandler(InKey:word;X,Y:byte):gAction;
{Input handler used by the lateral scrolling string field}
var
  FSP:FieldSettingsPtr;

   procedure Erase;
   {}
   begin
      FixedSetNull(FSP);
      FixedDisplay(FSP,HiStatus);
   end; { Erase }

   procedure CursorRight;
   {}
   begin
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         if StrLocX < Fieldlen then
            inc(StrLocX);
         if (StrLocX = succ(WholeP)) then
            inc(StrLocX);
      end;
   end; { CursorRight }

   procedure CursorLeft;
   {}
   begin
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         if StrLocX > 1 then
            dec(StrLocX);
         if (StrLocX = succ(WholeP)) then
            dec(StrLocX);
      end;
   end; { CursorLeft }

   procedure CursorHome;
   {}
   begin
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
          StrLocX := 1;
   end; { CursorHome }

   procedure CursorEnd;
   {}
   begin
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
          StrLocX := FieldLen;
   end; { CursorEnd }

   procedure DeleteChar;
   {}
   var P : byte;
   begin
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
          if StrLocX  <= WholeP then
          begin
             P := StrLocX-(WholeP-length(WholeStr));
             delete(WholeStr,P,1);
             insert(Pad,WholeStr,P);
          end
          else
          begin
             P := StrLocX - succ(WholeP);
             delete(DPStr,P,1);
             insert(Pad,DPStr,P);
          end;
          FixedRedisplay(FSP,HiStatus);
      end;
   end; { DeleteChar }

   procedure Backspace;
   {}
   begin
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         if StrLocX > 1 then
         begin
            CursorLeft;
            DeleteChar;
         end;
      end;
   end; { Backspace }

   procedure PeriodHit;
   {}
   begin
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         Condense(FSP);
         if RealDP > 0 then
            StrLocX := WholeP + 2
         else
            StrLocX := WholeP;
         FixedRedisplay(FSP,HiStatus);
      end;
   end; { PeriodHit }

   procedure PlusHit;
   {}
   var P: byte;
   begin
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         if FirstCharPress and IsRule(FieldRules,EraseDefault) then
            Erase;
         P := pos('-',WholeStr);
         if P > 0 then
         begin
            delete(WholeStr,P,1);
            insert(Pad,WholeStr,P);
            FixedRedisplay(FSP,HiStatus);
         end;
      end;
   end; { PlusHit }

   procedure MinusHit;
   {}
   var P: byte;
   begin
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         if (EMin >= 0.0) and (EMin <> EMax) then
            Beep
         else
         begin
            if FirstCharPress and IsRule(FieldRules,EraseDefault) then
               Erase;
            P := pos('-',WholeStr);
            if P = 0 then
            begin
               P := pos(Pad,WholeStr);
               if P = 0 then
                  Beep
               else
               begin
                  delete(WholeStr,P,1);
                  WholeStr := '-'+WholeStr;
               end;
               FixedRedisplay(FSP,HiStatus);
               if StrLocX = 1 then
                  CursorRight;
            end;
         end;
      end;
   end; { MinusHit }

   procedure FixedProcessChar(FSP:FieldSettingsPtr; Ch:Char);
   {}
   var
     P,WholePos,DPPos: byte;
   begin
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         if Ch in ['0'..'9'] then
         begin
            if FirstCharPress and IsRule(FieldRules,EraseDefault) then
            begin
               FixedSetNull(FSP);
               FixedRedisplay(FSP,HiStatus);
            end;
         end
         else
         begin
            Ding;
            exit
         end;
         WholePos := StrLocX-(WholeP-length(WholeStr));
         if StrLocX > WholeP then  {entering decimals}
            DPPos := StrLocX - succ(WholeP)
         else
            DPPos := 0;
         if not ActiveForm^.InsertMode then
         begin
            if DPpos > 0 then  {entering decimals}
            begin
               delete(DPStr,DPPos,1);
               insert(Ch,DPStr,DPPos);
            end
            else  {entering whole numbers}
            begin
               delete(WholeStr,WholePos,1);
               insert(Ch,WholeStr,WholePos);
            end;
         end
         else    {insertmode}
         begin
            if DPPos > 0 then  {entering decimals}
            begin
               if DPStr[DPPos] = Pad then
               begin
                  delete(DPStr,DPPos,1);
                  insert(Ch,DPStr,DPPos);
               end
               else
               begin
                  P := PosAfter(Pad,DPStr,DPPos);
                  if P = 0 then   {push a character off the end}
                     delete(DPStr,length(DPStr),1)
                  else
                     delete(DPStr,P,1);
                  insert(Ch,DPStr,DPPos);
               end;
            end
            else  {entering whole numbers}
            begin
               if WholeStr[WholePos] in [Pad,'-'] then
               begin
                  delete(WholeStr,WholePos,1);
                  insert(Ch,WholeStr,WholePos);
               end
               else
               begin
                  P := LastPosBefore(Pad,WholeStr,WholePos);
                  if P = 0 then
                     P := pos(Pad,WholeStr);
                  if P = 0 then   {no room for another character}
                  begin
                     FieldFullMessage;
                     exit;
                  end
                  else
                  begin
                     delete(WholeStr,P,1);
                     insert(Ch,WholeStr,WholePos);
                     if WholePos = WholeP then
                     begin
                        FixedRedisplay(FSP,HiStatus);  {don't cursor right}
                        exit;
                     end;
                  end;
               end;
            end;
         end;
      end;
      CursorRight;
      FixedRedisplay(FSP,HiStatus);
   end; { FixedProcessChar }

   procedure MouseDown;
   {}
   var
      L,C,R:boolean;
      X,Y:byte;
   begin
      with FSP^ do
      with ScrollInfoPtr(DataPtr)^ do
      begin
         repeat
            MouseStatusWin(L,C,R,X,Y);
            if L and (Y = Y1) and (X >= X1) and (X <= X2) then
            begin
               StrLocX := X - pred(X1);
               gotoxy(X,Y1);
               if (FirstCharPress) then
               begin  {clear the erase default setting}
                   FirstCharPress := false;
                   FixedRedisplay(FSP,HiStatus);
               end;
            end;
         until not L;
      end;
   end; { MouseDown }

begin
   FSP := ActiveForm^.ActiveFieldPtr^.FieldInfo;
   FixedKeyHandler := none;
   if Inkey = ord(DecimalSep) then
      PeriodHit
   else
      case InKey of
         8: BackSpace;
         339: DeleteChar;
         327: CursorHome;
         335: CursorEnd;
         331: CursorLeft;
         333: CursorRight;
         338: with ActiveForm^ do
              begin
                  InsertMode := not InsertMode;
                  InsertProc(InsertMode);
              end;
         ord('+'): PlusHit;
         ord('-'): MinusHit;
         32..255: FixedProcessChar(FSP,chr(InKey));    {characters}
         500: MouseDown;
      end; {case}
   if (Inkey > 0) and (Inkey < 256) then
      FSP^.FirstCharPress := false;
   with FSP^ do
      GotoXY(X1+pred(StrLocX),Y1);
end; { FixedKeyHandler }

procedure FixedDisposeHook(FNP:FieldSettingsPtr);
{}
begin
   if FNP <> nil then
      with FNP^ do
         freemem(DataPtr,DataSize);
end; {FixedDisposeHook}
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure FixedRealField(FieldID:integer; var Realvar:extended;Whole,DP:byte;Min,Max:extended);
{}
var FNP: FieldNodePtr;
begin
   FNP := FieldPtr(FieldID);
   if (FNP <> nil) then
      with FNP^.FieldInfo^ do
      begin
         RPtr := @RealVar;
         RealDP := DP;
         FieldType := IOOther;
         FieldStr      := Sptr^;
         if DP = 0 then
            FieldLen := Whole
         else
            FieldLen      := succ(Whole+DP);
         StrLocX       := 1;
         X2 := X1 + pred(FieldLen);
         ProcesskeyHook := FixedKeyHandler;
         SuspendHook := FixedSuspend;
         DisplayHook := FixedDisplay;
         RefreshFieldHook := FixedRefresh;
         UpdateVarHook := FixedUpdate;
         DisposeHook := FixedDisposeHook;
         OMisc       := FixedFld;
         UsesCursors := false;
         DataSize := sizeof(FixedInfo);
         getmem(DataPtr,DataSize);
         with FixedInfoPtr(DataPtr)^ do
         begin
            WholeP := Whole;
            Pad := IOVars.Whitespace;
            EMax := Max;
            EMin := Min;
         end;
         FixedRefresh(FNP^.FieldInfo);
      end;
end; { FixedRealField }

                           {********************}
                           {**  Spin Generic  **}
                           {********************}
procedure DrawIcons(X,Y:byte; Spinners, Drop:boolean; Active:boolean);
{}
var
  W,BackAttr: byte;

begin
   with IOVars.Form[IOVars.CurrentForm]^ do
   with IO3Vars do
   begin
      BackAttr := BAttr(ReadAttr(X+1,Y));
      if not Active then {hide icons}
      begin
         W := length(IconPadLeft)+length(IconPadRight)+1+ord(Drop)+Ord(Spinners);
         WriteAT(succ(X),Y,Cattr(black,BackAttr),replicate(W,' '));
      end
      else
      begin
         if Spinners then
         begin
           if Drop then
           begin
              WriteAT(succ(X),Y,Cattr(BAttr(Col[IOIcons]),BackAttr),IconPadLeft+'   '+IconPadRight);
              WriteAT(X+2,Y,Col[IOIcons],SpinDown+SpinUp+DropDown);
           end
           else
           begin
              WriteAT(succ(X),Y,Cattr(BAttr(Col[IOIcons]),BackAttr),IconPadLeft+'  '+IconPadRight);
              WriteAT(X+2,Y,Col[IOIcons],SpinDown+SpinUp);
           end;
         end
         else      {draw drop icon}
         begin
              WriteAT(succ(X),Y,Cattr(BAttr(Col[IOIcons]),BackAttr),IconPadLeft+' '+IconPadRight);
              WriteAT(X+2,Y,Col[IOIcons],DropDown);
         end;
      end;
   end;
end; { DrawIcons }

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure SpinBasicDisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
begin
   with FSP^ do
   begin
      DrawIcons(X2,Y1,true,false,Active=FldOn);
      BasicDisplay(FSP,Status);
   end;
end; { SpinBasicDisplay }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

                             {****************}
                             {**  SpinLong  **}
                             {****************}
{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
function SpinLongKeyHandler(InKey:word;X,Y:byte):gAction;
{Input handler used by the lateral scrolling string field}
var
  FSP:FieldSettingsPtr;
  WaitTime,
  RetCode:integer;
  VL:longint;
  L,C,R: boolean;
  MX,MY: byte;

   procedure SpinUpOne;
   {}
   begin
      with FSP^ do
      begin
         val(FieldStr,VL,Retcode);
         if (RetCode = 0) and ((LMin = LMax) or (VL < LMax)) then
         begin
            FieldStr := IntToStr(VL+delta);
            SetCursor(FSP);
         end;
      end;
   end; { SpinUpOne }

   procedure SpinDownOne;
   {}
   begin
      with FSP^ do
      begin
         val(FieldStr,VL,Retcode);
         if (RetCode = 0) and ((LMin = LMax) or (VL > LMin)) then
         begin
            FieldStr := IntToStr(VL-Delta);
            SetCursor(FSP);
         end;
      end;
   end; { SpinDownOne }

   procedure MouseSpinUp;
   {}
   begin
      WaitTime := KeyVars.InitScrollDelay;
      with FSP^ do
      begin
         val(FieldStr,VL,Retcode);
         if (RetCode = 0) then
         begin
            FirstCharPress := false;
            repeat
               MouseStatusWin(L,C,R,MX,MY);
               if L and (MY = Y1) and (MX = X2+3) then
               begin
                  if ((LMin = LMax) or (VL < LMax)) then
                  begin
                     inc(VL,delta);
                     FieldStr := IntToStr(VL);
                     BasicDisplay(FSP,HiStatus);
                     if (ActiveForm^.WinNum <> 0) then
                        WinDrawTop;
                  end;
               end;
               DelayIt(L,(ActiveForm^.WinNum <> 0),WaitTime);
            until not L;
         end
         else
            MouseRelease;
      end;
      SetCursor(FSP);
   end; { MouseSpinUp }

   procedure MouseSpinDown;
   {}
   begin
      WaitTime := KeyVars.InitScrollDelay;
      with FSP^ do
      begin
         val(FieldStr,VL,Retcode);
         if (RetCode = 0) then
         begin
            FirstCharPress := false;
            repeat
               MouseStatusWin(L,C,R,MX,MY);
               if L and (MY = Y1) and (MX = X2+2) then
               begin
                  if ((LMin = LMax) or (VL > LMin)) then
                  begin
                     dec(VL,Delta);
                     FieldStr := IntToStr(VL);
                     BasicDisplay(FSP,HiStatus);
                     if (ActiveForm^.WinNum <> 0) then
                        WinDrawTop;
                  end;
               end;
               DelayIt(L,(ActiveForm^.WinNum <> 0),WaitTime);
            until not L;
         end
         else
            MouseRelease;
      end;
      SetCursor(FSP);
   end; { MouseSpinDown }

begin
   FSP := ActiveForm^.ActiveFieldPtr^.FieldInfo;
   SpinLongKeyHandler := none;
   with FSP^ do
   with IO3Vars do
   begin
      if (Inkey = SpinUpkey) then
         SpinUpOne
      else if (Inkey = SpinDownkey) then
         SpinDownOne
      else if (Inkey = 500) and (X = X2+2) then
         MouseSpinDown
      else if (Inkey = 500) and (X = X2+3) then
         MouseSpinUp
      else
         SpinLongKeyHandler := BasicKeyHandler(Inkey,X,Y);
   end; {with}
end; { SpinLongKeyHandler }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure SpinLongField(FieldID:integer; var LongIntvar:LongInt;Width:byte;
                        Min,Max,Increment : LongInt);
{}
var FNP: FieldNodePtr;
begin
   FNP := FieldPtr(FieldID);
   if (FNP <> nil) then
      with FNP^.FieldInfo^ do
      begin
         FieldType := IOLongInt;
         LPtr      := @LongIntVar;
         FieldFmt  := replicate(Width,'#');
         FieldStr  := VartoString(FieldID);
         if (Max = 0) or (Max < Min) then
            LMax := 2147483647
         else
            LMax := Max;
         if ((Min = 0) and (Max = 0)) or (Min > LMax) then
            LMin := -2147483647
         else
            LMin := Min;
         if Increment < 1 then
            Delta := 1
         else
            Delta := Increment;
         FieldLen  := Width;
         X2 := X1 + pred(FieldLen);
         IconWidth := 4;
         SetBasicHooks(FNP^.FieldInfo,true);
         DisplayHook := SpinBasicDisplay;
         ProcesskeyHook := SpinLongKeyHandler;
       end;
end; {SpinLongField}

                             {****************}
                             {**  SpinReal  **}
                             {****************}
{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure SpinRealDisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
begin
   with FSP^ do
   begin
      DrawIcons(X2,Y1,true,false,Active=FldOn);
      FixedDisplay(FSP,Status);
   end;
end; { SpinRealDisplay }

function SpinRealKeyHandler(InKey:word;X,Y:byte):gAction;
{Input handler used by the lateral scrolling string field}
var
   FSP:FieldSettingsPtr;
   WaitTime:integer;
   VE:extended;
   L,C,R: boolean;
   MX,MY: byte;

   procedure SpinUpDelta;
   {}
   begin
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         VE := StrToReal(FixedValStr(FSP));
         if ((EMin = EMax) or (VE < EMax)) then
         begin
            VE := VE + EDelta;
            if VE > EMax then
               VE := EMax;
            RPtr^ := VE;
            FixedRefresh(FSP);
         end;
      end;
   end; { SpinUpDelta }

   procedure SpinDownDelta;
   {}
   begin
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         VE := StrToReal(FixedValStr(FSP));
         if ((EMin = EMax) or (VE > EMin)) then
         begin
            VE := VE - EDelta;
            if VE < EMin then
               VE := EMin;
            RPtr^ := VE;
            FixedRefresh(FSP);
         end;
      end;
   end; { SpinDownDelta }

   procedure MouseSpinUp;
   {}
   begin
      WaitTime := KeyVars.InitScrollDelay;
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         VE := StrToReal(FixedValStr(FSP));
         FirstCharPress := false;
         repeat
            MouseStatusWin(L,C,R,MX,MY);
            if L and (MY = Y1) and (MX = X2+3) then
            begin
               if ((EMin = EMax) or (VE < EMax)) then
               begin
                  VE := VE + EDelta;
                  if VE > EMax then
                     VE := EMax;
                  RPtr^ := VE;
                  FixedRefresh(FSP);
                  FixedDisplay(FSP,HiStatus);
                  if (ActiveForm^.WinNum <> 0) then
                     WinDrawTop;
               end;
               DelayIt(L,(ActiveForm^.WinNum <> 0),WaitTime);
            end;
         until not L;
      end;
      SetCursor(FSP);
   end; { MouseSpinUp }

   procedure MouseSpinDown;
   {}
   begin
      WaitTime := KeyVars.InitScrollDelay;
      with FSP^ do
      with FixedInfoPtr(DataPtr)^ do
      begin
         VE := StrToReal(FixedValStr(FSP));
         FirstCharPress := false;
         repeat
            MouseStatusWin(L,C,R,MX,MY);
            if L and (MY = Y1) and (MX = X2+2) then
            begin
               if ((EMin = EMax) or (VE > EMin)) then
               begin
                  VE := VE - EDelta;
                  if VE < EMin then
                     VE := EMin;
                  RPtr^ := VE;
                  FixedRefresh(FSP);
                  FixedDisplay(FSP,HiStatus);
                  if (ActiveForm^.WinNum <> 0) then
                     WinDrawTop;
               end;
               DelayIt(L,(ActiveForm^.WinNum <> 0),WaitTime);
            end;
         until not L;
      end;
      SetCursor(FSP);
   end; { MouseSpinDown }

begin
   FSP := ActiveForm^.ActiveFieldPtr^.FieldInfo;
   SpinRealKeyHandler := none;
   with FSP^ do
   with IO3Vars do
   begin
      if (Inkey = SpinUpkey) then
         SpinUpDelta
      else if (Inkey = SpinDownkey) then
         SpinDownDelta
      else if (Inkey = 500) and (X = X2+2) then
         MouseSpinDown
      else if (Inkey = 500) and (X = X2+3) then
         MouseSpinUp
      else
         SpinRealKeyHandler := FixedKeyHandler(Inkey,X,Y);
   end; {with}
end; { SpinRealKeyHandler }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure SpinRealField(FieldID:integer; var Realvar:extended;Whole,DP:byte;Min,Max,Delta:extended);
{}
var FNP: FieldNodePtr;
begin
   FNP := FieldPtr(FieldID);
   if (FNP <> nil) then
      with FNP^.FieldInfo^ do
      begin
         FixedRealField(FieldID,Realvar,Whole,DP,Min,Max);
         IconWidth := 4;
         FixedInfoPtr(DataPtr)^.EDelta := Delta;
         DisplayHook := SpinRealDisplay;
         ProcesskeyHook := SpinRealKeyHandler;
       end;
end; {SpinRealField}

                             {****************}
                             {**  SpinDate  **}
                             {****************}

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
function SpinDateKeyHandler(InKey:word;X,Y:byte):gAction;
var
  FSP:FieldSettingsPtr;
  WaitTime: integer;
  Jul:dates;
  L,C,R: boolean;
  MX,MY: byte;

   procedure SpinUpOne;
   {}
   begin
      with FSP^ do
      begin
         if not ValidDateStr(FieldStr,DFormat) then
            exit;
         Jul := StrtoJul(FieldStr,DFormat);
         if (DMin = DMax) or (Jul < DMax) then
         begin
            FieldStr:= Unformatteddate(JultoStr(succ(Jul),DFormat));
            SetCursor(FSP);
         end;
      end;
   end; { SpinUpOne }

   procedure SpinDownOne;
   {}
   begin
      with FSP^ do
      begin
         if not ValidDateStr(FieldStr,DFormat) then
            exit;
         Jul := StrtoJul(FieldStr,DFormat);
         if (DMin = DMax) or (Jul > DMin) then
         begin
            FieldStr:= Unformatteddate(JultoStr(pred(Jul),DFormat));
            SetCursor(FSP);
         end;
      end;
   end; { SpinDownOne }

   procedure MouseSpinUp;
   {}
   begin
      WaitTime := KeyVars.InitScrollDelay;
      with FSP^ do
      begin
         if ValidDateStr(FieldStr,DFormat) then
         begin
            FirstCharPress := false;
            Jul := StrtoJul(FieldStr,DFormat);
            repeat
               MouseStatusWin(L,C,R,MX,MY);
               if L and (MY = Y1) and (MX = X2+3) then
               begin
                  if (DMin = DMax) or (Jul < DMax) then
                  begin
                     inc(Jul);
                     FieldStr:= Unformatteddate(JultoStr(Jul,DFormat));
                     BasicDisplay(FSP,HiStatus);
                     if (ActiveForm^.WinNum <> 0) then
                        WinDrawTop;
                  end;
               end;
               DelayIt(L,(ActiveForm^.WinNum <> 0),WaitTime);
            until not L;
         end
         else
            MouseRelease;
      end;
      SetCursor(FSP);
   end; { MouseSpinUp }

   procedure MouseSpinDown;
   {}
   begin
      WaitTime := KeyVars.InitScrollDelay;
      with FSP^ do
      begin
         if ValidDateStr(FieldStr,DFormat) then
         begin
            FirstCharPress := false;
            Jul := StrtoJul(FieldStr,DFormat);
            repeat
               MouseStatusWin(L,C,R,MX,MY);
               if L and (MY = Y1) and (MX = X2+2) then
               begin
                  if ((DMin = DMax) or (Jul > DMin)) then
                  begin
                     dec(Jul);
                     FieldStr:= Unformatteddate(JultoStr(Jul,DFormat));
                     BasicDisplay(FSP,HiStatus);
                     if (ActiveForm^.WinNum <> 0) then
                        WinDrawTop;
                  end;
               end;
               DelayIt(L,(ActiveForm^.WinNum <> 0),WaitTime);
            until not L;
         end
         else
            MouseRelease;
      end;
      SetCursor(FSP);
   end; { MouseSpinDown }

begin
   FSP := ActiveForm^.ActiveFieldPtr^.FieldInfo;
   SpinDateKeyHandler := none;
   with FSP^ do
   with IO3Vars do
   begin
      if (Inkey = SpinUpkey) then
         SpinUpOne
      else if (Inkey = SpinDownkey) then
         SpinDownOne
      else if (Inkey = 500) and (X = X2+2) then
         MouseSpinDown
      else if (Inkey = 500) and (X = X2+3) then
         MouseSpinUp
      else
         SpinDateKeyHandler := BasicKeyHandler(Inkey,X,Y);
   end; {with}
end; { SpinDateKeyHandler }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure SpinDateField(FieldID:integer; var Datevar:Dates; DateFormat:gDate;
                        DefFormat:string; Min,Max : Dates);
{}
var FNP: FieldNodePtr;
begin
   FNP := FieldPtr(FieldID);
   if (FNP <> nil) then
      with FNP^.FieldInfo^ do
      begin
         DateField(FieldID,Datevar,DateFormat,DefFormat,Min,Max);
         IconWidth := 4;
         DisplayHook := SpinBasicDisplay;
         ProcesskeyHook := SpinDateKeyHandler;
       end;
end; {SpinDateField}

                             {****************}
                             {**  DropDate  **}
                             {****************}

procedure DropTheCal(FSP:FieldSettingsPtr);
{}
var
  Jul: Dates;
  OldSettings: CalSet;
begin
   with FSP^ do
   begin
      OldSettings := CalVars;
      {adjust the calendar window position}
      with CalVars do
      begin

      end;
      Jul := StrtoJul(FieldStr,DFormat);
      if (FieldStr = '') or (Jul = 0) then
         Jul := TodayinJul;
      CalVars.Chooseday := true;
      Jul := RunCalendar(Jul,'');
      if (KeyVars.LastKey <> 27) and (KeyVars.LastKey <> 600) then
         FieldStr:= Unformatteddate(JultoStr(Jul,DFormat));
   end;
   CalVars := OldSettings;
end; { DropTheCal }

function ReleaseOnDrop(FSP:FieldSettingsPtr;X2Offset:byte):boolean;
{}
var
  L,C,R: boolean;
  X,Y: byte;
begin
   repeat
      MouseStatusWin(L,C,R,X,Y);
   until not L;
   with FSP^ do
      ReleaseOnDrop := (Y = Y1) and (X = X2 + X2Offset);
end; { ReleaseOnDrop }

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure DropDateDisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
begin
   with FSP^ do
   begin
      DrawIcons(X2,Y1,false,true,Active=FldOn);
      BasicDisplay(FSP,Status);
   end;
end; { DropDateDisplay }

function DropDateKeyHandler(InKey:word;X,Y:byte):gAction;
var
  FSP:FieldSettingsPtr;
begin
   FSP := ActiveForm^.ActiveFieldPtr^.FieldInfo;
   DropDateKeyHandler := none;
   with FSP^ do
   with IO3Vars do
   begin
      if (InKey = DropDownKey) then
         DropTheCal(FSP)
      else if ((Inkey=500) and (X = X2+2)) then
      begin
         if ReleaseOnDrop(FSP,2) then
             DropTheCal(FSP);
      end
      else
         DropDateKeyHandler := BasicKeyHandler(Inkey,X,Y);
   end;
end; { DropDateKeyHandler }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure DropDateField(FieldID:integer; var Datevar:Dates; DateFormat:gDate;
                        DefFormat:string; Min,Max : Dates);
{}
var FNP: FieldNodePtr;
begin
   FNP := FieldPtr(FieldID);
   if (FNP <> nil) then
      with FNP^.FieldInfo^ do
      begin
         DateField(FieldID,Datevar,DateFormat,DefFormat,Min,Max);
         IconWidth := 4;
         DisplayHook := DropDateDisplay;
         ProcesskeyHook := DropDateKeyHandler;
         UsesCursors := true;
       end;
end; {DropDateField}

                           {********************}
                           {**  SpinDropDate  **}
                           {********************}

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure SpinDropDateDisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
begin
   with FSP^ do
   begin
      DrawIcons(X2,Y1,true,true,Active=FldOn);
      BasicDisplay(FSP,Status);
   end;
end; { SpinDropDateDisplay }

function SpinDropDateKeyHandler(InKey:word;X,Y:byte):gAction;
var
  FSP:FieldSettingsPtr;
begin
   FSP := ActiveForm^.ActiveFieldPtr^.FieldInfo;
   SpinDropDateKeyHandler := none;
   with FSP^ do
   with IO3Vars do
   begin
      if (InKey = DropDownKey) then
         DropTheCal(FSP)
      else if ((Inkey=500) and (X = X2+4)) then
      begin
         if ReleaseOnDrop(FSP,4) then
            DropTheCal(FSP);
      end
      else
         SpinDropDateKeyHandler := SpinDateKeyHandler(Inkey,X,Y);
   end;
end; { SpinDropDateKeyHandler }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure SpinDropDateField(FieldID:integer; var Datevar:Dates; DateFormat:gDate;
                            DefFormat:string; Min,Max : Dates);
{}
var FNP: FieldNodePtr;
begin
   FNP := FieldPtr(FieldID);
   if (FNP <> nil) then
      with FNP^.FieldInfo^ do
      begin
         DateField(FieldID,Datevar,DateFormat,DefFormat,Min,Max);
         IconWidth := 5;
         DisplayHook := SpinDropDateDisplay;
         ProcesskeyHook := SpinDropDateKeyHandler;
         UsesCursors := true;
       end;
end; {SpinDropDateField}

                            {*****************}
                            {**  Drop List  **}
                            {*****************}

function DropTheList(FSP:FieldSettingsPtr): longint;
{}
var
  X,Y,
  W,D: byte;
begin
   with FSP^ do
   with ListCfg(DataPtr^)  do
   begin
      W := X2-X1+6;                                 {make window correct width}
      if StringLLPtr(DataSource)^.TotalNodes <= 8 then
         D := StringLLPtr(DataSource)^.TotalNodes + 2
      else
         D := 10;
      if (ActiveForm^.WinNum <> 0) then
      begin
         X := WinGlobalX(0,X1);
         Y := WinGlobalY(0,Y1);
      end
      else
      begin
         X := X1;
         Y := Y1;
      end;
      {display the window over the field if it fits}
      with ListVars do
      begin
         if X + W - 2 <= HardVars.Width then
         begin
            if X > 2 then
               ListVars.WX1 := X - 2
            else
               ListVars.WX1 := 1;
         end
         else if HardVars.Width - W - 4 >= 1 then
            ListVars.WX1 := HardVars.Width - W - 4
         else
            ListVars.WX1 := 1;
         if Y + D - 1 <= HardVars.Depth then
         begin
            if Y > 1 then
               ListVars.WY1 := pred(Y)
            else
               Y := 1;
         end
         else if HardVars.Depth - D - 2 >= 1 then
            ListVars.WY1 := HardVars.Depth - D
         else
            ListVars.WY1 := 1;
         WX2 := WX1 + pred(W);
         WY2 := WY1 + pred(D);
      end;
      {show the list}
      DropTheList := RunListStrLL(StringLLPtr(DataSource)^,'');
   end;
end; { DropTheList }

procedure JustDropList(FSP:FieldSettingsPtr);
{}
var Item: longint;
begin
   Item := DropTheList(FSP);
   {update the field if the user didn't escape}
   if Item <> 0 then
      with FSP^ do
      with StringLLPtr(ListCfg(DataPtr^).DataSource)^  do
           ActiveNode := Item
end; { JustDropList }

procedure DropListRedisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
var A : byte;
begin
   with FSP^ do
   with ListCfg(DataPtr^)  do
   with IOVars.Form[IOVars.CurrentForm]^ do
   begin
      if Active <> FldOn then
         A := Col[IOEditOff]
      else
      case Status of
         NormStatus: A := Col[IOEditNorm];
         OffStatus:  A := Col[IOEditOff];
         else A := Col[IOEditHi];
      end;
      WriteAT(X1,Y1,A,padleft(StrLLGetStr(StringLLPtr(DataSource)^,
                              StringLLPtr(DataSource)^.ActiveNode),
                              succ(X2-X1),' '));
      integer(SourcePtr^) := ActiveNode;
      if Status in [HiStatus,Activate] then
         GotoXY(X1,Y1);
   end;
end; {DropListRedisplay}


{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure DropListDisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
begin
   with FSP^ do
   begin
      DrawIcons(X2,Y1,false,true,Active=FldOn);
      DropListReDisplay(FSP,Status);
   end;
end; { DropListDisplay }

function DropListKeyHandler(InKey:word;X,Y:byte):gAction;
var
  FSP:FieldSettingsPtr;
begin
   FSP := ActiveForm^.ActiveFieldPtr^.FieldInfo;
   DropListKeyHandler := none;
   with FSP^ do
   with IO3Vars do
   begin
      if (InKey = DropDownKey) then
         JustDropList(FSP)
      else if ((Inkey=500) and (X = X2+2)) then
      begin
         if ReleaseOnDrop(FSP,2) then
            JustDropList(FSP);
      end
      else
         with StringLLPtr(ListCfg(DataPtr^).DataSource)^  do
         begin
           if (Inkey = SpinDownkey) and (ActiveNode < TotalNodes) then
               inc(ActiveNode)
           else if (Inkey = SpinUpkey) and (ActiveNode > 1) then
               dec(ActiveNode);
         end;
      ListCfg(DataPtr^).ActiveNode := StringLLPtr(ListCfg(DataPtr^).DataSource)^.ActiveNode;
      integer(SourcePtr^) := ListCfg(DataPtr^).ActiveNode;
   end;
end; { DropListKeyHandler }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure DropListField(FieldID:integer; width:byte; var SelectedItem:integer);
{}
var FNP: FieldNodePtr;
begin
   FNP := FieldPtr(FieldID);
   if (FNP <> nil) then
      with FNP^.FieldInfo^ do
      begin
         ListField(FieldID,width,1,SelectedItem);
         ProcesskeyHook := DropListKeyHandler;
         DisplayHook := DropListDisplay;
         IconWidth := 4;
      end;
end; { DropListField }

                            {*****************}
                            {**  Spin List  **}
                            {*****************}

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure SpinListDisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
begin
   with FSP^ do
   begin
      DrawIcons(X2,Y1,true,false,Active=FldOn);
      DropListRedisplay(FSP,Status);
   end;
end; { SpinListDisplay }

function SpinListKeyHandler(InKey:word;X,Y:byte):gAction;
var
  FSP:FieldSettingsPtr;
  WaitTime: integer;
  L,C,R: boolean;
  MX,MY:byte;

   procedure SpinUpOne;
   {Spins down the list by increasing the ActiveNode value}
   begin
      with FSP^ do
      with StringLLPtr(ListCfg(DataPtr^).DataSource)^  do
      begin
         if ActiveNode < TotalNodes then
            inc(ActiveNode);
      end;
   end; { SpinUpOne }

   procedure SpinDownOne;
   {Spins up the list by decreasing the ActiveNode value}
   begin
      with FSP^ do
      with StringLLPtr(ListCfg(DataPtr^).DataSource)^ do
      begin
         if ActiveNode > 1 then
            dec(ActiveNode);
      end;
   end; { SpinDownOne }

   procedure MouseSpinUp;
   {}
   begin
      WaitTime := KeyVars.InitScrollDelay;
      with FSP^ do
      with StringLLPtr(ListCfg(DataPtr^).DataSource)^  do
      begin
            FirstCharPress := false;
            repeat
               MouseStatusWin(L,C,R,MX,MY);
               if L and (MY = Y1) and (MX = X2+3) then
               begin
                  if ActiveNode > 1 then
                  begin
                     dec(ActiveNode);
                     DropListRedisplay(FSP,HiStatus);
                     if (ActiveForm^.WinNum <> 0) then
                        WinDrawTop;
                  end;
               end;
               DelayIt(L,(ActiveForm^.WinNum <> 0),WaitTime);
            until not L;
      end;
   end; { MouseSpinUp }

   procedure MouseSpinDown;
   {}
   begin
      WaitTime := KeyVars.InitScrollDelay;
      with FSP^ do
      with StringLLPtr(ListCfg(DataPtr^).DataSource)^  do
      begin
            FirstCharPress := false;
            repeat
               MouseStatusWin(L,C,R,MX,MY);
               if L and (MY = Y1) and (MX = X2+2) then
               begin
                  if ActiveNode < TotalNodes then
                  begin
                     inc(ActiveNode);
                     DropListRedisplay(FSP,HiStatus);
                     if (ActiveForm^.WinNum <> 0) then
                        WinDrawTop;
                  end;
               end;
               DelayIt(L,(ActiveForm^.WinNum <> 0),WaitTime);
            until not L;
      end;
   end; { MouseSpinDown }

begin
   FSP := ActiveForm^.ActiveFieldPtr^.FieldInfo;
   SpinListKeyHandler := none;
   with FSP^ do
   with IO3Vars do
   begin
      if (Inkey = SpinUpkey) then
         SpinDownOne
      else if (Inkey = SpinDownkey) then
         SpinUpOne
      else if (Inkey = 500) and (X = X2+2) then
         MouseSpinDown
      else if (Inkey = 500) and (X = X2+3) then
         MouseSpinUp;
      with StringLLPtr(ListCfg(DataPtr^).DataSource)^  do
      begin
         ListCfg(DataPtr^).ActiveNode := ActiveNode;
         integer(SourcePtr^) := ActiveNode;
      end;

   end;
end; { SpinListKeyHandler }

{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure SpinListField(FieldID:integer; width:byte; var SelectedItem:integer);
{}
var FNP: FieldNodePtr;
begin
   FNP := FieldPtr(FieldID);
   if (FNP <> nil) then
      with FNP^.FieldInfo^ do
      begin
         ListField(FieldID,width,1,SelectedItem);
         ProcesskeyHook := SpinListKeyHandler;
         DisplayHook := SpinListDisplay;
         IconWidth := 4;
      end;
end; { SpinListField }

                           {********************}
                           {**  SpinDropList  **}
                           {********************}

procedure DropSpinList(FSP:FieldSettingsPtr);
{}
var Item: longint;
begin
   Item := DropTheList(FSP);
   {update the field if the user didn't escape}
   if Item <> 0 then
      with FSP^ do
      with StringLLPtr(ListCfg(DataPtr^).DataSource)^  do
      begin
         ActiveNode := Item;
         ListCfg(DataPtr^).ActiveNode := ActiveNode;
         integer(SourcePtr^) := Item;
      end;
end; { DropSpinList }

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure SpinDropListDisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
begin
   with FSP^ do
   begin
      DrawIcons(X2,Y1,true,true,Active=FldOn);
      DropListRedisplay(FSP,Status);
   end;
end; {SpinDropListDisplay}

function SpinDropListKeyHandler(InKey:word;X,Y:byte):gAction;
var
  FSP:FieldSettingsPtr;
begin
   FSP := ActiveForm^.ActiveFieldPtr^.FieldInfo;
   SpinDropListKeyHandler := none;
   with FSP^ do
   with IO3Vars do
   begin
      if (InKey = DropDownKey) then
         DropSpinList(FSP)
      else if ((Inkey=500) and (X = X2+4)) then
      begin
         if ReleaseOnDrop(FSP,4) then
            DropSpinList(FSP);
      end
      else
         SpinDropListKeyHandler := SpinListKeyHandler(Inkey,X,Y);
   end;
end; { SpinDropListKeyHandler }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure SpinDropListField(FieldID:integer; width:byte; var SelectedItem:integer);
{}
var FNP: FieldNodePtr;
begin
   FNP := FieldPtr(FieldID);
   if (FNP <> nil) then
      with FNP^.FieldInfo^ do
      begin
         SpinListField(FieldID,width,SelectedItem);
         ProcesskeyHook := SpinDropListKeyHandler;
         DisplayHook := SpinDropListDisplay;
         IconWidth := 5;
      end;
end; { SpinDropListField }

                          {**********************}
                          {**  Edit Drop List  **}
                          {**********************}

procedure EditDropListRedisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
begin
   ScrollDisplay(FSP,Status);
end; {SpinDropListRedisplay}

procedure DropEditList(FSP:FieldSettingsPtr);
{}
var Item: longint;
begin
   Item := DropTheList(FSP);
   {update the field if the user didn't escape}
   if Item <> 0 then
      with FSP^ do
      begin
          StringLLPtr(ListCfg(DataPtr^).DataSource)^.ActiveNode := item;
          with ListCfg(DataPtr^)  do
             FieldStr := StrLLGetStr(StringLLPtr(DataSource)^,
                         StringLLPtr(DataSource)^.ActiveNode);
          StrLocX := 1;
          CursorX := succ(X1);
          ScrollInfoPtr(DataPtrS)^.StartChar := 1;
      end;
end; { DropEditList }

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure EditDropListDisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
begin
   with FSP^ do
   begin
      DrawIcons(X2,Y1,false,true,Active=FldOn);
      ScrollDisplay(FSP,Status);
   end;
end; {EditDropListDisplay}

function EditDropListKeyHandler(InKey:word;X,Y:byte):gAction;
var
  FSP:FieldSettingsPtr;
begin
   FSP := ActiveForm^.ActiveFieldPtr^.FieldInfo;
   EditDropListKeyHandler := none;
   with FSP^ do
   with IO3Vars do
   begin
      if (InKey = DropDownKey) then
            DropEditList(FSP)
      else if ((Inkey=500) and (X = X2+2)) then
      begin
         if ReleaseOnDrop(FSP,2) then
            
            DropEditList(FSP);
      end
      else
         EditDropListKeyHandler := ScrollKeyHandler(Inkey,X,Y);
   end;
end; {EditDropListKeyHandler}

procedure DisposeEditDropMemory(FNP:FieldSettingsPtr);
{Disposes of heap memory allocated by scroll and drop data}
begin
   DisposeScrollMemory(FNP);
   DisposeListMemory(FNP);
end; {DisposeEditDropMemory}

{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure EditDropListField(FieldID:integer; var Strvar:string;FieldL,MaxL:byte);
{}
var FNP: FieldNodePtr;
begin
   FNP := FieldPtr(FieldID);
   if (FNP <> nil) then
      with FNP^.FieldInfo^ do
      begin
         ScrollField(FieldID,StrVar,FieldL,MaxL);
         ProcesskeyHook := EditDropListKeyHandler;
         DisplayHook := EditDropListDisplay;
         DisposeHook := DisposeEditDropMemory;
         IconWidth := 2;
      end;
end; { EditDropListField }

                          {*********************}
                          {**  HotSpot Field  **}
                          {*********************}

procedure HotspotField(FieldID:integer; W,D: byte; Action:gAction);
{}
var FNP: FieldNodePtr;
begin
   FNP := FieldPtr(FieldID);
   if (FNP <> nil) then
      with FNP^.FieldInfo^ do
      begin
         HotKeyHook := StandardHotKeyHandler;
         DisplayHook := NoDisplay;
         ProcessKeyHook := NoKeyHandler;
         SuspendHook := SuspendOK;
         RefreshFieldHook := DoNothing;
         UpdateVarHook := DoNothing;
         HotKey := 500;    {indicates that it is a special hotspot field}
         Visible := false;
         X2 := X1 + pred(W);
         Y2 := Y1 + pred(D);
         OMisc := ord(Action);
      end;
end; { HotSpotField }

                           {********************}
                           {**  BrowseFields  **}
                           {********************}

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}

procedure BrowseDisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
begin
   BrowseRefresh(ListCfg(FSP^.DataPtr^));
end; { BrowseDisplay }

function BrowseKeyHandler(InKey:word;X,Y:byte):gAction;
{}
begin
   BrowseKeyHandler := none;
   with ActiveForm^.ActiveFieldPtr^.FieldInfo^ do
      BrowseProcessKey(ListCfg(DataPtr^),Inkey,X,Y,false);
end; { BrowseKeyHandler }

procedure BrowseRefreshField(FNP:FieldSettingsPtr);
{}
begin
   with FNP^ do
      if DataPtr <> nil then
         ListCfg(DataPtr^).ActiveNode := integer(SourcePtr^);
end; { BrowseRefreshField }

{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure BrowseField(FieldID:integer; width,depth:byte; var ListDetails: ListCfg);
{}
var FNP: FieldNodePtr;
begin
   FNP := FieldPtr(FieldID);
   if (FNP <> nil) then
      with FNP^.FieldInfo^ do
      begin
         SetFieldDefaults(FNP^.FieldInfo);
         X2 := X1 + pred(width);
         Y2 := Y1 + pred(depth);
         Listdetails.X1 := X1;
         Listdetails.Y1 := Y1;
         Listdetails.X2 := X2;
         Listdetails.Y2 := Y2;
         ProcesskeyHook := BrowseKeyHandler;
         SuspendHook := SuspendOK;
         DisplayHook := BrowseDisplay;
         RefreshFieldHook := BrowseRefreshField;    {change this}
         FieldStr    := '';
         FieldFmt    := '';
         FieldLen    := 0;
         FieldRules  := 0;
         OMisc       := ListFld;
         UsesCursors := true;
         DataPtr := @Listdetails;
     end;
 end; { BrowseField }

                           {*******************}
                           {**  Memo Fields  **}
                           {*******************}

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure MemoDisplay(FSP:FieldSettingsPtr;Status:gStatus);
{}
begin
   DisplayMemo(MemoCfg(FSP^.DataPtr^),Status);
   if Status in [HiStatus,Activate] then
   begin
      with MemoCfg(FSP^.DataPtr^) do
         InsMode(InsertOn);
      MoveCursor(MemoCfg(FSP^.DataPtr^))
   end;
end; {MemoDisplay}

function MemoKeyHandler(InKey:word;X,Y:byte):gAction;
{}
begin
   MemoKeyHandler := none;
   with ActiveForm^.ActiveFieldPtr^.FieldInfo^ do
      MemoProcessKey(MemoCfg(DataPtr^),Inkey,X,Y);
end; {MemoKeyHandler}

function MemoSuspend:boolean;
{}
begin
   MemoSuspend := true;
   with MemoCfg(ActiveForm^.ActiveFieldPtr^.FieldInfo^.DataPtr^) do
        SetLine(@MemoCfg(ActiveForm^.ActiveFieldPtr^.FieldInfo^.DataPtr^),pred(TopNode)+CursorPosY,LineStr);
   TurnBlockOff(MemoCfg(ActiveForm^.ActiveFieldPtr^.FieldInfo^.DataPtr^));
end; {MemoSuspend}
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure MemoField(FieldID:integer; width,depth:byte;var Memo:MemoCfg);
{}
var FNP: FieldNodePtr;
begin
   FNP := FieldPtr(FieldID);
   if (FNP <> nil) then
   begin
      with FNP^.FieldInfo^ do
      begin
         SetFieldDefaults(FNP^.FieldInfo);
         X2 := X1 + pred(width);
         Y2 := Y1 + pred(depth);
         ProcesskeyHook := MemoKeyHandler;
         SuspendHook := MemoSuspend;
         DisplayHook := MemoDisplay;
         FieldStr    := '';
         FieldFmt    := '';
         FieldLen    := 0;
         FieldRules  := 0;
         OMisc       := ListFld;
         UsesCursors := true;
         DataPtr := @Memo;
      end;
      with Memo do
      begin
         X1 := FNP^.FieldInfo^.X1;
         Y1 := FNP^.FieldInfo^.Y1;
         X2 := X1 + pred(width) - 1;
         Y2 := Y1 + pred(depth);
         InWindow := false;      {let IO manager deal with window stuff}
         if WordWrap then
            MaxWidth := Width - 2;
      end;
   end;
end; { MemoField }

                {**********************************************}
                {**  U N I T    I N I T I A L I Z A T I O N  **}
                {**********************************************}

procedure IO3DefaultSettings;
{}
begin
   with IO3Vars do
   begin
      SpinUpKey := 408; {Alt-Up}
      SpinDownkey := 416; {Alt-Down}
      SpinUp := '';
      SpinDown := '';
      DropDownKey := 336; {down}
      DropDown := '';
      IconPadLeft := '';
      IconPadRight := '';
   end;
end; { IO3DefaultSettings }

procedure GoldIO3Init;
{}
begin
   IO3DefaultSettings;
end; {GoldIO3Init}

begin
   GoldIO3Init;
end.
