{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: GOLDDEMO.PAS
              A general demo for Gold showing some of the main features of
              the Toolkit.
}

program GoldDemo;

{$I GOLDFLAG.INC}

uses DOS, CRT,
     GoldFast, GoldWin, GoldMenu, GoldMisc, GoldKey, GoldRead,
     GoldIO, GoldAttr, GoldStr, GoldLink, GoldList, GoldGrid,
     GoldDate, GoldTint, GoldDir, Printer, GoldHard, GoldIO2, GoldIO3,
     GoldDb, GoldMemo;

const
     TJName  = 'TJ Software, Inc.';
     BackChar:char = '';

type
   PrintRec = record
      TypefaceID: integer;
      TypeSize: byte;
      Bold: boolean;
      Italic: boolean;
   end; {PrintRec}

var
   PrintInfo: PrintRec;
   Norm: boolean;
   LongVar: longint;
   MainMenu: MenuRecord;
   Choice: integer;
   Errorcode: integer;

                        {*********************}
                        {**  Miscellaneous  **}
                        {*********************}
procedure ClearMsgPanel;
begin
   PartClear(1,24,80,25,LightGrayOnBlue,BackChar);
end;

procedure SetMessage1(Msg:string);
begin
  PartClear(1,24,80,25,Lightgrayonblue,' ');
  WriteHi(5,24,yellowonblue,lightgrayonblue,Msg);
end;

procedure SetMessage2(Msg:string);
begin
  WriteHi(5,25,yellowonblue,lightgrayonblue,Msg);
end;

procedure SetScreen;
{}
begin
   Clear(LightGrayOnBlue,BackChar);
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,UseTint,TJName);
end; {SetScreen}

                        {*************************}
                        {**  Forms & Databases  **}
                        {*************************}

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure WatchNDXBuild( KeysWritten, TotRecords: longint; Status: byte );
{}
begin
  WriteProgressLong(18,57,10,KeysWritten,TotRecords,true);
end;
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure ShowDatabaseOnForm;
{}
const FN: string[12] = 'DEMCUST';
      Msg1 = ' An Example Of Browsing And Editing a Database ';
      Msg2 = ' Client Profiles ';
      Msg5 = ' Top of file ';
      Msg6 = '^Looping to last record';
      Msg7 = ' End of file ';
      Msg8 = '^Looping to first record';
      Msg9 = ' Deleting Record! ';
      Msg10 = '^Are you sure?';
      Msg11 = ' Ending the D/B demo ';
      Msg12 = '^Have you really finished?';
      Msg13 = ' About to cancel! ';
      EdtBtn = '~E~dit';
      AddBtn = '~A~dd';
      SavBtn = '~S~ave';
      CanBtn = '~C~ancel';
      DelBtn = '~D~el';
      QuiBtn = ' ~Q~uit ';

type UserRecord = record
       ENTERED: Dates;
       CLIENT: string[30];
       ADDR1: string[30];
       ADDR2: string[30];
       CITY: string[22];
       STATE: string[2];
       ZIP: string[9];
       COUNTRY: string[20];
       PHONE: string[10];
       UNITS: longint;
     end;

var I, Win1, Handle,
    ActiveField: integer;
    UserTerminates,
    Saving, Editing,
    Cancelling, Adding: boolean;
    RecNum, X, SavedX: longint;
    LastAction: gAction;
    UserRec, SavdUserRec: UserRecord;
    EC, NdxFld: integer;
    SavValidate: gValidate;

   procedure SetScreen;
   {}
   begin
      Tint[IOLabelNorm] := LightBlueOnLightGray;
      Tint[IOLabelNormHot] := LightBlueOnLightGray;
      Tint[IOLabelHi] := LightBlueOnLightGray;
      Tint[IOLabelHiHot] := LightBlueOnLightGray;
      Tint[IOLabelOff] := LightBlueOnLightGray;
   end; { SetScreen }

   procedure SaveUserRec;
   {}
   begin
      SavdUserRec := UserRec;
      SavedX := X;
   end; { SaveUserRec }

   procedure RestoreUserRec;
   {}
   begin
      UserRec := SavdUserRec;
      X := SavedX;
   end; { RestoreUserRec }

   function DataHasChanged: boolean;
   {}
   begin
      DataHasChanged := Different(UserRec,SavdUserRec,sizeof(UserRec));
   end; { DataHasChanged }

   procedure InitData;
   {}
   begin
      with UserRec do
      begin
         Entered := TodayInJul;
         Client := '';
         Addr1 := '';
         Addr2 := '';
         City := '';
         State := '';
         Zip := '';
         Country := '';
         Phone := '';
         Units := 0;
      end;
   end; { InitData }

   procedure DatabaseToScreen(RecNo:longint);
   {}
   begin
      with UserRec do
      begin
         Entered := DbGetFldDate(RecNo,1);
         Client := DbGetFldString(RecNo,2);
         Addr1 := DbGetFldString(RecNo,3);
         Addr2 := DbGetFldString(RecNo,4);
         City := DbGetFldString(RecNo,5);
         State := DbGetFldString(RecNo,6);
         Zip := DbGetFldString(RecNo,7);
         Country := DbGetFldString(RecNo,8);
         Phone := DbGetFldString(RecNo,9);
         Units := DbGetFldLong(RecNo,10);
      end;
   end; { DatabaseToScreen }

   procedure ScreenToDatabase;
   {}
   begin
      with UserRec do
      begin
         DbSetFldDate(1,Entered);
         DbSetFldString(2,Client);
         DbSetFldString(3,Addr1);
         DbSetFldString(4,Addr2);
         DbSetFldString(5,City);
         DbSetFldString(6,State);
         DbSetFldString(7,Zip);
         DbSetFldString(8,Country);
         DbSetFldString(9,Phone);
         DbSetFldInt(10,Units);
      end;
      if Adding then
      begin
         DbAddRecord;
         Adding := false;
      end else
         DbPutRecord;
   end; { ScreenToRecord }

   procedure BuildForm;
   {}
   var I: integer;
   begin
      CreateForms(1);
      ActivateForm(1);
      AllowEsc(false);
      SetFormWindow(10,4,70,22,7);
      Win1 := FormWinNum;
      WinSetTitle(Win1,Msg2);
      WinSetType(Win1,WMoveNoClose);
      WinSetShowNum(Win1,false);
      SetMessageXY(12,25,false);
      WinDisplay(Win1);
      KwikAddField(1, 43,2);         { ENTERED D 8 }
      KwikAddField(2, 21,4);         { CLIENT C 30 }
      KwikAddField(3, 21,5);         { ADDR1 C 30 }
      KwikAddField(4, 21,6);         { ADDR2 C 30 }
      KwikAddField(5, 21,7);         { CITY C 22 }
      KwikAddField(6, 49,7);         { STATE C 2 }
      KwikAddField(7, 21,8);         { ZIP C 10 }
      KwikAddField(8, 21,11);        { COUNTRY C 20}
      KwikAddField(9, 21,12);        { PHONE C 10}
      KwikAddField(10, 21,13);       { UNITS N 10 }
      KwikAddField(11, 3,16);        { goto top }
      KwikAddField(12, 9,16);        { prev }
      KwikAddField(13, 14,16);       { next }
      KwikAddField(14, 19,16);       { goto end }
      KwikAddField(15, 25,16);       { add }
      KwikAddField(16, 32,16);       { del }
      KwikAddField(17, 39,16);       { edit/save }
      KwikAddField(18, 47,16);       { quit/cancel }
      KwikAddLastField(19, 14,2);    { Record No }
      with UserRec do
      begin
         SpinDropDateField(1,Entered,MMDDYY,'',0,0);
         StringField(2,Client,Replicate(30,'*'));
         FieldRules(2,NoRules+EraseDefault,[NoChar],[NoChar]);
         { turns off allowNul, turn on EraseDefault }
         StringField(3,Addr1,Replicate(30,'*'));
         StringField(4,Addr2,Replicate(30,'*'));
         StringField(5,City,Replicate(22,'*'));
         StringField(6,State,'!!');
         StringField(7,Zip,'#####-####');
         StringField(8,Country,Replicate(20,'*'));
         StringField(9,Phone,'(###) ###-####');
         SpinLongField(10,Units,10,0,0,1);
      end;
      ButtonField(11,'',Stop1);
      ButtonField(12,'',Stop2);
      ButtonField(13,'',Stop3);
      ButtonField(14,'',Stop4);
      ButtonField(15,AddBtn,Stop8);
      ButtonField(16,DelBtn,Stop9);
      ButtonField(17,EdtBtn,Stop5);
      ButtonDefaultField(18,QuiBtn,escaped);
      LongintField(19,RecNum,'',0,0);
      FieldSetState(19,FldOff); { display only }
      { define labels }
      SetLabel(1,LabelLeft,LabelLeft,'Date');
      SetLabel(2,LabelLeft,LabelLeft,'Client''s name');
      SetLabel(3,LabelLeft,LabelLeft,'Address');
      SetLabel(5,LabelLeft,LabelLeft,'City, State');
      SetLabel(7,LabelLeft,LabelLeft,'Zip code');
      SetLabel(8,LabelLeft,LabelLeft,'Country');
      SetLabel(9,LabelLeft,LabelLeft,'Phone #');
      SetLabel(10,LabelLeft,LabelLeft,'Units ordered');
      SetLabel(19,LabelLeft,LabelLeft,'Record No');
      { define messages }
      SetMessage(1,0,0,'Entry date');
      SetMessage(2,0,0,'Client''s name');
      SetMessage(3,0,0,'Street address');
      SetMessage(4,0,0,'Post office box (etc.)');
      SetMessage(5,0,0,'City');
      SetMessage(6,0,0,'State');
      SetMessage(7,0,0,'Zip code');
      SetMessage(8,0,0,'Country');
      SetMessage(9,0,0,'Telephone number');
      SetMessage(10,0,0,'Number of units client has ordered');
      SetMessage(11,0,0,'Go to first record in database');
      SetMessage(12,0,0,'Go to previous record in database');
      SetMessage(13,0,0,'Go to next record in database');
      SetMessage(14,0,0,'Go to last record in database');
      SetMessage(15,0,0,'Add a new record');
      SetMessage(16,0,0,'Delete current record');
      SetMessage(17,0,0,'Edit current record');
      SetMessage(18,0,0,'Return to DOS');
      { define hotkeys }
      SetHK(15,286);  { Alt+A } {save button}
      SetHK(16,288);  { Alt+D } {del button}
      SetHK(17,274);  { Alt+E } {edit button}
      SetHK(18,272);  { Alt+Q } {quit button}
      for I := 1 to 10 do  { set for browse }
         FieldSetState(I,FldOff);
   end; { BuildForm }

   procedure CreateNewDataFile;
   {could be built on the fly via I/O form}
   var EValue: integer;
   begin
      EValue := 0;
      inc(EValue,DbAddDbfField('DATE','D',8,0));       { DATE  D  8 }
      inc(EValue,DbAddDbfField('CLIENT','C',30,0));    { LAST  C 15 }
      inc(EValue,DbAddDbfField('ADDR1','C',30,0));     { ADDR1 C 30 }
      inc(EValue,DbAddDbfField('ADDR2','C',30,0));     { ADDR2 C 30 }
      inc(EValue,DbAddDbfField('CITY','C',22,0));      { CITY  C 22 }
      inc(EValue,DbAddDbfField('STATE','C',2,0));      { STATE C  2 }
      inc(EValue,DbAddDbfField('ZIP','C',10,0));       { ZIP   C 10 }
      inc(EValue,DbAddDbfField('COUNTRY','C',20,0));   { COUNTRY C 20 }
      inc(EValue,DbAddDbfField('PHONE','C',10,0));     { PHONE C 10 }
      inc(EValue,DbAddDbfField('UNITS','N',10,0));     { UNITS C 14 }
      inc(EValue,DbBuildDataFile(FN,1));
      if EValue <> 0 then
      begin
         PromptOK(' File Error ','Unable to create data file!');
         Halt;
      end;
   end; { CreateNewDataFile }

   procedure PreSetFields;
   {}
   var I: integer;
   begin
      if DbGetNumRecs = 0 then
      begin
         for I := 11 to 14 do { turn off VCR buttons }
            FieldSetState(I,FldOff);
         FieldSetState(17,FldOff); { turn off edit button }
         FieldSetState(16,FldOff); { turn off del button }
         ActiveField := 15;  {add button}
      end else
         ActiveField := 13;
   end; { PreSetFields }

   procedure CompleteStop6or7;
   {}
   var I: integer;
   begin
      for I := 1 to 10 do          { fields }
         FieldSetState(I,FldOff);
      for I := 11 to 18 do
         FieldSetState(I,FldOn);
      ButtonChangeSettings(17,EdtBtn,Stop5);
      SetMessage(17,0,0,'Edit current record');
      SetHK(17,274);  { Alt+E } {edit button}
      ButtonChangeSettings(18,QuiBtn,Escaped);
      SetMessage(18,0,0,'Return to DOS');
      SetHK(18,272);  { Alt+Q } {quit button}
      ActiveField := 13;  { next }
   end; { CompleteStop6or7 }

   procedure SetValidation;
   {}
   begin
      SavValidate := IOVars.DefaultValidate;
      IOVars.DefaultValidate := ValidateAtEnd;
   end; { SetValidation }

   procedure RestoreValidation;
   {}
   begin
      IOVars.DefaultValidate := SavValidate;
   end; { RestoreValidation }

   procedure InitVars;
   {}
   begin
      NdxFld := 2;
      EC := 0;
      Adding := false;
      Saving := false;
      Editing := false;
      Cancelling := false;
   end; { InitVars }

begin { main }
   ClearMsgPanel;
   PromptOK(' Databases ''R'' Us ','Yes, we do databases! Gold includes an easy-to-use'+
                                  '|set of database routines. When you combine the '+
                                  '|powerful form input with the database routines'+
                                  '|you get rock solid applications!');
   ClearLine(25,lightgrayonblue);
   if not DBFExist(FN) then
      CreateNewDataFile;
   InitVars;
   if DbOpenDataSet(FN) <> 0 then
   begin
      if DbIndexedField = 0 then
      begin
         SetShowNdxProgress(WatchNDXBuild);
         Box3D(15,8,65,12,BlackOnCyan,WhiteOnCyan,4);
         WriteAT(18,8,WhiteOnCyan,' Building Index ');
         if NdxBuildNew(NdxFld) <> 0 then
         begin
            PromptOK(' INDEX ERROR ','Index is missing!');
            halt;
         end;
         PromptOK(' Complete! ','^Index was missing|^It has been completely rebuilt,|^You may continue.');
      end;
      Tint[IOWinTitle] := WhiteOnRed;
      SetValidation;
      SetScreen;
      BuildForm;
      MouseShow(true);
      PreSetFields;
      UserTerminates := false;
      DbSetFullStrings(false);
      InitData;
      X := NdxGotoFirst;
      repeat
         RecNum := X;
         if ((DbGetNumRecs > 0) and (X > 0)) and
            (not Saving) and
            (not Editing) and
            (not Cancelling) then
            DatabaseToScreen(X);
         DisplayForm;
         LastAction := EditForm(ActiveField);
         ActiveField := FieldWithFocus;
         Editing := false;
         Saving := false;
         Cancelling := false;
         case LastAction of
            Stop1: begin
                      X := NdxGotoFirst;
                      ActiveField := 13;  { next }
                   end;
            Stop2: begin
                      X := NdxGotoPrev;
                      if X = 0 then
                      begin
                         X := NdxGotoLast;
                         PromptOK(Msg5,Msg6)
                      end;
                   end;
            Stop3: begin
                      X := NdxGotoNext;
                      if X = 0 then
                      begin
                         X := NdxGotoFirst;
                         PromptOK(Msg7,Msg8);
                      end;
                   end;
            Stop4: begin
                      X := NdxGotoLast;
                      ActiveField := 12;  { prev }
                   end;
            Stop8,         { add  }
            Stop5: begin   { edit }
                      SaveUserRec;
                      if (LastAction = Stop8) then
                      begin
                         Adding := true;
                         InitData;
                         X := 0; { prevents redisplaying previous data }
                         FieldSetState(15,FldOff); { add }
                         FieldSetState(17,FldOn);  { edit/save }
                      end
                      else Editing := true;

                      for I := 1 to 10 do          { fields }
                         FieldSetState(I,FldOn);
                      for I := 11 to 14 do         { vcr }
                         FieldSetState(I,FldOff);
                      FieldSetState(15,FldOff);    { add }
                      FieldSetState(16,FldOff);    { del }
                      ButtonChangeSettings(17,SavBtn,Stop6);
                      SetMessage(17,0,0,'Saves edited information');
                      SetHK(17,287);
                      ButtonChangeSettings(18,CanBtn,Cancel1);
                      SetMessage(18,0,0,'Cancels current operation');
                      SetHK(18,302);
                      ActiveField := 2;
                   end;
            Stop6: begin   { save }
                      if DataHasChanged then
                      begin
                         ScreenToDatabase;
                         Saving := true;
                      end;
                      CompleteStop6or7;
                   end;
          Cancel1: begin   { cancel }
                      Cancelling := true;
                      if PromptYesNo(Msg13,Msg10) = 1 then
                      begin
                         Adding := false;
                         if DbGetNumRecs > 0 then
                            RestoreUserRec;
                         CompleteStop6or7;
                      end
                   end;
            Stop9: begin   { delete }
                      for I := 11 to 15 do
                         FieldSetState(I,FldOff);
                      FieldSetState(17,FldOff);
                      if PromptYesNo(Msg9,Msg10) = 1 then
                      begin
                         DbDeleteRecord(X);
                         X := NdxGotoNext;
                         if X = 0 then
                            X := NdxGotoFirst;
                      end;
                      for I := 11 to 15 do
                         FieldSetState(I,FldOn);
                      FieldSetState(17,FldOn);
                      ActiveField := 13;
                   end;
          Escaped: begin
                      if PromptYesNo(Msg11,Msg12) = 1 then
                         UserTerminates := true;
                   end;
         end;  { case }
      until UserTerminates;
      DisposeFields;
      DisposeForms;
      MouseShow(false);
      DbCloseAllDatabases;
      RestoreValidation;
   end else
      PromptOK(' DATA ERROR ','Unable to open '+FN+' or one of its related files.');
end;

                          {*********************}
                          {**  Quick Prompts  **}
                          {*********************}

procedure QPString;
{}
var TmpStr, TmpMsg: StrScreen;
begin
   SetMessage1('Use ~PromptStr~ to prompt the user to input a string. You can optionally');
   SetMessage2('force all input to upper case. Long strings will automatically scroll.');
   TmpStr := PromptStr(0,5,50,'^Enter User Name',' GoldRead Input Demo ','Frank Borland',true);
end; {QPString}

procedure QPNumber;
{}
var TmpMsg: string;
    TmpNum: longint;
    DogYrs: real;
begin
   SetMessage1('Use ~PromptNum~ to prompt the user to input a number. You can set');
   SetMessage2('minimum and maximum ranges -- in this case 16 to 65.');
   TmpNum := PromptNum(0,0,'Please enter your true age',
                       ' GoldRead Numeric Input Demo ',21,16,65,true);
end; {QPNumber}

procedure QPPassword;
{}
var TmpMsg, TmpStr: string;
begin
   SetMessage1('By setting the variable ~ReadVars.Password~ to true, PromptStr will');
   SetMessage2('not echo the input characters -- it''s ideal for passwords.');
   ReadVars.Password := true;
   TmpStr := PromptStr(0,5,29,'^Enter User Password:',
                       ' GoldRead Input Demo ','',true);
end; {QPPassword}

procedure QPRadio;
{}
var TmpMsg, RadioStr: string;
    TmpNum: byte;
begin
   SetMessage1('The ~PromptRadio~ function provides a quick and easy way to allow the user');
   SetMessage2('to select an single item from a list.');
   RadioStr := 'Two double beds|'+
               'Three single beds|'+
               'One king bed and sofa|'+
               'One king bed and single|'+
               'One double bed and two sofas|'+
               'Three sofas';
   TmpNum := PromptRadio(0,4,' Pick One ',' Select the room furniture ',RadioStr,1);
end; {QPRadio}

procedure ShowQuickPrompts;
{}
var QuickPromptMenu: MenuRecord;
    QPChoice: integer;
    QPErrCode: integer;
begin
   QPErrCode := 0;
   MenuSet(QuickPromptMenu);
   with QuickPromptMenu do
   begin
      Heading1 := 'Quick Prompt';
      Heading2 := 'Samples';
      Topic[1] := 'String Prompt';
      Topic[2] := 'Password Prompt';
      Topic[3] := 'Numeric Prompt';
      Topic[4] := 'Radio Prompt';
      Topic[5] := 'Exit';
      TotalPicks := 5;
      TopLeftXY[1] := 35;
      TopLeftXY[2] := 12;
      Boxtype := 4;
      QPChoice := 1;
   end;
   repeat
      SetMessage1('Quick prompts provide a quick and easy way to prompt the user to input');
      SetMessage2('a single item, avoiding the need to build a full-blown input form.');
      DisplayMenu(QuickPromptMenu,true,QPChoice,QPErrCode);
      if QPErrCode <> 0 then
         QPChoice := 5;
      case QPChoice of
         1 : QPString;
         2 : QPPassword;
         3 : QPNumber;
         4 : QPRadio;
      end;
   until QPChoice = 5;
   PartClear(15,5,65,20,LightGrayOnBlue,'');
end; {ShowQuickPrompts}

                       {***************************}
                       {**  Files & Directories  **}
                       {***************************}

procedure FilesAndDirectories;
{}
var
  FN: string;

    procedure ShowPromptFile;
    {}
    begin
       SetMessage1('You can use the ~PromptFile~ procedure whenever you want the user to');
       SetMessage2('enter a file name. You can customize the messages, add help, etc.');
       FN := PromptFile('*.pas');
       if FN <> '' then
          PromptOK('','You chose '+FN);
    end; {ShowPromptFile}

    procedure ShowFileList;
    {}
    begin
       SetMessage1('This is a classic multi-column file list. You can configure whether');
       SetMessage2('directories and drives are displayed, filemasks, sort options, colors, etc.');
       DirVars.LWinStyle := 7;
       FN := FileList('*.*',' Pick a file -- any file! ');
       if FN <> '' then
          PromptOK('','You chose '+FN);
    end; {ShowFileList}

    procedure ShowPromptDir;
    {}
    begin
       SetMessage1('Use the ~PromptDir~ function when you want to prompt the user for a');
       SetMessage2('directory path. A help button will appear if you assign a help proc.');
       FN := PromptDir('','');
       if FN <> '' then
          PromptOK('','You chose '+FN);

    end; {ShowPromptDir}

begin
   ShowPromptFile;
   ShowFileList;
   ShowPromptDir;
end; {FilesAndDirectories}

                       {***************************}
                       {**  Window Illustration  **}
                       {***************************}
procedure ShowMultiWindows;
{}
const
   TotalWindows = 4;
var
   WinHandle: array [1..TotalWindows] of integer;
   I: integer;
   Finished: boolean;
   Startmem: longint;
begin
   SetMessage1('~Gold~ supports multiple overlapping windows. You may write to any');
   SetMessage2('window at any time -- even if the window is obscured.');
   SetBlinking(false);
   Startmem := MaxAvail;
   ShowNow := false;
   WinHandle[1] := WinCreate(10,5,40,12,4);
   WinHandle[2] := WinCreate(30,8,75,18,4);
   WinHandle[3] := WinCreate(15,14,60,22,4);
   WinHandle[4] := WinCreate(27,11,54,15,4);
   WinSetColor(2,WinBorder,BlackOnWhite);
   WinSetColor(2,WinBody,BlackOnWhite);
   WinSetColor(3,WinBorder,WhiteOnLightgreen);
   WinSetColor(3,WinBody,WhiteOnLightgreen);
   WinSetColor(4,WinBorder,WhiteOnLightred);
   WinSetColor(4,WinBody,WhiteOnLightred);
   for I := 1 to TotalWindows do
      WinPaint(WinHandle[I]);
   ActivateWindow(WinHandle[4]);
   WriteAT(3,2,WhiteOnLightred, 'Press a key to scroll!');
   LineWrap := true;
   ShowNow := false;
   WinDrawAll;
   GetInput;
   WriteAT(3,2,WhiteOnLightred, 'Is this cool, or what!');
   repeat
      ActivateWindow(WinHandle[1]);
      WriteAT(1,6,random(15),'This is the bottom window, and it is a beauty');
      ActivateWindow(WinHandle[2]);
      WriteAT(1,9,random(15),'This is the second window and it is wider than the bottom one');
      ActivateWindow(WinHandle[3]);
      WriteAT(1,7,random(15),'TechnoJock''s Turbo Toolkit Gold is the best thing since sliced bread');
      WinDrawAll;
   until keypressed;
   KeyFlushBuffer;
   PromptOK(' Multiple Windows Demo ','Not even a flicker out of place.');
   for I := 1 to 4 do
      WinDispose(I);
   SetBlinking(true);
end; {ShowMultiWindows}

procedure ShowWindowTypes;
{}
type
   WindowCfg = record
      Style: byte;
      Custom:boolean;
      WType: byte;
      Tit:boolean;
      Num:boolean;
   end; {WindowCfg}

var
  WinHandle: integer;
  WinSettings: WindowCfg;
  Finished: boolean;
  ECode: gAction;

   procedure InitVars;
   {}
   begin
      with WinSettings do
      begin
         Style := 7;
         Custom := true;
         WType := 5;
         Tit := true;
         Num := false;
      end;
   end; {InitVars}

   procedure WriteDemoText;
   {}
   begin
      WritePlain(1,1,'Press Esc or click the right mouse button to return to the form.');
      WinDrawTop;   {repaint the window}
   end; {WriteDemoText}

   procedure SetFields;
   {Creates the input Form which defines the window characteristics}
   var I : Integer;
   begin
      CreateForms(1);
      ActivateForm(1);
      SetFormWindow(5,4,75,22,1);
      KwikAddField(1,3,3);
      KwikAddField(2,40,3);
      KwikAddField(3,40,8);
      KwikAddField(4,40,15);
      KwikAddLastField(5,52,15);

      RadioField(1,35,10,WinSettings.Style);
      RadioAddItem(1,1,1,'~0~ No border','A window with no border',48);
      RadioAddItem(1,1,2,'~1~ Single line','A plain single line window',49);
      RadioAddItem(1,1,3,'~2~ Double line','A plain double line window',50);
      RadioAddItem(1,1,4,'~3~ Title Bar   (no border)','A "caption" title bar with no border',51);
      RadioAddItem(1,1,5,'~4~ Edge Border (no title bar)','Uses special characters to draw an edge border',52);
      RadioAddItem(1,1,6,'~5~ Menu-Style ','A "Professional Write" style used in menus',53);
      RadioAddItem(1,1,7,'~6~ Title Bar + edge border','Uses custom characters',54);
      RadioAddItem(1,1,8,'~7~ Raised chisel effect','Chiselled single line border ',55);
      RadioAddItem(1,1,9,'~8~ Sunken chisel effect','Chiselled single line border',56);
      RadioAddItem(1,1,10,'~9~ Ring-style Notepad','Used for special effects',57);
      SetLabel(1,LabelTop,LabelTop,' Style ');
      {field 2}
      CheckField(2,28,3);
      CheckAddItem(2,1,1,'~U~se Custom chars','Use Gold''s custom characters when checked',278,WinSettings.Custom);
      CheckAddItem(2,1,2,'~D~isplay example title','Display an example title in the Show Me window',288,WinSettings.Tit);
      CheckAddItem(2,1,3,'Display a ~n~umber','Show an example window number',305,WinSettings.Num);
      SetLabel(2,LabelTop,LabelTop,' Miscellaneous');
      {field 3}
      RadioField(3,28,5,WinSettings.WType);
      RadioAddItem(3,1,1,'~P~lain (no icons)','',48);
      RadioAddItem(3,1,2,'~C~loseable','',48);
      RadioAddItem(3,1,3,'~M~ove and close','',48);
      RadioAddItem(3,1,4,'Move ~n~o close','',48);
      RadioAddItem(3,1,5,'Move, close & ~s~tretch','',48);
      SetLabel(3,LabelTop,LabelTop,' Icons ');
      {field 4 & 5}
      ButtonDefaultField(4,'~S~how me!',Stop1);
      SetHK(4,287);
      SetMessage(4,0,0,'Display an example of the window configuration');
      ButtonField(5,'  E~x~it  ',GoldIO.Finished);
      SetHK(5,301);
      SetMessage(5,0,0,'Terminate the program');
   end; {SetFields}

   procedure ShowWin;
   {}
   begin
      CursorOff;
      SetBlinking(false);
      if WinSettings.Custom then
         UseCustomChars;
      {try changing the last argument in the following call
       to any value in the range 0 through 9}
      WinHandle := WinCreate(19,7,62,15,pred(WinSettings.Style));  {creates a window structure, but doesn't draw it}
      WinSetType(WinHandle,WinType(pred(WinSettings.WType)));
      if WinSettings.Tit then
         WinSetTitle(WinHandle,' Window Title ');
      WinSetShowNum(WinHandle,WinSettings.Num);
      if pred(WinSettings.Style) in [7,8] then
      begin
         WinSetColor(WinHandle,WinBody,blackonlightgray);
         WinSetColor(WinHandle,WinIcons,yellowonlightgray);
      end;
      WinDisplay(WinHandle);
      ActivateWindow(WinHandle);
      LineWrap := true;  {instructs gold to wrap the text of too long for window}
      WriteDemoText;
      MouseShow(true);
      Finished := false;
      repeat
         GetInput;
         with KeyVars do
         begin
            if IsWinKey(LastKey,LastX,LastY) then
               WinProcessKey(LastKey,LastX,LastY);
            case LastKey of
               27,600,504: begin
                  Finished := true;
                  MouseRelease;
               end;
               602: begin    {window was zoomed or stretched -- need to redraw contents}
                  WriteDemoText;
                  WinDrawAll;
               end;
            end; {case}
         end;
      until Finished;
      WinDispose(WinHandle);
      WinDrawAll;
      MouseShow(true);
   end; {ShowWin}

begin
   InitVars;
   SetMessage1('Gold supports a variety of different window styles and shapes. Choose');
   SetMessage2('window characteristics and press "Show Me" to see the window in action!');
   SetFields;
   repeat
      Ecode := EditForm(1);
      if Ecode = Stop1 then
         ShowWin;
   until Ecode = GoldIO.Finished;
   DisposeFields;
   DisposeForms;
   WinDispose(WinHandle);
end; {ShowWindowTypes}

procedure ShowWindows;
{}
begin
   ShowMultiWindows;
   ShowWindowTypes;
end; {ShowWindows}

                        {*************************}
                        {**  Lists Lists Lists  **}
                        {*************************}

procedure DisplaySimpleList;
{}
var
   Properties: ListCfg;
   GirlFriends: SingleLL;
   RetCode: integer;

   procedure BuildTheList;
   {}
   begin
      InitSLLStr(GirlFriends);
      SLLSetActiveList(GirlFriends);
      Retcode := SLLAddStr('Erica');
      inc(Retcode,SLLAddStr('Theresa'));
      inc(Retcode,SLLAddStr('Lynn'));
      inc(Retcode,SLLAddStr('Donna'));
      inc(Retcode,SLLAddStr('Godzilla'));
   end; { BuildTheList }

begin
   SetMessage1('This is a simple list displayed in a single column. The contents of the');
   SetMessage2('window can be sourced from a string array, or a single/double linked list.');
   BuildTheList;
   if RetCode <> 0 then
      PromptOK(' Error ','Unable to build the list')
   else
   begin
      InitListCfg(Properties);
      ListAssignSLL(Properties,Girlfriends);
      ListSetWin(Properties,45,5,75,11,1);
      RunList(Properties,' My first list! ');
   end;
   SLLSetActiveList(GirlFriends);
   SLLDestroy;
end; {DisplaySimpleList}

procedure DisplayMultiColList;
var
   Properties: ListCfg;
   Files: DoubleLL;
   I,Counter,
   RetCode: integer;

const
   DemoMask: string[12] = '*.*';

   function BuildTheList: boolean;
   {Reads all the files matching DemoMask and returns true if there
    is at least one entry in the list}
   var
      SrchRec: SearchRec;
   begin
      InitDLLStr(Files);
      DLLSetActiveList(Files);
      findfirst(DemoMask,Anyfile - Hidden - Directory - SysFile - VolumeID,SrchRec);
      while DosError = 0 do
      begin
         if (SrchRec.Attr and Directory <> Directory) then
         begin
            Retcode := DLLAddStr(SrchRec.Name);
            if (Retcode <> 0) then
            begin
               BuildTheList := false;
               exit;
            end;
         end;
         findnext(SrchRec);
      end;
      DLLSort(0,true);
   end; { BuildTheList }

begin
   SetMessage1('This is a multi-column list with tagging. You can even stretch the window!');
   WriteHiCenter(25,YellowOnBlue,LightgrayOnBlue,'~T~ tag  ~U~ untag  ~SPACE~ toggle  ~Alt-T~ tag all'+
                                             '  ~Alt-U~ untag all, or use mouse');
   if not BuildTheList then
      PromptOK(' Error ','Unable to build the list')
   else
   begin
      InitListCfg(Properties);
      ListAssignDLL(Properties,Files);
      ListSetColWidth(Properties,15);
      ListSetWin(Properties, 5,3,75,23,1);
      ListSetTagging(Properties, true);
      RunList(Properties,' Tag some files! ');
   end;
   DLLSetActiveList(Files);
   DLLDestroy;
end;

procedure DisplayGrid;
var
   SourceList: SingleLL;
   GridLayout: ListCfg;
   GridHeading: string;
   TabStops: array[1..5] of integer;

   procedure FillTheList;
   {}
   var I: integer;
   begin
      I := 0;
      InitSLLStr(SourceList);
      SLLSetActiveList(SourceList);
      inc(I,SLLAddStr('R D Smith        22202 Chevy Chase    Maryland      WI  23233'));
      inc(I,SLLAddStr('M J Dooley       1123 Queens Blvd     Madison       WI  23278'));
      inc(I,SLLAddStr('E L G Jognson    12623 Ashford Hills  Houston       TX  77079'));
      inc(I,SLLAddStr('P R Group        4585 The Grille #21  Bose          HI  90991'));
      inc(I,SLLAddStr('Mark Norman      34 The Ridgeway      Delaware      OR  33789'));
      inc(I,SLLAddStr('Jennifer Worth   22 The Circle        Illinois      RI  22445'));
      inc(I,SLLAddStr('Susan Jones      52242 #12 South Road Fort Bender   MA  26889'));
      inc(I,SLLAddStr('J T Ainsworth    164 Dunvale Lane     Texas         TX  77023'));
      inc(I,SLLAddStr('Geoff Range      18 Meadow Wood       Washington    WA  67833'));
      inc(I,SLLAddStr('Joey Doolittle   229 Oak Drive        San Francisco CA  21345'));
      inc(I,SLLAddStr('Sally Weathers   79 Anchors Road      Kennebunport  MA  66720'));
      inc(I,SLLAddStr('G N Greene       816a Hwy 68 South    Portland      OR  23763'));
      if I <> 0 then
          PromptOK(' ERROR! ','Not enough memory to run grid!');
   end; {FillTheList}

   procedure SetGridLayout;
   {}
   begin
      Gridheading := 'Name|Street|City|ST|Zip';
      TabStops[1] := 1;
      TabStops[2] := 18;
      TabStops[3] := 39;
      TabStops[4] := 53;
      TabStops[5] := 57;
      InitListCfg(GridLayout);
      ListAssignSLL(GridLayout,SourceList);
      ListAssignHeader(GridLayout,1,GridHeading);
      ListSetWin(GridLayout,15,5,65,15,7);
      ListSetGaps(GridLayout,1,0,0,1);
      GridAssignTabs(GridLayout,@TabStops,5);
   end; { SetGridLayout }

begin
   SetMessage1('This is a grid list. You can scroll up and down by row, or right');
   SetMessage2('and left by ~logical~ columm. Columns and rows can be optionally locked.');
   FillTheList;
   SetGridLayout;
   RunGrid(GridLayout,' People! ');
   SLLSetActiveList(SourceList);
   SLLDestroy;
end;

procedure ListDemo;
begin
   PromptOK(' List Demo ','Gold supports many different list windows, such as'+
                          '|simple lists, multi-column lists, and scrollable '+
                          '|grids. Here are a few examples.');
   DisplaySimpleList;
   DisplayMultiColList;
   DisplayGrid;
end;

                               {*****************}
                               {**  ShowFields **}
                               {*****************}

procedure ShowFields;
{}
var
  Action:gAction;
  SelectedItem: byte;
  TheDate: Dates;
  ListPick: integer;
  TextData: SingleLL;
  MemoSettings: MemoCfg;

   procedure InitVars;
   var I: integer;
   begin
      TheDate := TodayInJul;
      Longvar := 12;
      ListPick := 1;
      SelectedItem := 1;
      PrintInfo.TypeFaceID := 1;
      InitSLLStr(TextData);
      SLLSetActiveList(TextData);
      I := 0;
      inc(I,SLLAddStr('This font has good serifs and the general poteau is'));
      inc(I,SLLAddStr('excellent.There are some print problems on non-postscript'));
      inc(I,SLLAddStr('printers. A call was made to verify the print situation.'));
      if I <> 0 then
         PromptOK('OOPS', 'Problem with Word wrap field');
      {Define the memo settings}
      MemoAssignSLL(MemoSettings,TextData);
      MemoSettings.Col[MemoNorm] := 15; {change the default color}
   end;

   procedure SetFields;
   {}
   var Win1 : Integer;
   begin
      CreateForms(1);
      ActivateForm(1);
      {define the form's window}
      SetFormWindow(5,4,75,22,1);
      Win1 := FormWinNum;
      WinSetTitle(Win1,'A Plethora of Fields');
      WinSetType(Win1,WMoveNoClose);
      WinSetShowNum(Win1,false);
      SetMessageXY(0,25,false);
      WinDisplay(Win1);
      KwikAddField(1,15,2);
      KwikAddField(2,15,4);
      KwikAddField(3,15,6);
      KwikAddField(4,45,6);
      KwikAddField(5,15,10);
      KwikAddField(6,15,12);
      KwikAddField(7,33,11);
      KwikAddField(8,55,2);
      KwikAddLastField(9, 55,4);
      {Font List}
      SpinDropListField(1,25,PrintInfo.TypeFaceID);
      ListKwikAddItem(1,'Adelaide|Arial MT|Bookman|Courier|Dom Casual|Freestyle Script|Griffon');
      ListKwikAddItem(1,'Helvetica|Juniper|Kidnap|Lithos Light|Palatino|Symbol|System|Times Roman|Zap Dingbobs');
      SetLabel(1,LabelLeft,LabelLeft,'~T~ypeface');
      SetHK(1,276);
      SetMessage(1,0,0,'Select the typeface for printed output');
      {Font Size}
      SpinLongField(2,Longvar,2,6,72,1);
      SetLabel(2,LabelLeft,LabelLeft,'~P~oint size');
      SetHK(2,281);
      SetMessage(2,0,0,'Enter a point size in the range 6 to 72');
      {Check boxes}
      CheckField(3,15,3);
      CheckAddItem(3,1,1,'~U~nderline','Turns off bold and italic',278,Norm);
      CheckAddItem(3,1,2,'~B~old','Select this field for bold text',304,Printinfo.Bold);
      CheckAddItem(3,1,3,'~I~talic','Select this field for bold text',279,Printinfo.Italic);
      SetLabel(3,LabelLeft,LabelLeft,'Format');
      {Radio Buttons}
      RadioField(4,15,3,SelectedItem);
      RadioAddItem(4,1,1,'~L~eft','Left justifies the text',294);
      RadioAddItem(4,1,2,'~C~enter','Center justifies the text',302);
      RadioAddItem(4,1,3,'~R~ight','Right justifies the text',275);
      SetLabel(4,LabelLeft,LabelLeft,'Justification');
      {Date Field}
      SpinDropDateField(5,TheDate,MMDDYYYY,'',0,0);
      SetLabel(5,LabelLeft,LabelLeft,'~P~rinted');
      SetHK(5,281);
      SetMessage(5,0,0,'Enter the date the test was printed');
      {List Field}
      ListField(6,15,4,ListPick);
      ListAddItem(6,'Standard');
      ListAddItem(6,'Subscript');
      ListAddItem(6,'SuperScript');
      ListAddItem(6,'Narrow');
      ListAddItem(6,'Wide');
      ListAddItem(6,'Extra Wide');
      ListAddItem(6,'All Caps');
      SetLabel(6,LabelLeft,LabelLeft,'~S~tyles');
      SetHK(6,281);
      SetMessage(6,0,0,'Select the font style');
      {Memo Field}
      MemoField(7,35,5,MemoSettings);
      WrapFull(MemoSettings);
      SetLabel(7,LabelTop,LabelTop,'~C~omments ');
      SetHK(7,302);
      SetMessage(7,0,0,'Enter the reviewer''s comments');
      {Buttons}
      ButtonDefaultField(8,'   ~O~K   ',finished);
      SetHK(8,280);
      SetMessage(8,0,0,'Accept the settings in this dialog box');
      ButtonField(9,' C~a~ncel ',escaped);
      SetHK(9,286);
      SetMessage(9,0,0,'Close the dialog box without making any changes');
   end; {SetFields}


begin
   ClearMsgPanel;
   PromptOK(' Form Input ','User input forms are the heart of Gold. More than'+
     '|25 field types are provided. Here is a quick sample.');
   SaveScreen(1);
   ClearLine(25,WhiteonBlue);
   InitVars;
   SetFields;
   Action := EditForm(1);
   DisposeFields;
   DisposeForms;
   SLLSetActiveList(TextData);
   SLLDestroy;
   SlideRestoreScreen(1,Down);
   DisposeScreen(1);
end;
                            {*****************}
                            {**  Register   **}
                            {*****************}
procedure RegisterGold;
var
   StrLL: StringLL;
   Ecode: integer;
begin
   ClearMsgPanel;
   StrLLInit(StrLL);
   ECode := 0;
   inc(ECode, StrLLAdd(StrLL,'Gold is distributed as a ~Shareware~ product.'));
   inc(ECode, StrLLAdd(StrLL,''));
   inc(ECode, StrLLAdd(StrLL,'If you have not registered your copy of Gold,'));
   inc(ECode, StrLLAdd(StrLL,'you can do so by completing the form in '));
   inc(ECode, StrLLAdd(StrLL,'ORDERFRM.DOC, or by executing the REGISTER.EXE'));
   inc(ECode, StrLLAdd(StrLL,'program. This program will demonstrate some of'));
   inc(ECode, StrLLAdd(StrLL,'the bonus features you get when you register!'));
   inc(ECode, StrLLAdd(StrLL,''));
   inc(ECode, StrLLAdd(StrLL,'If you have not registered your copy of Gold'));
   inc(ECode, StrLLAdd(StrLL,'after ~30 days~ of evaluation, you must cease'));
   inc(ECode, StrLLAdd(StrLL,'using the product.'));
   inc(ECode, StrLLAdd(StrLL,''));
   inc(ECode, StrLLAdd(StrLL,'Thanks to all the registered users for your'));
   inc(ECode, StrLLAdd(StrLL,'continued support.'));
   if ECode = 0 then
      PromptOKStrLL(' Registration ',StrLL);
   StrLlDestroy(StrLL);  {dispose of linked list}
end;


                           {*****************}
                           {**  About Box  **}
                           {*****************}
procedure About;
begin
    PromptOK(' GoldDemo ','^Copyright 1995 TechnoJock Software, Inc.|'+
      '^All Rights Reserved||^Tel (409) 737-5472|^Fax (409) 737-5458'+
      '|^BBS (409) 737-1705|^CIS 74017,227    ');
end;
                           {********************}
                           {**  Main Program  **}
                           {********************}

procedure ClosingMessage;
begin
    PromptOK(' More Demos ','Try running the program DEMOVIEW.PAS.'+
       '|This program will show all the demo'+
       '|programs in a list window. You can '+
       '|even view the PAS files!');
end;

procedure OpeningMessage;
begin
    PromptOK(' GoldDemo ','This demo program shows you some of the'+
    { a | means remaining text on new line}
      '|power of ~Gold~. The latest Turbo Pascal'+
      '|toolkit from TJ Software, Inc.'+
      '||There are more than 100 other demo'+
      '|programs included in the package! More'+
      '|about that later.');
end;

procedure DefineMainMenu;
{}
begin
   ErrorCode := 0;
   MenuSet(MainMenu);
   with MainMenu do
   begin
      Heading1 := 'G O L D';
      Heading2 := 'TJ Software, Inc.';
      Topic[1] := 'Lists, Lists, Lists';
      Topic[2] := 'Files & Directories';
      Topic[3] := 'Forms and Dialogs';
      Topic[4] := 'Quick Prompts';
      Topic[5] := 'Windows';
      Topic[6] := 'Databases';
      Topic[7] := 'Registering GOLD';
      Topic[8] := 'About';
      Topic[9] := 'Exit';
      TotalPicks := 9;
      PicksPerLine := 1;
      AddPrefix := 1;                    {0 no, 1 No.'s, 2 Lets}
      TopLeftXY[1] := 0;     {X,Y}
      TopLeftXY[2] := 0;
      Boxtype := 4;
      Choice := 1;                   {0,1,2,3, >3}
   end;
end; {DefineMainMenu}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   CursorOff;
   SetScreen;
   if CustomCapable then { detect monitor }
      UseCustomChars;
   MouseShow(true);
   DefineMainMenu;
   OpeningMessage;
   SetMessage1('This is a ~classic~ menu which can be displayed in a variety of styles.');
   if CustomCapable then
      SetMessage2('Note that the menu border uses a custom line character on the box edge.');
   repeat
      DisplayMenu(MainMenu,false,Choice,Errorcode);
      if ErrorCode <> 0 then
         Choice := 0;
      case Choice of
        1 : ListDemo;   {Lists}
        2 : FilesAndDirectories; {Files, Directories}
        3 : ShowFields;          {input form}
        4 : ShowQuickPrompts;    {Quick Prompts}
        5 : ShowWindows;         {Windows}
        6 : ShowDatabaseOnForm;  {Forms & Databases}
        7 : RegisterGold;        {Register GOLD}
        8:  About;               {About box}
      end; { case }
      ClearMsgPanel;
   until Choice in [9,0];
   MouseShow(false);
   ResetStartupMode;
   ClosingMessage;
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end. { GoldDemo }
