{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit                       }
{                Version: GOLD                                             }
{                Build:   1.00                                             }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                    {*********************************}
                    {**       Unit:   GOLDCAL       **}
                    {*********************************}

{++++++++++++++++++++++++++++++} unit GOLDCAL; {++++++++++++++++++++++++++++}

{$I GOLDFLAG.INC}
{$IFNDEF GOLDCAL}
   {$DEFINE GOLDCAL}
{$ENDIF}

{++++++++++++++++++++++++++++++++} INTERFACE {+++++++++++++++++++++++++++++++}

uses DOS, CRT, GoldHard, GoldTint, GoldWin, GoldMisc, GoldKey,
     GoldFast, GoldDate, GoldStr;


type
   gCalChange = (Paint,ChangeDay,ChangeMonth);
   CalChangeProc = procedure(CType:gCalChange;Val1,Val2:dates);
   CalColorProc = procedure(DaytoColor:Dates; var DefCol: byte);

   CalInfo = record   {attached to the Window UserData pointer}
      ActiveDay:word;
      ActiveMonth:word;
      ActiveYear:longint;
      ActiveDate,
      Today,
      FofM,
      LofM,
      AnchorDay: Dates;
   end; { CalInfo }

   CALSet = record
      LastECode: integer;
      NextMkey: word;     {keys pressed to change months/years}
      PrevMkey: word;
      NextYkey: word;
      PrevYkey: word;
      NextMchar: char;    {characters displayed as icons for changing M/Y}
      PrevMchar: char;
      NextYchar: char;
      PrevYchar: char;
      DayLetters: string[14];  {2-chars per day for Sun to Sat}
      WinStyle:byte;
      WX1: byte;          {dimensions of window}
      WY1: byte;
      WX2: byte;
      WY2: byte;
      CX1: byte;          {location of calendar grid within window}
      CY1: byte;
      EMsgFunc: ErrMsgFunc;
      ChooseDay: boolean; {can user scroll a specific day}
      ChosenDate: Dates;
      CalCharHook: KeyPressedHook;
      CalChangeHook: CalChangeProc;
      CalColHook: CalColorProc;
   end; {CalSet}

{hooks}
procedure AssignCalCharHook(Hook: KeyPressedHook);
procedure RemoveCalCharHook;
procedure AssignCalChangeHook(Hook: CalChangeProc);
procedure RemoveCalChangeHook;
procedure AssignCalColorHook(Hook: CalColorProc);
procedure RemoveCalColorHook;
procedure CalDefaultSettings;
{main calendar}
function  DrawMonth(Mon,Yr:word;X1,Y1:byte;Active:boolean):Dates;
function  RunCalendar(StartDate:Dates;Tit:string):dates;
{desktop functions}
function  LaunchCalendar(StartDate:Dates;Tit:string): byte;
{error}
function  LastCalError: integer;
{internal}
procedure CalProcessKey;
procedure DrawDay(X1,Y1:byte; Day, AnchorDay:Dates; Col:byte);

var
   CalVars: CALSet;

{+++++++++++++++++++++++++++++} IMPLEMENTATION {+++++++++++++++++++++++++++++}

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
function CalEMsg(ECode:integer): string;
{}
begin
   case Ecode of
      0: exit;
      1: CalEMsg := 'Not enough memory to draw calendar window';
      else
         CalEMsg := 'Internal calendar error';
   end; {case}
end; { CalEMsg }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure CalSetError(ECode:integer);
{}
{$IFOPT D+}
var Msg: StrScreen;
{$ENDIF}
begin
   CalVars.LastEcode := ECode;
{$IFOPT D+}  {if debug active display an error message and terminate}
   if Ecode <> 0 then
   begin
      str(Ecode,Msg);
      Msg := Msg+': '+CalVars.EMsgFunc(Ecode);
      SetWinIgnore(true);
      if PromptCustom(' GoldCal Error ',Msg,' ~I~gnore ',' ~A~bort ','',279,286,0,0, 10000) = 2 then
         Halt;
   end;
{$ENDIF}
end; {CalSetError}

function LastCalError: integer;
{}
begin
   LastCalError := CalVars.LastECode;
end; { LastCalError }

                          {*********************}
                          {**  Hook Routines  **}
                          {*********************}

procedure AssignCalCharHook(Hook: KeyPressedHook);
{}
begin
   CalVars.CalCharHook := Hook;
end; { AssignCalCharHook }

procedure RemoveCalCharHook;
{}
begin
   CalVars.CalCharHook := nil;
end; { RemoveCalCharHook }

procedure AssignCalChangeHook(Hook: CalChangeProc);
{}
begin
   CalVars.CalChangeHook := Hook;
end; { AssignCalChangeHook }

procedure RemoveCalChangeHook;
{}
begin
   CalVars.CalChangeHook := nil;
end; { RemoveCalChangeHook }

procedure AssignCalColorHook(Hook: CalColorProc);
{}
begin
   CalVars.CalColHook := Hook;
end; { AssignCalColorHook }

procedure RemoveCalColorHook;
{}
begin
   CalVars.CalColHook := nil;
end; { RemoveCalColorHook }


                        {*************************}
                        {**  Calendar Routines  **}
                        {*************************}

procedure DrawDay(X1,Y1:byte; Day, AnchorDay:Dates; Col:byte);
{}
var
   M,D:word;
   Y: longint;
begin
   JulToGreg(Day,M,D,Y);
   if @CalVars.CalColHook <> nil then
      CalVars.CalColHook(Day,Col);
   WriteAt(X1 + 3 * ( (Day - pred(AnchorDay) - 1) mod 7 ),
           Y1 + (Day - pred(AnchorDay) - 1) div 7,
           Col, PadRight(IntToStr(D),2,' '));
end; { DrawDay }

function DrawMonthEngine(Mon,Yr:word;var FofM,LofM,Today:Dates;X1,Y1:byte;Active:boolean):Dates;
{INTERNAL}
const
   Width = 24;
   Depth = 9;
var
   M,D,Y: word;
   MthStr: string[Width];
   I: integer;
   DOW: byte;
   StartDate,
   PDay: Dates;
   Col:byte;

begin
   if Active then
      Col := Tint[CalActiveMonth]
   else
      Col := Tint[CalEdgeMonth];
   ClearText(X1,Y1,X1+pred(Width),Y1+depth-2,Col);
   MthStr := Pad(JustCenter,Months[Mon] + ' ' + IntToStr(Yr),Width,' ');
   if Active then
      Col := Tint[CalTitle];
   WriteAt(X1,Y1,Col,MthStr);
   for I := 1 to 7 do
       WriteAt(X1+2+pred(I)*3,succ(Y1),Col,
               copy(CalVars.DayLetters,1+pred(I)*2,2));
   {draw the month/year changing icons}
   if Active then
   begin
      WriteAt(X1+1,Y1,Tint[CalIcons],CalVars.PrevMChar);
      WriteAt(X1+3,Y1,Tint[CalIcons],CalVars.NextMChar);
      WriteAt(X1+20,Y1,Tint[CalIcons],CalVars.PrevYChar);
      WriteAt(X1+22,Y1,Tint[CalIcons],CalVars.NextYChar);
   end;
   {time to determine the Julian date of the first day in the date matrix}
   StartDate := GregToJul(Mon,1,Yr);
   FofM := StartDate;
   if Mon < 12 then
      LofM := pred(GregToJul(succ(Mon),1,Yr))
   else
      LofM := pred(GregToJul(1,1,succ(Yr)));
   DOW := DOWJul(StartDate);
   dec(StartDate,DOW);
   Today := TodayInJul;
   for I := 1 to 42 do
   begin
      PDay := StartDate+pred(I);
      if ((PDay < FofM) or (PDay > LofM)) or (Active = false) then
         Col := Tint[CalEdgeMonth]
      else if PDay = Today then
         Col := Tint[CalToday]
      else
         Col := Tint[CalActiveMonth];
      if ((PDay >= FofM) and (PDay <= LofM)) or (Active = true) then
         DrawDay(X1+2,Y1+2,StartDate+pred(I),StartDate,Col);
   end;
   DrawMonthEngine := StartDate;
end; { DrawMonthEngine }

function DrawMonth(Mon,Yr:word;X1,Y1:byte;Active:boolean):Dates;
{Draws the calendar for the specified month and returns
 the Julian date of the first day in the 7*6 day-matrix}
var
   FofM,LofM,Today: Dates;
begin
   DrawMonth := DrawMonthEngine(Mon,Yr,FofM,LofM,Today,X1,Y1,Active);
end; { DrawMonth }

function CalPaint(StartDate:Dates;Tit:string;X1,Y1,X2,Y2:byte ):integer;
{}
var
  Handle:integer;
  WinP: WStructurePtr;

  procedure SetWindow;
  {}
  begin
     with CalVars do
     begin
        Handle := WinCreate(X1,Y1,X2,Y2,WinStyle);
        WinSetType(Handle,WMove);
        WinSetTitle(Handle,Tit);
        WinSetShowNum(Handle,false);
        WinSetColor(Handle,WinBorder,Tint[CalBorder]);
        WinSetColor(Handle,WinBorderOff,Tint[CalBorderOff]);
        WinSetColor(Handle,WinIcons,Tint[CalIcons]);
        WinSetColor(Handle,WinBody,Tint[CalActiveMonth]);
        WinSetColor(Handle,WinTitle,Tint[CalTitle]);
        WinPaint(Handle);
     end;
  end; { SetWindow }

begin
   SetWindow;
   WinDisplay(Handle);
   WinP := WinPtr(Handle);
   if WinP <> nil then
   begin
      getmem(WinP^.UserData,sizeof(CalInfo));
      with CalInfo(WinP^.UserData^) do
      begin
         JulToGreg(StartDate,ActiveMonth,ActiveDay,ActiveYear);
      with CalVars do
         AnchorDay := DrawMonthEngine(ActiveMonth,ActiveYear,FofM,LofM,Today,CX1,CY1,true);
      WinDrawTop;
      {call the ChangeHook to indicate window is drawn}
      if @CalVars.CalChangeHook <> nil then
         CalVars.CalChangeHook(Paint,ActiveMonth,ActiveYear);
      end;
   end;
   CalPaint := handle;
end; { CalPaint }

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
 function CalCloseHandler(Handle: integer):boolean;
 {}
 var
    WinP: WStructurePtr;
 begin
    WinP := WinPtr(Handle);
    if WinP <> nil then
       freemem(WinP^.Userdata,sizeof(CalInfo));
    WinDispose(Handle);
    CalCloseHandler := true;
 end; {CalCloseHandler}
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

procedure CalProcessKey;
{}
var
  WinP: WStructurePtr;
  NewDate: Dates;
  TempDate:dates;
  MX,MY: byte;
  WaitTime: integer;
  Handle: byte;

  procedure DelayIt;
  {}
  begin
     delay(WaitTime);
     if WaitTime <> KeyVars.ScrollDelay then
        WaitTime := KeyVars.ScrollDelay;
  end; { DelayIt }

  procedure ChangeActiveDay(ClearOldDay:boolean;Newday:dates);
  {}
  begin
     with CalVars do
     with CalInfo(WinP^.UserData^) do
     begin
        if ClearOldDay then
        begin
           if ActiveDate = Today then
              DrawDay(CX1+2,CY1+2,ActiveDate,AnchorDay,Tint[CalToDay])
           else
              DrawDay(CX1+2,CY1+2,ActiveDate,AnchorDay,Tint[CalActiveMonth]);
        end;
        if @CalVars.CalChangeHook <> nil then
           CalVars.CalChangeHook(ChangeDay,Activedate,NewDay);
        ActiveDate := NewDay;
        DrawDay(CX1+2,CY1+2,ActiveDate,AnchorDay,Tint[CalHiDay]);
     end;
  end; { ChangeActiveDay }

  procedure NextMonth;
  {}
  begin
     with CalVars do
     with CalInfo(WinP^.UserData^) do
     begin
        if ActiveMonth < 12 then
           inc(ActiveMonth)
        else
        begin
           ActiveMonth := 1;
           inc(ActiveYear);
        end;
        AnchorDay := DrawMonthEngine(ActiveMonth,ActiveYear,FofM,LofM,Today,CX1,CY1,true);
        if @CalChangeHook <> nil then
           CalChangeHook(ChangeMonth,ActiveMonth,ActiveYear);
        if ChooseDay then
           ChangeActiveDay(false,FofM);
     end; {with}
  end; { NextMonth }

  procedure PrevMonth;
  {}
  begin
     with CalVars do
     with CalInfo(WinP^.UserData^) do
     begin
        if ActiveMonth > 1 then
           dec(ActiveMonth)
        else if ActiveYear > 0 then
        begin
           ActiveMonth := 12;
           dec(ActiveYear);
        end;
        AnchorDay := DrawMonthEngine(ActiveMonth,ActiveYear,FofM,LofM,Today,CX1,CY1,true);
        if @CalChangeHook <> nil then
           CalChangeHook(ChangeMonth,ActiveMonth,ActiveYear);
        if ChooseDay then
           ChangeActiveDay(false,LofM);
     end;
  end; { PrevMonth }

  procedure ChangeYear(NewYear:word);
  {}
  begin
     with CalVars do
     with CalInfo(WinP^.UserData^) do
     begin
        JulToGreg(ActiveDate,ActiveMonth,ActiveDay,ActiveYear);
        if (ActiveMonth = 2) and (ActiveDay = 29) then
           ActiveDay := 28;
        ActiveYear := NewYear;
        ActiveDate := GregToJul(ActiveMonth,ActiveDay,ActiveYear);
        AnchorDay := DrawMonthEngine(ActiveMonth,ActiveYear,FofM,LofM,Today,CX1,CY1,true);
        if @CalChangeHook <> nil then
           CalChangeHook(ChangeMonth,ActiveMonth,ActiveYear);
        if ChooseDay then
           ChangeActiveDay(false,ActiveDate);
     end;
  end; { ChangeYear }

  function GetDay(X,Y:byte):Dates;
  {Returns the Jul date clicked on with mouse, or zero if not on active day}
  var NewDate: Dates;
  begin
     GetDay := 0;
     with CalVars do
     with CalInfo(WinP^.UserData^) do
     begin
        if (X>=CX1+2) and (X<=CX1+21) and (Y>=CY1+2) and (Y<=CY1+7)
        and ((X - CX1 - 1) mod 3 <> 0)  then  {not inbetween the columns}
        begin
           NewDate := AnchorDay + (Y-CY1-2)*7 + ((X-CX1-2) div 3);
           if (NewDate >= FofM) and (NewDate <= LofM) then
              GetDay := NewDate;
        end;
     end;
  end; { GetDay }

  procedure MouseClick(X,Y:byte);
  {Responds to mouse click on any day in the active month}
  begin
     with CalVars do
     with CalInfo(WinP^.UserData^) do
     begin
        NewDate := GetDay(X,Y);
        if (NewDate <> 0)
        and (NewDate <> ActiveDate) then
        begin
           ChangeActiveDay(true,NewDate);
           MouseRelease;
        end;
     end; {with}
  end; { MouseClick }

  procedure CloseWindow(Escaped:boolean);
  {}
  begin
     if Escaped then
        CalVars.ChosenDate := 0
     else
        CalVars.ChosenDate := CalInfo(WinP^.UserData^).ActiveDate;
     freemem(WinP^.Userdata,sizeof(CalInfo));
     WinDispose(Handle);
  end; { CloseWindow }

  procedure ProcessMouseDown;
  {}
  var L,C,R:boolean;
  begin
     with CalInfo(WinP^.UserData^) do
     if WinLocalY(Handle,KeyVars.LastY) = CalVars.CY1 then
        with CalVars do
        begin
           MX := WinLocalX(Handle,KeyVars.LastX);
           if (MX = succ(CX1)) then
              repeat
                 if (MX = succ(CX1)) then
                 begin
                    PrevMonth;
                    WinDrawTop;
                 end;
                 DelayIt;
                 MouseStatus(L,C,R,MX,MY);
                 MX := WinLocalX(Handle,KeyVars.LastX);
              until not L;
           if (MX = CX1+3) then
              repeat
                 if (MX = CX1+3) then
                 begin
                    NextMonth;
                    WinDrawTop;
                 end;
                 DelayIt;
                 MouseStatus(L,C,R,MX,MY);
                 MX := WinLocalX(Handle,KeyVars.LastX);
              until not L;
           if (MX = CX1+20) then
              repeat
                 if (MX = CX1+20) then
                 begin
                    ChangeYear(succ(ActiveYear));
                    WinDrawTop;
                 end;
                 DelayIt;
                 MouseStatus(L,C,R,MX,MY);
                 MX := WinLocalX(Handle,KeyVars.LastX);
              until not L;
           if (MX = CX1+22) then
              repeat
                 if (MX = CX1+22) then
                 begin
                    ChangeYear(pred(ActiveYear));
                    WinDrawTop;
                 end;
                 DelayIt;
                 MouseStatus(L,C,R,MX,MY);
                 MX := WinLocalX(Handle,KeyVars.LastX);
              until not L;
        end else
        if CalVars.ChooseDay then
           MouseClick(WinLocalX(Handle,KeyVars.LastX),WinLocalY(Handle,KeyVars.LastY));
  end; { ProcessMouseDown }


begin
   Handle := WinWithFocus;
   WaitTime := KeyVars.InitScrollDelay;
   WinP := WinPtr(Handle);
   with CalInfo(WinP^.UserData^) do
   begin
      with KeyVars do
      begin
         if @CalVars.CalCharHook <> nil then
            CalVars.CalCharHook(LastKey,LastX,LastY); {call user hook}
         if IsWinKey(LastKey,LastX,LastY) then
            WinProcessKey(LastKey,LastX,LastY);
      end;
      if KeyVars.LastKey = CalVars.NextMKey then
         NextMonth
      else if KeyVars.LastKey = CalVars.PrevMKey then
         PrevMonth
      else if KeyVars.LastKey = CalVars.NextYKey then
         ChangeYear(succ(ActiveYear))
      else if KeyVars.LastKey = CalVars.PrevYKey then
         ChangeYear(pred(ActiveYear))
      else
         case KeyVars.Lastkey of
            328: if CalVars.ChooseDay then {up cursor}
                 begin
                    if ActiveDate-7 < FofM then
                    begin
                       TempDate := ActiveDate + 27;
                       while TempDate > LofM do
                          dec(TempDate,7);
                       ChangeActiveDay(true,Tempdate);
                    end else
                       ChangeActiveDay(true,ActiveDate-7);
                 end;
            336: if CalVars.ChooseDay then {down cursor}
                 begin
                    if ActiveDate+7 > LofM then
                    begin
                       TempDate := ActiveDate - 27;
                       while TempDate < FofM do
                          inc(TempDate,7);
                       ChangeActiveDay(true,TempDate);
                    end else
                       ChangeActiveDay(true,ActiveDate+7);
                 end;
            331: if CalVars.ChooseDay then {left cursor}
                 begin
                    if ActiveDate > FofM then
                       ChangeActiveDay(true,pred(ActiveDate))
                    else
                       ChangeActiveDay(true,LofM);
                 end;
            333: if CalVars.ChooseDay then {right cursor}
                 begin
                    if ActiveDate < LofM then
                       ChangeActiveDay(true,succ(ActiveDate))
                    else
                       ChangeActiveDay(true,FofM);
                 end;
            600: begin {close icon}
                    CloseWindow(true);
                    MouseRelease;
                 end;
            13:  CloseWindow(false);
            27:  CloseWindow(true);
            500: ProcessMouseDown;
            540: begin
                 if CalVars.ChooseDay then
                 begin
                    NewDate := GetDay(WinLocalX(Handle,KeyVars.LastX),WinLocalY(Handle,KeyVars.LastY));
                    if NewDate <> 0 then
                    begin
                       CloseWindow(false);
                       MouseRelease;
                    end else
                    begin
                       KeyVars.LastX := 0; {indicates that session is not finished}
                       ProcessMouseDown;   {treat as single click}
                    end;
                 end;
            end;
         end;
      end;
end; { CalProcessKey }

function RunCalendar(StartDate:Dates;Tit:string):dates;
{Modal window which displays a monthly calendar}
var
   WinP: WStructurePtr;
   Handle : integer;

   function Finished: boolean;
   {}
   begin
      with KeyVars do
         Finished := (LastKey = 600)
                  or ((LastKey = 540) and (LastX <> 0) and (Calvars.Chooseday))
                  or (LastKey = 27)
                  or (LastKey = 13);
   end; { Finished }

begin
   CursorOff;
   with CalVars do
      Handle := CalPaint(StartDate,Tit,WX1,WY1,WX2,WY2);
   if Handle = 0 then
   begin
      CalSetError(1);
      RunCalendar := 0;
   end
   else
   begin
      WinP := WinPtr(Handle);
      with CalVars, CalInfo(WinP^.UserData^) do
      begin
         ActiveDate := StartDate;
         if ChooseDay then
            DrawDay(CX1+2,CY1+2,ActiveDate,AnchorDay,Tint[CalHiDay]);
         if @CalChangeHook <> nil then
            CalChangeHook(ChangeDay,Activedate,ActiveDate);
         WinDrawAll;
         repeat
            GetInput;
            CalProcessKey;
            WinDrawAll;
         until Finished;
         RunCalendar := ChosenDate;
      end;
   end;
   CursorOn;
end; {RunCalendar}

{$IFOPT F-}
   {$DEFINE FOFF}
   {$F+}
{$ENDIF}
procedure CalProcessKeyOnDesktop;
{}
begin
   with KeyVars do
      if (Lastkey <> 13)
      and (Lastkey <> 27)
      and (Lastkey <> 540) then
          CalProcessKey;
end; { CalProcessKeyOnDesktop }
{$IFDEF FOFF}
   {$F-}
   {$UNDEF FOFF}
{$ENDIF}

function LaunchCalendar(StartDate:Dates;Tit:string): byte;
{Call this proc when adding a calendar to the desktop}
var
   Handle: byte;
   WinP: WStructurePtr;
   X,Y:byte;
begin
   WinFadeTopWin;
   with CalVars do
      if WinVars.DesktopCascadeNew then {get new window position}
      begin
         DeskNextWinCoords(X,Y);
         Handle := CalPaint(StartDate,Tit,X,Y,X+WX2-WX1,Y+WY2-WY1);
      end
      else
         Handle := CalPaint(StartDate,Tit,WX1,WY1,WX2,WY2);
   WinP := WinPtr(Handle);
   with CalVars do
   with CalInfo(WinP^.UserData^) do
   begin
      ActiveDate := StartDate;
      if ChooseDay then
         DrawDay(CX1+2,CY1+2,ActiveDate,AnchorDay,Tint[CalHiDay]);
   end;
   WinP^.ProcessKeyProc := CalProcessKeyOnDeskTop;
   WinP^.CloseWinProc := CalCloseHandler;
   WinDrawTop;
   LaunchCalendar := Handle;
end; { LaunchCalendar }

              {*********************************************}
              {**  U N I T   I N I T I A L I Z A T I O N  **}
              {*********************************************}

procedure CalDefaultSettings;
{}
begin
   with CalVars do
   begin
      NextMkey := 337; {PgDn}
      PrevMkey := 329; {PgUp}
      NextYkey := 374; {Ctrl-PgDn}
      PrevYkey := 388; {Ctrl-PgUp}
      NextMchar := '';
      PrevMchar := '';
      NextYchar := '';
      PrevYchar := '';
      DayLetters := 'SuMoTuWeThFrSa';
      WinStyle := 1;
      WX1 := 28;
      WY1 := 9;
      WX2 := 53;
      WY2 := 18;
      CX1 := 1;
      CY1 := 1;
      ChooseDay := true;
      CalCharHook := NoKeyPressedHook;
      CalChangeHook := nil;
      CalColHook := nil;
   end;
end; { CalDefaultSettings }

procedure GoldCALInit;
{}
begin
   with CalVars do
   begin
      LastECode := 0;
      EMsgFunc := CalEMsg;
   end;
   CalDefaultSettings;
end; { GoldCALInit }

begin
   GoldCALInit;
end.
