{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit                       }
{                Version: GOLD                                             }
{                Build:   1.00                                             }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

                    {**********************************}
                    {**       Unit:   GOLDATTR       **}
                    {**********************************}

{++++++++++++++++++++++++++++++} unit GOLDATTR; {++++++++++++++++++++++++++++}

{$I GOLDFLAG.INC}
{$IFNDEF GOLDATTR}
   {$DEFINE GOLDATTR}
{$ENDIF}

{++++++++++++++++++++++++++++++++} INTERFACE {+++++++++++++++++++++++++++++++}

uses DOS, CRT;

type
   ATTRSet = record
      LastECode: integer;
   end;

const
   UseTint                     = $00;     {  0}
   BlackOnBlack                = $00;     {  0}
   BlueOnBlack                 = $01;     {  1}
   GreenOnBlack                = $02;     {  2}
   CyanOnBlack                 = $03;     {  3}
   RedOnBlack                  = $04;     {  4}
   MagentaOnBlack              = $05;     {  5}
   BrownOnBlack                = $06;     {  6}
   LightGrayOnBlack            = $07;     {  7}
   DarkGrayOnBlack             = $08;     {  8}
   LightBlueOnBlack            = $09;     {  9}
   LightGreenOnBlack           = $0A;     { 10}
   LightCyanOnBlack            = $0B;     { 11}
   LightRedOnBlack             = $0C;     { 12}
   LightMagentaOnBlack         = $0D;     { 13}
   YellowOnBlack               = $0E;     { 14}
   WhiteOnBlack                = $0F;     { 15}
   BlackOnBlue                 = $10;     { 16}
   BlueOnBlue                  = $11;     { 17}
   GreenOnBlue                 = $12;     { 18}
   CyanOnBlue                  = $13;     { 19}
   RedOnBlue                   = $14;     { 20}
   MagentaOnBlue               = $15;     { 21}
   BrownOnBlue                 = $16;     { 22}
   LightGrayOnBlue             = $17;     { 23}
   DarkGrayOnBlue              = $18;     { 24}
   LightBlueOnBlue             = $19;     { 25}
   LightGreenOnBlue            = $1A;     { 26}
   LightCyanOnBlue             = $1B;     { 27}
   LightRedOnBlue              = $1C;     { 28}
   LightMagentaOnBlue          = $1D;     { 29}
   YellowOnBlue                = $1E;     { 30}
   WhiteOnBlue                 = $1F;     { 31}
   BlackOnGreen                = $20;     { 32}
   BlueOnGreen                 = $21;     { 33}
   GreenOnGreen                = $22;     { 34}
   CyanOnGreen                 = $23;     { 35}
   RedOnGreen                  = $24;     { 36}
   MagentaOnGreen              = $25;     { 37}
   BrownOnGreen                = $26;     { 38}
   LightGrayOnGreen            = $27;     { 39}
   DarkGrayOnGreen             = $28;     { 40}
   LightBlueOnGreen            = $29;     { 41}
   LightGreenOnGreen           = $2A;     { 42}
   LightCyanOnGreen            = $2B;     { 43}
   LightRedOnGreen             = $2C;     { 44}
   LightMagentaOnGreen         = $2D;     { 45}
   YellowOnGreen               = $2E;     { 46}
   WhiteOnGreen                = $2F;     { 47}
   BlackOnCyan                 = $30;     { 48}
   BlueOnCyan                  = $31;     { 49}
   GreenOnCyan                 = $32;     { 50}
   CyanOnCyan                  = $33;     { 51}
   RedOnCyan                   = $34;     { 52}
   MagentaOnCyan               = $35;     { 53}
   BrownOnCyan                 = $36;     { 54}
   LightGrayOnCyan             = $37;     { 55}
   DarkGrayOnCyan              = $38;     { 56}
   LightBlueOnCyan             = $39;     { 57}
   LightGreenOnCyan            = $3A;     { 58}
   LightCyanOnCyan             = $3B;     { 59}
   LightRedOnCyan              = $3C;     { 60}
   LightMagentaOnCyan          = $3D;     { 61}
   YellowOnCyan                = $3E;     { 62}
   WhiteOnCyan                 = $3F;     { 63}
   BlackOnRed                  = $40;     { 64}
   BlueOnRed                   = $41;     { 65}
   GreenOnRed                  = $42;     { 66}
   CyanOnRed                   = $43;     { 67}
   RedOnRed                    = $44;     { 68}
   MagentaOnRed                = $45;     { 69}
   BrownOnRed                  = $46;     { 70}
   LightGrayOnRed              = $47;     { 71}
   DarkGrayOnRed               = $48;     { 72}
   LightBlueOnRed              = $49;     { 73}
   LightGreenOnRed             = $4A;     { 74}
   LightCyanOnRed              = $4B;     { 75}
   LightRedOnRed               = $4C;     { 76}
   LightMagentaOnRed           = $4D;     { 77}
   YellowOnRed                 = $4E;     { 78}
   WhiteOnRed                  = $4F;     { 79}
   BlackOnMagenta              = $50;     { 80}
   BlueOnMagenta               = $51;     { 81}
   GreenOnMagenta              = $52;     { 82}
   CyanOnMagenta               = $53;     { 83}
   RedOnMagenta                = $54;     { 84}
   MagentaOnMagenta            = $55;     { 85}
   BrownOnMagenta              = $56;     { 86}
   LightGrayOnMagenta          = $57;     { 87}
   DarkGrayOnMagenta           = $58;     { 88}
   LightBlueOnMagenta          = $59;     { 89}
   LightGreenOnMagenta         = $5A;     { 90}
   LightCyanOnMagenta          = $5B;     { 91}
   LightRedOnMagenta           = $5C;     { 92}
   LightMagentaOnMagenta       = $5D;     { 93}
   YellowOnMagenta             = $5E;     { 94}
   WhiteOnMagenta              = $5F;     { 95}
   BlackOnBrown                = $60;     { 96}
   BlueOnBrown                 = $61;     { 97}
   GreenOnBrown                = $62;     { 98}
   CyanOnBrown                 = $63;     { 99}
   RedOnBrown                  = $64;     {100}
   MagentaOnBrown              = $65;     {101}
   BrownOnBrown                = $66;     {102}
   LightGrayOnBrown            = $67;     {103}
   DarkGrayOnBrown             = $68;     {104}
   LightBlueOnBrown            = $69;     {105}
   LightGreenOnBrown           = $6A;     {106}
   LightCyanOnBrown            = $6B;     {107}
   LightRedOnBrown             = $6C;     {108}
   LightMagentaOnBrown         = $6D;     {109}
   YellowOnBrown               = $6E;     {110}
   WhiteOnBrown                = $6F;     {111}
   BlackOnLightGray            = $70;     {112}
   BlueOnLightGray             = $71;     {113}
   GreenOnLightGray            = $72;     {114}
   CyanOnLightGray             = $73;     {115}
   RedOnLightGray              = $74;     {116}
   MagentaOnLightGray          = $75;     {117}
   BrownOnLightGray            = $76;     {118}
   LightGrayOnLightGray        = $77;     {119}
   DarkGrayOnLightGray         = $78;     {120}
   LightBlueOnLightGray        = $79;     {121}
   LightGreenOnLightGray       = $7A;     {122}
   LightCyanOnLightGray        = $7B;     {123}
   LightRedOnLightGray         = $7C;     {124}
   LightMagentaOnLightGray     = $7D;     {125}
   YellowOnLightGray           = $7E;     {126}
   WhiteOnLightGray            = $7F;     {127}
   BlackOnDarkGray             = $80;     {128}
   BlueOnDarkGray              = $81;     {129}
   GreenOnDarkGray             = $82;     {130}
   CyanOnDarkGray              = $83;     {131}
   RedOnDarkGray               = $84;     {132}
   MagentaOnDarkGray           = $85;     {133}
   BrownOnDarkGray             = $86;     {134}
   LightGrayOnDarkGray         = $87;     {135}
   DarkGrayOnDarkGray          = $88;     {136}
   LightBlueOnDarkGray         = $89;     {137}
   LightGreenOnDarkGray        = $8A;     {138}
   LightCyanOnDarkGray         = $8B;     {139}
   LightRedOnDarkGray          = $8C;     {140}
   LightMagentaOnDarkGray      = $8D;     {141}
   YellowOnDarkGray            = $8E;     {142}
   WhiteOnDarkGray             = $8F;     {143}
   BlackOnLightBlue            = $90;     {144}
   BlueOnLightBlue             = $91;     {145}
   GreenOnLightBlue            = $92;     {146}
   CyanOnLightBlue             = $93;     {147}
   RedOnLightBlue              = $94;     {148}
   MagentaOnLightBlue          = $95;     {149}
   BrownOnLightBlue            = $96;     {150}
   LightGrayOnLightBlue        = $97;     {151}
   DarkGrayOnLightBlue         = $98;     {152}
   LightBlueOnLightBlue        = $99;     {153}
   LightGreenOnLightBlue       = $9A;     {154}
   LightCyanOnLightBlue        = $9B;     {155}
   LightRedOnLightBlue         = $9C;     {156}
   LightMagentaOnLightBlue     = $9D;     {157}
   YellowOnLightBlue           = $9E;     {158}
   WhiteOnLightBlue            = $9F;     {159}
   BlackOnLightGreen           = $A0;     {160}
   BlueOnLightGreen            = $A1;     {161}
   GreenOnLightGreen           = $A2;     {162}
   CyanOnLightGreen            = $A3;     {163}
   RedOnLightGreen             = $A4;     {164}
   MagentaOnLightGreen         = $A5;     {165}
   BrownOnLightGreen           = $A6;     {166}
   LightGrayOnLightGreen       = $A7;     {167}
   DarkGrayOnLightGreen        = $A8;     {168}
   LightBlueOnLightGreen       = $A9;     {169}
   LightGreenOnLightGreen      = $AA;     {170}
   LightCyanOnLightGreen       = $AB;     {171}
   LightRedOnLightGreen        = $AC;     {172}
   LightMagentaOnLightGreen    = $AD;     {173}
   YellowOnLightGreen          = $AE;     {174}
   WhiteOnLightGreen           = $AF;     {175}
   BlackOnLightCyan            = $B0;     {176}
   BlueOnLightCyan             = $B1;     {177}
   GreenOnLightCyan            = $B2;     {178}
   CyanOnLightCyan             = $B3;     {179}
   RedOnLightCyan              = $B4;     {180}
   MagentaOnLightCyan          = $B5;     {181}
   BrownOnLightCyan            = $B6;     {182}
   LightGrayOnLightCyan        = $B7;     {183}
   DarkGrayOnLightCyan         = $B8;     {184}
   LightBlueOnLightCyan        = $B9;     {185}
   LightGreenOnLightCyan       = $BA;     {186}
   LightCyanOnLightCyan        = $BB;     {187}
   LightRedOnLightCyan         = $BC;     {188}
   LightMagentaOnLightCyan     = $BD;     {189}
   YellowOnLightCyan           = $BE;     {190}
   WhiteOnLightCyan            = $BF;     {191}
   BlackOnLightRed             = $C0;     {192}
   BlueOnLightRed              = $C1;     {193}
   GreenOnLightRed             = $C2;     {194}
   CyanOnLightRed              = $C3;     {195}
   RedOnLightRed               = $C4;     {196}
   MagentaOnLightRed           = $C5;     {197}
   BrownOnLightRed             = $C6;     {198}
   LightGrayOnLightRed         = $C7;     {199}
   DarkGrayOnLightRed          = $C8;     {200}
   LightBlueOnLightRed         = $C9;     {201}
   LightGreenOnLightRed        = $CA;     {202}
   LightCyanOnLightRed         = $CB;     {203}
   LightRedOnLightRed          = $CC;     {204}
   LightMagentaOnLightRed      = $CD;     {205}
   YellowOnLightRed            = $CE;     {206}
   WhiteOnLightRed             = $CF;     {207}
   BlackOnLightMagenta         = $D0;     {208}
   BlueOnLightMagenta          = $D1;     {209}
   GreenOnLightMagenta         = $D2;     {210}
   CyanOnLightMagenta          = $D3;     {211}
   RedOnLightMagenta           = $D4;     {212}
   MagentaOnLightMagenta       = $D5;     {213}
   BrownOnLightMagenta         = $D6;     {214}
   LightGrayOnLightMagenta     = $D7;     {215}
   DarkGrayOnLightMagenta      = $D8;     {216}
   LightBlueOnLightMagenta     = $D9;     {217}
   LightGreenOnLightMagenta    = $DA;     {218}
   LightCyanOnLightMagenta     = $DB;     {219}
   LightRedOnLightMagenta      = $DC;     {220}
   LightMagentaOnLightMagenta  = $DD;     {221}
   YellowOnLightMagenta        = $DE;     {222}
   WhiteOnLightMagenta         = $DF;     {223}
   BlackOnYellow               = $E0;     {224}
   BlueOnYellow                = $E1;     {225}
   GreenOnYellow               = $E2;     {226}
   CyanOnYellow                = $E3;     {227}
   RedOnYellow                 = $E4;     {228}
   MagentaOnYellow             = $E5;     {229}
   BrownOnYellow               = $E6;     {230}
   LightGrayOnYellow           = $E7;     {231}
   DarkGrayOnYellow            = $E8;     {232}
   LightBlueOnYellow           = $E9;     {233}
   LightGreenOnYellow          = $EA;     {234}
   LightCyanOnYellow           = $EB;     {235}
   LightRedOnYellow            = $EC;     {236}
   LightMagentaOnYellow        = $ED;     {237}
   YellowOnYellow              = $EE;     {238}
   WhiteOnYellow               = $EF;     {239}
   BlackOnWhite                = $F0;     {240}
   BlueOnWhite                 = $F1;     {241}
   GreenOnWhite                = $F2;     {242}
   CyanOnWhite                 = $F3;     {243}
   RedOnWhite                  = $F4;     {244}
   MagentaOnWhite              = $F5;     {245}
   BrownOnWhite                = $F6;     {246}
   LightGrayOnWhite            = $F7;     {247}
   DarkGrayOnWhite             = $F8;     {248}
   LightBlueOnWhite            = $F9;     {249}
   LightGreenOnWhite           = $FA;     {250}
   LightCyanOnWhite            = $FB;     {251}
   LightRedOnWhite             = $FC;     {252}
   LightMagentaOnWhite         = $FD;     {253}
   YellowOnWhite               = $FE;     {254}
   WhiteOnWhite                = $FF;     {255}

function  CAttr(F,B:byte):byte;
function  FAttr(A:byte): byte;
function  BAttr(A:byte): byte;

{$IFDEF TTT5}

function Attr(F,B:byte):byte;

{$ENDIF}

var
   ATTRData: ATTRSet;

{+++++++++++++++++++++++++++++} IMPLEMENTATION {+++++++++++++++++++++++++++++}

                      {******************************}
                      {**  Miscelleanous Routines  **}
                      {******************************}

function CAttr(F,B:byte):byte;
{converts foreground(F) and background(B) colors to combined Attribute byte}
begin
   if B > 15 then
      B := BAttr(B);
   if F > 15 then
      F := FAttr(F);
   CAttr := (B Shl 4) or F;
end;  { CAttr }

function FAttr(A:byte): byte;
{returns the foreground color from an attribute Byte}
begin
   FAttr := A and 15;
end; { FAttr }

function BAttr(A:byte): byte;
{returns the background color from an attribute Byte}
begin
   BAttr := A shr 4;
end; { BAttr }

              {**********************************************}
              {**  U N I T   I N I T I A L I Z A T I O N   **}
              {**********************************************}


procedure GoldATTRInit;
{}
begin
   with ATTRData do
   begin
      LastECode := 0;
   end;
end; {GoldATTRInit}

{$IFDEF TTT5}

function Attr(F,B:byte):byte;
{}
begin
   Attr := CAttr(F,B);
end;  { Attr }

{$ENDIF}

begin
   GoldATTRInit;
end.
