{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMRD8.PAS
              Illustrates the PromptColor function in the GoldRead unit.
}

Program DemRd8;

{$I GOLDFLAG.INC}

uses DOS,CRT, GoldAttr, GoldTint, GoldIO2, GoldMisc, GoldDate, GoldFast,
              GoldRead, GoldIO, GoldWin, GoldStr, GoldKey;

var TmpMsg: string;
    TmpColor: byte;

procedure SetScreen;
{}
begin
   Clear(WhiteOnCyan,'');
   ClearLine(1,WhiteOnBlue);
   WriteCenter(1,UseTint,' Demo of PromptColor from GOLDREAD ');
   WriteAt(1,2,BlueOnRed,replicate(80,''));
   WriteAT(70,2,WhiteOnBlack,'TTT Gold!');
   ClearLine(25,YellowOnBlue);
end; { SetScreen }

{$F+}
procedure NewTextHook(CurrentField:byte;var Refresh:byte);
{}
var A: byte;
begin
   with ReadVars do
   begin
      A := Cattr(pred(ForeGroundByte),pred(BackGroundByte));
      Refresh := RefreshOthers;
      Box3D(2,8,46+2*Ord(not ReadVars.PromptStyle in [7,8]),14,
                  BlackOnCyan,WhiteOnCyan,8);
      PartClear(5,9,43+2*Ord(not ReadVars.PromptStyle in [7,8]),13,A,' ');
      WriteAT(5,9,A,' Help on the Colors dialog box');
      WriteAT(5,10,A,'');
      WriteAT(5,11,A,'TTTGOLD includes a TextSampleHook that');
      WriteAT(5,12,A,'permits the developer to make changes');
      WriteAT(5,13,A,'to the PromptColor function on the fly.');
   end;
end; { NewTextHook }
{$F-}

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   SetScreen;
   {resize depth of window to add text in hook}
   with ReadVars do
   begin
      ColorWinDepth := 15;
      PromptStyle := 4;
      Use16BgndColors := true;
   end;
   UseCustomChars;
   MouseShow(true);
   AssignTextSampleHook(NewTextHook);
   TmpColor := PromptColor(0,4,RedOnCyan,'Pick a color',' GoldRead Color Input Demo ');
   if ReadVars.LastAction = Escaped then
      TmpMsg := 'You pressed Escape!'
   else
      TmpMsg := 'You choose '+IntToStr(TmpColor);
   PromptOK(' PromptColor ',TmpMsg);
   delay(500);
   MouseShow(false);
   Clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
