{--------------------------------------------------------------------------}
{                Product: TechnoJock's Turbo Toolkit GOLD                  }
{                                                                          }
{                     TTT GOLD - DEMO PROGRAM                        }
{                                                                          }
{                Copyright 1986-1995  TechnoJock Software, Inc.            }
{                           All Rights Reserved                            }
{                          Restricted by License                           }
{--------------------------------------------------------------------------}

{Description: DEMPLL4.PAS
              Shows how to create an imitation of the Borland Pascal
              7.0 IDE menu.
}

program DemPll4;

{$I GOLDFLAG.INC}

uses DOS, CRT, GoldFast, GoldKey, GoldMenu, GoldAttr,
     GoldWin, GoldStr, GoldMisc, GoldTint;

var
   MainMenu: Bar;
   FileMenu: PopUp;
   EditMenu: PopUp;
   SearchMenu: PopUp;
   RunMenu: PopUp;
   CompileMenu: PopUp;
   DebugMenu: PopUp;
   ToolsMenu: PopUp;
   OptionsMenu: PopUp;
   WindowMenu: PopUp;
   HelpMenu: PopUp;
   EnvironmentMenu: PopUp;
   Choice: word;

{$F+}
procedure MenuHelp(ID:integer);
{}
begin
   PromptOK(' Help! ','You asked for help on menu item ID: '+IntToStr(ID));
end; { MenuHelp }
{$F-}

procedure DefineFilePopUp;
{}
begin
   InitPopUp(FileMenu);
   PopUpAddItem(FileMenu,'~N~ew',101,78,'Create a new file in a new Edit window',nil);
   PopUpAddItem(FileMenu,'~O~pen...:F3',102,79,'Locate and open in an Edit window',nil);
   PopUpAddItem(FileMenu,'~S~ave:F2',103,83,'Save the file in the active Edit window',nil);
   PopUpAddItem(FileMenu,'Save ~a~s...',104,65,'Save the current file under a different name directory or drive',nil);
   PopUpAddItem(FileMenu,'Save a~l~l',105,76,'Save all modified files',nil);
   PopUpAddItem(FileMenu,'-',0,0,'',nil); {separator}
   PopUpAddItem(FileMenu,'~C~hange dir...',106,67,'Choose a new default directory',nil);
   PopUpAddItem(FileMenu,'~P~rint',107,80,'Print the contents of the active Edit window',nil);
   PopUpAddItem(FileMenu,'P~r~inter setup',108,82,'Choose printer filter to use for printing',nil);
   PopUpAddItem(FileMenu,'~D~os shell',109,68,'Temporily exit to DOS',nil);
   PopUpAddItem(FileMenu,'E~x~it',110,88,'~Exit~ Turbo Pascal',nil);
end; { DefineFilePopUp }

procedure DefineEditPopUp;
{}
begin
   InitPopUp(EditMenu);
   PopUpAddItem(EditMenu,'~U~ndo:Alt+BkSp',201,85,'Undo the previous editor operation',nil);
   PopUpAddItem(EditMenu,'!~R~edo',202,82,'Redo the previously undone editor operation',nil);
   PopUpAddItem(EditMenu,'-',0,0,'',nil);
   PopUpAddItem(EditMenu,'!Cu~t~:Shift+Del',203,84,'Remove the selected text and put it in the Clipboard',nil);
   PopUpAddItem(EditMenu,'!~C~opy:Ctrl+Ins',204,67,'Copy the selected text into the Clipboard',nil);
   PopUpAddItem(EditMenu,'!~P~aste:Shift+Ins',205,80,'Insert selected text from the Clipboard at the cursor position',nil);
   PopUpAddItem(EditMenu,'!C~l~ear:Ctrl+Del',206,76,'Delete the selected text',nil);
   PopUpAddItem(EditMenu,'-',0,0,'',nil);
   PopUpAddItem(EditMenu,'~S~how clipboard',207,83,'Open the Clipboard window',nil);
end; { DefineEditPopUp }

procedure DefineSearchPopUp;
{}
begin
   InitPopUp(SearchMenu);
    PopUpAddItem(SearchMenu,'~F~ind...',301,70,'Search for text',nil);
    PopUpAddItem(SearchMenu,'~R~eplace...',302,82,'Search for text and replace it with new text',nil);
    PopUpAddItem(SearchMenu,'~S~earch again',303,83,'Repeat the last Find or Replace command',nil);
    PopUpAddItem(SearchMenu,'-',0,0,'',nil);
    PopUpAddItem(SearchMenu,'~G~o to line number',304,71,'Move the cursor to a specified line number',nil);
    PopUpAddItem(SearchMenu,'!Show last ~c~ompiler error',305,67,
                            'Move the cursor to the position of the last compiler error',nil);
    PopUpAddItem(SearchMenu,'Find ~e~rror',306,69,'Move the cursor to the position of a runtime error',nil);
    PopUpAddItem(SearchMenu,'Find ~p~rocedure',307,80,'Search for a procedure or function declaration while debugging',nil);
    PopUpAddItem(SearchMenu,'-',0,0,'',nil);
    PopUpAddItem(SearchMenu,'!Previous ~b~rowser',308,66,'Redisplay the last-viewed browser window',nil);
    PopUpAddItem(SearchMenu,'~O~bjects',309,79,'Open a browser displaying all objects in the program',nil);
    PopUpAddItem(SearchMenu,'~U~nits',310,85,'Open a browser displaying all units in the program',nil);
    PopUpAddItem(SearchMenu,'G~l~obals',311,76,'Open a browser displaying all global symbols in the program',nil);
    PopUpAddItem(SearchMenu,'-',0,0,'',nil);
    PopUpAddItem(SearchMenu,'S~y~mbol',312,83,'Enter symbol to browse',nil);
end; { DefineSearchPopUp }

procedure DefineRunPopUp;
{}
begin
   InitPopUp(RunMenu);
   PopUpAddItem(RunMenu,'~R~un:Ctrl+F9',401,82,'Run the current program',nil);
   PopUpAddItem(RunMenu,'~S~tep over:F8',402,83,'Execute next statement, skipping over the current procedure',nil);
   PopUpAddItem(RunMenu,'~T~race into:F7',403,84,'Execute next statement, stopping within the current procedure',nil);
   PopUpAddItem(RunMenu,'~G~o to cursor:F4',404,71,'Run the program from the run bar to the cursor position',nil);
   PopUpAddItem(RunMenu,'!~P~rogram reset',405,80,'Halt debugging session and release memory',nil);
   PopUpAddItem(RunMenu,'P~a~rameters',406,65,'Set command-line parameters to be passed to program',nil);
end; { DefineRunPopUp }

procedure DefineCompilePopUp;
{}
begin
   InitPopUp(CompileMenu);
   PopUpAddItem(CompileMenu,'~C~ompile:Alt+F9',501,67,'Compile source file',nil);
   PopUpAddItem(CompileMenu,'~M~ake:F9',502,77,'Rebuild source file and all other files that have been modified',nil);
   PopUpAddItem(CompileMenu,'~B~uild',503,66,'Rebuild source file and all other files',nil);
   PopUpAddItem(CompileMenu,'-',0,0,'',nil);
   PopUpAddItem(CompileMenu,'~T~arget...:Real',504,84,'Select target platform to compile for',nil);
   PopUpAddItem(CompileMenu,'~P~rimary file...',505,80,'Define the file that is the focus of Make and Build',nil);
   PopUpAddItem(CompileMenu,'C~l~ear primary file',506,76,'Clear the file previously set with Primary file',nil);
   PopUpAddItem(CompileMenu,'-',0,0,'',nil);
   PopUpAddItem(CompileMenu,'~I~nformation',507,73,'Show status information',nil);
end; { DefineCompilePopUp }

procedure DefineDebugPopUp;
{}
begin
   InitPopUp(DebugMenu);
   PopUpAddItem(DebugMenu,'~B~reakpoints...',601,66,'Set conditional breakpoints, view and edit breakpoints',nil);
   PopUpAddItem(DebugMenu,'~C~all stack:Ctrl+F3',602,67,'Show the procedures the program called to reach this point',nil);
   PopUpAddItem(DebugMenu,'~R~egister',603,82,'Open the Register window',nil);
   PopUpAddItem(DebugMenu,'~W~atch',604,87,'Open the Watch window',nil);
   PopUpAddItem(DebugMenu,'~O~utput',605,79,'Open the Output window',nil);
   PopUpAddItem(DebugMenu,'~U~ser screen',606,85,'Switch to the full-screen user output',nil);
   PopUpAddItem(DebugMenu,'-',0,0,'',nil);
   PopUpAddItem(DebugMenu,'~E~valuate/modify...',607,69,
                          'Evaluate a variable or expression and display or modify the value',nil);
   PopUpAddItem(DebugMenu,'~A~dd watch...:Ctrl+F7',608,65,'Insert a watch expression into a Watch window',nil);
   PopUpAddItem(DebugMenu,'Add break~p~oint...',609,80,'Add a breakpoint expression',nil);
end; { DefineDebugPopUp }

procedure DefineToolsPopUp;
{}
begin
   InitPopUp(ToolsMenu);
   PopUpAddItem(ToolsMenu,'~M~essages',701,77,'Open the message window',nil);
   PopUpAddItem(ToolsMenu,'!Go to ~n~ext:Alt+F8',702,78,'Go to the next source position',nil);
   PopUpAddItem(ToolsMenu,'!Go to ~p~revious:Alt+F7',703,80,'Go to the previous source position',nil);
   PopUpAddItem(ToolsMenu,'-',0,0,'',nil);
   PopUpAddItem(ToolsMenu,'~G~rep',704,71,'User installed tool:Shift+F2',nil);
   PopUpAddItem(ToolsMenu,'Turbo ~A~ssembler:Shift+F3',705,65,'User installed tool',nil);
   PopUpAddItem(ToolsMenu,'Turbo ~D~ebugger:Shift+F4',706,68,'User installed tool',nil);
   PopUpAddItem(ToolsMenu,'Turbo P~r~ofiler:Shift+F5',707,82,'User installed tool',nil);
end; { DefineToolsPopUp }

procedure DefineOptionsPopUp;
{}
begin
   InitPopUp(OptionsMenu);
   PopUpAddItem(OptionsMenu,'~C~ompiler...',801,67,'Set default compiler directives and conditional defines',nil);
   PopUpAddItem(OptionsMenu,'~M~emory sizes...',802,77,'Set default stack and heap sizes for generated programs',nil);
   PopUpAddItem(OptionsMenu,'~L~inker...',803,76,'Set linker options (link buffer; .MAP file options)',nil);
   PopUpAddItem(OptionsMenu,'De~b~ugger...',804,66,'Set debugger options (standalone, integrated, display swapping)',nil);
   PopUpAddItem(OptionsMenu,'~D~irectories...',805,68,'Set paths for units, include files, OBJs, and generated files',nil);
   PopUpAddItem(OptionsMenu,'Bro~w~ser...',806,87,'Set global browser settings',nil);
   PopUpAddItem(OptionsMenu,'~T~ools...',807,84,'Create or change tools',nil);
   PopUpAddItem(OptionsMenu,'-',0,0,'',nil);
   PopUpAddItem(OptionsMenu,'~E~nvironment...',808,69,'Specify environment settings',@EnvironmentMenu);
   PopUpAddItem(OptionsMenu,'-',0,0,'',nil);
   PopUpAddItem(OptionsMenu,'~O~pen...',809,79,'Load options file previously created with Save Options',nil);
   PopUpAddItem(OptionsMenu,'~S~ave:\BP\BIN\BP.TP',810,83,'Save all the settings you''ve made in the Options menu',nil);
   PopUpAddItem(OptionsMenu,'Save ~a~s',811,65,'Save all the settings in the Options menu to another file',nil);
end; { DefineOptionsPopUp }

procedure DefineWindowPopUp;
{}
begin
   InitPopUp(WindowMenu);
   PopUpAddItem(WindowMenu,'~T~ile',901,84,'Arrange windows on desktop by tiling',nil);
   PopUpAddItem(WindowMenu,'C~a~scading',902,65,'Arrange windows on desktop by cascading',nil);
   PopUpAddItem(WindowMenu,'Cl~o~se all',903,79,'Close all windows on the desktop',nil);
   PopUpAddItem(WindowMenu,'~R~efresh display',904,82,'Redraw the screen',nil);
   PopUpAddItem(WindowMenu,'-',0,0,'',nil);
   PopUpAddItem(WindowMenu,'~S~ize/Move:Ctrl+F5',905,83,'Change the size or position of the active window',nil);
   PopUpAddItem(WindowMenu,'~Z~oom',906,90,'Enlarge or restore the size of the active window',nil);
   PopUpAddItem(WindowMenu,'~N~ext',907,78,'Make the next window active',nil);
   PopUpAddItem(WindowMenu,'~P~revious',908,80,'Make the previous window active',nil);
   PopUpAddItem(WindowMenu,'~C~lose',909,67,'Close the active window',nil);
   PopUpAddItem(WindowMenu,'-',0,0,'',nil);
   PopUpAddItem(WindowMenu,'~L~ist',910,76,'Show a list of all open windows',nil);
end; { DefineWindowPopUp }

procedure DefineHelpPopUp;
{}
begin
   InitPopUp(HelpMenu);
   PopUpAddItem(HelpMenu,'~C~ontents',9001,67,'Show table of contents for online Help',nil);
   PopUpAddItem(HelpMenu,'~I~ndex:Shift+F1',9002,73,'Show index for online Help',nil);
   PopUpAddItem(HelpMenu,'~T~opic search:Ctrl+F1',9003,84,'Display help on the word at the cursor',nil);
   PopUpAddItem(HelpMenu,'~P~revious topic:Alt+F1',9004,80,'Redisplay the last-viewed online Help screen',nil);
   PopUpAddItem(HelpMenu,'Using ~h~elp',9005,72,'How to use online Help',nil);
   PopUpAddItem(HelpMenu,'~F~iles...',9006,70,'Add or delete installed help files',nil);
   PopUpAddItem(HelpMenu,'-',0,0,'',nil);
   PopUpAddItem(HelpMenu,'Compiler ~d~irectives',9007,68,'Display help about the compiler directives',nil);
   PopUpAddItem(HelpMenu,'Pr~o~cedures and functions',9008,79,'Display help about procedures and functions',nil);
   PopUpAddItem(HelpMenu,'~R~eserved words',9009,82,'Display Borland Pascal''s reserved words',nil);
   PopUpAddItem(HelpMenu,'Standard ~u~nits',9010,85,'Display help about standard Borland Pascal units',nil);
   PopUpAddItem(HelpMenu,'Borland Pascal ~L~anguages',9011,76,'Display help about standard Borland Pascal language',nil);
   PopUpAddItem(HelpMenu,'~E~rror messages',9012,69,'Display help about the error messages',nil);
   PopUpAddItem(HelpMenu,'-',0,0,'',nil);
   PopUpAddItem(HelpMenu,'~A~bout...',9013,65,'Show version and copyright information',nil);
end; { DefineHelpPopUp }

procedure DefineEnvironmentPopUp;
{}
begin
   InitPopUp(EnvironmentMenu);
   PopUpAddItem(EnvironmentMenu,'~P~references...',851,80,'Specify desktop settings',nil);
   PopUpAddItem(EnvironmentMenu,'~E~ditor...',852,69,'Specify editor settings',nil);
   PopUpAddItem(EnvironmentMenu,'~M~ouse...',853,77,'Specify mouse settings',nil);
   PopUpAddItem(EnvironmentMenu,'~S~tartup...',854,83,'Permanently change default startup options',nil);
   PopUpAddItem(EnvironmentMenu,'~C~olors...',855,67,'Customize IDE colors for windows, menus, etc.',nil);
end; { DefineEnvironmentPopUp }

procedure DefinePopups;
{}
begin
   DefineFilePopUp;
   DefineEditPopUp;
   DefineSearchPopUp;
   DefineRunPopUp;
   DefineCompilePopUp;
   DefineDebugPopUp;
   DefineToolsPopUp;
   DefineOptionsPopUp;
   DefineWindowPopUp;
   DefineHelpPopUp;
   DefineEnvironmentPopUp;
end; { DefinePopups }

procedure DefineMainMenu;
{}
begin
   InitBar(MainMenu);
   BarAddItem(MainMenu,'~F~ile',100,70,289,'File management commands (open, new, etc).',@FileMenu);
   BarAddItem(MainMenu,'~E~dit',200,69,274,'Cut-and-paste editing commands',@EditMenu);
   BarAddItem(MainMenu,'~S~earch',300,83,287,'Text and error search commands',@SearchMenu);
   BarAddItem(MainMenu,'~R~un',400,82,275,'Execute or single step through a program',@RunMenu);
   BarAddItem(MainMenu,'~C~ompile',500,67,302,'Compile to disk or memory',@CompileMenu);
   BarAddItem(MainMenu,'~D~ebug',600,68,288,'Evaluate expressions, modify data, set breakpoints and watches',@DebugMenu);
   BarAddItem(MainMenu,'~T~ools',700,84,276,'Tracking commands and user installed tools',@ToolsMenu);
   BarAddItem(MainMenu,'~O~ptions',800,79,280,'Set defaults for compiler, editor, mouse, debugger, etc.',@OptionsMenu);
   BarAddItem(MainMenu,'~W~indow',900,87,273,'Open, arrange and list windows',@Windowmenu);
   BarAddItem(MainMenu,'~H~elp',9000,72,289,'Get online help',@HelpMenu);
   BarAddHK(MainMenu,317,102); {F3 - File Open}
   BarAddHK(MainMenu,316,103); {F2 - File Save}
   BarAddHK(MainMenu,270,201); {Alt+BkSp - Undo}
   BarAddHK(MainMenu,263,203); {Shift+Del - Cut}
   BarAddHK(MainMenu,260,204); {Ctrl+Ins - Copy}
   BarAddHK(MainMenu,261,205); {Shift+Ins - Paste}
   BarAddHK(MainMenu,262,206); {Ctrl+Del - Clear}
   BarAddHK(MainMenu,358,401); {Ctrl+F9 - Run}
   BarAddHK(MainMenu,322,402); {F8 - Step over}
   BarAddHK(MainMenu,321,403); {F7 - Trace into}
   BarAddHK(MainMenu,318,404); {F4 - Go to cursor}
   BarAddHK(MainMenu,351,405); {Ctrl+F2 - Program reset}
   BarAddHK(MainMenu,368,501); {Alt+F9 - Compile}
   BarAddHK(MainMenu,323,502); {F9 - Make}
   BarAddHK(MainMenu,352,602); {Ctrl+F3 - Call stack}
   BarAddHK(MainMenu,364,606); {Alt+F5 - User screen}
   BarAddHK(MainMenu,353,607); {Ctrl+F4 - Evaluate/modify}
   BarAddHK(MainMenu,356,608); {Ctrl+F7 - Add watch}
   BarAddHK(MainMenu,367,702); {Alt+F8 - Go to next}
   BarAddHK(MainMenu,366,703); {Alt+F7 - Go to previous}
   BarAddHK(MainMenu,341,704); {Shift+F2 - Grep}
   BarAddHK(MainMenu,342,705); {Shift+F3 - Turbo Assembler}
   BarAddHK(MainMenu,343,706); {Shift+F4 - Turbo Debugger}
   BarAddHK(MainMenu,344,707); {Shift+F5 - Turbo Profiler}
   BarAddHK(MainMenu,354,905); {Ctrl+F5 - Size/Move}
   BarAddHK(MainMenu,319,906); {F5 - Zoom}
   BarAddHK(MainMenu,320,907); {F6 - Next}
   BarAddHK(MainMenu,345,908); {Shift+F6 - Previous}
   BarAddHK(MainMenu,342,909); {Alt+F3 - Close}
   BarAddHK(MainMenu,385,910); {Alt+0 - List}
   BarAddHK(MainMenu,340,9002); {Shift+F1 - Index}
   BarAddHK(MainMenu,350,9003); {Ctrl+F1 - Topic search}
   BarAddHK(MainMenu,360,9004); {Alt+F1 - Previous topic}
end; { DefineMainMenu }

procedure SetScreen;
{Paints the background}
begin
   case MainMenu.Style of
     3: FBox(1,2,80,24,whiteonblue,4);
     4: FBox(1,3,80,25,whiteonblue,4);
     else
        FBox(1,2,80,24,whiteonblue,1);
   end;
   if MainMenu.Style = 4 then
   begin
      ClearLine(1,WhiteOnBlue);
      ClearLine(2,BlackOnLightgray);
      MainMenu.DescX1 := 4;
      MainMenu.DescX2 := 80;
      MainMenu.DescY := 1;
      GoldSetColor(PullMsgHot, whiteonblue);
      GoldSetColor(PullMsg, lightgrayonblue);
   end
   else
   begin
      ClearLine(1,BlackOnLightgray);
      ClearLine(25,BlackOnLightgray);
      WriteCenter(25,0,'An emulation of Borland Pascal 7.0''s menu!!');
   end;
end; {SetScreen}

procedure DisposeMenus;
{}
begin
   DestroyBar(MainMenu);
   DestroyPopUp(FileMenu);
   DestroyPopUp(EditMenu);
   DestroyPopUp(SearchMenu);
   DestroyPopUp(RunMenu);
   DestroyPopUp(CompileMenu);
   DestroyPopUp(DebugMenu);
   DestroyPopUp(ToolsMenu);
   DestroyPopUp(OptionsMenu);
   DestroyPopUp(WindowMenu);
   DestroyPopUp(HelpMenu);
   DestroyPopUp(EnvironmentMenu);
end; { DisposeMenus }

begin
{$IFOPT D+}
   HeapRecord;
{$ENDIF}
   UseCustomChars;
   DefinePopUps;
   DefineMainMenu;
   AssignMenuHelpHook(MainMenu,MenuHelp);
   MainMenu.Style := 2;
   SetScreen;
   DrawBar(MainMenu);
   MouseShow(true);
   Choice := ActivatePullmenu(MainMenu);
   if Choice = 0 then
      PromptOK(' Gold ','You escaped!')
   else
      PromptOK(' Gold ','You chose menu ID '+IntToStr(Choice));
   MouseShow(false);
   DisposeMenus;
   PromptOK(' Suggestion ','Try changing the MainMenu.Style value|on line 343 to any value in the range|1..4!');
   clear(LightGrayOnBlack,' ');
{$IFOPT D+}
   HeapCheck;
{$ENDIF}
end.
